clear
close all
currentpath=pwd;
addpath('..\Codes')
cd('..\Data\Experimental Errors')

%
load('dia100_25us_2D_U_OTSigma.mat')
U1=U;
staticE=10;
dynamicE=5;
a=520;
A=10;
sigma_0=47;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0);
%
f = figure;  
H=gca;
H.LineWidth=0.5;

hold on
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 600 250];
%
subplot(1,2,1)
plot(U1(:,1),U1(:,4),'ok',UD1(:,1),UD1(:,2),'k')
ylim([-2,12])
xlim([440,600])
hold on
%
load('dia50_250us_2D_U_OTSigma.mat')
U1=U;
dynamicE=8;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0);
plot(U1(:,1),U1(:,4),'oc',UD1(:,1),UD1(:,2),'c')
%
load('dia7p8_2500us_2D_U_OTSigma.mat')
U1=U;
dynamicE=12;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0);
plot(U1(:,1),U1(:,4),'or',UD1(:,1),UD1(:,2),'r')
xlabel('r [nm]')
ylabel('U [kT]')
title('PS500-dynamic error')
legend('25us','','250us','', '2500us')
box on
grid on
set(gca,'FontSize', 8)

%%
%
load('dia100_250us_2D_U_OTSigma.mat')
U1=U;
staticE=3;
dynamicE=8;
a=520;
A=10;
sigma_0=47;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0);
subplot(1,2,2)
plot(U1(:,1),U1(:,4),'ok',UD1(:,1),UD1(:,2),'k')
ylim([-2,12])
xlim([440,600])
hold on
%
load('dia50_250us_2D_U_OTSigma.mat')
U1=U;
staticE=10;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0);
plot(U1(:,1),U1(:,4),'oc',UD1(:,1),UD1(:,2),'c')
%
load('dia20_250us_2D_U_OTSigma.mat')
U1=U;
staticE=20;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0);
plot(U1(:,1),U1(:,4),'og',UD1(:,1),UD1(:,2),'g')
%
load('dia8_250us_2D_U_OTSigma.mat')
U1=U;
staticE=40;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0);
plot(U1(:,1)-8,U1(:,4),'or',UD1(:,1),UD1(:,2),'r')
xlabel('r [nm]')
ylabel('U [kT]')
title('PS500-static error')
legend('70','','22','','12','','5','')
box on
grid on
set(gca,'FontSize', 8)
%% save to PDF
cd(currentpath)
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'AOMpot','-dpdf','-r0')