clear
close all
addpath('..\Codes')
%% load data
load('..\Data\Depletion\T35_1mMF108_2D_U.mat')
load('..\Data\Depletion\T35_1mMF108_2D.mat')
Stiffness_line_raaccept;
%set range
x=U(1:end,1);
y=U(1:end,2);
xcut=900;
y=y(x<xcut);
x=x(x<xcut);
dynamicE=4;
staticE=3;
sigma=42;
%model
[Umodel,n] = UDepletionB_exp(0.85,40,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])
[Umodel1,n] = UDepletionB_exp(0.85,36,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])
[Umodel2,n] = UDepletionB_exp(0.85,44,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])
%plot
f = figure;  
% Create axes
axes1 = axes('Parent',f);
hold(axes1,'on');
H=gca;
hold on
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 333 250];  %[left bottom width height], in Adobe Illustrator, this fits to artbord (88 mm,66 mm)
% ---make plot
p1=plot(U(3:end,1),U(3:end,4)+0.5,'s','MarkerEdgeColor','#1F77B4','MarkerFaceColor','#808080','MarkerSize',6,'LineWidth',1);
p12=plot(Umodel(:,1),Umodel(:,3)+0.5,'--','Color','#4DA6FF','LineWidth',1);
patch('Parent',axes1,'XData',[Umodel1(:,1)' fliplr(Umodel2(:,1)')], 'YData',[Umodel1(:,2)'+0.5 fliplr(Umodel2(:,2)'+0.5)],'FaceAlpha',0.5,'FaceColor','#1F77B4','EdgeColor','none');
%% load data
load('..\Data\Depletion\T35_2mMF108_2D_U.mat')
load('..\Data\Depletion\T35_2mMF108_2D.mat')
Stiffness_line_raaccept;
%set range
x=U(1:end,1);
y=U(1:end,2);
xcut=900;
y=y(x<xcut);
x=x(x<xcut);
%model
[Umodel,n] = UDepletionB_exp(1.85,40,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])
[Umodel1,n] = UDepletionB_exp(1.85,36,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])
[Umodel2,n] = UDepletionB_exp(1.85,44,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])
%plot
p2=plot(U(3:end,1),U(3:end,4)-0.5,'o','MarkerEdgeColor','#FF7F0E','MarkerFaceColor','#808080','MarkerSize',6,'LineWidth',1);
p22=plot(Umodel(:,1),Umodel(:,3)-0.5,'--','Color','#FFA64D','LineWidth',1);
patch('Parent',axes1,'XData',[Umodel1(:,1)' fliplr(Umodel2(:,1)')], 'YData',[Umodel1(:,2)'-0.5 fliplr(Umodel2(:,2)'-0.5)],'FaceAlpha',0.5,'FaceColor','#FF7F0E','EdgeColor','none');
% ---set range
xlim([680,900])
ylim([-6,6])
% ---axis
box on
% grid on
H.LineWidth=0.5;
% ---fonts
set(gca,'FontSize', 8)
% ---labels
xlabel('r [nm]')
ylabel('U(r) [kT]')
% ---legned
legend([p12,p22,p1,p2],{'','','1 mM','2 mM'},'Position',[0.6 0.8 0 0],'NumColumns',2); %[left bottom width height]
legend boxoff 
%% save to PDF
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'DepetionB','-dpdf','-r0')