clear
close all
addpath('..\Codes')
%% load data
load('..\Data\Depletion\T35_1mMF108_2D_U.mat')
load('..\Data\Depletion\T35_1mMF108_2D.mat')
Stiffness_line_raaccept;
%set range
x=U(1:end,1);
y=U(1:end,2);
xcut=900;
y=y(x<xcut);
x=x(x<xcut);
dynamicE=4;
staticE=3;
sigma=42;
%model
% fun = @(p) ThreeErrors_fitCore(x,y,p,dynamicE,staticE,sigma,Lambda,1,method);
% options = optimset('PlotFcns',@optimplotfval,'MaxIter',10000);
[Umodel,n] = UDepletionB_exp(0.85,40,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])

%plot
f = figure;  
H=gca;
hold on
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 333 250];  %[left bottom width height], in Adobe Illustrator, this fits to artbord (88 mm,66 mm)
% ---make plot
p1=plot(U(3:end,1),U(3:end,4)+0.5,'s','MarkerEdgeColor','#1F77B4','MarkerFaceColor','#808080','MarkerSize',6,'LineWidth',1);
p2=plot(Umodel(:,1),Umodel(:,2)+0.5,'-','Color','#1F77B4','LineWidth',1);
p22=plot(Umodel(:,1),Umodel(:,3)+0.5,'--','Color','#4DA6FF','LineWidth',0.5);
hold on
%% load data
load('..\Data\Depletion\T35_2mMF108_2D_U.mat')
load('..\Data\Depletion\T35_2mMF108_2D.mat')
Stiffness_line_raaccept;
%set range
x=U(1:end,1);
y=U(1:end,2);
xcut=900;
y=y(x<xcut);
x=x(x<xcut);
%model
[Umodel,n] = UDepletionB_exp(1.85,40,720,10,dynamicE,staticE,sigma);
disp(['n = ' num2str(n) ', phi = ' num2str(4*pi/3*10^3*n) '.'])
%plot
p3=plot(U(3:end,1),U(3:end,4)-0.5,'o','MarkerEdgeColor','#FF7F0E','MarkerFaceColor','#808080','MarkerSize',6,'LineWidth',1);
p4=plot(Umodel(:,1),Umodel(:,2)-0.5,'-','Color','#FF7F0E','LineWidth',1);
p42=plot(Umodel(:,1),Umodel(:,3)-0.5,'--','Color','#FFA64D','LineWidth',0.5);

% ---set range
xlim([680,900])
ylim([-6,6])
% ---axis
box on
% grid on
H.LineWidth=0.5;
% ---fonts
set(gca,'FontSize', 8)
% ---labels
xlabel('r [nm]')
ylabel('U(r) [kT]')
% ---legned
legend([p22 p42 p2 p4 p1 p3],{'','','','','1 mM','2 mM'},'Position',[0.6 0.8 0 0],'NumColumns',3); %[left bottom width height]
legend boxoff 
%% save to PDF
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'Depetion','-dpdf','-r0')