clear
close all
main = pwd;
addpath('..\Codes')
cd('..\Data\Experimental Errors')
%
colours ={'#1F77B4', '#FF7F0E', '#2CA02C', '#D62728', '#9467BD', '#8C564B', '#E377C2', '#7F7F7F'};
colours = vertcat(colours{:});
%
f = figure;  
H=gca;
H.LineWidth=0.5;
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 990 250];
%
load('zoffset10500_2D_U_OTSigma.mat')
U1=U;
staticE=3;
dynamicE=5;
a=523;
A=50;
sigma_0=78;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
subplot(1,3,1)
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(1,:),'MarkerFaceColor',colours(1,:),'MarkerSize',4,'LineWidth',1)
hold on
plot(UD1(:,1),UD1(:,2),'Color',colours(1,:))
ylim([-2,12])
xlim([440,700])
%
load('zoffset11500_2D_U_OTSigma.mat')
U1=U;
sigma_0=46;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(2,:),'MarkerFaceColor',colours(2,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(2,:))
%
load('zoffset12000_2D_U_OTSigma.mat')
U1=U;
sigma_0=43;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(3,:),'MarkerFaceColor',colours(3,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(3,:))
%
load('zoffset13000_2D_U_OTSigma.mat')
U1=U;
sigma_0=50;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(4,:),'MarkerFaceColor',colours(4,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(4,:))
%
load('zoffset14000_2D_U_OTSigma.mat')
U1=U;
sigma_0=58;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(5,:),'MarkerFaceColor',colours(5,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(5,:))
xlabel('r [nm]')
ylabel('U [kT]')
% title('PS500-aberration')
legend('0.55\mum','','1.65 \mum','','2.2 \mum','','3.3\mum','','4.4\mum')
legend boxoff 
set(gca,'FontSize', 8)
box on
text(-0.16,1,'a)','Units','normalized','FontSize',12)

% grid on
%%
subplot(1,3,2)
%
load('25us_10k_2D_U_OTSigma.mat') % has SNR of 109
U1=U;
staticE=3;
dynamicE=5;
a=508;
sigma_0=42;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(1,:),'MarkerFaceColor',colours(1,:),'MarkerSize',4,'LineWidth',1)
hold on
plot(UD1(:,1),UD1(:,2),'Color',colours(1,:))
ylim([-2,12])
xlim([440,700])
%
load('250us_7k_2D_U_OTSigma.mat') %SNR of 87
U1=U;
dynamicE=8;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(2,:),'MarkerFaceColor',colours(2,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(2,:))
%
load('2500us_5k_2D_U_OTSigma.mat') % SNR 78
U1=U;
dynamicE=12;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(3,:),'MarkerFaceColor',colours(3,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(3,:))
xlabel('r [nm]')
ylabel('U [kT]')
% title('PS500-dynamic error')
legend('25\mus','','250\mus','','2500\mus','')
legend boxoff 
set(gca,'FontSize', 8)
box on
% grid on
text(-0.16,1,'b)','Units','normalized','FontSize',12)

%%
subplot(1,3,3)
%
load('25us_10k_2D_U_OTSigma.mat') % SNR 120
U1=U;
staticE=3;
dynamicE=5;
sigma_0=42;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1),U1(:,4),'o','MarkerEdgeColor',colours(1,:),'MarkerFaceColor',colours(1,:),'MarkerSize',4,'LineWidth',1)
hold on
plot(UD1(:,1),UD1(:,2),'Color',colours(1,:))
ylim([-2,12])
xlim([440,700])
hold on
%
load('25us_1k_2D_U_OTSigma.mat') % SNR 40
U1=U;
staticE=5;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1)-6,U1(:,4),'o','MarkerEdgeColor',colours(2,:),'MarkerFaceColor',colours(2,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(2,:))
%
load('25us_300_2D_U_OTSigma.mat') % SNR 20
U1=U;
staticE=10;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1)+3,U1(:,4),'o','MarkerEdgeColor',colours(3,:),'MarkerFaceColor',colours(3,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(3,:))
%
load('25us_150_2D_U_OTSigmaB.mat') % SNR 13
U1=U;
staticE=20;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_0,1);
plot(U1(:,1)-15,U1(:,4),'o','MarkerEdgeColor',colours(5,:),'MarkerFaceColor',colours(5,:),'MarkerSize',4,'LineWidth',1)
plot(UD1(:,1),UD1(:,2),'Color',colours(5,:))
xlabel('r [nm]')
ylabel('U [kT]')
legend('120','','40','','20','','13','') % use SNR in the legend
legend boxoff 
box on
set(gca,'FontSize', 8)
text(-0.16,1,'c)','Units','normalized','FontSize',12)

%% save to PDF
cd(main)
set(f, 'Renderer', 'painters')
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'all_errors_B','-dpdf','-r0')



