clear
close all
addpath('..\Codes')
%
staticE=2.5;
dynamicE=5;
a=500;
sigma_z=25;
[UD1] = UHarsphereB_exp(a,dynamicE,staticE,sigma_z);
f = figure;  
H=gca;
H.LineWidth=0.5;

hold on
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 333 500];
%
subplot(2,1,1)
UD1(isinf(UD1(:,3)),3)=100;
plot(UD1(:,1)/a,UD1(:,3),'k','LineWidth',1)
hold on
plot(   UD1(:,1)/a,UD1(:,13),'Color','#1F77B4','LineWidth',1)
plot(  UD1(:,1)/a,-log(UD1(:,9))-UD1(:,12),'Color','#FF7F0E','LineWidth',1)
plot(UD1(:,1)/a,UD1(:,2),'Color','#2CA02C','LineWidth',1)
legend(...
    'Depletion', ...
    '+ Z motion', ...
    'Z motion + Dynamic error', ...
    sprintf('Z motion + Dynamic\n& Static error') ...
);
legend boxoff 
box on
% grid on
% ---fonts
set(gca,'FontSize', 8)
ylim([-1,8])
xlim([0.96,1.1])
xlabel('r/R')
ylabel('U [kT]')
% title('Error')
% grid on
text(-0.14,1,'a)','Units','normalized','FontSize',12)

%%
[Umodel,n] = UDepletionB_exp(1,50,a,10,dynamicE,staticE,sigma_z);
subplot(2,1,2)
Umodel(isinf(Umodel(:,3)),3)=100;
plot(Umodel(:,1)/a,Umodel(:,3),'k','LineWidth',1)
hold on
plot(   Umodel(:,1)/a,Umodel(:,13),'Color','#1F77B4','LineWidth',1)
plot(  Umodel(:,1)/a,-log(Umodel(:,9))-Umodel(:,12),'Color','#FF7F0E','LineWidth',1)
plot(Umodel(:,1)/a,Umodel(:,2),'Color','#2CA02C','LineWidth',1)
% legend('Depletion','+ Z motion','Z motion + Dynamic error','Z motion + Dynamic & Static error')
% legend boxoff 
box on
xz=(520:520+staticE)/a;
yz=xz*0+6;
plot(xz,yz,'-','Color','#808080','HandleVisibility', 'off')
xz=(520:520+dynamicE)/a;
yz=xz*0+5;
plot(xz,yz,'-','Color','#808080','HandleVisibility', 'off')
xz=(520:520+sigma_z)/a;
yz=xz*0+4;
plot(xz,yz,'-','Color','#808080','HandleVisibility', 'off')
% grid on
% ---fonts
set(gca,'FontSize', 8)
ylim([-5,8])
xlim([0.96,1.1])
xlabel('r/R')
ylabel('U [kT]')
text(-0.14,1,'b)','Units','normalized','FontSize',12)
text(0.5,0.85,'\sigma_{S}','Units','normalized','FontSize',8)
text(0.5,0.78,'\sigma_{D}','Units','normalized','FontSize',8)
text(0.5,0.71,'\sigma_{z}','Units','normalized','FontSize',8)

% title('Error')
%% save to PDF
set(f, 'Renderer', 'painters')
set(f,'Units','Inches');
pos = get(f,'Position');
set(f,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(f,'potentialerrors','-dpdf','-r0')