clear
close all
addpath('..\Codes')
%% load data
load('..\Data\Depletion\T35_1mMF108_2D_U.mat')
load('..\Data\Depletion\T35_1mMF108_2D.mat')
Stiffness_line_raaccept;
%set range
U1=U;
x=U1(1:end,1);
y=U1(1:end,2);
xcut=900;
y=y(x<xcut);
x=x(x<xcut);
dynamicE=5;
staticE=3;
sigma=42;
%model fit
r=U1(:,1);
Umesure=U1(:,4);
CM=0.85;
rm=9.75;
range=[700,900];
% fun = @(p) fitcore_Depletion(r,Umesure,CM,Nmicelle,D,rm,C,dynamicE,staticE,sigma,range);
fun = @(p) fitcore_Depletion(r,Umesure,CM,p(1),p(2),p(3),p(4),dynamicE,staticE,sigma,range);
options = optimset('PlotFcns',@optimplotfval,'MaxIter',200);
p0=[80,710,10,0];
% [ertry,Umodel]=fitcore_Depletion(r,Umesure,CM,p0(1),p0(2),p0(3),p0(4),dynamicE,staticE,sigma,range);
% pfit=p0;
pfit= fminsearch(fun,p0,options);
[Umodel,~] = UDepletionB_exp(CM,pfit(1),pfit(2),pfit(3),dynamicE,staticE,sigma);

%% 
load('..\Data\Depletion\T35_2mMF108_2D_U.mat')
load('..\Data\Depletion\T35_2mMF108_2D.mat')
Stiffness_line_raaccept;
%set range
U2=U;
x=U2(1:end,1);
y=U2(1:end,2);
xcut=900;
y=y(x<xcut);
x=x(x<xcut);
%model fit
r2=U2(:,1);
Umesure2=U2(:,4);
CM2=1.85;
% fun = @(p) fitcore_Depletion(r,Umesure,CM,Nmicelle,D,rm,C,dynamicE,staticE,sigma,range);
fun = @(p) fitcore_Depletion(r2,Umesure2,CM2,p(1),p(2),p(3),p(4),dynamicE,staticE,sigma,range);
options = optimset('PlotFcns',@optimplotfval,'MaxIter',200);
% [ertry,Umodel]=fitcore_Depletion(r,Umesure,CM,p0(1),p0(2),p0(3),p0(4),dynamicE,staticE,sigma,range);
% pfit=p0;
pfit2= fminsearch(fun,p0,options);
[Umodel2,~] = UDepletionB_exp(CM2,pfit2(1),pfit2(2),pfit2(3),dynamicE,staticE,sigma);
% plot
% plot
f = figure;  
H=gca;
hold on
% ---set figure size in px. (4 px = 3 pts)
f.Position = [10 10 333 250];  %[left bottom width height], in Adobe Illustrator, this fits to artbord (88 mm,66 mm)
% ---make plot
p1=plot(U1(3:end,1),U1(3:end,4)+0.5,'s','MarkerEdgeColor','#1F77B4','MarkerFaceColor','#808080','MarkerSize',6,'LineWidth',1);
p2=plot(Umodel(:,1),Umodel(:,2)+0.5,'--','Color','#1F77B4','LineWidth',1);
p22=plot(Umodel(:,1),Umodel(:,3)+0.5,'-','Color','#4DA6FF','LineWidth',1);
%
p3=plot(U2(3:end,1),U2(3:end,4)-0.5,'o','MarkerEdgeColor','#FF7F0E','MarkerFaceColor','#808080','MarkerSize',6,'LineWidth',1);
p4=plot(Umodel2(:,1),Umodel2(:,2)-0.5,'--','Color','#FF7F0E','LineWidth',1);
p42=plot(Umodel2(:,1),Umodel2(:,3)-0.5,'-','Color','#FFA64D','LineWidth',1);

% ---set range
xlim([680,900])
ylim([-6,6])