function [UD] = UHarsphereB_exp(a,dynamicE,staticE,sigma,ifDLVO)
%all size in unit of nm
if nargin < 5
    ifDLVO = 0;
end
%set up things
step=0.05;
r=(a-100):step:(a+1000);
% guess=[4.7*10^-5,8.6,800,1.11,800,0];
k=5*10^-5;
AOB=9;
omega=800;
phi=1.1;
Dfit=420;
OT_sigma=800;
UOT=U_OT_OB_B(r,k,AOB,omega,phi,0,Dfit,OT_sigma);
LB=0.71;
ka=1/4.3;
Z=3750; %charge
lambda=1/LB; %kT
Ah=1*10^-21/(1.38*10^-23*300);
U=Z^2*lambda*exp(-ka*(r))./(r)*(exp(ka*a/2)/(1+ka*a/2))^2-0*Ah*a./(12*(r-a)); %VDW is longer range and being removed while fitting pot
% U(isinf(U))=0;
U(r<=a)=inf;
if ifDLVO == 0
U(r>a)=0; %perfect hard sphere
end
UD(:,1)=r;
UD(:,3)=U;
if nargin < 2
    dynamicE=0;
end
if nargin < 3
    staticE=0;
end
if nargin <4
    sigma = 0;
end
% z motion correction
if sigma > 0
    [U]=ZCorrection(r,U,sigma);
end
UD(:,13)=U;
% dynamic error
    UD(:,4)=U+UOT;%total U
    UD(:,5)=exp(-UD(:,4)); %PDF
    PDFU=UD(:,5);
    if dynamicE  > 0
        % Inputs: r (distance array), PDFU (exp(-U/kT)), dynamicE = sigma_D, step
        rs = -5*dynamicE : step : 5*dynamicE;
        [RR, AA] = meshgrid(r, rs);  % RR: position, AA: fluctuation
        
        % Interpolate P(r) = PDFU(r), assumed normalised
        P_interp = @(x) interp1(r, PDFU, x, 'linear', 0);  % Zero outside bounds
        P_vals = P_interp(RR + 1*AA);
        
        % Construct full dynamic kernel
        P_D_mod = P_vals .* exp(-AA.^2 / (2 * dynamicE^2));
        
        %normalize P_D
        for i = 1 : length(P_D_mod(1,:))
            normfact=sum(P_D_mod(:,i));
            if normfact > 0
                P_D_mod(:,i) = P_D_mod(:,i) / normfact;
            else
                P_D_mod(:,i) = P_D_mod(:,i)*0;
            end
        end
        RRprime_shifted = RR - 1*AA;
        P_rprime_shifted = interp1(r, PDFU, RRprime_shifted, 'linear', 0);  % size [length(a) x length(r)]
        P_all=P_rprime_shifted .* P_D_mod;
        P_dyn=sum(P_all);
        UD(:,9)=P_dyn;
    else
        UD(:,9) = UD(:,5);
    end
    % static error
    if staticE > 0
    pG= 1/(staticE*sqrt(2*pi))*exp(-(r-mean(r)).^2/(2*staticE^2));
    pG=pG/sum(pG);
    UD(:,10)=conv(UD(:,9),pG,'same');
    else
    UD(:,10)=UD(:,9);
    end
    % convert back to potential
    UD(:,2)=-log(UD(:,10))-UOT';
    UD(:,12)=UOT';
    UD(isinf(UD(:,3)),3)=100;

end