/*
cgo stubs for package smr.
File is generated by gopy. Do not edit.
gopy gen -build-tags=-gcflags=all="-N -l" -output=../distributed_notebook/smr -vm=/home/scusemua/virtual-envs/venv/bin/python3.12 github.com/scusemua/distributed-notebook/smr
*/

package main

/*

#cgo CFLAGS: -I/usr/include/python3.12d -ggdb3 -Wall -O0 -Wno-error -Wno-implicit-function-declaration -Wno-int-conversion
#cgo LDFLAGS: -L"/usr/lib/x86_64-linux-gnu/"  -ggdb3 -lpython3.12d -lcrypt -lpthread -ldl -lutil -lm

// #define Py_LIMITED_API // need full API for PyRun*
#include <Python.h>
#include <stdio.h>
typedef uint8_t bool;
// static inline is trick for avoiding need for extra .c file
// the following are used for build value -- switch on reflect.Kind
// or the types equivalent
static inline PyObject* gopy_build_bool(uint8_t val) {
	return Py_BuildValue("b", val);
}
static inline PyObject* gopy_build_int64(int64_t val) {
	return Py_BuildValue("k", val);
}
static inline PyObject* gopy_build_uint64(uint64_t val) {
	return Py_BuildValue("K", val);
}
static inline PyObject* gopy_build_float64(double val) {
	return Py_BuildValue("d", val);
}
static inline PyObject* gopy_build_string(const char* val) {
	return Py_BuildValue("s", val);
}
static inline void gopy_decref(PyObject* obj) { // macro
	Py_XDECREF(obj);
}
static inline void gopy_incref(PyObject* obj) { // macro
	Py_XINCREF(obj);
}
static inline int gopy_method_check(PyObject* obj) { // macro
	return PyMethod_Check(obj);
}
static inline void gopy_err_handle() {

	if(PyErr_Occurred() != NULL) {
		printf("[ERROR] A Python error has occurred...\n");
		PyErr_Print();
	}
}

*/
import "C"
import (
	"errors"
	"fmt"
	"reflect"
	"runtime"
	"sync"

	"github.com/scusemua/gopy/gopyh" // handler

	"context"
	"time"
	"unsafe"

	"github.com/scusemua/distributed-notebook/smr"
	raft "go.etcd.io/etcd/raft/v3"
	"go.etcd.io/etcd/raft/v3/raftpb"
	"go.etcd.io/etcd/server/v3/wal/walpb"
	"google.golang.org/protobuf/runtime/protoiface"
)

// main doesn't do anything in lib / pkg mode, but is essential for exe mode
func main() {

}

// initialization functions -- can be called from python after library is loaded
// GoPyInitRunFile runs a separate python file -- call in GoPyInit if it
// steals the main thread e.g., for GUI event loop, as in GoGi startup.

//export GoPyInit
func GoPyInit() {

}

// type for the handle -- int64 for speed (can switch to string)
type GoHandle int64
type CGoHandle C.longlong

// DecRef decrements the reference count for the specified handle
// and deletes it it goes to zero.
//
//export DecRef
func DecRef(handle CGoHandle) {
	gopyh.DecRef(gopyh.CGoHandle(handle))
}

// IncRef increments the reference count for the specified handle.
//
//export IncRef
func IncRef(handle CGoHandle) {
	gopyh.IncRef(gopyh.CGoHandle(handle))
}

// NumHandles returns the number of handles currently in use.
//
//export NumHandles
func NumHandles() int {
	return gopyh.NumHandles()
}

// boolGoToPy converts a Go bool to python-compatible C.char
func boolGoToPy(b bool) C.char {
	if b {
		return 1
	}
	return 0
}

// boolPyToGo converts a python-compatible C.Char to Go bool
func boolPyToGo(b C.char) bool {
	if b != 0 {
		return true
	}
	return false
}

func complex64GoToPy(c complex64) *C.PyObject {
	return C.PyComplex_FromDoubles(C.double(real(c)), C.double(imag(c)))
}

func complex64PyToGo(o *C.PyObject) complex64 {
	v := C.PyComplex_AsCComplex(o)
	return complex(float32(v.real), float32(v.imag))
}

func complex128GoToPy(c complex128) *C.PyObject {
	return C.PyComplex_FromDoubles(C.double(real(c)), C.double(imag(c)))
}

func complex128PyToGo(o *C.PyObject) complex128 {
	v := C.PyComplex_AsCComplex(o)
	return complex(float64(v.real), float64(v.imag))
}

// errorGoToPy converts a Go error to python-compatible C.CString
func errorGoToPy(e error) *C.char {
	if e != nil {
		return C.CString(e.Error())
	}
	return C.CString("")
}

// --- generated code for package: smr below: ---

// ---- External Types Outside of Targeted Packages ---

// Converters for pointer handles for type: *raftpb.ConfChange
func ptrFromHandle_Ptr_raftpb_ConfChange(h CGoHandle) *raftpb.ConfChange {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*raftpb.ConfChange")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.ConfChange{})).(*raftpb.ConfChange)
}
func handleFromPtr_Ptr_raftpb_ConfChange(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*raftpb.ConfChange", p))
}

// Converters for pointer handles for type: *raftpb.ConfChangeTransition
func ptrFromHandle_Ptr_raftpb_ConfChangeTransition(h CGoHandle) *raftpb.ConfChangeTransition {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*raftpb.ConfChangeTransition")
	if p == nil {
		return nil
	}
	return p.(*raftpb.ConfChangeTransition)
}
func handleFromPtr_Ptr_raftpb_ConfChangeTransition(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*raftpb.ConfChangeTransition", p))
}

// Converters for pointer handles for type: *raftpb.ConfChangeType
func ptrFromHandle_Ptr_raftpb_ConfChangeType(h CGoHandle) *raftpb.ConfChangeType {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*raftpb.ConfChangeType")
	if p == nil {
		return nil
	}
	return p.(*raftpb.ConfChangeType)
}
func handleFromPtr_Ptr_raftpb_ConfChangeType(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*raftpb.ConfChangeType", p))
}

// Converters for pointer handles for type: *raftpb.ConfState
func ptrFromHandle_Ptr_raftpb_ConfState(h CGoHandle) *raftpb.ConfState {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*raftpb.ConfState")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.ConfState{})).(*raftpb.ConfState)
}
func handleFromPtr_Ptr_raftpb_ConfState(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*raftpb.ConfState", p))
}

// Converters for pointer handles for type: *raftpb.EntryType
func ptrFromHandle_Ptr_raftpb_EntryType(h CGoHandle) *raftpb.EntryType {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*raftpb.EntryType")
	if p == nil {
		return nil
	}
	return p.(*raftpb.EntryType)
}
func handleFromPtr_Ptr_raftpb_EntryType(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*raftpb.EntryType", p))
}

// Converters for pointer handles for type: *raftpb.MessageType
func ptrFromHandle_Ptr_raftpb_MessageType(h CGoHandle) *raftpb.MessageType {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*raftpb.MessageType")
	if p == nil {
		return nil
	}
	return p.(*raftpb.MessageType)
}
func handleFromPtr_Ptr_raftpb_MessageType(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*raftpb.MessageType", p))
}

// Converters for pointer handles for type: *raftpb.Snapshot
func ptrFromHandle_Ptr_raftpb_Snapshot(h CGoHandle) *raftpb.Snapshot {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*raftpb.Snapshot")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.Snapshot{})).(*raftpb.Snapshot)
}
func handleFromPtr_Ptr_raftpb_Snapshot(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*raftpb.Snapshot", p))
}

// Converters for pointer handles for type: context.Context
func ptrFromHandle_context_Context(h CGoHandle) context.Context {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "context.Context")
	if p == nil {
		return nil
	}
	return p.(context.Context)
}
func handleFromPtr_context_Context(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("context.Context", p))
}

// Converters for non-pointer handles for type: raftpb.ConfChange
func ptrFromHandle_raftpb_ConfChange(h CGoHandle) *raftpb.ConfChange {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.ConfChange")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.ConfChange{})).(*raftpb.ConfChange)
}
func handleFromPtr_raftpb_ConfChange(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.ConfChange", p))
}

// Converters for non-pointer handles for type: raftpb.ConfChangeSingle
func ptrFromHandle_raftpb_ConfChangeSingle(h CGoHandle) *raftpb.ConfChangeSingle {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.ConfChangeSingle")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.ConfChangeSingle{})).(*raftpb.ConfChangeSingle)
}
func handleFromPtr_raftpb_ConfChangeSingle(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.ConfChangeSingle", p))
}

// Converters for non-pointer handles for type: raftpb.ConfChangeV2
func ptrFromHandle_raftpb_ConfChangeV2(h CGoHandle) *raftpb.ConfChangeV2 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.ConfChangeV2")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.ConfChangeV2{})).(*raftpb.ConfChangeV2)
}
func handleFromPtr_raftpb_ConfChangeV2(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.ConfChangeV2", p))
}

// Converters for non-pointer handles for type: raftpb.ConfState
func ptrFromHandle_raftpb_ConfState(h CGoHandle) *raftpb.ConfState {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.ConfState")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.ConfState{})).(*raftpb.ConfState)
}
func handleFromPtr_raftpb_ConfState(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.ConfState", p))
}

// Converters for non-pointer handles for type: raftpb.Entry
func ptrFromHandle_raftpb_Entry(h CGoHandle) *raftpb.Entry {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.Entry")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.Entry{})).(*raftpb.Entry)
}
func handleFromPtr_raftpb_Entry(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.Entry", p))
}

// Converters for non-pointer handles for type: raftpb.HardState
func ptrFromHandle_raftpb_HardState(h CGoHandle) *raftpb.HardState {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.HardState")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.HardState{})).(*raftpb.HardState)
}
func handleFromPtr_raftpb_HardState(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.HardState", p))
}

// Converters for non-pointer handles for type: raftpb.Message
func ptrFromHandle_raftpb_Message(h CGoHandle) *raftpb.Message {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.Message")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.Message{})).(*raftpb.Message)
}
func handleFromPtr_raftpb_Message(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.Message", p))
}

// Converters for non-pointer handles for type: raftpb.Snapshot
func ptrFromHandle_raftpb_Snapshot(h CGoHandle) *raftpb.Snapshot {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.Snapshot")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.Snapshot{})).(*raftpb.Snapshot)
}
func handleFromPtr_raftpb_Snapshot(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.Snapshot", p))
}

// Converters for non-pointer handles for type: raftpb.SnapshotMetadata
func ptrFromHandle_raftpb_SnapshotMetadata(h CGoHandle) *raftpb.SnapshotMetadata {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "raftpb.SnapshotMetadata")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(raftpb.SnapshotMetadata{})).(*raftpb.SnapshotMetadata)
}
func handleFromPtr_raftpb_SnapshotMetadata(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("raftpb.SnapshotMetadata", p))
}

// Converters for non-pointer handles for type: walpb.Snapshot
func ptrFromHandle_walpb_Snapshot(h CGoHandle) *walpb.Snapshot {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "walpb.Snapshot")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(walpb.Snapshot{})).(*walpb.Snapshot)
}
func handleFromPtr_walpb_Snapshot(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("walpb.Snapshot", p))
}

// Converters for pointer handles for type: protoiface.MessageV1
func ptrFromHandle_protoiface_MessageV1(h CGoHandle) protoiface.MessageV1 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "protoiface.MessageV1")
	if p == nil {
		return nil
	}
	return p.(protoiface.MessageV1)
}
func handleFromPtr_protoiface_MessageV1(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("protoiface.MessageV1", p))
}

// ---- Package: go ---

// ---- Types ---

// Converters for implicit pointer handles for type: []bool
func ptrFromHandle_Slice_bool(h CGoHandle) *[]bool {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]bool")
	if p == nil {
		return nil
	}
	return p.(*[]bool)
}
func deptrFromHandle_Slice_bool(h CGoHandle) []bool {
	p := ptrFromHandle_Slice_bool(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_bool(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]bool", p))
}

// --- wrapping slice: []bool ---
//
//export Slice_bool_CTor
func Slice_bool_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_bool(&[]bool{}))
}

//export Slice_bool_len
func Slice_bool_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_bool(handle))
}

//export Slice_bool_elem
func Slice_bool_elem(handle CGoHandle, _idx int) C.char {
	s := deptrFromHandle_Slice_bool(handle)
	return boolGoToPy(s[_idx])
}

//export Slice_bool_subslice
func Slice_bool_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_bool(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_bool(&ss))
}

//export Slice_bool_set
func Slice_bool_set(handle CGoHandle, _idx int, _vl C.char) {
	s := deptrFromHandle_Slice_bool(handle)
	s[_idx] = boolPyToGo(_vl)
}

//export Slice_bool_append
func Slice_bool_append(handle CGoHandle, _vl C.char) {
	s := ptrFromHandle_Slice_bool(handle)
	*s = append(*s, boolPyToGo(_vl))
}

// Converters for implicit pointer handles for type: []byte
func ptrFromHandle_Slice_byte(h CGoHandle) *[]byte {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]byte")
	if p == nil {
		return nil
	}
	return p.(*[]byte)
}
func deptrFromHandle_Slice_byte(h CGoHandle) []byte {
	p := ptrFromHandle_Slice_byte(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_byte(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]byte", p))
}

// --- wrapping slice: []byte ---
//
//export Slice_byte_CTor
func Slice_byte_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_byte(&[]byte{}))
}

//export Slice_byte_len
func Slice_byte_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_byte(handle))
}

//export Slice_byte_elem
func Slice_byte_elem(handle CGoHandle, _idx int) C.char {
	s := deptrFromHandle_Slice_byte(handle)
	return C.char(s[_idx])
}

//export Slice_byte_subslice
func Slice_byte_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_byte(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_byte(&ss))
}

//export Slice_byte_set
func Slice_byte_set(handle CGoHandle, _idx int, _vl C.char) {
	s := deptrFromHandle_Slice_byte(handle)
	s[_idx] = byte(_vl)
}

//export Slice_byte_append
func Slice_byte_append(handle CGoHandle, _vl C.char) {
	s := ptrFromHandle_Slice_byte(handle)
	*s = append(*s, byte(_vl))
}

//export Slice_byte_from_bytes
func Slice_byte_from_bytes(o *C.PyObject) CGoHandle {
	size := C.PyBytes_Size(o)
	ptr := unsafe.Pointer(C.PyBytes_AsString(o))
	data := make([]byte, size)
	tmp := unsafe.Slice((*byte)(ptr), size)
	copy(data, tmp)
	return handleFromPtr_Slice_byte(&data)
}

//export Slice_byte_to_bytes
func Slice_byte_to_bytes(handle CGoHandle) *C.PyObject {
	s := deptrFromHandle_Slice_byte(handle)
	ptr := unsafe.Pointer(&s[0])
	size := len(s)
	return C.PyBytes_FromStringAndSize((*C.char)(ptr), C.long(size))
}

// Converters for implicit pointer handles for type: []error
func ptrFromHandle_Slice_error(h CGoHandle) *[]error {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]error")
	if p == nil {
		return nil
	}
	return p.(*[]error)
}
func deptrFromHandle_Slice_error(h CGoHandle) []error {
	p := ptrFromHandle_Slice_error(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_error(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]error", p))
}

// --- wrapping slice: []error ---
//
//export Slice_error_CTor
func Slice_error_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_error(&[]error{}))
}

//export Slice_error_len
func Slice_error_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_error(handle))
}

//export Slice_error_elem
func Slice_error_elem(handle CGoHandle, _idx int) *C.char {
	s := deptrFromHandle_Slice_error(handle)
	return errorGoToPy(s[_idx])
}

//export Slice_error_subslice
func Slice_error_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_error(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_error(&ss))
}

//export Slice_error_set
func Slice_error_set(handle CGoHandle, _idx int, _vl *C.char) {
	s := deptrFromHandle_Slice_error(handle)
	s[_idx] = errors.New(C.GoString(_vl))
}

//export Slice_error_append
func Slice_error_append(handle CGoHandle, _vl *C.char) {
	s := ptrFromHandle_Slice_error(handle)
	*s = append(*s, errors.New(C.GoString(_vl)))
}

// Converters for implicit pointer handles for type: []float32
func ptrFromHandle_Slice_float32(h CGoHandle) *[]float32 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]float32")
	if p == nil {
		return nil
	}
	return p.(*[]float32)
}
func deptrFromHandle_Slice_float32(h CGoHandle) []float32 {
	p := ptrFromHandle_Slice_float32(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_float32(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]float32", p))
}

// --- wrapping slice: []float32 ---
//
//export Slice_float32_CTor
func Slice_float32_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_float32(&[]float32{}))
}

//export Slice_float32_len
func Slice_float32_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_float32(handle))
}

//export Slice_float32_elem
func Slice_float32_elem(handle CGoHandle, _idx int) C.float {
	s := deptrFromHandle_Slice_float32(handle)
	return C.float(s[_idx])
}

//export Slice_float32_subslice
func Slice_float32_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_float32(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_float32(&ss))
}

//export Slice_float32_set
func Slice_float32_set(handle CGoHandle, _idx int, _vl C.float) {
	s := deptrFromHandle_Slice_float32(handle)
	s[_idx] = float32(_vl)
}

//export Slice_float32_append
func Slice_float32_append(handle CGoHandle, _vl C.float) {
	s := ptrFromHandle_Slice_float32(handle)
	*s = append(*s, float32(_vl))
}

// Converters for implicit pointer handles for type: []float64
func ptrFromHandle_Slice_float64(h CGoHandle) *[]float64 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]float64")
	if p == nil {
		return nil
	}
	return p.(*[]float64)
}
func deptrFromHandle_Slice_float64(h CGoHandle) []float64 {
	p := ptrFromHandle_Slice_float64(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_float64(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]float64", p))
}

// --- wrapping slice: []float64 ---
//
//export Slice_float64_CTor
func Slice_float64_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_float64(&[]float64{}))
}

//export Slice_float64_len
func Slice_float64_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_float64(handle))
}

//export Slice_float64_elem
func Slice_float64_elem(handle CGoHandle, _idx int) C.double {
	s := deptrFromHandle_Slice_float64(handle)
	return C.double(s[_idx])
}

//export Slice_float64_subslice
func Slice_float64_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_float64(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_float64(&ss))
}

//export Slice_float64_set
func Slice_float64_set(handle CGoHandle, _idx int, _vl C.double) {
	s := deptrFromHandle_Slice_float64(handle)
	s[_idx] = float64(_vl)
}

//export Slice_float64_append
func Slice_float64_append(handle CGoHandle, _vl C.double) {
	s := ptrFromHandle_Slice_float64(handle)
	*s = append(*s, float64(_vl))
}

// Converters for implicit pointer handles for type: []int
func ptrFromHandle_Slice_int(h CGoHandle) *[]int {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int")
	if p == nil {
		return nil
	}
	return p.(*[]int)
}
func deptrFromHandle_Slice_int(h CGoHandle) []int {
	p := ptrFromHandle_Slice_int(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int", p))
}

// --- wrapping slice: []int ---
//
//export Slice_int_CTor
func Slice_int_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int(&[]int{}))
}

//export Slice_int_len
func Slice_int_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int(handle))
}

//export Slice_int_elem
func Slice_int_elem(handle CGoHandle, _idx int) C.longlong {
	s := deptrFromHandle_Slice_int(handle)
	return C.longlong(s[_idx])
}

//export Slice_int_subslice
func Slice_int_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int(&ss))
}

//export Slice_int_set
func Slice_int_set(handle CGoHandle, _idx int, _vl C.longlong) {
	s := deptrFromHandle_Slice_int(handle)
	s[_idx] = int(_vl)
}

//export Slice_int_append
func Slice_int_append(handle CGoHandle, _vl C.longlong) {
	s := ptrFromHandle_Slice_int(handle)
	*s = append(*s, int(_vl))
}

// Converters for implicit pointer handles for type: []int16
func ptrFromHandle_Slice_int16(h CGoHandle) *[]int16 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int16")
	if p == nil {
		return nil
	}
	return p.(*[]int16)
}
func deptrFromHandle_Slice_int16(h CGoHandle) []int16 {
	p := ptrFromHandle_Slice_int16(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int16(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int16", p))
}

// --- wrapping slice: []int16 ---
//
//export Slice_int16_CTor
func Slice_int16_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int16(&[]int16{}))
}

//export Slice_int16_len
func Slice_int16_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int16(handle))
}

//export Slice_int16_elem
func Slice_int16_elem(handle CGoHandle, _idx int) C.short {
	s := deptrFromHandle_Slice_int16(handle)
	return C.short(s[_idx])
}

//export Slice_int16_subslice
func Slice_int16_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int16(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int16(&ss))
}

//export Slice_int16_set
func Slice_int16_set(handle CGoHandle, _idx int, _vl C.short) {
	s := deptrFromHandle_Slice_int16(handle)
	s[_idx] = int16(_vl)
}

//export Slice_int16_append
func Slice_int16_append(handle CGoHandle, _vl C.short) {
	s := ptrFromHandle_Slice_int16(handle)
	*s = append(*s, int16(_vl))
}

// Converters for implicit pointer handles for type: []int32
func ptrFromHandle_Slice_int32(h CGoHandle) *[]int32 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int32")
	if p == nil {
		return nil
	}
	return p.(*[]int32)
}
func deptrFromHandle_Slice_int32(h CGoHandle) []int32 {
	p := ptrFromHandle_Slice_int32(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int32(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int32", p))
}

// --- wrapping slice: []int32 ---
//
//export Slice_int32_CTor
func Slice_int32_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int32(&[]int32{}))
}

//export Slice_int32_len
func Slice_int32_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int32(handle))
}

//export Slice_int32_elem
func Slice_int32_elem(handle CGoHandle, _idx int) C.long {
	s := deptrFromHandle_Slice_int32(handle)
	return C.long(s[_idx])
}

//export Slice_int32_subslice
func Slice_int32_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int32(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int32(&ss))
}

//export Slice_int32_set
func Slice_int32_set(handle CGoHandle, _idx int, _vl C.long) {
	s := deptrFromHandle_Slice_int32(handle)
	s[_idx] = int32(_vl)
}

//export Slice_int32_append
func Slice_int32_append(handle CGoHandle, _vl C.long) {
	s := ptrFromHandle_Slice_int32(handle)
	*s = append(*s, int32(_vl))
}

// Converters for implicit pointer handles for type: []int64
func ptrFromHandle_Slice_int64(h CGoHandle) *[]int64 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int64")
	if p == nil {
		return nil
	}
	return p.(*[]int64)
}
func deptrFromHandle_Slice_int64(h CGoHandle) []int64 {
	p := ptrFromHandle_Slice_int64(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int64(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int64", p))
}

// --- wrapping slice: []int64 ---
//
//export Slice_int64_CTor
func Slice_int64_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int64(&[]int64{}))
}

//export Slice_int64_len
func Slice_int64_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int64(handle))
}

//export Slice_int64_elem
func Slice_int64_elem(handle CGoHandle, _idx int) C.longlong {
	s := deptrFromHandle_Slice_int64(handle)
	return C.longlong(s[_idx])
}

//export Slice_int64_subslice
func Slice_int64_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int64(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int64(&ss))
}

//export Slice_int64_set
func Slice_int64_set(handle CGoHandle, _idx int, _vl C.longlong) {
	s := deptrFromHandle_Slice_int64(handle)
	s[_idx] = int64(_vl)
}

//export Slice_int64_append
func Slice_int64_append(handle CGoHandle, _vl C.longlong) {
	s := ptrFromHandle_Slice_int64(handle)
	*s = append(*s, int64(_vl))
}

// Converters for implicit pointer handles for type: []int8
func ptrFromHandle_Slice_int8(h CGoHandle) *[]int8 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int8")
	if p == nil {
		return nil
	}
	return p.(*[]int8)
}
func deptrFromHandle_Slice_int8(h CGoHandle) []int8 {
	p := ptrFromHandle_Slice_int8(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int8(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int8", p))
}

// --- wrapping slice: []int8 ---
//
//export Slice_int8_CTor
func Slice_int8_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int8(&[]int8{}))
}

//export Slice_int8_len
func Slice_int8_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int8(handle))
}

//export Slice_int8_elem
func Slice_int8_elem(handle CGoHandle, _idx int) C.char {
	s := deptrFromHandle_Slice_int8(handle)
	return C.char(s[_idx])
}

//export Slice_int8_subslice
func Slice_int8_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int8(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int8(&ss))
}

//export Slice_int8_set
func Slice_int8_set(handle CGoHandle, _idx int, _vl C.char) {
	s := deptrFromHandle_Slice_int8(handle)
	s[_idx] = int8(_vl)
}

//export Slice_int8_append
func Slice_int8_append(handle CGoHandle, _vl C.char) {
	s := ptrFromHandle_Slice_int8(handle)
	*s = append(*s, int8(_vl))
}

// Converters for implicit pointer handles for type: []rune
func ptrFromHandle_Slice_rune(h CGoHandle) *[]rune {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]rune")
	if p == nil {
		return nil
	}
	return p.(*[]rune)
}
func deptrFromHandle_Slice_rune(h CGoHandle) []rune {
	p := ptrFromHandle_Slice_rune(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_rune(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]rune", p))
}

// --- wrapping slice: []rune ---
//
//export Slice_rune_CTor
func Slice_rune_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_rune(&[]rune{}))
}

//export Slice_rune_len
func Slice_rune_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_rune(handle))
}

//export Slice_rune_elem
func Slice_rune_elem(handle CGoHandle, _idx int) C.long {
	s := deptrFromHandle_Slice_rune(handle)
	return C.long(s[_idx])
}

//export Slice_rune_subslice
func Slice_rune_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_rune(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_rune(&ss))
}

//export Slice_rune_set
func Slice_rune_set(handle CGoHandle, _idx int, _vl C.long) {
	s := deptrFromHandle_Slice_rune(handle)
	s[_idx] = rune(_vl)
}

//export Slice_rune_append
func Slice_rune_append(handle CGoHandle, _vl C.long) {
	s := ptrFromHandle_Slice_rune(handle)
	*s = append(*s, rune(_vl))
}

// Converters for implicit pointer handles for type: []string
func ptrFromHandle_Slice_string(h CGoHandle) *[]string {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]string")
	if p == nil {
		return nil
	}
	return p.(*[]string)
}
func deptrFromHandle_Slice_string(h CGoHandle) []string {
	p := ptrFromHandle_Slice_string(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_string(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]string", p))
}

// --- wrapping slice: []string ---
//
//export Slice_string_CTor
func Slice_string_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_string(&[]string{}))
}

//export Slice_string_len
func Slice_string_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_string(handle))
}

//export Slice_string_elem
func Slice_string_elem(handle CGoHandle, _idx int) *C.char {
	s := deptrFromHandle_Slice_string(handle)
	return C.CString(s[_idx])
}

//export Slice_string_subslice
func Slice_string_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_string(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_string(&ss))
}

//export Slice_string_set
func Slice_string_set(handle CGoHandle, _idx int, _vl *C.char) {
	s := deptrFromHandle_Slice_string(handle)
	s[_idx] = C.GoString(_vl)
}

//export Slice_string_append
func Slice_string_append(handle CGoHandle, _vl *C.char) {
	s := ptrFromHandle_Slice_string(handle)
	*s = append(*s, C.GoString(_vl))
}

// Converters for implicit pointer handles for type: []uint
func ptrFromHandle_Slice_uint(h CGoHandle) *[]uint {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint")
	if p == nil {
		return nil
	}
	return p.(*[]uint)
}
func deptrFromHandle_Slice_uint(h CGoHandle) []uint {
	p := ptrFromHandle_Slice_uint(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint", p))
}

// --- wrapping slice: []uint ---
//
//export Slice_uint_CTor
func Slice_uint_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint(&[]uint{}))
}

//export Slice_uint_len
func Slice_uint_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint(handle))
}

//export Slice_uint_elem
func Slice_uint_elem(handle CGoHandle, _idx int) C.ulonglong {
	s := deptrFromHandle_Slice_uint(handle)
	return C.ulonglong(s[_idx])
}

//export Slice_uint_subslice
func Slice_uint_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint(&ss))
}

//export Slice_uint_set
func Slice_uint_set(handle CGoHandle, _idx int, _vl C.ulonglong) {
	s := deptrFromHandle_Slice_uint(handle)
	s[_idx] = uint(_vl)
}

//export Slice_uint_append
func Slice_uint_append(handle CGoHandle, _vl C.ulonglong) {
	s := ptrFromHandle_Slice_uint(handle)
	*s = append(*s, uint(_vl))
}

// Converters for implicit pointer handles for type: []uint16
func ptrFromHandle_Slice_uint16(h CGoHandle) *[]uint16 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint16")
	if p == nil {
		return nil
	}
	return p.(*[]uint16)
}
func deptrFromHandle_Slice_uint16(h CGoHandle) []uint16 {
	p := ptrFromHandle_Slice_uint16(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint16(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint16", p))
}

// --- wrapping slice: []uint16 ---
//
//export Slice_uint16_CTor
func Slice_uint16_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint16(&[]uint16{}))
}

//export Slice_uint16_len
func Slice_uint16_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint16(handle))
}

//export Slice_uint16_elem
func Slice_uint16_elem(handle CGoHandle, _idx int) C.ushort {
	s := deptrFromHandle_Slice_uint16(handle)
	return C.ushort(s[_idx])
}

//export Slice_uint16_subslice
func Slice_uint16_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint16(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint16(&ss))
}

//export Slice_uint16_set
func Slice_uint16_set(handle CGoHandle, _idx int, _vl C.ushort) {
	s := deptrFromHandle_Slice_uint16(handle)
	s[_idx] = uint16(_vl)
}

//export Slice_uint16_append
func Slice_uint16_append(handle CGoHandle, _vl C.ushort) {
	s := ptrFromHandle_Slice_uint16(handle)
	*s = append(*s, uint16(_vl))
}

// Converters for implicit pointer handles for type: []uint32
func ptrFromHandle_Slice_uint32(h CGoHandle) *[]uint32 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint32")
	if p == nil {
		return nil
	}
	return p.(*[]uint32)
}
func deptrFromHandle_Slice_uint32(h CGoHandle) []uint32 {
	p := ptrFromHandle_Slice_uint32(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint32(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint32", p))
}

// --- wrapping slice: []uint32 ---
//
//export Slice_uint32_CTor
func Slice_uint32_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint32(&[]uint32{}))
}

//export Slice_uint32_len
func Slice_uint32_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint32(handle))
}

//export Slice_uint32_elem
func Slice_uint32_elem(handle CGoHandle, _idx int) C.ulong {
	s := deptrFromHandle_Slice_uint32(handle)
	return C.ulong(s[_idx])
}

//export Slice_uint32_subslice
func Slice_uint32_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint32(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint32(&ss))
}

//export Slice_uint32_set
func Slice_uint32_set(handle CGoHandle, _idx int, _vl C.ulong) {
	s := deptrFromHandle_Slice_uint32(handle)
	s[_idx] = uint32(_vl)
}

//export Slice_uint32_append
func Slice_uint32_append(handle CGoHandle, _vl C.ulong) {
	s := ptrFromHandle_Slice_uint32(handle)
	*s = append(*s, uint32(_vl))
}

// Converters for implicit pointer handles for type: []uint64
func ptrFromHandle_Slice_uint64(h CGoHandle) *[]uint64 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint64")
	if p == nil {
		return nil
	}
	return p.(*[]uint64)
}
func deptrFromHandle_Slice_uint64(h CGoHandle) []uint64 {
	p := ptrFromHandle_Slice_uint64(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint64(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint64", p))
}

// --- wrapping slice: []uint64 ---
//
//export Slice_uint64_CTor
func Slice_uint64_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint64(&[]uint64{}))
}

//export Slice_uint64_len
func Slice_uint64_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint64(handle))
}

//export Slice_uint64_elem
func Slice_uint64_elem(handle CGoHandle, _idx int) C.ulonglong {
	s := deptrFromHandle_Slice_uint64(handle)
	return C.ulonglong(s[_idx])
}

//export Slice_uint64_subslice
func Slice_uint64_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint64(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint64(&ss))
}

//export Slice_uint64_set
func Slice_uint64_set(handle CGoHandle, _idx int, _vl C.ulonglong) {
	s := deptrFromHandle_Slice_uint64(handle)
	s[_idx] = uint64(_vl)
}

//export Slice_uint64_append
func Slice_uint64_append(handle CGoHandle, _vl C.ulonglong) {
	s := ptrFromHandle_Slice_uint64(handle)
	*s = append(*s, uint64(_vl))
}

// Converters for implicit pointer handles for type: []uint8
func ptrFromHandle_Slice_uint8(h CGoHandle) *[]uint8 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint8")
	if p == nil {
		return nil
	}
	return p.(*[]uint8)
}
func deptrFromHandle_Slice_uint8(h CGoHandle) []uint8 {
	p := ptrFromHandle_Slice_uint8(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint8(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint8", p))
}

// --- wrapping slice: []uint8 ---
//
//export Slice_uint8_CTor
func Slice_uint8_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint8(&[]uint8{}))
}

//export Slice_uint8_len
func Slice_uint8_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint8(handle))
}

//export Slice_uint8_elem
func Slice_uint8_elem(handle CGoHandle, _idx int) C.uchar {
	s := deptrFromHandle_Slice_uint8(handle)
	return C.uchar(s[_idx])
}

//export Slice_uint8_subslice
func Slice_uint8_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint8(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint8(&ss))
}

//export Slice_uint8_set
func Slice_uint8_set(handle CGoHandle, _idx int, _vl C.uchar) {
	s := deptrFromHandle_Slice_uint8(handle)
	s[_idx] = uint8(_vl)
}

//export Slice_uint8_append
func Slice_uint8_append(handle CGoHandle, _vl C.uchar) {
	s := ptrFromHandle_Slice_uint8(handle)
	*s = append(*s, uint8(_vl))
}

// ---- Package: smr ---

// ---- Types ---

// Converters for pointer handles for type: *smr.Bytes
func ptrFromHandle_Ptr_smr_Bytes(h CGoHandle) *smr.Bytes {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*smr.Bytes")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.Bytes{})).(*smr.Bytes)
}
func handleFromPtr_Ptr_smr_Bytes(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*smr.Bytes", p))
}

// Converters for pointer handles for type: *smr.ConfChangeContext
func ptrFromHandle_Ptr_smr_ConfChangeContext(h CGoHandle) *smr.ConfChangeContext {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*smr.ConfChangeContext")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.ConfChangeContext{})).(*smr.ConfChangeContext)
}
func handleFromPtr_Ptr_smr_ConfChangeContext(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*smr.ConfChangeContext", p))
}

// Converters for pointer handles for type: *smr.IntRet
func ptrFromHandle_Ptr_smr_IntRet(h CGoHandle) *smr.IntRet {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*smr.IntRet")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.IntRet{})).(*smr.IntRet)
}
func handleFromPtr_Ptr_smr_IntRet(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*smr.IntRet", p))
}

// Converters for pointer handles for type: *smr.LogNode
func ptrFromHandle_Ptr_smr_LogNode(h CGoHandle) *smr.LogNode {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*smr.LogNode")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode)
}
func handleFromPtr_Ptr_smr_LogNode(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*smr.LogNode", p))
}

// Converters for pointer handles for type: *smr.LogNodeConfig
func ptrFromHandle_Ptr_smr_LogNodeConfig(h CGoHandle) *smr.LogNodeConfig {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*smr.LogNodeConfig")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.LogNodeConfig{})).(*smr.LogNodeConfig)
}
func handleFromPtr_Ptr_smr_LogNodeConfig(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*smr.LogNodeConfig", p))
}

// Converters for pointer handles for type: *smr.SMRContext
func ptrFromHandle_Ptr_smr_SMRContext(h CGoHandle) *smr.SMRContext {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*smr.SMRContext")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.SMRContext{})).(*smr.SMRContext)
}
func handleFromPtr_Ptr_smr_SMRContext(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*smr.SMRContext", p))
}

// Converters for implicit pointer handles for type: []raftpb.ConfChangeSingle
func ptrFromHandle_Slice_raftpb_ConfChangeSingle(h CGoHandle) *[]raftpb.ConfChangeSingle {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]raftpb.ConfChangeSingle")
	if p == nil {
		return nil
	}
	return p.(*[]raftpb.ConfChangeSingle)
}
func deptrFromHandle_Slice_raftpb_ConfChangeSingle(h CGoHandle) []raftpb.ConfChangeSingle {
	p := ptrFromHandle_Slice_raftpb_ConfChangeSingle(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_raftpb_ConfChangeSingle(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]raftpb.ConfChangeSingle", p))
}

// --- wrapping slice: []raftpb.ConfChangeSingle ---
//
//export Slice_raftpb_ConfChangeSingle_CTor
func Slice_raftpb_ConfChangeSingle_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_raftpb_ConfChangeSingle(&[]raftpb.ConfChangeSingle{}))
}

//export Slice_raftpb_ConfChangeSingle_len
func Slice_raftpb_ConfChangeSingle_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_raftpb_ConfChangeSingle(handle))
}

//export Slice_raftpb_ConfChangeSingle_elem
func Slice_raftpb_ConfChangeSingle_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_raftpb_ConfChangeSingle(handle)
	return handleFromPtr_raftpb_ConfChangeSingle(&(s[_idx]))
}

//export Slice_raftpb_ConfChangeSingle_subslice
func Slice_raftpb_ConfChangeSingle_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_raftpb_ConfChangeSingle(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_raftpb_ConfChangeSingle(&ss))
}

//export Slice_raftpb_ConfChangeSingle_set
func Slice_raftpb_ConfChangeSingle_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_raftpb_ConfChangeSingle(handle)
	s[_idx] = *ptrFromHandle_raftpb_ConfChangeSingle(_vl)
}

//export Slice_raftpb_ConfChangeSingle_append
func Slice_raftpb_ConfChangeSingle_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_raftpb_ConfChangeSingle(handle)
	*s = append(*s, *ptrFromHandle_raftpb_ConfChangeSingle(_vl))
}

// Converters for implicit pointer handles for type: []raftpb.Entry
func ptrFromHandle_Slice_raftpb_Entry(h CGoHandle) *[]raftpb.Entry {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]raftpb.Entry")
	if p == nil {
		return nil
	}
	return p.(*[]raftpb.Entry)
}
func deptrFromHandle_Slice_raftpb_Entry(h CGoHandle) []raftpb.Entry {
	p := ptrFromHandle_Slice_raftpb_Entry(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_raftpb_Entry(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]raftpb.Entry", p))
}

// --- wrapping slice: []raftpb.Entry ---
//
//export Slice_raftpb_Entry_CTor
func Slice_raftpb_Entry_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_raftpb_Entry(&[]raftpb.Entry{}))
}

//export Slice_raftpb_Entry_len
func Slice_raftpb_Entry_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_raftpb_Entry(handle))
}

//export Slice_raftpb_Entry_elem
func Slice_raftpb_Entry_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_raftpb_Entry(handle)
	return handleFromPtr_raftpb_Entry(&(s[_idx]))
}

//export Slice_raftpb_Entry_subslice
func Slice_raftpb_Entry_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_raftpb_Entry(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_raftpb_Entry(&ss))
}

//export Slice_raftpb_Entry_set
func Slice_raftpb_Entry_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_raftpb_Entry(handle)
	s[_idx] = *ptrFromHandle_raftpb_Entry(_vl)
}

//export Slice_raftpb_Entry_append
func Slice_raftpb_Entry_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_raftpb_Entry(handle)
	*s = append(*s, *ptrFromHandle_raftpb_Entry(_vl))
}

// Converters for implicit pointer handles for type: []walpb.Snapshot
func ptrFromHandle_Slice_walpb_Snapshot(h CGoHandle) *[]walpb.Snapshot {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]walpb.Snapshot")
	if p == nil {
		return nil
	}
	return p.(*[]walpb.Snapshot)
}
func deptrFromHandle_Slice_walpb_Snapshot(h CGoHandle) []walpb.Snapshot {
	p := ptrFromHandle_Slice_walpb_Snapshot(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_walpb_Snapshot(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]walpb.Snapshot", p))
}

// --- wrapping slice: []walpb.Snapshot ---
//
//export Slice_walpb_Snapshot_CTor
func Slice_walpb_Snapshot_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_walpb_Snapshot(&[]walpb.Snapshot{}))
}

//export Slice_walpb_Snapshot_len
func Slice_walpb_Snapshot_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_walpb_Snapshot(handle))
}

//export Slice_walpb_Snapshot_elem
func Slice_walpb_Snapshot_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_walpb_Snapshot(handle)
	return handleFromPtr_walpb_Snapshot(&(s[_idx]))
}

//export Slice_walpb_Snapshot_subslice
func Slice_walpb_Snapshot_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_walpb_Snapshot(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_walpb_Snapshot(&ss))
}

//export Slice_walpb_Snapshot_set
func Slice_walpb_Snapshot_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_walpb_Snapshot(handle)
	s[_idx] = *ptrFromHandle_walpb_Snapshot(_vl)
}

//export Slice_walpb_Snapshot_append
func Slice_walpb_Snapshot_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_walpb_Snapshot(handle)
	*s = append(*s, *ptrFromHandle_walpb_Snapshot(_vl))
}

// Converters for pointer handles for type: any
func ptrFromHandle_any(h CGoHandle) any {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "any")
	if p == nil {
		return nil
	}
	return p.(any)
}
func handleFromPtr_any(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("any", p))
}

// Converters for non-pointer handles for type: smr.Bytes
func ptrFromHandle_smr_Bytes(h CGoHandle) *smr.Bytes {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.Bytes")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.Bytes{})).(*smr.Bytes)
}
func handleFromPtr_smr_Bytes(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.Bytes", p))
}

// Converters for non-pointer handles for type: smr.ConfChangeContext
func ptrFromHandle_smr_ConfChangeContext(h CGoHandle) *smr.ConfChangeContext {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.ConfChangeContext")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.ConfChangeContext{})).(*smr.ConfChangeContext)
}
func handleFromPtr_smr_ConfChangeContext(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.ConfChangeContext", p))
}

// Converters for non-pointer handles for type: smr.IntRet
func ptrFromHandle_smr_IntRet(h CGoHandle) *smr.IntRet {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.IntRet")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.IntRet{})).(*smr.IntRet)
}
func handleFromPtr_smr_IntRet(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.IntRet", p))
}

// Converters for non-pointer handles for type: smr.LogNode
func ptrFromHandle_smr_LogNode(h CGoHandle) *smr.LogNode {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.LogNode")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode)
}
func handleFromPtr_smr_LogNode(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.LogNode", p))
}

// Converters for non-pointer handles for type: smr.LogNodeConfig
func ptrFromHandle_smr_LogNodeConfig(h CGoHandle) *smr.LogNodeConfig {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.LogNodeConfig")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.LogNodeConfig{})).(*smr.LogNodeConfig)
}
func handleFromPtr_smr_LogNodeConfig(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.LogNodeConfig", p))
}

// Converters for pointer handles for type: smr.LogSnapshotter
func ptrFromHandle_smr_LogSnapshotter(h CGoHandle) smr.LogSnapshotter {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.LogSnapshotter")
	if p == nil {
		return nil
	}
	return p.(smr.LogSnapshotter)
}
func handleFromPtr_smr_LogSnapshotter(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.LogSnapshotter", p))
}

// Converters for pointer handles for type: smr.LogStorage
func ptrFromHandle_smr_LogStorage(h CGoHandle) smr.LogStorage {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.LogStorage")
	if p == nil {
		return nil
	}
	return p.(smr.LogStorage)
}
func handleFromPtr_smr_LogStorage(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.LogStorage", p))
}

// Converters for pointer handles for type: smr.ReadCloser
func ptrFromHandle_smr_ReadCloser(h CGoHandle) smr.ReadCloser {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.ReadCloser")
	if p == nil {
		return nil
	}
	return p.(smr.ReadCloser)
}
func handleFromPtr_smr_ReadCloser(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.ReadCloser", p))
}

// Converters for non-pointer handles for type: smr.SMRContext
func ptrFromHandle_smr_SMRContext(h CGoHandle) *smr.SMRContext {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.SMRContext")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(smr.SMRContext{})).(*smr.SMRContext)
}
func handleFromPtr_smr_SMRContext(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.SMRContext", p))
}

// Converters for pointer handles for type: smr.SmrContext
func ptrFromHandle_smr_SmrContext(h CGoHandle) smr.SmrContext {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.SmrContext")
	if p == nil {
		return nil
	}
	return p.(smr.SmrContext)
}
func handleFromPtr_smr_SmrContext(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.SmrContext", p))
}

// Converters for pointer handles for type: smr.WriteCloser
func ptrFromHandle_smr_WriteCloser(h CGoHandle) smr.WriteCloser {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "smr.WriteCloser")
	if p == nil {
		return nil
	}
	return p.(smr.WriteCloser)
}
func handleFromPtr_smr_WriteCloser(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("smr.WriteCloser", p))
}

// ---- Global Variables: can only use functions to access ---
//
//export smr_AddNodeProposalDeadline
func smr_AddNodeProposalDeadline() C.longlong {
	return C.longlong(int64(smr.AddNodeProposalDeadline))
}

//export smr_Set_AddNodeProposalDeadline
func smr_Set_AddNodeProposalDeadline(val C.longlong) {
	smr.AddNodeProposalDeadline = time.Duration(int64(val))
}

//export smr_ErrEOF
func smr_ErrEOF() *C.char {
	return C.CString(smr.ErrEOF)
}

//export smr_Set_ErrEOF
func smr_Set_ErrEOF(val *C.char) {
	smr.ErrEOF = C.GoString(val)
}

//export smr_ProposalDeadline
func smr_ProposalDeadline() C.longlong {
	return C.longlong(int64(smr.ProposalDeadline))
}

//export smr_Set_ProposalDeadline
func smr_Set_ProposalDeadline(val C.longlong) {
	smr.ProposalDeadline = time.Duration(int64(val))
}

//export smr_RemoveNodeProposalDeadline
func smr_RemoveNodeProposalDeadline() C.longlong {
	return C.longlong(int64(smr.RemoveNodeProposalDeadline))
}

//export smr_Set_RemoveNodeProposalDeadline
func smr_Set_RemoveNodeProposalDeadline(val C.longlong) {
	smr.RemoveNodeProposalDeadline = time.Duration(int64(val))
}

//export smr_UpdateNodeProposalDeadline
func smr_UpdateNodeProposalDeadline() C.longlong {
	return C.longlong(int64(smr.UpdateNodeProposalDeadline))
}

//export smr_Set_UpdateNodeProposalDeadline
func smr_Set_UpdateNodeProposalDeadline(val C.longlong) {
	smr.UpdateNodeProposalDeadline = time.Duration(int64(val))
}

// ---- Interfaces ---

//export smr_LogSnapshotter_Load
func smr_LogSnapshotter_Load(_handle CGoHandle) CGoHandle {
	go_src_func_name := "smr_LogSnapshotter_Load"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.LogSnapshotter")
	if __err != nil {
		return handleFromPtr_Ptr_raftpb_Snapshot(nil)
	}
	cret, __err := vifc.(smr.LogSnapshotter).Load()

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_Ptr_raftpb_Snapshot(nil)
	}
	return handleFromPtr_Ptr_raftpb_Snapshot(cret)
}

//export smr_LogSnapshotter_LoadNewestAvailable
func smr_LogSnapshotter_LoadNewestAvailable(_handle CGoHandle, arg_0 CGoHandle) CGoHandle {
	go_src_func_name := "smr_LogSnapshotter_LoadNewestAvailable"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.LogSnapshotter")
	if __err != nil {
		return handleFromPtr_Ptr_raftpb_Snapshot(nil)
	}
	cret, __err := vifc.(smr.LogSnapshotter).LoadNewestAvailable(deptrFromHandle_Slice_walpb_Snapshot(arg_0))

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_Ptr_raftpb_Snapshot(nil)
	}
	return handleFromPtr_Ptr_raftpb_Snapshot(cret)
}

//export smr_LogSnapshotter_SaveSnap
func smr_LogSnapshotter_SaveSnap(_handle CGoHandle, arg_0 CGoHandle) *C.char {
	go_src_func_name := "smr_LogSnapshotter_SaveSnap"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.LogSnapshotter")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = vifc.(smr.LogSnapshotter).SaveSnap(*ptrFromHandle_raftpb_Snapshot(arg_0))

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogStorage_Close
func smr_LogStorage_Close(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_LogStorage_Close"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.LogStorage")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = vifc.(smr.LogStorage).Close()

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogStorage_ReleaseLockTo
func smr_LogStorage_ReleaseLockTo(_handle CGoHandle, arg_0 C.ulonglong) *C.char {
	go_src_func_name := "smr_LogStorage_ReleaseLockTo"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.LogStorage")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = vifc.(smr.LogStorage).ReleaseLockTo(uint64(arg_0))

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogStorage_Save
func smr_LogStorage_Save(_handle CGoHandle, arg_0 CGoHandle, arg_1 CGoHandle) *C.char {
	go_src_func_name := "smr_LogStorage_Save"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.LogStorage")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = vifc.(smr.LogStorage).Save(*ptrFromHandle_raftpb_HardState(arg_0), deptrFromHandle_Slice_raftpb_Entry(arg_1))

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogStorage_SaveSnapshot
func smr_LogStorage_SaveSnapshot(_handle CGoHandle, arg_0 CGoHandle, goRun C.char) {
	go_src_func_name := "smr_LogStorage_SaveSnapshot"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.LogStorage")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go vifc.(smr.LogStorage).SaveSnapshot(*ptrFromHandle_walpb_Snapshot(arg_0))
	} else {
		vifc.(smr.LogStorage).SaveSnapshot(*ptrFromHandle_walpb_Snapshot(arg_0))
	}
}

//export smr_ReadCloser_Close
func smr_ReadCloser_Close(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_ReadCloser_Close"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.ReadCloser")
	if __err != nil {
		return C.CString("")
	}
	return C.CString(vifc.(smr.ReadCloser).Close())

}

//export smr_ReadCloser_Read
func smr_ReadCloser_Read(_handle CGoHandle, p CGoHandle) CGoHandle {
	go_src_func_name := "smr_ReadCloser_Read"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.ReadCloser")
	if __err != nil {
		return handleFromPtr_Ptr_smr_IntRet(nil)
	}
	return handleFromPtr_Ptr_smr_IntRet(vifc.(smr.ReadCloser).Read(*ptrFromHandle_smr_Bytes(p)))

}

//export smr_SmrContext_Cancel
func smr_SmrContext_Cancel(_handle CGoHandle, goRun C.char) {
	go_src_func_name := "smr_SmrContext_Cancel"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.SmrContext")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go vifc.(smr.SmrContext).Cancel()
	} else {
		vifc.(smr.SmrContext).Cancel()
	}
}

//export smr_SmrContext_Err
func smr_SmrContext_Err(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_SmrContext_Err"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.SmrContext")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = vifc.(smr.SmrContext).Err()

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_SmrContext_ID
func smr_SmrContext_ID(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_SmrContext_ID"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.SmrContext")
	if __err != nil {
		return C.CString("")
	}
	return C.CString(vifc.(smr.SmrContext).ID())

}

//export smr_SmrContext_Reset
func smr_SmrContext_Reset(_handle CGoHandle, timeout C.longlong) CGoHandle {
	go_src_func_name := "smr_SmrContext_Reset"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.SmrContext")
	if __err != nil {
		return handleFromPtr_smr_SmrContext(nil)
	}
	return handleFromPtr_smr_SmrContext(vifc.(smr.SmrContext).Reset(time.Duration(int64(timeout))))

}

//export smr_SmrContext_ResetWithPreviousTimeout
func smr_SmrContext_ResetWithPreviousTimeout(_handle CGoHandle) CGoHandle {
	go_src_func_name := "smr_SmrContext_ResetWithPreviousTimeout"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.SmrContext")
	if __err != nil {
		return handleFromPtr_smr_SmrContext(nil)
	}
	return handleFromPtr_smr_SmrContext(vifc.(smr.SmrContext).ResetWithPreviousTimeout())

}

//export smr_SmrContext_Value
func smr_SmrContext_Value(_handle CGoHandle, key CGoHandle) CGoHandle {
	go_src_func_name := "smr_SmrContext_Value"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.SmrContext")
	if __err != nil {
		return handleFromPtr_any(nil)
	}
	return handleFromPtr_any(vifc.(smr.SmrContext).Value(ptrFromHandle_any(key)))

}

//export smr_WriteCloser_Close
func smr_WriteCloser_Close(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_WriteCloser_Close"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.WriteCloser")
	if __err != nil {
		return C.CString("")
	}
	return C.CString(vifc.(smr.WriteCloser).Close())

}

//export smr_WriteCloser_Write
func smr_WriteCloser_Write(_handle CGoHandle, p CGoHandle) CGoHandle {
	go_src_func_name := "smr_WriteCloser_Write"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "smr.WriteCloser")
	if __err != nil {
		return handleFromPtr_Ptr_smr_IntRet(nil)
	}
	return handleFromPtr_Ptr_smr_IntRet(vifc.(smr.WriteCloser).Write(*ptrFromHandle_smr_Bytes(p)))

}

// ---- Structs ---

// --- wrapping struct: smr.Bytes ---
//
//export smr_Bytes_CTor
func smr_Bytes_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_smr_Bytes(&smr.Bytes{}))
}

//export smr_Bytes_Bytes
func smr_Bytes_Bytes(_handle CGoHandle) CGoHandle {
	go_src_func_name := "smr_Bytes_Bytes"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.Bytes")
	if __err != nil {
		return handleFromPtr_Slice_byte(nil)
	}
	cret := gopyh.Embed(vifc, reflect.TypeOf(smr.Bytes{})).(*smr.Bytes).Bytes()

	return handleFromPtr_Slice_byte(&cret)
}

//export smr_Bytes_Len
func smr_Bytes_Len(_handle CGoHandle) C.longlong {
	go_src_func_name := "smr_Bytes_Len"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.Bytes")
	if __err != nil {
		return C.longlong(0)
	}
	return C.longlong(gopyh.Embed(vifc, reflect.TypeOf(smr.Bytes{})).(*smr.Bytes).Len())

}

// --- wrapping struct: smr.SMRContext ---
//
//export smr_SMRContext_CTor
func smr_SMRContext_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_smr_SMRContext(&smr.SMRContext{}))
}

//export smr_SMRContext_Timeout_Get
func smr_SMRContext_Timeout_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_smr_SMRContext(handle)
	return C.longlong(int64(op.Timeout))
}

//export smr_SMRContext_Timeout_Set
func smr_SMRContext_Timeout_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_smr_SMRContext(handle)
	op.Timeout = time.Duration(int64(val))
}

//export smr_SMRContext_ID
func smr_SMRContext_ID(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_SMRContext_ID"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.SMRContext")
	if __err != nil {
		return C.CString("")
	}
	return C.CString(gopyh.Embed(vifc, reflect.TypeOf(smr.SMRContext{})).(*smr.SMRContext).ID())

}

//export smr_SMRContext_Reset
func smr_SMRContext_Reset(_handle CGoHandle, timeout C.longlong) CGoHandle {
	go_src_func_name := "smr_SMRContext_Reset"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.SMRContext")
	if __err != nil {
		return handleFromPtr_smr_SmrContext(nil)
	}
	return handleFromPtr_smr_SmrContext(gopyh.Embed(vifc, reflect.TypeOf(smr.SMRContext{})).(*smr.SMRContext).Reset(time.Duration(int64(timeout))))

}

//export smr_SMRContext_ResetWithPreviousTimeout
func smr_SMRContext_ResetWithPreviousTimeout(_handle CGoHandle) CGoHandle {
	go_src_func_name := "smr_SMRContext_ResetWithPreviousTimeout"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.SMRContext")
	if __err != nil {
		return handleFromPtr_smr_SmrContext(nil)
	}
	return handleFromPtr_smr_SmrContext(gopyh.Embed(vifc, reflect.TypeOf(smr.SMRContext{})).(*smr.SMRContext).ResetWithPreviousTimeout())

}

//export smr_SMRContext_Cancel
func smr_SMRContext_Cancel(_handle CGoHandle, goRun C.char) {
	go_src_func_name := "smr_SMRContext_Cancel"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.SMRContext")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.SMRContext{})).(*smr.SMRContext).Cancel()
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.SMRContext{})).(*smr.SMRContext).Cancel()
	}
}

// --- wrapping struct: smr.IntRet ---
//
//export smr_IntRet_CTor
func smr_IntRet_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_smr_IntRet(&smr.IntRet{}))
}

//export smr_IntRet_N_Get
func smr_IntRet_N_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_smr_IntRet(handle)
	return C.longlong(op.N)
}

//export smr_IntRet_N_Set
func smr_IntRet_N_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_smr_IntRet(handle)
	op.N = int(val)
}

//export smr_IntRet_Err_Get
func smr_IntRet_Err_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_smr_IntRet(handle)
	return C.CString(op.Err)
}

//export smr_IntRet_Err_Set
func smr_IntRet_Err_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_smr_IntRet(handle)
	op.Err = C.GoString(val)
}

// --- wrapping struct: smr.LogNode ---
//
//export smr_LogNode_CTor
func smr_LogNode_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_smr_LogNode(&smr.LogNode{}))
}

//export smr_LogNode_ServeHttpDebug
func smr_LogNode_ServeHttpDebug(_handle CGoHandle, goRun C.char) {
	go_src_func_name := "smr_LogNode_ServeHttpDebug"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).ServeHttpDebug()
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).ServeHttpDebug()
	}
}

//export smr_LogNode_RemoteStorageReadLatencyMilliseconds
func smr_LogNode_RemoteStorageReadLatencyMilliseconds(_handle CGoHandle) C.longlong {
	go_src_func_name := "smr_LogNode_RemoteStorageReadLatencyMilliseconds"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return C.longlong(0)
	}
	return C.longlong(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).RemoteStorageReadLatencyMilliseconds())

}

//export smr_LogNode_ConnectedToRemoteStorage
func smr_LogNode_ConnectedToRemoteStorage(_handle CGoHandle) C.char {
	go_src_func_name := "smr_LogNode_ConnectedToRemoteStorage"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return boolGoToPy(false)
	}
	return boolGoToPy(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).ConnectedToRemoteStorage())

}

//export smr_LogNode_NumChanges
func smr_LogNode_NumChanges(_handle CGoHandle) C.longlong {
	go_src_func_name := "smr_LogNode_NumChanges"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return C.longlong(0)
	}
	return C.longlong(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).NumChanges())

}

//export smr_LogNode_Start
func smr_LogNode_Start(_handle CGoHandle, config CGoHandle) C.char {
	go_src_func_name := "smr_LogNode_Start"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return boolGoToPy(false)
	}
	return boolGoToPy(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).Start(ptrFromHandle_Ptr_smr_LogNodeConfig(config)))

}

//export smr_LogNode_StartAndWait
func smr_LogNode_StartAndWait(_handle CGoHandle, config CGoHandle, goRun C.char) {
	go_src_func_name := "smr_LogNode_StartAndWait"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).StartAndWait(ptrFromHandle_Ptr_smr_LogNodeConfig(config))
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).StartAndWait(ptrFromHandle_Ptr_smr_LogNodeConfig(config))
	}
}

//export smr_LogNode_GetSerializedState
func smr_LogNode_GetSerializedState(_handle CGoHandle) CGoHandle {
	go_src_func_name := "smr_LogNode_GetSerializedState"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return handleFromPtr_Slice_byte(nil)
	}
	cret := gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).GetSerializedState()

	return handleFromPtr_Slice_byte(&cret)
}

//export smr_LogNode_Propose
func smr_LogNode_Propose(_handle CGoHandle, val CGoHandle, resolve *C.PyObject, msg *C.char, goRun C.char) {
	_fun_arg := resolve
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNode_Propose"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).Propose(*ptrFromHandle_smr_Bytes(val), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		}, C.GoString(msg))
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).Propose(*ptrFromHandle_smr_Bytes(val), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		}, C.GoString(msg))
	}
}

//export smr_LogNode_AddNode
func smr_LogNode_AddNode(_handle CGoHandle, id C.longlong, addr *C.char, resolve *C.PyObject, goRun C.char) {
	_fun_arg := resolve
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNode_AddNode"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).AddNode(int(id), C.GoString(addr), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).AddNode(int(id), C.GoString(addr), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	}
}

//export smr_LogNode_RemoveNode
func smr_LogNode_RemoveNode(_handle CGoHandle, id C.longlong, resolve *C.PyObject, goRun C.char) {
	_fun_arg := resolve
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNode_RemoveNode"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).RemoveNode(int(id), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).RemoveNode(int(id), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	}
}

//export smr_LogNode_UpdateNode
func smr_LogNode_UpdateNode(_handle CGoHandle, id C.longlong, addr *C.char, resolve *C.PyObject, goRun C.char) {
	_fun_arg := resolve
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNode_UpdateNode"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).UpdateNode(int(id), C.GoString(addr), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).UpdateNode(int(id), C.GoString(addr), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	}
}

//export smr_LogNode_WaitToClose
func smr_LogNode_WaitToClose(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_LogNode_WaitToClose"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).WaitToClose()

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogNode_Close
func smr_LogNode_Close(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_LogNode_Close"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).Close()

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogNode_CloseRemoteStorageClient
func smr_LogNode_CloseRemoteStorageClient(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_LogNode_CloseRemoteStorageClient"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).CloseRemoteStorageClient()

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogNode_WriteDataDirectoryToRemoteStorage
func smr_LogNode_WriteDataDirectoryToRemoteStorage(_handle CGoHandle, serializedState CGoHandle, resolve *C.PyObject, goRun C.char) {
	_fun_arg := resolve
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNode_WriteDataDirectoryToRemoteStorage"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).WriteDataDirectoryToRemoteStorage(deptrFromHandle_Slice_byte(serializedState), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).WriteDataDirectoryToRemoteStorage(deptrFromHandle_Slice_byte(serializedState), func(arg_0 interface{}, arg_1 string) {
			runtime.LockOSThread()
			fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			wg.Wait()
			fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			_gstate := C.PyGILState_Ensure() // Acquire GIL
			fmt.Printf("Acquired GIL in Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			if _fun_arg == nil {
				fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			if C.PyCallable_Check(_fun_arg) == 0 {
				C.PyGILState_Release(_gstate) // Release GIL
				return
			}
			fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_string(C.CString(fmt.Sprintf("%s", (arg_0)))))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_string(C.CString(arg_1)))
			fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			fmt.Printf("Calling into Python callback of type smr.ResolveCallback now [%s] \n", go_src_func_name)
			C.PyObject_CallObject(_fun_arg, _fcargs)
			fmt.Printf("Returned from Python callback of type smr.ResolveCallback [%s] \n", go_src_func_name)
			fmt.Printf("Checking if Python error occurred while executing callback of type smr.ResolveCallback [%s] now...\n", go_src_func_name)
			if C.PyErr_Occurred() != nil {
				fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ResolveCallback [%s]! Printing the error now...\n", go_src_func_name)
				C.PyErr_Print()
			} else {
				fmt.Printf("No Python error occurred while executing callback of type smr.ResolveCallback [%s].\n", go_src_func_name)
			}
			C.gopy_decref(_fcargs)
			C.PyGILState_Release(_gstate) // Release GIL
		})
	}
}

//export smr_LogNode_Process
func smr_LogNode_Process(_handle CGoHandle, ctx CGoHandle, m CGoHandle) *C.char {
	go_src_func_name := "smr_LogNode_Process"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).Process(ptrFromHandle_context_Context(ctx), *ptrFromHandle_raftpb_Message(m))

	C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export smr_LogNode_IsIDRemoved
func smr_LogNode_IsIDRemoved(_handle CGoHandle, id C.ulonglong) C.char {
	go_src_func_name := "smr_LogNode_IsIDRemoved"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return boolGoToPy(false)
	}
	return boolGoToPy(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).IsIDRemoved(uint64(id)))

}

//export smr_LogNode_ReportUnreachable
func smr_LogNode_ReportUnreachable(_handle CGoHandle, id C.ulonglong, goRun C.char) {
	go_src_func_name := "smr_LogNode_ReportUnreachable"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).ReportUnreachable(uint64(id))
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).ReportUnreachable(uint64(id))
	}
}

//export smr_LogNode_ReportSnapshot
func smr_LogNode_ReportSnapshot(_handle CGoHandle, id C.ulonglong, status C.longlong, goRun C.char) {
	go_src_func_name := "smr_LogNode_ReportSnapshot"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNode")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).ReportSnapshot(uint64(id), raft.SnapshotStatus(int(status)))
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(smr.LogNode{})).(*smr.LogNode).ReportSnapshot(uint64(id), raft.SnapshotStatus(int(status)))
	}
}

// --- wrapping struct: smr.LogNodeConfig ---
//
//export smr_LogNodeConfig_CTor
func smr_LogNodeConfig_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_smr_LogNodeConfig(&smr.LogNodeConfig{}))
}

//export smr_LogNodeConfig_ElectionTick_Get
func smr_LogNodeConfig_ElectionTick_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_smr_LogNodeConfig(handle)
	return C.longlong(op.ElectionTick)
}

//export smr_LogNodeConfig_ElectionTick_Set
func smr_LogNodeConfig_ElectionTick_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_smr_LogNodeConfig(handle)
	op.ElectionTick = int(val)
}

//export smr_LogNodeConfig_HeartbeatTick_Get
func smr_LogNodeConfig_HeartbeatTick_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_smr_LogNodeConfig(handle)
	return C.longlong(op.HeartbeatTick)
}

//export smr_LogNodeConfig_HeartbeatTick_Set
func smr_LogNodeConfig_HeartbeatTick_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_smr_LogNodeConfig(handle)
	op.HeartbeatTick = int(val)
}

//export smr_LogNodeConfig_Debug_Get
func smr_LogNodeConfig_Debug_Get(handle CGoHandle) C.char {
	op := ptrFromHandle_smr_LogNodeConfig(handle)
	return boolGoToPy(op.Debug)
}

//export smr_LogNodeConfig_Debug_Set
func smr_LogNodeConfig_Debug_Set(handle CGoHandle, val C.char) {
	op := ptrFromHandle_smr_LogNodeConfig(handle)
	op.Debug = boolPyToGo(val)
}

//export smr_LogNodeConfig_WithChangeCallback
func smr_LogNodeConfig_WithChangeCallback(_handle CGoHandle, cb *C.PyObject) CGoHandle {
	_fun_arg := cb
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNodeConfig_WithChangeCallback"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNodeConfig")
	if __err != nil {
		return handleFromPtr_Ptr_smr_LogNodeConfig(nil)
	}
	return handleFromPtr_Ptr_smr_LogNodeConfig(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNodeConfig{})).(*smr.LogNodeConfig).WithChangeCallback(func(arg_0 smr.ReadCloser, arg_1 int, arg_2 string) string {
		runtime.LockOSThread()
		fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.StateValueCallback [%s] \n", go_src_func_name)
		wg.Wait()
		fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.StateValueCallback [%s] \n", go_src_func_name)
		_gstate := C.PyGILState_Ensure() // Acquire GIL
		fmt.Printf("Acquired GIL in Python callback of type smr.StateValueCallback [%s] \n", go_src_func_name)
		if _fun_arg == nil {
			fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
			C.PyGILState_Release(_gstate) // Release GIL
			return C.GoString(nil)
		}
		if C.PyCallable_Check(_fun_arg) == 0 {
			C.PyGILState_Release(_gstate) // Release GIL
			return C.GoString(nil)
		}
		fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.StateValueCallback now [%s] \n", go_src_func_name)
		_fcargs := C.PyTuple_New(3)
		C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_int64(C.int64_t(handleFromPtr_smr_ReadCloser(arg_0))))
		C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_int64(C.int64_t(arg_1)))
		C.PyTuple_SetItem(_fcargs, 2, C.gopy_build_string(C.CString(arg_2)))
		fmt.Printf("Setup Python arguments tuple for Python callback of type smr.StateValueCallback now [%s] \n", go_src_func_name)
		fmt.Printf("Calling into Python callback of type smr.StateValueCallback now [%s] \n", go_src_func_name)
		_fcret := C.PyObject_CallObject(_fun_arg, _fcargs)
		fmt.Printf("Returned from Python callback of type smr.StateValueCallback [%s] \n", go_src_func_name)
		fmt.Printf("Checking if Python error occurred while executing callback of type smr.StateValueCallback [%s] now...\n", go_src_func_name)
		if C.PyErr_Occurred() != nil {
			fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.StateValueCallback [%s]! Printing the error now...\n", go_src_func_name)
			C.PyErr_Print()
		} else {
			fmt.Printf("No Python error occurred while executing callback of type smr.StateValueCallback [%s].\n", go_src_func_name)
		}
		C.gopy_decref(_fcargs)
		ret := C.GoString(C.PyBytes_AsString(_fcret))
		C.PyGILState_Release(_gstate) // Release GIL
		return ret
	}))

}

//export smr_LogNodeConfig_WithRestoreCallback
func smr_LogNodeConfig_WithRestoreCallback(_handle CGoHandle, cb *C.PyObject) CGoHandle {
	_fun_arg := cb
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNodeConfig_WithRestoreCallback"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNodeConfig")
	if __err != nil {
		return handleFromPtr_Ptr_smr_LogNodeConfig(nil)
	}
	return handleFromPtr_Ptr_smr_LogNodeConfig(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNodeConfig{})).(*smr.LogNodeConfig).WithRestoreCallback(func(arg_0 smr.ReadCloser, arg_1 int) string {
		runtime.LockOSThread()
		fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.StatesValueCallback [%s] \n", go_src_func_name)
		wg.Wait()
		fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.StatesValueCallback [%s] \n", go_src_func_name)
		_gstate := C.PyGILState_Ensure() // Acquire GIL
		fmt.Printf("Acquired GIL in Python callback of type smr.StatesValueCallback [%s] \n", go_src_func_name)
		if _fun_arg == nil {
			fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
			C.PyGILState_Release(_gstate) // Release GIL
			return C.GoString(nil)
		}
		if C.PyCallable_Check(_fun_arg) == 0 {
			C.PyGILState_Release(_gstate) // Release GIL
			return C.GoString(nil)
		}
		fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.StatesValueCallback now [%s] \n", go_src_func_name)
		_fcargs := C.PyTuple_New(2)
		C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_int64(C.int64_t(handleFromPtr_smr_ReadCloser(arg_0))))
		C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_int64(C.int64_t(arg_1)))
		fmt.Printf("Setup Python arguments tuple for Python callback of type smr.StatesValueCallback now [%s] \n", go_src_func_name)
		fmt.Printf("Calling into Python callback of type smr.StatesValueCallback now [%s] \n", go_src_func_name)
		_fcret := C.PyObject_CallObject(_fun_arg, _fcargs)
		fmt.Printf("Returned from Python callback of type smr.StatesValueCallback [%s] \n", go_src_func_name)
		fmt.Printf("Checking if Python error occurred while executing callback of type smr.StatesValueCallback [%s] now...\n", go_src_func_name)
		if C.PyErr_Occurred() != nil {
			fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.StatesValueCallback [%s]! Printing the error now...\n", go_src_func_name)
			C.PyErr_Print()
		} else {
			fmt.Printf("No Python error occurred while executing callback of type smr.StatesValueCallback [%s].\n", go_src_func_name)
		}
		C.gopy_decref(_fcargs)
		ret := C.GoString(C.PyBytes_AsString(_fcret))
		C.PyGILState_Release(_gstate) // Release GIL
		return ret
	}))

}

//export smr_LogNodeConfig_WithShouldSnapshotCallback
func smr_LogNodeConfig_WithShouldSnapshotCallback(_handle CGoHandle, cb *C.PyObject) CGoHandle {
	_fun_arg := cb
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNodeConfig_WithShouldSnapshotCallback"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNodeConfig")
	if __err != nil {
		return handleFromPtr_Ptr_smr_LogNodeConfig(nil)
	}
	return handleFromPtr_Ptr_smr_LogNodeConfig(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNodeConfig{})).(*smr.LogNodeConfig).WithShouldSnapshotCallback(func(arg_0 *smr.LogNode) bool {
		runtime.LockOSThread()
		fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.ShouldLogNodeCallback [%s] \n", go_src_func_name)
		wg.Wait()
		fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.ShouldLogNodeCallback [%s] \n", go_src_func_name)
		_gstate := C.PyGILState_Ensure() // Acquire GIL
		fmt.Printf("Acquired GIL in Python callback of type smr.ShouldLogNodeCallback [%s] \n", go_src_func_name)
		if _fun_arg == nil {
			fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
			C.PyGILState_Release(_gstate) // Release GIL
			return false
		}
		if C.PyCallable_Check(_fun_arg) == 0 {
			C.PyGILState_Release(_gstate) // Release GIL
			return false
		}
		fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.ShouldLogNodeCallback now [%s] \n", go_src_func_name)
		_fcargs := C.PyTuple_New(1)
		C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_int64(C.int64_t(handleFromPtr_Ptr_smr_LogNode(arg_0))))
		fmt.Printf("Setup Python arguments tuple for Python callback of type smr.ShouldLogNodeCallback now [%s] \n", go_src_func_name)
		fmt.Printf("Calling into Python callback of type smr.ShouldLogNodeCallback now [%s] \n", go_src_func_name)
		_fcret := C.PyObject_CallObject(_fun_arg, _fcargs)
		fmt.Printf("Returned from Python callback of type smr.ShouldLogNodeCallback [%s] \n", go_src_func_name)
		fmt.Printf("Checking if Python error occurred while executing callback of type smr.ShouldLogNodeCallback [%s] now...\n", go_src_func_name)
		if C.PyErr_Occurred() != nil {
			fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.ShouldLogNodeCallback [%s]! Printing the error now...\n", go_src_func_name)
			C.PyErr_Print()
		} else {
			fmt.Printf("No Python error occurred while executing callback of type smr.ShouldLogNodeCallback [%s].\n", go_src_func_name)
		}
		C.gopy_decref(_fcargs)
		ret := boolPyToGo(C.char(C.PyLong_AsLongLong(_fcret)))
		C.PyGILState_Release(_gstate) // Release GIL
		return ret
	}))

}

//export smr_LogNodeConfig_WithSnapshotCallback
func smr_LogNodeConfig_WithSnapshotCallback(_handle CGoHandle, cb *C.PyObject) CGoHandle {
	_fun_arg := cb
	C.gopy_incref(_fun_arg)
	go_src_func_name := "smr_LogNodeConfig_WithSnapshotCallback"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNodeConfig")
	if __err != nil {
		return handleFromPtr_Ptr_smr_LogNodeConfig(nil)
	}
	return handleFromPtr_Ptr_smr_LogNodeConfig(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNodeConfig{})).(*smr.LogNodeConfig).WithSnapshotCallback(func(arg_0 smr.WriteCloser) string {
		runtime.LockOSThread()
		fmt.Printf("Calling WaitGroup::Wait() while preparing to execute Python callback of type smr.WriteCallback [%s] \n", go_src_func_name)
		wg.Wait()
		fmt.Printf("Returned from WaitGroup::Wait() while preparing to execute Python callback of type smr.WriteCallback [%s] \n", go_src_func_name)
		_gstate := C.PyGILState_Ensure() // Acquire GIL
		fmt.Printf("Acquired GIL in Python callback of type smr.WriteCallback [%s] \n", go_src_func_name)
		if _fun_arg == nil {
			fmt.Printf("[CGO WARNING] 'resolve' PyObject* callback is nil.\n")
			C.PyGILState_Release(_gstate) // Release GIL
			return C.GoString(nil)
		}
		if C.PyCallable_Check(_fun_arg) == 0 {
			C.PyGILState_Release(_gstate) // Release GIL
			return C.GoString(nil)
		}
		fmt.Printf("Setting up Python arguments tuple for Python callback of type smr.WriteCallback now [%s] \n", go_src_func_name)
		_fcargs := C.PyTuple_New(1)
		C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_int64(C.int64_t(handleFromPtr_smr_WriteCloser(arg_0))))
		fmt.Printf("Setup Python arguments tuple for Python callback of type smr.WriteCallback now [%s] \n", go_src_func_name)
		fmt.Printf("Calling into Python callback of type smr.WriteCallback now [%s] \n", go_src_func_name)
		_fcret := C.PyObject_CallObject(_fun_arg, _fcargs)
		fmt.Printf("Returned from Python callback of type smr.WriteCallback [%s] \n", go_src_func_name)
		fmt.Printf("Checking if Python error occurred while executing callback of type smr.WriteCallback [%s] now...\n", go_src_func_name)
		if C.PyErr_Occurred() != nil {
			fmt.Printf("[ERROR] A Python error occurred while executing callback of type smr.WriteCallback [%s]! Printing the error now...\n", go_src_func_name)
			C.PyErr_Print()
		} else {
			fmt.Printf("No Python error occurred while executing callback of type smr.WriteCallback [%s].\n", go_src_func_name)
		}
		C.gopy_decref(_fcargs)
		ret := C.GoString(C.PyBytes_AsString(_fcret))
		C.PyGILState_Release(_gstate) // Release GIL
		return ret
	}))

}

//export smr_LogNodeConfig_String
func smr_LogNodeConfig_String(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_LogNodeConfig_String"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.LogNodeConfig")
	if __err != nil {
		return C.CString("")
	}
	return C.CString(gopyh.Embed(vifc, reflect.TypeOf(smr.LogNodeConfig{})).(*smr.LogNodeConfig).String())

}

// --- wrapping struct: smr.ConfChangeContext ---
//
//export smr_ConfChangeContext_CTor
func smr_ConfChangeContext_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_smr_ConfChangeContext(&smr.ConfChangeContext{}))
}

//export smr_ConfChangeContext_ID
func smr_ConfChangeContext_ID(_handle CGoHandle) *C.char {
	go_src_func_name := "smr_ConfChangeContext_ID"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.ConfChangeContext")
	if __err != nil {
		return C.CString("")
	}
	return C.CString(gopyh.Embed(vifc, reflect.TypeOf(smr.ConfChangeContext{})).(*smr.ConfChangeContext).ID())

}

//export smr_ConfChangeContext_Reset
func smr_ConfChangeContext_Reset(_handle CGoHandle, timeout C.longlong) CGoHandle {
	go_src_func_name := "smr_ConfChangeContext_Reset"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.ConfChangeContext")
	if __err != nil {
		return handleFromPtr_smr_SmrContext(nil)
	}
	return handleFromPtr_smr_SmrContext(gopyh.Embed(vifc, reflect.TypeOf(smr.ConfChangeContext{})).(*smr.ConfChangeContext).Reset(time.Duration(int64(timeout))))

}

//export smr_ConfChangeContext_ResetWithPreviousTimeout
func smr_ConfChangeContext_ResetWithPreviousTimeout(_handle CGoHandle) CGoHandle {
	go_src_func_name := "smr_ConfChangeContext_ResetWithPreviousTimeout"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*smr.ConfChangeContext")
	if __err != nil {
		return handleFromPtr_smr_SmrContext(nil)
	}
	return handleFromPtr_smr_SmrContext(gopyh.Embed(vifc, reflect.TypeOf(smr.ConfChangeContext{})).(*smr.ConfChangeContext).ResetWithPreviousTimeout())

}

// ---- Slices ---

// ---- Maps ---

// ---- Constructors ---

//export smr_NewLogNode
func smr_NewLogNode(storePath *C.char, id C.longlong, remoteStorageHostname *C.char, remoteStorage *C.char, shouldLoadDataFromRemoteStorage C.char, peerAddresses CGoHandle, peerIDs CGoHandle, join C.char, httpDebugPort C.longlong, deploymentMode *C.char) CGoHandle {
	go_src_func_name := "_NewLogNode"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	return handleFromPtr_Ptr_smr_LogNode(smr.NewLogNode(C.GoString(storePath), int(id), C.GoString(remoteStorageHostname), C.GoString(remoteStorage), boolPyToGo(shouldLoadDataFromRemoteStorage), deptrFromHandle_Slice_string(peerAddresses), deptrFromHandle_Slice_int(peerIDs), boolPyToGo(join), int(httpDebugPort), C.GoString(deploymentMode)))

}

//export smr_NewConfig
func smr_NewConfig() CGoHandle {
	go_src_func_name := "_NewConfig"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	return handleFromPtr_Ptr_smr_LogNodeConfig(smr.NewConfig())

}

//export smr_NewConfChangeContext
func smr_NewConfChangeContext(id *C.char, cc CGoHandle, timeout C.longlong) CGoHandle {
	go_src_func_name := "_NewConfChangeContext"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	return handleFromPtr_Ptr_smr_ConfChangeContext(smr.NewConfChangeContext(C.GoString(id), ptrFromHandle_Ptr_raftpb_ConfChange(cc), time.Duration(int64(timeout))))

}

// ---- Functions ---

//export smr_CreateBytes
func smr_CreateBytes(len C.char) CGoHandle {
	go_src_func_name := "_CreateBytes"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	cret := smr.CreateBytes(byte(len))

	return handleFromPtr_Slice_byte(&cret)
}

//export smr_PrintTestMessage
func smr_PrintTestMessage(goRun C.char) {
	go_src_func_name := "_PrintTestMessage"
	fmt.Printf("Calling: '%s'\n", go_src_func_name)
	_saved_thread := C.PyEval_SaveThread() // Release GIL
	var wg sync.WaitGroup
	wg.Add(1)
	defer wg.Done()
	defer C.PyEval_RestoreThread(_saved_thread) // Reacquire GIL
	if boolPyToGo(goRun) {
		go smr.PrintTestMessage()
	} else {
		smr.PrintTestMessage()
	}
}
