"""
Package smr

# Copyright 2015 The etcd Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

"""
# python wrapper for package github.com/scusemua/distributed-notebook/smr within overall package smr
# This is what you import to use the package.
# File is generated by gopy. Do not edit.
# gopy gen -build-tags=-gcflags=all="-N -l" -output=../distributed_notebook/smr -vm=/home/scusemua/virtual-envs/venv/bin/python3.12 github.com/scusemua/distributed-notebook/smr

# the following is required to enable dlopen to open the _go.so file
import os,sys,inspect,collections
try:
	import collections.abc as _collections_abc
except ImportError:
	_collections_abc = collections

cwd = os.getcwd()
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
os.chdir(currentdir)
from . import _smr
from . import go

os.chdir(cwd)

# to use this code in your end-user python file, import it as follows:
# from smr import smr
# and then refer to everything using smr. prefix
# packages imported by this package listed below:




# ---- Types ---

# Python type for slice []raftpb.ConfChangeSingle
class Slice_raftpb_ConfChangeSingle(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.Slice_raftpb_ConfChangeSingle_CTor()
			_smr.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_raftpb_ConfChangeSingle.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		s = 'smr.Slice_raftpb_ConfChangeSingle len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'smr.Slice_raftpb_ConfChangeSingle([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _smr.Slice_raftpb_ConfChangeSingle_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _smr.Slice_raftpb_ConfChangeSingle_len(self.handle)
				return Slice_raftpb_ConfChangeSingle(handle=_smr.Slice_raftpb_ConfChangeSingle_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return go.raftpb_ConfChangeSingle(handle=_smr.Slice_raftpb_ConfChangeSingle_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_smr.Slice_raftpb_ConfChangeSingle_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_raftpb_ConfChangeSingle.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = go.raftpb_ConfChangeSingle(handle=_smr.Slice_raftpb_ConfChangeSingle_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_smr.Slice_raftpb_ConfChangeSingle_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []raftpb.Entry
class Slice_raftpb_Entry(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.Slice_raftpb_Entry_CTor()
			_smr.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_raftpb_Entry.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		s = 'smr.Slice_raftpb_Entry len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'smr.Slice_raftpb_Entry([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _smr.Slice_raftpb_Entry_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _smr.Slice_raftpb_Entry_len(self.handle)
				return Slice_raftpb_Entry(handle=_smr.Slice_raftpb_Entry_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return go.raftpb_Entry(handle=_smr.Slice_raftpb_Entry_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_smr.Slice_raftpb_Entry_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_raftpb_Entry.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = go.raftpb_Entry(handle=_smr.Slice_raftpb_Entry_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_smr.Slice_raftpb_Entry_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []walpb.Snapshot
class Slice_walpb_Snapshot(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.Slice_walpb_Snapshot_CTor()
			_smr.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_walpb_Snapshot.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		s = 'smr.Slice_walpb_Snapshot len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'smr.Slice_walpb_Snapshot([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _smr.Slice_walpb_Snapshot_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _smr.Slice_walpb_Snapshot_len(self.handle)
				return Slice_walpb_Snapshot(handle=_smr.Slice_walpb_Snapshot_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return go.walpb_Snapshot(handle=_smr.Slice_walpb_Snapshot_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_smr.Slice_walpb_Snapshot_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_walpb_Snapshot.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = go.walpb_Snapshot(handle=_smr.Slice_walpb_Snapshot_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_smr.Slice_walpb_Snapshot_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]


#---- Enums from Go (collections of consts with same type) ---


#---- Constants from Go: Python can only ask that you please don't change these! ---
DoneString = "DONE"
VersionText = "1.0.1"


# ---- Global Variables: can only use functions to access ---
def AddNodeProposalDeadline():
	"""
	AddNodeProposalDeadline Gets Go Variable: smr.AddNodeProposalDeadline
	
	"""
	return _smr.smr_AddNodeProposalDeadline()

def Set_AddNodeProposalDeadline(value):
	"""
	Set_AddNodeProposalDeadline Sets Go Variable: smr.AddNodeProposalDeadline
	
	"""
	if isinstance(value, go.GoClass):
		_smr.smr_Set_AddNodeProposalDeadline(value.handle)
	else:
		_smr.smr_Set_AddNodeProposalDeadline(value)

def ErrEOF():
	"""
	ErrEOF Gets Go Variable: smr.ErrEOF
	
	"""
	return _smr.smr_ErrEOF()

def Set_ErrEOF(value):
	"""
	Set_ErrEOF Sets Go Variable: smr.ErrEOF
	
	"""
	if isinstance(value, go.GoClass):
		_smr.smr_Set_ErrEOF(value.handle)
	else:
		_smr.smr_Set_ErrEOF(value)

def ProposalDeadline():
	"""
	ProposalDeadline Gets Go Variable: smr.ProposalDeadline
	
	"""
	return _smr.smr_ProposalDeadline()

def Set_ProposalDeadline(value):
	"""
	Set_ProposalDeadline Sets Go Variable: smr.ProposalDeadline
	
	"""
	if isinstance(value, go.GoClass):
		_smr.smr_Set_ProposalDeadline(value.handle)
	else:
		_smr.smr_Set_ProposalDeadline(value)

def RemoveNodeProposalDeadline():
	"""
	RemoveNodeProposalDeadline Gets Go Variable: smr.RemoveNodeProposalDeadline
	
	"""
	return _smr.smr_RemoveNodeProposalDeadline()

def Set_RemoveNodeProposalDeadline(value):
	"""
	Set_RemoveNodeProposalDeadline Sets Go Variable: smr.RemoveNodeProposalDeadline
	
	"""
	if isinstance(value, go.GoClass):
		_smr.smr_Set_RemoveNodeProposalDeadline(value.handle)
	else:
		_smr.smr_Set_RemoveNodeProposalDeadline(value)

def UpdateNodeProposalDeadline():
	"""
	UpdateNodeProposalDeadline Gets Go Variable: smr.UpdateNodeProposalDeadline
	
	"""
	return _smr.smr_UpdateNodeProposalDeadline()

def Set_UpdateNodeProposalDeadline(value):
	"""
	Set_UpdateNodeProposalDeadline Sets Go Variable: smr.UpdateNodeProposalDeadline
	
	"""
	if isinstance(value, go.GoClass):
		_smr.smr_Set_UpdateNodeProposalDeadline(value.handle)
	else:
		_smr.smr_Set_UpdateNodeProposalDeadline(value)



# ---- Interfaces ---

# Python type for interface smr.LogSnapshotter
class LogSnapshotter(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = 0
	def Load(self):
		"""Load() object, str"""
		return go.Ptr_raftpb_Snapshot(handle=_smr.smr_LogSnapshotter_Load(self.handle))
	def LoadNewestAvailable(self, arg_0):
		"""LoadNewestAvailable([]object) object, str"""
		return go.Ptr_raftpb_Snapshot(handle=_smr.smr_LogSnapshotter_LoadNewestAvailable(self.handle, arg_0.handle))
	def SaveSnap(self, arg_0):
		"""SaveSnap(object) str"""
		return _smr.smr_LogSnapshotter_SaveSnap(self.handle, arg_0.handle)

# Python type for interface smr.LogStorage
class LogStorage(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = 0
	def Close(self):
		"""Close() str"""
		return _smr.smr_LogStorage_Close(self.handle)
	def ReleaseLockTo(self, arg_0):
		"""ReleaseLockTo(long) str"""
		return _smr.smr_LogStorage_ReleaseLockTo(self.handle, arg_0)
	def Save(self, arg_0, arg_1):
		"""Save(object, []object) str"""
		return _smr.smr_LogStorage_Save(self.handle, arg_0.handle, arg_1.handle)
	def SaveSnapshot(self, arg_0, goRun=False):
		"""SaveSnapshot(object) """
		_smr.smr_LogStorage_SaveSnapshot(self.handle, arg_0.handle, goRun)

# Python type for interface smr.ReadCloser
class ReadCloser(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = 0
	def Close(self):
		"""Close() str"""
		return _smr.smr_ReadCloser_Close(self.handle)
	def Read(self, p):
		"""Read(object p) object"""
		return IntRet(handle=_smr.smr_ReadCloser_Read(self.handle, p.handle))

# Python type for interface smr.SmrContext
class SmrContext(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = 0
	def Cancel(self, goRun=False):
		"""Cancel() """
		_smr.smr_SmrContext_Cancel(self.handle, goRun)
	def Err(self):
		"""Err() str"""
		return _smr.smr_SmrContext_Err(self.handle)
	def ID(self):
		"""ID() str"""
		return _smr.smr_SmrContext_ID(self.handle)
	def Reset(self, timeout):
		"""Reset(long timeout) object"""
		return SmrContext(handle=_smr.smr_SmrContext_Reset(self.handle, timeout))
	def ResetWithPreviousTimeout(self):
		"""ResetWithPreviousTimeout() object"""
		return SmrContext(handle=_smr.smr_SmrContext_ResetWithPreviousTimeout(self.handle))
	def Value(self, key):
		"""Value(object key) object"""
		return any(handle=_smr.smr_SmrContext_Value(self.handle, key.handle))

# Python type for interface smr.WriteCloser
class WriteCloser(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = 0
	def Close(self):
		"""Close() str"""
		return _smr.smr_WriteCloser_Close(self.handle)
	def Write(self, p):
		"""Write(object p) object"""
		return IntRet(handle=_smr.smr_WriteCloser_Write(self.handle, p.handle))


# ---- Structs ---

# Python type for struct smr.Bytes
class Bytes(go.GoClass):
	"""Manager of python bytes for buffered stream.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.smr_Bytes_CTor()
			_smr.IncRef(self.handle)
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.Bytes{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.Bytes ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	def Bytes(self):
		"""Bytes() []int
		
		Return the underlying byte slice as buffer.
		"""
		return go.Slice_byte(handle=_smr.smr_Bytes_Bytes(self.handle))
	def Len(self):
		"""Len() int
		
		Get the length of the underlying byte slice.
		"""
		return _smr.smr_Bytes_Len(self.handle)

# Python type for struct smr.SMRContext
class SMRContext(go.context_Context):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.smr_SMRContext_CTor()
			_smr.IncRef(self.handle)
			if  3 < len(args):
				self.Timeout = args[3]
			if "Timeout" in kwargs:
				self.Timeout = kwargs["Timeout"]
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.SMRContext{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.SMRContext ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Timeout(self):
		return _smr.smr_SMRContext_Timeout_Get(self.handle)
	@Timeout.setter
	def Timeout(self, value):
		if isinstance(value, go.GoClass):
			_smr.smr_SMRContext_Timeout_Set(self.handle, value.handle)
		else:
			_smr.smr_SMRContext_Timeout_Set(self.handle, value)
	def ID(self):
		"""ID() str"""
		return _smr.smr_SMRContext_ID(self.handle)
	def Reset(self, timeout):
		"""Reset(long timeout) object"""
		return SmrContext(handle=_smr.smr_SMRContext_Reset(self.handle, timeout))
	def ResetWithPreviousTimeout(self):
		"""ResetWithPreviousTimeout() object"""
		return SmrContext(handle=_smr.smr_SMRContext_ResetWithPreviousTimeout(self.handle))
	def Cancel(self, goRun=False):
		"""Cancel() """
		_smr.smr_SMRContext_Cancel(self.handle, goRun)

# Python type for struct smr.IntRet
class IntRet(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.smr_IntRet_CTor()
			_smr.IncRef(self.handle)
			if  0 < len(args):
				self.N = args[0]
			if "N" in kwargs:
				self.N = kwargs["N"]
			if  1 < len(args):
				self.Err = args[1]
			if "Err" in kwargs:
				self.Err = kwargs["Err"]
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.IntRet{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.IntRet ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def N(self):
		return _smr.smr_IntRet_N_Get(self.handle)
	@N.setter
	def N(self, value):
		if isinstance(value, go.GoClass):
			_smr.smr_IntRet_N_Set(self.handle, value.handle)
		else:
			_smr.smr_IntRet_N_Set(self.handle, value)
	@property
	def Err(self):
		return _smr.smr_IntRet_Err_Get(self.handle)
	@Err.setter
	def Err(self, value):
		if isinstance(value, go.GoClass):
			_smr.smr_IntRet_Err_Set(self.handle, value.handle)
		else:
			_smr.smr_IntRet_Err_Set(self.handle, value)

# Python type for struct smr.LogNode
class LogNode(go.GoClass):
	"""LogNode is a SyncLog backed by raft\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.smr_LogNode_CTor()
			_smr.IncRef(self.handle)
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.LogNode{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.LogNode ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	def ServeHttpDebug(self, goRun=False):
		"""ServeHttpDebug() """
		_smr.smr_LogNode_ServeHttpDebug(self.handle, goRun)
	def RemoteStorageReadLatencyMilliseconds(self):
		"""RemoteStorageReadLatencyMilliseconds() int
		
		RemoteStorageReadLatencyMilliseconds returns the latency of the remote storage read operation(s) performed by the LogNode.
		If the LogNode did not read data from remote storage, then -1 is returned.
		"""
		return _smr.smr_LogNode_RemoteStorageReadLatencyMilliseconds(self.handle)
	def ConnectedToRemoteStorage(self):
		"""ConnectedToRemoteStorage() bool
		
		ConnectedToRemoteStorage returns true if we successfully connected to remote storage.
		"""
		return _smr.smr_LogNode_ConnectedToRemoteStorage(self.handle)
	def NumChanges(self):
		"""NumChanges() int"""
		return _smr.smr_LogNode_NumChanges(self.handle)
	def Start(self, config):
		"""Start(object config) bool"""
		return _smr.smr_LogNode_Start(self.handle, config.handle)
	def StartAndWait(self, config, goRun=False):
		"""StartAndWait(object config) """
		_smr.smr_LogNode_StartAndWait(self.handle, config.handle, goRun)
	def GetSerializedState(self):
		"""GetSerializedState() []int
		
		GetSerializedState returns the serialized_state_json field.
		This field is populated by ReadDataDirectoryFromRemoteStorage if there is a serialized state file to be read.
		It is only required during migration/error recovery.
		"""
		return go.Slice_byte(handle=_smr.smr_LogNode_GetSerializedState(self.handle))
	def Propose(self, val, resolve, msg, goRun=False):
		"""Propose(object val, callable resolve, str msg) 
		
		Propose appends the difference of the value of specified key to the synchronization queue.
		"""
		_smr.smr_LogNode_Propose(self.handle, val.handle, resolve, msg, goRun)
	def AddNode(self, id, addr, resolve, goRun=False):
		"""AddNode(int id, str addr, callable resolve) """
		_smr.smr_LogNode_AddNode(self.handle, id, addr, resolve, goRun)
	def RemoveNode(self, id, resolve, goRun=False):
		"""RemoveNode(int id, callable resolve) """
		_smr.smr_LogNode_RemoveNode(self.handle, id, resolve, goRun)
	def UpdateNode(self, id, addr, resolve, goRun=False):
		"""UpdateNode(int id, str addr, callable resolve) """
		_smr.smr_LogNode_UpdateNode(self.handle, id, addr, resolve, goRun)
	def WaitToClose(self):
		"""WaitToClose() str lastErr"""
		return _smr.smr_LogNode_WaitToClose(self.handle)
	def Close(self):
		"""Close() str
		
		Close closes the LogNode.
		
		NOTE: Close does NOT close the remote storage client.
		This is because, when migrating a raft cluster member, we must first stop the raft
		node before copying the contents of its data directory.
		"""
		return _smr.smr_LogNode_Close(self.handle)
	def CloseRemoteStorageClient(self):
		"""CloseRemoteStorageClient() str"""
		return _smr.smr_LogNode_CloseRemoteStorageClient(self.handle)
	def WriteDataDirectoryToRemoteStorage(self, serializedState, resolve, goRun=False):
		"""WriteDataDirectoryToRemoteStorage([]int serializedState, callable resolve) 
		
		WriteDataDirectoryToRemoteStorage writes the data directory for this Raft node from local storage to remote storage.
		"""
		_smr.smr_LogNode_WriteDataDirectoryToRemoteStorage(self.handle, serializedState.handle, resolve, goRun)
	def Process(self, ctx, m):
		"""Process(object ctx, object m) str"""
		return _smr.smr_LogNode_Process(self.handle, ctx.handle, m.handle)
	def IsIDRemoved(self, id):
		"""IsIDRemoved(long id) bool"""
		return _smr.smr_LogNode_IsIDRemoved(self.handle, id)
	def ReportUnreachable(self, id, goRun=False):
		"""ReportUnreachable(long id) """
		_smr.smr_LogNode_ReportUnreachable(self.handle, id, goRun)
	def ReportSnapshot(self, id, status, goRun=False):
		"""ReportSnapshot(long id, int status) """
		_smr.smr_LogNode_ReportSnapshot(self.handle, id, status, goRun)

# Python type for struct smr.LogNodeConfig
class LogNodeConfig(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.smr_LogNodeConfig_CTor()
			_smr.IncRef(self.handle)
			if  0 < len(args):
				self.ElectionTick = args[0]
			if "ElectionTick" in kwargs:
				self.ElectionTick = kwargs["ElectionTick"]
			if  1 < len(args):
				self.HeartbeatTick = args[1]
			if "HeartbeatTick" in kwargs:
				self.HeartbeatTick = kwargs["HeartbeatTick"]
			if  2 < len(args):
				self.Debug = args[2]
			if "Debug" in kwargs:
				self.Debug = kwargs["Debug"]
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		return self.String()
	
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.LogNodeConfig ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def ElectionTick(self):
		return _smr.smr_LogNodeConfig_ElectionTick_Get(self.handle)
	@ElectionTick.setter
	def ElectionTick(self, value):
		if isinstance(value, go.GoClass):
			_smr.smr_LogNodeConfig_ElectionTick_Set(self.handle, value.handle)
		else:
			_smr.smr_LogNodeConfig_ElectionTick_Set(self.handle, value)
	@property
	def HeartbeatTick(self):
		return _smr.smr_LogNodeConfig_HeartbeatTick_Get(self.handle)
	@HeartbeatTick.setter
	def HeartbeatTick(self, value):
		if isinstance(value, go.GoClass):
			_smr.smr_LogNodeConfig_HeartbeatTick_Set(self.handle, value.handle)
		else:
			_smr.smr_LogNodeConfig_HeartbeatTick_Set(self.handle, value)
	@property
	def Debug(self):
		return _smr.smr_LogNodeConfig_Debug_Get(self.handle)
	@Debug.setter
	def Debug(self, value):
		if isinstance(value, go.GoClass):
			_smr.smr_LogNodeConfig_Debug_Set(self.handle, value.handle)
		else:
			_smr.smr_LogNodeConfig_Debug_Set(self.handle, value)
	def WithChangeCallback(self, cb):
		"""WithChangeCallback(callable cb) object"""
		return LogNodeConfig(handle=_smr.smr_LogNodeConfig_WithChangeCallback(self.handle, cb))
	def WithRestoreCallback(self, cb):
		"""WithRestoreCallback(callable cb) object
		
		WithRestoreCallback
		
		Note: the restore callback should not be run on a Python IO loop.
		LogNode::Start is called (from Python code --> Go code) on an asyncio IO loop.
		While going from Python --> Go releases the GIL, the IO loop will still essentially be blocked.
		So, while we can call back into Python code from Go (from the LogNode::Start method),
		we must do so "directly", and not by scheduling something to run on an IO loop.
		(If we schedule something to run on the IO loop, then it will not be executed until we return from LogNode::Start).
		"""
		return LogNodeConfig(handle=_smr.smr_LogNodeConfig_WithRestoreCallback(self.handle, cb))
	def WithShouldSnapshotCallback(self, cb):
		"""WithShouldSnapshotCallback(callable cb) object"""
		return LogNodeConfig(handle=_smr.smr_LogNodeConfig_WithShouldSnapshotCallback(self.handle, cb))
	def WithSnapshotCallback(self, cb):
		"""WithSnapshotCallback(callable cb) object"""
		return LogNodeConfig(handle=_smr.smr_LogNodeConfig_WithSnapshotCallback(self.handle, cb))
	def String(self):
		"""String() str"""
		return _smr.smr_LogNodeConfig_String(self.handle)

# Python type for struct smr.ConfChangeContext
class ConfChangeContext(SMRContext):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_smr.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_smr.IncRef(self.handle)
		else:
			self.handle = _smr.smr_ConfChangeContext_CTor()
			_smr.IncRef(self.handle)
	def __del__(self):
		_smr.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.ConfChangeContext{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'smr.ConfChangeContext ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	def ID(self):
		"""ID() str"""
		return _smr.smr_ConfChangeContext_ID(self.handle)
	def Reset(self, timeout):
		"""Reset(long timeout) object"""
		return SmrContext(handle=_smr.smr_ConfChangeContext_Reset(self.handle, timeout))
	def ResetWithPreviousTimeout(self):
		"""ResetWithPreviousTimeout() object"""
		return SmrContext(handle=_smr.smr_ConfChangeContext_ResetWithPreviousTimeout(self.handle))


# ---- Slices ---


# ---- Maps ---


# ---- Constructors ---
def NewLogNode(storePath, id, remoteStorageHostname, remoteStorage, shouldLoadDataFromRemoteStorage, peerAddresses, peerIDs, join, httpDebugPort, deploymentMode):
	"""NewLogNode(str storePath, int id, str remoteStorageHostname, str remoteStorage, bool shouldLoadDataFromRemoteStorage, []str peerAddresses, []int peerIDs, bool join, int httpDebugPort, str deploymentMode) object
	
	NewLogNode initiates a raft instance and returns a committed log entry
	channel and error channel. Proposals for log updates are sent over the
	provided the proposal channel. All log entries are replayed over the
	commit channel, followed by a nil message (to indicate the channel is
	current), then new log entries.
	
	To shut down, close proposeC and read errorC.
	
	The store_path is used as the actual data directory.
	"""
	return LogNode(handle=_smr.smr_NewLogNode(storePath, id, remoteStorageHostname, remoteStorage, shouldLoadDataFromRemoteStorage, peerAddresses.handle, peerIDs.handle, join, httpDebugPort, deploymentMode))
def NewConfig():
	"""NewConfig() object"""
	return LogNodeConfig(handle=_smr.smr_NewConfig())
def NewConfChangeContext(id, cc, timeout):
	"""NewConfChangeContext(str id, object cc, long timeout) object"""
	return ConfChangeContext(handle=_smr.smr_NewConfChangeContext(id, cc.handle, timeout))


# ---- Functions ---
def CreateBytes(len):
	"""CreateBytes(int len) []int"""
	return go.Slice_byte(handle=_smr.smr_CreateBytes(len))
def PrintTestMessage(goRun=False):
	"""PrintTestMessage() """
	_smr.smr_PrintTestMessage(goRun)


