# python build stubs for package smr
# File is generated by gopy. Do not edit.
# gopy gen -build-tags=-gcflags=all="-N -l" -output=../distributed_notebook/smr -vm=/home/scusemua/virtual-envs/venv/bin/python3.12 github.com/scusemua/distributed-notebook/smr

from pybindgen import retval, param, Function, Module
import sys

class CheckedFunction(Function):
    def __init__(self, *a, **kw):
        super(CheckedFunction, self).__init__(*a, **kw)
        self._failure_expression = kw.get('failure_expression', '')
        self._failure_cleanup = kw.get('failure_cleanup', '')

    def set_failure_expression(self, expr):
        self._failure_expression = expr

    def set_failure_cleanup(self, expr):
        self._failure_cleanup = expr

    def generate_call(self):
        super(CheckedFunction, self).generate_call()
        check = "PyErr_Occurred()"
        if self._failure_expression:
            check = "{} && {}".format(self._failure_expression, check)
        failure_cleanup = self._failure_cleanup or None
        self.before_call.write_error_check(check, failure_cleanup)

def add_checked_function(mod, name, retval, params, failure_expression='', *a, **kw):
    fn = CheckedFunction(name, retval, params, *a, **kw)
    fn.set_failure_expression(failure_expression)
    mod._add_function_obj(fn)
    return fn

def add_checked_string_function(mod, name, retval, params, failure_expression='', *a, **kw):
    fn = CheckedFunction(name, retval, params, *a, **kw)
    fn.set_failure_cleanup('if (retval != NULL) free(retval);')
    fn.after_call.add_cleanup_code('free(retval);')
    fn.set_failure_expression(failure_expression)
    mod._add_function_obj(fn)
    return fn

mod = Module('_smr')
mod.add_include('"smr_go.h"')
mod.add_function('GoPyInit', None, [])
mod.add_function('DecRef', None, [param('int64_t', 'handle')])
mod.add_function('IncRef', None, [param('int64_t', 'handle')])
mod.add_function('NumHandles', retval('int'), [])
mod.add_function('Slice_bool_CTor', retval('int64_t'), [])
mod.add_function('Slice_bool_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_bool_elem', retval('bool'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_bool_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_bool_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('bool', 'value')])
mod.add_function('Slice_bool_append', None, [param('int64_t', 'handle'), param('bool', 'value')])
mod.add_function('Slice_byte_CTor', retval('int64_t'), [])
mod.add_function('Slice_byte_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_byte_elem', retval('uint8_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_byte_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_byte_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint8_t', 'value')])
mod.add_function('Slice_byte_append', None, [param('int64_t', 'handle'), param('uint8_t', 'value')])
mod.add_function('Slice_byte_from_bytes', retval('int64_t'), [param('PyObject*', 'o', transfer_ownership=False)])
mod.add_function('Slice_byte_to_bytes', retval('PyObject*', caller_owns_return=True), [param('int64_t', 'handle')])
mod.add_function('Slice_error_CTor', retval('int64_t'), [])
mod.add_function('Slice_error_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_error_elem', retval('char*'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_error_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_error_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('char*', 'value')])
mod.add_function('Slice_error_append', None, [param('int64_t', 'handle'), param('char*', 'value')])
mod.add_function('Slice_float32_CTor', retval('int64_t'), [])
mod.add_function('Slice_float32_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_float32_elem', retval('float'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_float32_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_float32_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('float', 'value')])
mod.add_function('Slice_float32_append', None, [param('int64_t', 'handle'), param('float', 'value')])
mod.add_function('Slice_float64_CTor', retval('int64_t'), [])
mod.add_function('Slice_float64_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_float64_elem', retval('double'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_float64_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_float64_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('double', 'value')])
mod.add_function('Slice_float64_append', None, [param('int64_t', 'handle'), param('double', 'value')])
mod.add_function('Slice_int_CTor', retval('int64_t'), [])
mod.add_function('Slice_int_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_int_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_int16_CTor', retval('int64_t'), [])
mod.add_function('Slice_int16_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int16_elem', retval('int16_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int16_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int16_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int16_t', 'value')])
mod.add_function('Slice_int16_append', None, [param('int64_t', 'handle'), param('int16_t', 'value')])
mod.add_function('Slice_int32_CTor', retval('int64_t'), [])
mod.add_function('Slice_int32_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int32_elem', retval('int32_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int32_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int32_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int32_t', 'value')])
mod.add_function('Slice_int32_append', None, [param('int64_t', 'handle'), param('int32_t', 'value')])
mod.add_function('Slice_int64_CTor', retval('int64_t'), [])
mod.add_function('Slice_int64_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int64_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int64_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int64_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_int64_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_int8_CTor', retval('int64_t'), [])
mod.add_function('Slice_int8_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int8_elem', retval('int8_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int8_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int8_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int8_t', 'value')])
mod.add_function('Slice_int8_append', None, [param('int64_t', 'handle'), param('int8_t', 'value')])
mod.add_function('Slice_rune_CTor', retval('int64_t'), [])
mod.add_function('Slice_rune_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_rune_elem', retval('int32_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_rune_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_rune_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int32_t', 'value')])
mod.add_function('Slice_rune_append', None, [param('int64_t', 'handle'), param('int32_t', 'value')])
mod.add_function('Slice_string_CTor', retval('int64_t'), [])
mod.add_function('Slice_string_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_string_elem', retval('char*'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_string_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_string_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('char*', 'value')])
mod.add_function('Slice_string_append', None, [param('int64_t', 'handle'), param('char*', 'value')])
mod.add_function('Slice_uint_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint_elem', retval('uint64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint64_t', 'value')])
mod.add_function('Slice_uint_append', None, [param('int64_t', 'handle'), param('uint64_t', 'value')])
mod.add_function('Slice_uint16_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint16_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint16_elem', retval('uint16_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint16_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint16_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint16_t', 'value')])
mod.add_function('Slice_uint16_append', None, [param('int64_t', 'handle'), param('uint16_t', 'value')])
mod.add_function('Slice_uint32_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint32_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint32_elem', retval('uint32_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint32_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint32_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint32_t', 'value')])
mod.add_function('Slice_uint32_append', None, [param('int64_t', 'handle'), param('uint32_t', 'value')])
mod.add_function('Slice_uint64_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint64_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint64_elem', retval('uint64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint64_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint64_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint64_t', 'value')])
mod.add_function('Slice_uint64_append', None, [param('int64_t', 'handle'), param('uint64_t', 'value')])
mod.add_function('Slice_uint8_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint8_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint8_elem', retval('uint8_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint8_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint8_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint8_t', 'value')])
mod.add_function('Slice_uint8_append', None, [param('int64_t', 'handle'), param('uint8_t', 'value')])
mod.add_function('Slice_raftpb_ConfChangeSingle_CTor', retval('int64_t'), [])
mod.add_function('Slice_raftpb_ConfChangeSingle_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_raftpb_ConfChangeSingle_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_raftpb_ConfChangeSingle_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_raftpb_ConfChangeSingle_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_raftpb_ConfChangeSingle_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_raftpb_Entry_CTor', retval('int64_t'), [])
mod.add_function('Slice_raftpb_Entry_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_raftpb_Entry_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_raftpb_Entry_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_raftpb_Entry_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_raftpb_Entry_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_walpb_Snapshot_CTor', retval('int64_t'), [])
mod.add_function('Slice_walpb_Snapshot_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_walpb_Snapshot_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_walpb_Snapshot_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_walpb_Snapshot_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_walpb_Snapshot_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('smr_AddNodeProposalDeadline', retval('int64_t'), [])
mod.add_function('smr_Set_AddNodeProposalDeadline', None, [param('int64_t', 'val')])
mod.add_function('smr_ErrEOF', retval('char*'), [])
mod.add_function('smr_Set_ErrEOF', None, [param('char*', 'val')])
mod.add_function('smr_ProposalDeadline', retval('int64_t'), [])
mod.add_function('smr_Set_ProposalDeadline', None, [param('int64_t', 'val')])
mod.add_function('smr_RemoveNodeProposalDeadline', retval('int64_t'), [])
mod.add_function('smr_Set_RemoveNodeProposalDeadline', None, [param('int64_t', 'val')])
mod.add_function('smr_UpdateNodeProposalDeadline', retval('int64_t'), [])
mod.add_function('smr_Set_UpdateNodeProposalDeadline', None, [param('int64_t', 'val')])
add_checked_function(mod, 'smr_LogSnapshotter_Load', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogSnapshotter_LoadNewestAvailable', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'arg_0')])
add_checked_function(mod, 'smr_LogSnapshotter_SaveSnap', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'arg_0')])
add_checked_function(mod, 'smr_LogStorage_Close', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogStorage_ReleaseLockTo', retval('char*'), [param('int64_t', '_handle'), param('uint64_t', 'arg_0')])
add_checked_function(mod, 'smr_LogStorage_Save', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'arg_0'), param('int64_t', 'arg_1')])
add_checked_function(mod, 'smr_LogStorage_SaveSnapshot', None, [param('int64_t', '_handle'), param('int64_t', 'arg_0'), param('bool', 'goRun')])
add_checked_string_function(mod, 'smr_ReadCloser_Close', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_ReadCloser_Read', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'p')])
add_checked_function(mod, 'smr_SmrContext_Cancel', None, [param('int64_t', '_handle'), param('bool', 'goRun')])
add_checked_function(mod, 'smr_SmrContext_Err', retval('char*'), [param('int64_t', '_handle')])
add_checked_string_function(mod, 'smr_SmrContext_ID', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_SmrContext_Reset', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'timeout')])
add_checked_function(mod, 'smr_SmrContext_ResetWithPreviousTimeout', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_SmrContext_Value', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'key')])
add_checked_string_function(mod, 'smr_WriteCloser_Close', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_WriteCloser_Write', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'p')])
mod.add_function('smr_Bytes_CTor', retval('int64_t'), [])
add_checked_function(mod, 'smr_Bytes_Bytes', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_Bytes_Len', retval('int64_t'), [param('int64_t', '_handle')])
mod.add_function('smr_SMRContext_CTor', retval('int64_t'), [])
mod.add_function('smr_SMRContext_Timeout_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('smr_SMRContext_Timeout_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
add_checked_string_function(mod, 'smr_SMRContext_ID', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_SMRContext_Reset', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'timeout')])
add_checked_function(mod, 'smr_SMRContext_ResetWithPreviousTimeout', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_SMRContext_Cancel', None, [param('int64_t', '_handle'), param('bool', 'goRun')])
mod.add_function('smr_IntRet_CTor', retval('int64_t'), [])
mod.add_function('smr_IntRet_N_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('smr_IntRet_N_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('smr_IntRet_Err_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('smr_IntRet_Err_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('smr_LogNode_CTor', retval('int64_t'), [])
add_checked_function(mod, 'smr_LogNode_ServeHttpDebug', None, [param('int64_t', '_handle'), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_RemoteStorageReadLatencyMilliseconds', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogNode_ConnectedToRemoteStorage', retval('bool'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogNode_NumChanges', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogNode_Start', retval('bool'), [param('int64_t', '_handle'), param('int64_t', 'config')])
add_checked_function(mod, 'smr_LogNode_StartAndWait', None, [param('int64_t', '_handle'), param('int64_t', 'config'), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_GetSerializedState', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogNode_Propose', None, [param('int64_t', '_handle'), param('int64_t', 'val'), param('PyObject*', 'resolve', transfer_ownership=False), param('char*', 'msg'), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_AddNode', None, [param('int64_t', '_handle'), param('int64_t', 'id'), param('char*', 'addr'), param('PyObject*', 'resolve', transfer_ownership=False), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_RemoveNode', None, [param('int64_t', '_handle'), param('int64_t', 'id'), param('PyObject*', 'resolve', transfer_ownership=False), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_UpdateNode', None, [param('int64_t', '_handle'), param('int64_t', 'id'), param('char*', 'addr'), param('PyObject*', 'resolve', transfer_ownership=False), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_WaitToClose', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogNode_Close', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogNode_CloseRemoteStorageClient', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_LogNode_WriteDataDirectoryToRemoteStorage', None, [param('int64_t', '_handle'), param('int64_t', 'serializedState'), param('PyObject*', 'resolve', transfer_ownership=False), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_Process', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'ctx'), param('int64_t', 'm')])
add_checked_function(mod, 'smr_LogNode_IsIDRemoved', retval('bool'), [param('int64_t', '_handle'), param('uint64_t', 'id')])
add_checked_function(mod, 'smr_LogNode_ReportUnreachable', None, [param('int64_t', '_handle'), param('uint64_t', 'id'), param('bool', 'goRun')])
add_checked_function(mod, 'smr_LogNode_ReportSnapshot', None, [param('int64_t', '_handle'), param('uint64_t', 'id'), param('int64_t', 'status'), param('bool', 'goRun')])
mod.add_function('smr_LogNodeConfig_CTor', retval('int64_t'), [])
mod.add_function('smr_LogNodeConfig_ElectionTick_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('smr_LogNodeConfig_ElectionTick_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('smr_LogNodeConfig_HeartbeatTick_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('smr_LogNodeConfig_HeartbeatTick_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('smr_LogNodeConfig_Debug_Get', retval('bool'), [param('int64_t', 'handle')])
mod.add_function('smr_LogNodeConfig_Debug_Set', None, [param('int64_t', 'handle'), param('bool', 'val')])
add_checked_function(mod, 'smr_LogNodeConfig_WithChangeCallback', retval('int64_t'), [param('int64_t', '_handle'), param('PyObject*', 'cb', transfer_ownership=False)])
add_checked_function(mod, 'smr_LogNodeConfig_WithRestoreCallback', retval('int64_t'), [param('int64_t', '_handle'), param('PyObject*', 'cb', transfer_ownership=False)])
add_checked_function(mod, 'smr_LogNodeConfig_WithShouldSnapshotCallback', retval('int64_t'), [param('int64_t', '_handle'), param('PyObject*', 'cb', transfer_ownership=False)])
add_checked_function(mod, 'smr_LogNodeConfig_WithSnapshotCallback', retval('int64_t'), [param('int64_t', '_handle'), param('PyObject*', 'cb', transfer_ownership=False)])
add_checked_string_function(mod, 'smr_LogNodeConfig_String', retval('char*'), [param('int64_t', '_handle')])
mod.add_function('smr_ConfChangeContext_CTor', retval('int64_t'), [])
add_checked_string_function(mod, 'smr_ConfChangeContext_ID', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_ConfChangeContext_Reset', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'timeout')])
add_checked_function(mod, 'smr_ConfChangeContext_ResetWithPreviousTimeout', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'smr_NewLogNode', retval('int64_t'), [param('char*', 'storePath'), param('int64_t', 'id'), param('char*', 'remoteStorageHostname'), param('char*', 'remoteStorage'), param('bool', 'shouldLoadDataFromRemoteStorage'), param('int64_t', 'peerAddresses'), param('int64_t', 'peerIDs'), param('bool', 'join'), param('int64_t', 'httpDebugPort'), param('char*', 'deploymentMode')])
add_checked_function(mod, 'smr_NewConfig', retval('int64_t'), [])
add_checked_function(mod, 'smr_NewConfChangeContext', retval('int64_t'), [param('char*', 'id'), param('int64_t', 'cc'), param('int64_t', 'timeout')])
add_checked_function(mod, 'smr_CreateBytes', retval('int64_t'), [param('uint8_t', 'len')])
add_checked_function(mod, 'smr_PrintTestMessage', None, [param('bool', 'goRun')])

mod.generate(open('smr.c', 'w'))

