# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import gateway_pb2 as gateway__pb2

GRPC_GENERATED_VERSION = '1.66.1'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The rpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in gateway_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your rpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class ClusterGatewayStub(object):
    """gRPC service provided by the ClusterGateway and "used" by the Local Daemons
    (i.e., the Cluster Gateway is the server while the Local Daemons are the clients).
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A rpc.Channel.
        """
        self.ID = channel.unary_unary(
                '/gateway.ClusterGateway/ID',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.ProvisionerId.FromString,
                _registered_method=True)
        self.RemoveHost = channel.unary_unary(
                '/gateway.ClusterGateway/RemoveHost',
                request_serializer=gateway__pb2.HostId.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.MigrateKernelReplica = channel.unary_unary(
                '/gateway.ClusterGateway/MigrateKernelReplica',
                request_serializer=gateway__pb2.MigrationRequest.SerializeToString,
                response_deserializer=gateway__pb2.MigrateKernelResponse.FromString,
                _registered_method=True)
        self.NotifyKernelRegistered = channel.unary_unary(
                '/gateway.ClusterGateway/NotifyKernelRegistered',
                request_serializer=gateway__pb2.KernelRegistrationNotification.SerializeToString,
                response_deserializer=gateway__pb2.KernelRegistrationNotificationResponse.FromString,
                _registered_method=True)
        self.SmrReady = channel.unary_unary(
                '/gateway.ClusterGateway/SmrReady',
                request_serializer=gateway__pb2.SmrReadyNotification.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.SmrNodeAdded = channel.unary_unary(
                '/gateway.ClusterGateway/SmrNodeAdded',
                request_serializer=gateway__pb2.ReplicaInfo.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.Notify = channel.unary_unary(
                '/gateway.ClusterGateway/Notify',
                request_serializer=gateway__pb2.Notification.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.PingGateway = channel.unary_unary(
                '/gateway.ClusterGateway/PingGateway',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)


class ClusterGatewayServicer(object):
    """gRPC service provided by the ClusterGateway and "used" by the Local Daemons
    (i.e., the Cluster Gateway is the server while the Local Daemons are the clients).
    """

    def ID(self, request, context):
        """ID returns the cluster gateway id and can be used to test connectivity.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveHost(self, request, context):
        """RemoveHost removes a local gateway from the cluster.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MigrateKernelReplica(self, request, context):
        """MigrateKernelReplica selects a qualified host and adds a kernel replica to the replica set.
        Unlike StartKernelReplica, a new replica is added to the replica set and a training task may
        need to start immediately after replica started, e.g., preempting a training task.

        The function will simply remove the replica from the kernel without stopping it.
        The caller should stop the replica after confirmed that the new replica is ready.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def NotifyKernelRegistered(self, request, context):
        """Notify the Gateway that a distributed kernel replica has started somewhere.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SmrReady(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SmrNodeAdded(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Notify(self, request, context):
        """Report that an error occurred within one of the local daemons (or possibly a jupyter kernel).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PingGateway(self, request, context):
        """PingGateway is a no-op for testing connectivity.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ClusterGatewayServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'ID': grpc.unary_unary_rpc_method_handler(
                    servicer.ID,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.ProvisionerId.SerializeToString,
            ),
            'RemoveHost': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveHost,
                    request_deserializer=gateway__pb2.HostId.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'MigrateKernelReplica': grpc.unary_unary_rpc_method_handler(
                    servicer.MigrateKernelReplica,
                    request_deserializer=gateway__pb2.MigrationRequest.FromString,
                    response_serializer=gateway__pb2.MigrateKernelResponse.SerializeToString,
            ),
            'NotifyKernelRegistered': grpc.unary_unary_rpc_method_handler(
                    servicer.NotifyKernelRegistered,
                    request_deserializer=gateway__pb2.KernelRegistrationNotification.FromString,
                    response_serializer=gateway__pb2.KernelRegistrationNotificationResponse.SerializeToString,
            ),
            'SmrReady': grpc.unary_unary_rpc_method_handler(
                    servicer.SmrReady,
                    request_deserializer=gateway__pb2.SmrReadyNotification.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'SmrNodeAdded': grpc.unary_unary_rpc_method_handler(
                    servicer.SmrNodeAdded,
                    request_deserializer=gateway__pb2.ReplicaInfo.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'Notify': grpc.unary_unary_rpc_method_handler(
                    servicer.Notify,
                    request_deserializer=gateway__pb2.Notification.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'PingGateway': grpc.unary_unary_rpc_method_handler(
                    servicer.PingGateway,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gateway.ClusterGateway', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gateway.ClusterGateway', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class ClusterGateway(object):
    """gRPC service provided by the ClusterGateway and "used" by the Local Daemons
    (i.e., the Cluster Gateway is the server while the Local Daemons are the clients).
    """

    @staticmethod
    def ID(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/ID',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.ProvisionerId.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RemoveHost(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/RemoveHost',
            gateway__pb2.HostId.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def MigrateKernelReplica(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/MigrateKernelReplica',
            gateway__pb2.MigrationRequest.SerializeToString,
            gateway__pb2.MigrateKernelResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def NotifyKernelRegistered(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/NotifyKernelRegistered',
            gateway__pb2.KernelRegistrationNotification.SerializeToString,
            gateway__pb2.KernelRegistrationNotificationResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SmrReady(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/SmrReady',
            gateway__pb2.SmrReadyNotification.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SmrNodeAdded(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/SmrNodeAdded',
            gateway__pb2.ReplicaInfo.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Notify(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/Notify',
            gateway__pb2.Notification.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PingGateway(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterGateway/PingGateway',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)


class DistributedClusterStub(object):
    """gRPC service provided by the Cluster Gateway and "used" by the Dashboard
    (i.e., the Cluster Gateway is the server while the Dashboard is the client).
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A rpc.Channel.
        """
        self.InducePanic = channel.unary_unary(
                '/gateway.DistributedCluster/InducePanic',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.ClusterAge = channel.unary_unary(
                '/gateway.DistributedCluster/ClusterAge',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.ClusterAgeResponse.FromString,
                _registered_method=True)
        self.SpoofNotifications = channel.unary_unary(
                '/gateway.DistributedCluster/SpoofNotifications',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.Ping = channel.unary_unary(
                '/gateway.DistributedCluster/Ping',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.Pong.FromString,
                _registered_method=True)
        self.PingKernel = channel.unary_unary(
                '/gateway.DistributedCluster/PingKernel',
                request_serializer=gateway__pb2.PingInstruction.SerializeToString,
                response_deserializer=gateway__pb2.Pong.FromString,
                _registered_method=True)
        self.IsKernelActivelyTraining = channel.unary_unary(
                '/gateway.DistributedCluster/IsKernelActivelyTraining',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.IsKernelTrainingReply.FromString,
                _registered_method=True)
        self.IsKernelActivelyMigrating = channel.unary_unary(
                '/gateway.DistributedCluster/IsKernelActivelyMigrating',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.IsKernelMigratingReply.FromString,
                _registered_method=True)
        self.IsKernelActivelyTrainingOrMigrating = channel.unary_unary(
                '/gateway.DistributedCluster/IsKernelActivelyTrainingOrMigrating',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.IsKernelTrainingOrMigratingReply.FromString,
                _registered_method=True)
        self.ListKernels = channel.unary_unary(
                '/gateway.DistributedCluster/ListKernels',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.ListKernelsResponse.FromString,
                _registered_method=True)
        self.SetTotalVirtualGPUs = channel.unary_unary(
                '/gateway.DistributedCluster/SetTotalVirtualGPUs',
                request_serializer=gateway__pb2.SetVirtualGPUsRequest.SerializeToString,
                response_deserializer=gateway__pb2.VirtualGpuInfo.FromString,
                _registered_method=True)
        self.GetClusterActualGpuInfo = channel.unary_unary(
                '/gateway.DistributedCluster/GetClusterActualGpuInfo',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.ClusterActualGpuInfo.FromString,
                _registered_method=True)
        self.GetJupyterMessage = channel.unary_unary(
                '/gateway.DistributedCluster/GetJupyterMessage',
                request_serializer=gateway__pb2.GetJupyterMessageRequest.SerializeToString,
                response_deserializer=gateway__pb2.GetJupyterMessageResponse.FromString,
                _registered_method=True)
        self.GetClusterVirtualGpuInfo = channel.unary_unary(
                '/gateway.DistributedCluster/GetClusterVirtualGpuInfo',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.ClusterVirtualGpuInfo.FromString,
                _registered_method=True)
        self.MigrateKernelReplica = channel.unary_unary(
                '/gateway.DistributedCluster/MigrateKernelReplica',
                request_serializer=gateway__pb2.MigrationRequest.SerializeToString,
                response_deserializer=gateway__pb2.MigrateKernelResponse.FromString,
                _registered_method=True)
        self.FailNextExecution = channel.unary_unary(
                '/gateway.DistributedCluster/FailNextExecution',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.RegisterDashboard = channel.unary_unary(
                '/gateway.DistributedCluster/RegisterDashboard',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.DashboardRegistrationResponse.FromString,
                _registered_method=True)
        self.GetVirtualDockerNodes = channel.unary_unary(
                '/gateway.DistributedCluster/GetVirtualDockerNodes',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.GetVirtualDockerNodesResponse.FromString,
                _registered_method=True)
        self.GetDockerSwarmNodes = channel.unary_unary(
                '/gateway.DistributedCluster/GetDockerSwarmNodes',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.GetDockerSwarmNodesResponse.FromString,
                _registered_method=True)
        self.GetNumNodes = channel.unary_unary(
                '/gateway.DistributedCluster/GetNumNodes',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.NumNodesResponse.FromString,
                _registered_method=True)
        self.SetNumClusterNodes = channel.unary_unary(
                '/gateway.DistributedCluster/SetNumClusterNodes',
                request_serializer=gateway__pb2.SetNumClusterNodesRequest.SerializeToString,
                response_deserializer=gateway__pb2.SetNumClusterNodesResponse.FromString,
                _registered_method=True)
        self.AddClusterNodes = channel.unary_unary(
                '/gateway.DistributedCluster/AddClusterNodes',
                request_serializer=gateway__pb2.AddClusterNodesRequest.SerializeToString,
                response_deserializer=gateway__pb2.AddClusterNodesResponse.FromString,
                _registered_method=True)
        self.RemoveSpecificClusterNodes = channel.unary_unary(
                '/gateway.DistributedCluster/RemoveSpecificClusterNodes',
                request_serializer=gateway__pb2.RemoveSpecificClusterNodesRequest.SerializeToString,
                response_deserializer=gateway__pb2.RemoveSpecificClusterNodesResponse.FromString,
                _registered_method=True)
        self.RemoveClusterNodes = channel.unary_unary(
                '/gateway.DistributedCluster/RemoveClusterNodes',
                request_serializer=gateway__pb2.RemoveClusterNodesRequest.SerializeToString,
                response_deserializer=gateway__pb2.RemoveClusterNodesResponse.FromString,
                _registered_method=True)
        self.ModifyClusterNodes = channel.unary_unary(
                '/gateway.DistributedCluster/ModifyClusterNodes',
                request_serializer=gateway__pb2.ModifyClusterNodesRequest.SerializeToString,
                response_deserializer=gateway__pb2.ModifyClusterNodesResponse.FromString,
                _registered_method=True)
        self.GetLocalDaemonNodeIDs = channel.unary_unary(
                '/gateway.DistributedCluster/GetLocalDaemonNodeIDs',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.GetLocalDaemonNodeIDsResponse.FromString,
                _registered_method=True)
        self.QueryMessage = channel.unary_unary(
                '/gateway.DistributedCluster/QueryMessage',
                request_serializer=gateway__pb2.QueryMessageRequest.SerializeToString,
                response_deserializer=gateway__pb2.QueryMessageResponse.FromString,
                _registered_method=True)
        self.ForceLocalDaemonToReconnect = channel.unary_unary(
                '/gateway.DistributedCluster/ForceLocalDaemonToReconnect',
                request_serializer=gateway__pb2.ForceLocalDaemonToReconnectRequest.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.ClusterStatistics = channel.unary_unary(
                '/gateway.DistributedCluster/ClusterStatistics',
                request_serializer=gateway__pb2.ClusterStatisticsRequest.SerializeToString,
                response_deserializer=gateway__pb2.ClusterStatisticsResponse.FromString,
                _registered_method=True)
        self.ClearClusterStatistics = channel.unary_unary(
                '/gateway.DistributedCluster/ClearClusterStatistics',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.ClusterStatisticsResponse.FromString,
                _registered_method=True)


class DistributedClusterServicer(object):
    """gRPC service provided by the Cluster Gateway and "used" by the Dashboard
    (i.e., the Cluster Gateway is the server while the Dashboard is the client).
    """

    def InducePanic(self, request, context):
        """Used for debugging/testing. Causes a Panic.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ClusterAge(self, request, context):
        """ClusterAge returns the age of the DistributedCluster as a UnixMilliseconds timestamp.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SpoofNotifications(self, request, context):
        """Used to test notifications.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Ping(self, request, context):
        """Used to test connectivity.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PingKernel(self, request, context):
        """Used to test connectivity with kernels.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def IsKernelActivelyTraining(self, request, context):
        """IsKernelTraining is used to query whether or not a particular kernel is actively training.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def IsKernelActivelyMigrating(self, request, context):
        """IsKernelActivelyMigrating is used to query whether or not a particular kernel is actively being migrated.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def IsKernelActivelyTrainingOrMigrating(self, request, context):
        """IsKernelActivelyMigrating is used to query whether or not a particular kernel is actively being migrated
        or if it is actively training.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListKernels(self, request, context):
        """Return a list of all of the current kernel IDs.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetTotalVirtualGPUs(self, request, context):
        """Set the maximum number of vGPU resources available on a particular node (identified by the local daemon).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetClusterActualGpuInfo(self, request, context):
        """Return the current GPU resource metrics on the node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetJupyterMessage(self, request, context):
        """GetJupyterMessage enables frontend clients to request a Jupyter message via gRPC in situations where
        the ZMQ message appears to have been delayed or dropped or otherwise lost in transit to the client.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetClusterVirtualGpuInfo(self, request, context):
        """Return the current vGPU (or "deflated GPU") resource metrics on the node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MigrateKernelReplica(self, request, context):
        """MigrateKernelReplica selects a qualified host and adds a kernel replica to the replica set.
        Unlike StartKernelReplica, a new replica is added to the replica set and a training task may
        need to start immediately after replica started, e.g., preempting a training task.

        The function will simply remove the replica from the kernel without stopping it.
        The caller should stop the replica after confirmed that the new replica is ready.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FailNextExecution(self, request, context):
        """Ensure that the next 'execute_request' for the specified kernel fails.
        This is to be used exclusively for testing/debugging purposes.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RegisterDashboard(self, request, context):
        """RegisterDashboard is called by the Cluster Dashboard backend server to both verify that a connection has been
        established and to obtain any important configuration information, such as the deployment mode (i.e., Docker or
        Kubernetes), from the Cluster Gateway.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetVirtualDockerNodes(self, request, context):
        """GetVirtualDockerNodes returns a (pointer to a) GetVirtualDockerNodesResponse struct describing the virtual,
        simulated nodes currently provisioned within the cluster.

        When deployed in Docker Swarm mode, our cluster has both "actual" nodes, which correspond to the nodes that
        Docker Swarm knows about, and virtual nodes that correspond to each local daemon container.

        In a "real" deployment, there would be one local daemon per Docker Swarm node. But for development and debugging,
        we may provision many local daemons per Docker Swarm node, where each local daemon manages its own virtual node.

        If the Cluster is not running in Docker mode, then this will return an error.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetDockerSwarmNodes(self, request, context):
        """GetDockerSwarmNodes returns a (pointer to a) GetDockerSwarmNodesResponse struct describing the Docker Swarm
        nodes that exist within the Docker Swarm cluster.

        When deployed in Docker Swarm mode, our cluster has both "actual" nodes, which correspond to the nodes that
        Docker Swarm knows about, and virtual nodes that correspond to each local daemon container.

        In a "real" deployment, there would be one local daemon per Docker Swarm node. But for development and debugging,
        we may provision many local daemons per Docker Swarm node, where each local daemon manages its own virtual node.

        If the Cluster is not running in Docker mode, then this will return an error.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetNumNodes(self, request, context):
        """GetNumNodes returns the number of nodes in the cluster.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetNumClusterNodes(self, request, context):
        """SetNumClusterNodes is used to scale the number of nodes in the cluster to a specifically value.
        This function accepts a SetNumClusterNodesRequest struct, which encodes the target number of nodes.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def AddClusterNodes(self, request, context):
        """AddClusterNodes provisions a parameterized number of additional nodes within the cluster.
        This function accepts a AddClusterNodesRequest struct, which encodes the number of nodes to add.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveSpecificClusterNodes(self, request, context):
        """RemoveClusterNodes removes the specified nodes from the Docker cluster.
        This function accepts a RemoveSpecificClusterNodesRequest struct, which encodes the IDs of the nodes to remove.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveClusterNodes(self, request, context):
        """RemoveClusterNodes removes the specified number of existing nodes from the Docker cluster.
        This function accepts a RemoveClusterNodesRequest struct, which encodes the number of nodes to remove.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ModifyClusterNodes(self, request, context):
        """ModifyClusterNodes enables the modification of one or more nodes within the cluster.
        Modifications include altering the number of GPUs available on the nodes.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetLocalDaemonNodeIDs(self, request, context):
        """GetLocalDaemonNodeIDs returns a string slice containing the host IDs of each local daemon.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def QueryMessage(self, request, context):
        """QueryMessage is used to query whether a given ZMQ message has been seen by any of the Cluster components
        and what the status of that message is (i.e., sent, response received, etc.)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ForceLocalDaemonToReconnect(self, request, context):
        """ForceLocalDaemonToReconnect is used to tell a Local Daemon to reconnect to the Cluster Gateway.
        This is mostly used for testing/debugging the reconnection process.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ClusterStatistics(self, request, context):
        """ClusterStatistics is used to request a serialized ClusterStatistics struct.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ClearClusterStatistics(self, request, context):
        """ClearClusterStatistics clears the current ClusterStatistics struct.

        ClearClusterStatistics returns the serialized ClusterStatistics struct before it was cleared.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_DistributedClusterServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'InducePanic': grpc.unary_unary_rpc_method_handler(
                    servicer.InducePanic,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'ClusterAge': grpc.unary_unary_rpc_method_handler(
                    servicer.ClusterAge,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.ClusterAgeResponse.SerializeToString,
            ),
            'SpoofNotifications': grpc.unary_unary_rpc_method_handler(
                    servicer.SpoofNotifications,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'Ping': grpc.unary_unary_rpc_method_handler(
                    servicer.Ping,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.Pong.SerializeToString,
            ),
            'PingKernel': grpc.unary_unary_rpc_method_handler(
                    servicer.PingKernel,
                    request_deserializer=gateway__pb2.PingInstruction.FromString,
                    response_serializer=gateway__pb2.Pong.SerializeToString,
            ),
            'IsKernelActivelyTraining': grpc.unary_unary_rpc_method_handler(
                    servicer.IsKernelActivelyTraining,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.IsKernelTrainingReply.SerializeToString,
            ),
            'IsKernelActivelyMigrating': grpc.unary_unary_rpc_method_handler(
                    servicer.IsKernelActivelyMigrating,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.IsKernelMigratingReply.SerializeToString,
            ),
            'IsKernelActivelyTrainingOrMigrating': grpc.unary_unary_rpc_method_handler(
                    servicer.IsKernelActivelyTrainingOrMigrating,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.IsKernelTrainingOrMigratingReply.SerializeToString,
            ),
            'ListKernels': grpc.unary_unary_rpc_method_handler(
                    servicer.ListKernels,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.ListKernelsResponse.SerializeToString,
            ),
            'SetTotalVirtualGPUs': grpc.unary_unary_rpc_method_handler(
                    servicer.SetTotalVirtualGPUs,
                    request_deserializer=gateway__pb2.SetVirtualGPUsRequest.FromString,
                    response_serializer=gateway__pb2.VirtualGpuInfo.SerializeToString,
            ),
            'GetClusterActualGpuInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.GetClusterActualGpuInfo,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.ClusterActualGpuInfo.SerializeToString,
            ),
            'GetJupyterMessage': grpc.unary_unary_rpc_method_handler(
                    servicer.GetJupyterMessage,
                    request_deserializer=gateway__pb2.GetJupyterMessageRequest.FromString,
                    response_serializer=gateway__pb2.GetJupyterMessageResponse.SerializeToString,
            ),
            'GetClusterVirtualGpuInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.GetClusterVirtualGpuInfo,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.ClusterVirtualGpuInfo.SerializeToString,
            ),
            'MigrateKernelReplica': grpc.unary_unary_rpc_method_handler(
                    servicer.MigrateKernelReplica,
                    request_deserializer=gateway__pb2.MigrationRequest.FromString,
                    response_serializer=gateway__pb2.MigrateKernelResponse.SerializeToString,
            ),
            'FailNextExecution': grpc.unary_unary_rpc_method_handler(
                    servicer.FailNextExecution,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'RegisterDashboard': grpc.unary_unary_rpc_method_handler(
                    servicer.RegisterDashboard,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.DashboardRegistrationResponse.SerializeToString,
            ),
            'GetVirtualDockerNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.GetVirtualDockerNodes,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.GetVirtualDockerNodesResponse.SerializeToString,
            ),
            'GetDockerSwarmNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.GetDockerSwarmNodes,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.GetDockerSwarmNodesResponse.SerializeToString,
            ),
            'GetNumNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.GetNumNodes,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.NumNodesResponse.SerializeToString,
            ),
            'SetNumClusterNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.SetNumClusterNodes,
                    request_deserializer=gateway__pb2.SetNumClusterNodesRequest.FromString,
                    response_serializer=gateway__pb2.SetNumClusterNodesResponse.SerializeToString,
            ),
            'AddClusterNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.AddClusterNodes,
                    request_deserializer=gateway__pb2.AddClusterNodesRequest.FromString,
                    response_serializer=gateway__pb2.AddClusterNodesResponse.SerializeToString,
            ),
            'RemoveSpecificClusterNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveSpecificClusterNodes,
                    request_deserializer=gateway__pb2.RemoveSpecificClusterNodesRequest.FromString,
                    response_serializer=gateway__pb2.RemoveSpecificClusterNodesResponse.SerializeToString,
            ),
            'RemoveClusterNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveClusterNodes,
                    request_deserializer=gateway__pb2.RemoveClusterNodesRequest.FromString,
                    response_serializer=gateway__pb2.RemoveClusterNodesResponse.SerializeToString,
            ),
            'ModifyClusterNodes': grpc.unary_unary_rpc_method_handler(
                    servicer.ModifyClusterNodes,
                    request_deserializer=gateway__pb2.ModifyClusterNodesRequest.FromString,
                    response_serializer=gateway__pb2.ModifyClusterNodesResponse.SerializeToString,
            ),
            'GetLocalDaemonNodeIDs': grpc.unary_unary_rpc_method_handler(
                    servicer.GetLocalDaemonNodeIDs,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.GetLocalDaemonNodeIDsResponse.SerializeToString,
            ),
            'QueryMessage': grpc.unary_unary_rpc_method_handler(
                    servicer.QueryMessage,
                    request_deserializer=gateway__pb2.QueryMessageRequest.FromString,
                    response_serializer=gateway__pb2.QueryMessageResponse.SerializeToString,
            ),
            'ForceLocalDaemonToReconnect': grpc.unary_unary_rpc_method_handler(
                    servicer.ForceLocalDaemonToReconnect,
                    request_deserializer=gateway__pb2.ForceLocalDaemonToReconnectRequest.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'ClusterStatistics': grpc.unary_unary_rpc_method_handler(
                    servicer.ClusterStatistics,
                    request_deserializer=gateway__pb2.ClusterStatisticsRequest.FromString,
                    response_serializer=gateway__pb2.ClusterStatisticsResponse.SerializeToString,
            ),
            'ClearClusterStatistics': grpc.unary_unary_rpc_method_handler(
                    servicer.ClearClusterStatistics,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.ClusterStatisticsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gateway.DistributedCluster', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gateway.DistributedCluster', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class DistributedCluster(object):
    """gRPC service provided by the Cluster Gateway and "used" by the Dashboard
    (i.e., the Cluster Gateway is the server while the Dashboard is the client).
    """

    @staticmethod
    def InducePanic(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/InducePanic',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ClusterAge(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/ClusterAge',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.ClusterAgeResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SpoofNotifications(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/SpoofNotifications',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Ping(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/Ping',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.Pong.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PingKernel(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/PingKernel',
            gateway__pb2.PingInstruction.SerializeToString,
            gateway__pb2.Pong.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def IsKernelActivelyTraining(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/IsKernelActivelyTraining',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.IsKernelTrainingReply.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def IsKernelActivelyMigrating(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/IsKernelActivelyMigrating',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.IsKernelMigratingReply.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def IsKernelActivelyTrainingOrMigrating(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/IsKernelActivelyTrainingOrMigrating',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.IsKernelTrainingOrMigratingReply.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListKernels(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/ListKernels',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.ListKernelsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SetTotalVirtualGPUs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/SetTotalVirtualGPUs',
            gateway__pb2.SetVirtualGPUsRequest.SerializeToString,
            gateway__pb2.VirtualGpuInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetClusterActualGpuInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/GetClusterActualGpuInfo',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.ClusterActualGpuInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetJupyterMessage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/GetJupyterMessage',
            gateway__pb2.GetJupyterMessageRequest.SerializeToString,
            gateway__pb2.GetJupyterMessageResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetClusterVirtualGpuInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/GetClusterVirtualGpuInfo',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.ClusterVirtualGpuInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def MigrateKernelReplica(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/MigrateKernelReplica',
            gateway__pb2.MigrationRequest.SerializeToString,
            gateway__pb2.MigrateKernelResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FailNextExecution(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/FailNextExecution',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RegisterDashboard(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/RegisterDashboard',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.DashboardRegistrationResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetVirtualDockerNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/GetVirtualDockerNodes',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.GetVirtualDockerNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetDockerSwarmNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/GetDockerSwarmNodes',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.GetDockerSwarmNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetNumNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/GetNumNodes',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.NumNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SetNumClusterNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/SetNumClusterNodes',
            gateway__pb2.SetNumClusterNodesRequest.SerializeToString,
            gateway__pb2.SetNumClusterNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def AddClusterNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/AddClusterNodes',
            gateway__pb2.AddClusterNodesRequest.SerializeToString,
            gateway__pb2.AddClusterNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RemoveSpecificClusterNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/RemoveSpecificClusterNodes',
            gateway__pb2.RemoveSpecificClusterNodesRequest.SerializeToString,
            gateway__pb2.RemoveSpecificClusterNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RemoveClusterNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/RemoveClusterNodes',
            gateway__pb2.RemoveClusterNodesRequest.SerializeToString,
            gateway__pb2.RemoveClusterNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ModifyClusterNodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/ModifyClusterNodes',
            gateway__pb2.ModifyClusterNodesRequest.SerializeToString,
            gateway__pb2.ModifyClusterNodesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetLocalDaemonNodeIDs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/GetLocalDaemonNodeIDs',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.GetLocalDaemonNodeIDsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def QueryMessage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/QueryMessage',
            gateway__pb2.QueryMessageRequest.SerializeToString,
            gateway__pb2.QueryMessageResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ForceLocalDaemonToReconnect(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/ForceLocalDaemonToReconnect',
            gateway__pb2.ForceLocalDaemonToReconnectRequest.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ClusterStatistics(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/ClusterStatistics',
            gateway__pb2.ClusterStatisticsRequest.SerializeToString,
            gateway__pb2.ClusterStatisticsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ClearClusterStatistics(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.DistributedCluster/ClearClusterStatistics',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.ClusterStatisticsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)


class ClusterDashboardStub(object):
    """gRPC service provided by the Dashboard and "used" by the Cluster Gateway
    (i.e., the Dashboard is the server while the Cluster Gateway is the client).
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A rpc.Channel.
        """
        self.SendNotification = channel.unary_unary(
                '/gateway.ClusterDashboard/SendNotification',
                request_serializer=gateway__pb2.Notification.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)


class ClusterDashboardServicer(object):
    """gRPC service provided by the Dashboard and "used" by the Cluster Gateway
    (i.e., the Dashboard is the server while the Cluster Gateway is the client).
    """

    def SendNotification(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ClusterDashboardServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'SendNotification': grpc.unary_unary_rpc_method_handler(
                    servicer.SendNotification,
                    request_deserializer=gateway__pb2.Notification.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gateway.ClusterDashboard', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gateway.ClusterDashboard', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class ClusterDashboard(object):
    """gRPC service provided by the Dashboard and "used" by the Cluster Gateway
    (i.e., the Dashboard is the server while the Cluster Gateway is the client).
    """

    @staticmethod
    def SendNotification(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.ClusterDashboard/SendNotification',
            gateway__pb2.Notification.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)


class KernelErrorReporterStub(object):
    """KernelErrorReporter is a gRPC service provided by Local Daemon nodes.

    Kernel replicas running on the same node as the Local Daemon will connect to the KernelErrorReporter service.
    If an error occurs within the kernel, then the kernel can report it to the Local Daemon using the KernelErrorReporter
    gRPC service. The Local Daemon can, in turn, report the error to the Cluster Gateway, so that a notification can
    be submitted to the Cluster Dashboard.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A rpc.Channel.
        """
        self.Notify = channel.unary_unary(
                '/gateway.KernelErrorReporter/Notify',
                request_serializer=gateway__pb2.KernelNotification.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)


class KernelErrorReporterServicer(object):
    """KernelErrorReporter is a gRPC service provided by Local Daemon nodes.

    Kernel replicas running on the same node as the Local Daemon will connect to the KernelErrorReporter service.
    If an error occurs within the kernel, then the kernel can report it to the Local Daemon using the KernelErrorReporter
    gRPC service. The Local Daemon can, in turn, report the error to the Cluster Gateway, so that a notification can
    be submitted to the Cluster Dashboard.
    """

    def Notify(self, request, context):
        """Report that an error occurred within one of the local daemons (or possibly a jupyter kernel).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_KernelErrorReporterServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Notify': grpc.unary_unary_rpc_method_handler(
                    servicer.Notify,
                    request_deserializer=gateway__pb2.KernelNotification.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gateway.KernelErrorReporter', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gateway.KernelErrorReporter', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class KernelErrorReporter(object):
    """KernelErrorReporter is a gRPC service provided by Local Daemon nodes.

    Kernel replicas running on the same node as the Local Daemon will connect to the KernelErrorReporter service.
    If an error occurs within the kernel, then the kernel can report it to the Local Daemon using the KernelErrorReporter
    gRPC service. The Local Daemon can, in turn, report the error to the Cluster Gateway, so that a notification can
    be submitted to the Cluster Dashboard.
    """

    @staticmethod
    def Notify(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.KernelErrorReporter/Notify',
            gateway__pb2.KernelNotification.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)


class LocalGatewayStub(object):
    """The Jupyter gateway service for host local kernels.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A rpc.Channel.
        """
        self.SetID = channel.unary_unary(
                '/gateway.LocalGateway/SetID',
                request_serializer=gateway__pb2.HostId.SerializeToString,
                response_deserializer=gateway__pb2.HostId.FromString,
                _registered_method=True)
        self.StartKernel = channel.unary_unary(
                '/gateway.LocalGateway/StartKernel',
                request_serializer=gateway__pb2.KernelSpec.SerializeToString,
                response_deserializer=gateway__pb2.KernelConnectionInfo.FromString,
                _registered_method=True)
        self.StartKernelReplica = channel.unary_unary(
                '/gateway.LocalGateway/StartKernelReplica',
                request_serializer=gateway__pb2.KernelReplicaSpec.SerializeToString,
                response_deserializer=gateway__pb2.KernelConnectionInfo.FromString,
                _registered_method=True)
        self.PromotePrewarmedContainer = channel.unary_unary(
                '/gateway.LocalGateway/PromotePrewarmedContainer',
                request_serializer=gateway__pb2.PrewarmedKernelReplicaSpec.SerializeToString,
                response_deserializer=gateway__pb2.KernelConnectionInfo.FromString,
                _registered_method=True)
        self.GetKernelStatus = channel.unary_unary(
                '/gateway.LocalGateway/GetKernelStatus',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.KernelStatus.FromString,
                _registered_method=True)
        self.KillKernel = channel.unary_unary(
                '/gateway.LocalGateway/KillKernel',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.StopKernel = channel.unary_unary(
                '/gateway.LocalGateway/StopKernel',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.PingKernel = channel.unary_unary(
                '/gateway.LocalGateway/PingKernel',
                request_serializer=gateway__pb2.PingInstruction.SerializeToString,
                response_deserializer=gateway__pb2.Pong.FromString,
                _registered_method=True)
        self.WaitKernel = channel.unary_unary(
                '/gateway.LocalGateway/WaitKernel',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.KernelStatus.FromString,
                _registered_method=True)
        self.SetClose = channel.unary_unary(
                '/gateway.LocalGateway/SetClose',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.AddReplica = channel.unary_unary(
                '/gateway.LocalGateway/AddReplica',
                request_serializer=gateway__pb2.ReplicaInfoWithAddr.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.UpdateReplicaAddr = channel.unary_unary(
                '/gateway.LocalGateway/UpdateReplicaAddr',
                request_serializer=gateway__pb2.ReplicaInfoWithAddr.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.StartSyncLog = channel.unary_unary(
                '/gateway.LocalGateway/StartSyncLog',
                request_serializer=gateway__pb2.ReplicaInfo.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.PrepareToMigrate = channel.unary_unary(
                '/gateway.LocalGateway/PrepareToMigrate',
                request_serializer=gateway__pb2.ReplicaInfo.SerializeToString,
                response_deserializer=gateway__pb2.PrepareToMigrateResponse.FromString,
                _registered_method=True)
        self.ResourcesSnapshot = channel.unary_unary(
                '/gateway.LocalGateway/ResourcesSnapshot',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.NodeResourcesSnapshotWithContainers.FromString,
                _registered_method=True)
        self.GetLocalDaemonInfo = channel.unary_unary(
                '/gateway.LocalGateway/GetLocalDaemonInfo',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.LocalDaemonInfo.FromString,
                _registered_method=True)
        self.GetActualGpuInfo = channel.unary_unary(
                '/gateway.LocalGateway/GetActualGpuInfo',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.GpuInfo.FromString,
                _registered_method=True)
        self.GetVirtualGpuInfo = channel.unary_unary(
                '/gateway.LocalGateway/GetVirtualGpuInfo',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.VirtualGpuInfo.FromString,
                _registered_method=True)
        self.SetTotalVirtualGPUs = channel.unary_unary(
                '/gateway.LocalGateway/SetTotalVirtualGPUs',
                request_serializer=gateway__pb2.SetVirtualGPUsRequest.SerializeToString,
                response_deserializer=gateway__pb2.VirtualGpuInfo.FromString,
                _registered_method=True)
        self.GetVirtualGpuAllocations = channel.unary_unary(
                '/gateway.LocalGateway/GetVirtualGpuAllocations',
                request_serializer=gateway__pb2.Void.SerializeToString,
                response_deserializer=gateway__pb2.VirtualGpuAllocations.FromString,
                _registered_method=True)
        self.YieldNextExecution = channel.unary_unary(
                '/gateway.LocalGateway/YieldNextExecution',
                request_serializer=gateway__pb2.KernelId.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)
        self.ReconnectToGateway = channel.unary_unary(
                '/gateway.LocalGateway/ReconnectToGateway',
                request_serializer=gateway__pb2.ReconnectToGatewayRequest.SerializeToString,
                response_deserializer=gateway__pb2.Void.FromString,
                _registered_method=True)


class LocalGatewayServicer(object):
    """The Jupyter gateway service for host local kernels.
    """

    def SetID(self, request, context):
        """SetID sets the local gateway id and return old id for failure tolerance.
        This also instructs the Local Daemon associated with the LocalGateway to create a PrometheusManager and begin serving metrics.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StartKernel(self, request, context):
        """StartKernel starts a kernel or kernel replica.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StartKernelReplica(self, request, context):
        """StartKernelReplica starts a kernel replica on the local host.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PromotePrewarmedContainer(self, request, context):
        """PromotePrewarmedContainer is similar to StartKernelReplica, except that PromotePrewarmedContainer launches the new
        kernel using an existing, pre-warmed container that is already available on this host.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetKernelStatus(self, request, context):
        """GetKernelStatus returns the status of a kernel.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def KillKernel(self, request, context):
        """KillKernel kills a kernel.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StopKernel(self, request, context):
        """StopKernel stops a kernel gracefully and return immediately.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PingKernel(self, request, context):
        """Used to test connectivity with kernels.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def WaitKernel(self, request, context):
        """WaitKernel waits for a kernel to stop and return status.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetClose(self, request, context):
        """SetClose request the gateway to close all kernels and stop.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def AddReplica(self, request, context):
        """AddReplica instructs a set of kernel replicas to add a new node to their SMR cluster.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateReplicaAddr(self, request, context):
        """UpdateReplicaAddr instructs a set of kernel replicas to update the peer address of a particular node.
        This is primarily used during migrations.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StartSyncLog(self, request, context):
        """StartSyncLog instructs the LocalGateway to send a "start_synclog_request" message to the specified kernel replica.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PrepareToMigrate(self, request, context):
        """Used to instruct a specific kernel replica to prepare to be migrated to a new node.
        This involves writing the contents of the etcd-raft data directory to remote storage so that
        it can be read back from make build-linux-amd64 by the new replica.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ResourcesSnapshot(self, request, context):
        """ResourcesSnapshot returns a NodeResourcesSnapshot struct encoding a snapshot of
        the current resource quantities on the node.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetLocalDaemonInfo(self, request, context):
        """GetLocalDaemonInfo returns key information about the Local Daemon, including its current resource counts,
        its ID, etc.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetActualGpuInfo(self, request, context):
        """Return the current GPU resource metrics on the node.
        @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetVirtualGpuInfo(self, request, context):
        """Return the current vGPU (or "deflated GPU") resource metrics on the node.
        @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetTotalVirtualGPUs(self, request, context):
        """Set the maximum number of vGPU resources available on the node.
        @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetVirtualGpuAllocations(self, request, context):
        """Return the current vGPU allocations on this node.
        @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def YieldNextExecution(self, request, context):
        """Ensure that the next 'execute_request' for the specified kernel fails.
        This is to be used exclusively for testing/debugging purposes.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReconnectToGateway(self, request, context):
        """ReconnectToGateway is used to force the Local Daemon to reconnect to the Cluster Gateway.

        The reconnection procedure is optionally initiated shortly after the ReconnectToGateway gRPC call returns,
        to avoid causing the ReconnectToGateway to encounter an error.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_LocalGatewayServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'SetID': grpc.unary_unary_rpc_method_handler(
                    servicer.SetID,
                    request_deserializer=gateway__pb2.HostId.FromString,
                    response_serializer=gateway__pb2.HostId.SerializeToString,
            ),
            'StartKernel': grpc.unary_unary_rpc_method_handler(
                    servicer.StartKernel,
                    request_deserializer=gateway__pb2.KernelSpec.FromString,
                    response_serializer=gateway__pb2.KernelConnectionInfo.SerializeToString,
            ),
            'StartKernelReplica': grpc.unary_unary_rpc_method_handler(
                    servicer.StartKernelReplica,
                    request_deserializer=gateway__pb2.KernelReplicaSpec.FromString,
                    response_serializer=gateway__pb2.KernelConnectionInfo.SerializeToString,
            ),
            'PromotePrewarmedContainer': grpc.unary_unary_rpc_method_handler(
                    servicer.PromotePrewarmedContainer,
                    request_deserializer=gateway__pb2.PrewarmedKernelReplicaSpec.FromString,
                    response_serializer=gateway__pb2.KernelConnectionInfo.SerializeToString,
            ),
            'GetKernelStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.GetKernelStatus,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.KernelStatus.SerializeToString,
            ),
            'KillKernel': grpc.unary_unary_rpc_method_handler(
                    servicer.KillKernel,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'StopKernel': grpc.unary_unary_rpc_method_handler(
                    servicer.StopKernel,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'PingKernel': grpc.unary_unary_rpc_method_handler(
                    servicer.PingKernel,
                    request_deserializer=gateway__pb2.PingInstruction.FromString,
                    response_serializer=gateway__pb2.Pong.SerializeToString,
            ),
            'WaitKernel': grpc.unary_unary_rpc_method_handler(
                    servicer.WaitKernel,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.KernelStatus.SerializeToString,
            ),
            'SetClose': grpc.unary_unary_rpc_method_handler(
                    servicer.SetClose,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'AddReplica': grpc.unary_unary_rpc_method_handler(
                    servicer.AddReplica,
                    request_deserializer=gateway__pb2.ReplicaInfoWithAddr.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'UpdateReplicaAddr': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateReplicaAddr,
                    request_deserializer=gateway__pb2.ReplicaInfoWithAddr.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'StartSyncLog': grpc.unary_unary_rpc_method_handler(
                    servicer.StartSyncLog,
                    request_deserializer=gateway__pb2.ReplicaInfo.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'PrepareToMigrate': grpc.unary_unary_rpc_method_handler(
                    servicer.PrepareToMigrate,
                    request_deserializer=gateway__pb2.ReplicaInfo.FromString,
                    response_serializer=gateway__pb2.PrepareToMigrateResponse.SerializeToString,
            ),
            'ResourcesSnapshot': grpc.unary_unary_rpc_method_handler(
                    servicer.ResourcesSnapshot,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.NodeResourcesSnapshotWithContainers.SerializeToString,
            ),
            'GetLocalDaemonInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.GetLocalDaemonInfo,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.LocalDaemonInfo.SerializeToString,
            ),
            'GetActualGpuInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.GetActualGpuInfo,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.GpuInfo.SerializeToString,
            ),
            'GetVirtualGpuInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.GetVirtualGpuInfo,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.VirtualGpuInfo.SerializeToString,
            ),
            'SetTotalVirtualGPUs': grpc.unary_unary_rpc_method_handler(
                    servicer.SetTotalVirtualGPUs,
                    request_deserializer=gateway__pb2.SetVirtualGPUsRequest.FromString,
                    response_serializer=gateway__pb2.VirtualGpuInfo.SerializeToString,
            ),
            'GetVirtualGpuAllocations': grpc.unary_unary_rpc_method_handler(
                    servicer.GetVirtualGpuAllocations,
                    request_deserializer=gateway__pb2.Void.FromString,
                    response_serializer=gateway__pb2.VirtualGpuAllocations.SerializeToString,
            ),
            'YieldNextExecution': grpc.unary_unary_rpc_method_handler(
                    servicer.YieldNextExecution,
                    request_deserializer=gateway__pb2.KernelId.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
            'ReconnectToGateway': grpc.unary_unary_rpc_method_handler(
                    servicer.ReconnectToGateway,
                    request_deserializer=gateway__pb2.ReconnectToGatewayRequest.FromString,
                    response_serializer=gateway__pb2.Void.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gateway.LocalGateway', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gateway.LocalGateway', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class LocalGateway(object):
    """The Jupyter gateway service for host local kernels.
    """

    @staticmethod
    def SetID(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/SetID',
            gateway__pb2.HostId.SerializeToString,
            gateway__pb2.HostId.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StartKernel(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/StartKernel',
            gateway__pb2.KernelSpec.SerializeToString,
            gateway__pb2.KernelConnectionInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StartKernelReplica(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/StartKernelReplica',
            gateway__pb2.KernelReplicaSpec.SerializeToString,
            gateway__pb2.KernelConnectionInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PromotePrewarmedContainer(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/PromotePrewarmedContainer',
            gateway__pb2.PrewarmedKernelReplicaSpec.SerializeToString,
            gateway__pb2.KernelConnectionInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetKernelStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/GetKernelStatus',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.KernelStatus.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def KillKernel(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/KillKernel',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StopKernel(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/StopKernel',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PingKernel(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/PingKernel',
            gateway__pb2.PingInstruction.SerializeToString,
            gateway__pb2.Pong.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def WaitKernel(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/WaitKernel',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.KernelStatus.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SetClose(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/SetClose',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def AddReplica(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/AddReplica',
            gateway__pb2.ReplicaInfoWithAddr.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UpdateReplicaAddr(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/UpdateReplicaAddr',
            gateway__pb2.ReplicaInfoWithAddr.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StartSyncLog(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/StartSyncLog',
            gateway__pb2.ReplicaInfo.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PrepareToMigrate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/PrepareToMigrate',
            gateway__pb2.ReplicaInfo.SerializeToString,
            gateway__pb2.PrepareToMigrateResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ResourcesSnapshot(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/ResourcesSnapshot',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.NodeResourcesSnapshotWithContainers.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetLocalDaemonInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/GetLocalDaemonInfo',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.LocalDaemonInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetActualGpuInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/GetActualGpuInfo',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.GpuInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetVirtualGpuInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/GetVirtualGpuInfo',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.VirtualGpuInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SetTotalVirtualGPUs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/SetTotalVirtualGPUs',
            gateway__pb2.SetVirtualGPUsRequest.SerializeToString,
            gateway__pb2.VirtualGpuInfo.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetVirtualGpuAllocations(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/GetVirtualGpuAllocations',
            gateway__pb2.Void.SerializeToString,
            gateway__pb2.VirtualGpuAllocations.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def YieldNextExecution(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/YieldNextExecution',
            gateway__pb2.KernelId.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ReconnectToGateway(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gateway.LocalGateway/ReconnectToGateway',
            gateway__pb2.ReconnectToGatewayRequest.SerializeToString,
            gateway__pb2.Void.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
