import { SVGIconProps } from '@patternfly/react-icons/dist/esm/createIcon';
import React from 'react';

interface RamIconProps extends SVGIconProps {
    scale?: number;
}

export class RamIcon extends React.Component<RamIconProps> {
    static displayName = 'RamIcon';

    id = `icon-title-ram-icon`;

    render() {
        let scale = 1;
        if (this.props.scale) {
            scale = this.props.scale;
        }

        const { title, className, ...props } = this.props;
        const classes = className ? `pf-v5-svg ${className}` : 'pf-v5-svg';

        const hasTitle = Boolean(title);
        const viewBox = [0, 0, 512, 512].join(' ');

        return (
            <svg
                className={classes}
                viewBox={viewBox}
                fill="currentColor"
                aria-labelledby={hasTitle ? this.id : undefined}
                aria-hidden={hasTitle ? undefined : true}
                role="img"
                width="1em"
                height="1em"
                transform={`scale(${scale})`}
                {...(props as Omit<React.SVGProps<SVGElement>, 'ref'>)} // Lie.
            >
                {hasTitle && <title id={this.id}>{title}</title>}
                <g id="ram">
                    <g>
                        <path
                            fill="#A0D468"
                            d="M278.625,361.594L256,338.969l0,0c-4.172-4.156-4.172-10.922,0-15.094c4.156-4.156,10.922-4.156,15.078,0    l0,0l22.625,22.641L512,128.227L459.203,75.43c-4.172,4.164-10.922,4.164-15.094,0c-4.156-4.164-4.156-10.922,0-15.086    l-7.531-7.539c-4.172,4.164-10.922,4.164-15.094-0.008c-4.156-4.164-4.156-10.914,0-15.078L383.781,0L0,383.781L37.703,421.5    c4.172-4.172,10.922-4.172,15.094,0c4.156,4.156,4.156,10.906,0,15.078l7.531,7.547c4.172-4.172,10.922-4.172,15.094,0    c4.156,4.156,4.172,10.906,0,15.078L128.219,512L278.625,361.594z"
                        />
                    </g>
                    <g>
                        <polygon
                            fill="#8CC153"
                            points="256,338.969 105.594,489.375 128.219,512 278.625,361.594 256,338.969   "
                        />
                        <polygon
                            fill="#8CC153"
                            points="271.078,323.875 271.078,323.875 271.078,323.875 293.703,346.516 512,128.227 489.375,105.602       "
                        />
                    </g>
                    <g>
                        <path
                            fill="#FFCE54"
                            d="M482.266,142.867c-4.156,4.164-4.156,10.922,0,15.086l15.094-15.086    C493.188,138.703,486.438,138.703,482.266,142.867z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M459.641,165.492c-4.156,4.164-4.156,10.922,0,15.086l15.094-15.086    C470.562,161.328,463.812,161.328,459.641,165.492z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M437.016,188.117c-4.172,4.172-4.172,10.922,0,15.086l15.078-15.086    C447.938,183.953,441.188,183.953,437.016,188.117z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M414.391,210.75c-4.172,4.164-4.172,10.922,0,15.086l15.078-15.086    C425.312,206.586,418.547,206.586,414.391,210.75z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M391.766,233.375c-4.172,4.164-4.172,10.922,0,15.086l15.078-15.086    C402.688,229.211,395.922,229.211,391.766,233.375z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M369.125,256c-4.156,4.172-4.156,10.922,0,15.086L384.219,256    C380.047,251.836,373.297,251.836,369.125,256z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M346.5,278.625c-4.156,4.172-4.156,10.938,0,15.094l15.094-15.094    C357.422,274.469,350.672,274.469,346.5,278.625z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M323.875,301.25c-4.156,4.172-4.156,10.938,0,15.094l15.094-15.094    C334.797,297.094,328.047,297.094,323.875,301.25z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M301.25,323.875c-4.156,4.188-4.172,10.938,0,15.094l15.094-15.094    C312.172,319.719,305.422,319.719,301.25,323.875z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M256,369.141c-4.172,4.172-4.172,10.922,0,15.078l15.078-15.078    C266.922,364.969,260.156,364.969,256,369.141z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M233.375,391.766c-4.172,4.172-4.172,10.922,0,15.078l15.078-15.078    C244.281,387.594,237.531,387.594,233.375,391.766z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M210.734,414.406c-4.156,4.156-4.156,10.906,0,15.078l15.094-15.078    C221.656,410.219,214.906,410.219,210.734,414.406z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M188.109,437.031c-4.156,4.156-4.156,10.906,0,15.078l15.094-15.078    C199.031,432.859,192.281,432.859,188.109,437.031z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M165.484,459.656c-4.156,4.156-4.156,10.906,0,15.078l15.094-15.078    C176.406,455.484,169.656,455.484,165.484,459.656z"
                        />
                        <path
                            fill="#FFCE54"
                            d="M142.859,482.281c-4.172,4.156-4.172,10.906,0,15.078l15.078-15.078    C153.781,478.109,147.031,478.109,142.859,482.281z"
                        />
                    </g>

                    <rect
                        x="84.259"
                        y="362.447"
                        transform="matrix(0.7071 0.7071 -0.7071 0.7071 302.302 37.7409)"
                        fill="#656D78"
                        width="42.669"
                        height="42.669"
                    />
                    <polygon
                        fill="#656D78"
                        points="165.938,353.609 135.766,323.438 165.938,293.281 196.094,323.438  "
                    />
                    <polygon fill="#656D78" points="256.438,263.102 226.266,232.93 256.438,202.766 286.609,232.93  " />

                    <rect
                        x="295.447"
                        y="151.259"
                        transform="matrix(0.7071 0.7071 -0.7071 0.7071 214.8253 -173.4466)"
                        fill="#656D78"
                        width="42.669"
                        height="42.669"
                    />
                    <g>
                        <path
                            fill="#434A54"
                            d="M60.328,383.781l45.266,45.25l45.25-45.25l-45.25-45.25L60.328,383.781z M105.594,398.875L90.5,383.781    l15.094-15.094l15.078,15.094L105.594,398.875z"
                        />
                        <path
                            fill="#434A54"
                            d="M120.672,323.438l45.266,45.25l45.25-45.25l-45.25-45.25L120.672,323.438z M165.938,338.531    l-15.094-15.094l15.094-15.078l15.078,15.078L165.938,338.531z"
                        />
                        <path
                            fill="#434A54"
                            d="M211.188,232.93l45.25,45.258l45.25-45.258l-45.25-45.25L211.188,232.93z M256.438,248.016l-15.078-15.086    l15.078-15.086l15.094,15.086L256.438,248.016z"
                        />
                        <path
                            fill="#434A54"
                            d="M316.781,127.336l-45.25,45.258l45.25,45.25l45.25-45.25L316.781,127.336z M301.688,172.594l15.094-15.086    l15.078,15.086l-15.078,15.086L301.688,172.594z"
                        />
                    </g>
                    <polygon fill="#656D78" points="377.125,142.422 346.953,112.25 377.125,82.086 407.281,112.25  " />
                    <path
                        fill="#434A54"
                        d="M377.125,67l-45.266,45.25l45.266,45.258l45.25-45.258L377.125,67z M377.125,127.336l-15.094-15.086   l15.094-15.078l15.078,15.078L377.125,127.336z"
                    />
                </g>
            </svg>
        );
    }
}
