import { SVGIconProps } from '@patternfly/react-icons/dist/esm/createIcon';
import React from 'react';

interface GpuIconProps extends SVGIconProps {
    scale?: number;
}

export class GpuIcon extends React.Component<GpuIconProps> {
    static displayName = 'GpuIcon';

    id = `icon-title-gpu-icon`;

    render() {
        let scale = 1;
        if (this.props.scale) {
            scale = this.props.scale;
        }

        const { title, className, ...props } = this.props;
        const classes = className ? `pf-v5-svg ${className}` : 'pf-v5-svg';

        const hasTitle = Boolean(title);
        const viewBox = [0, 0, 1024, 1024].join(' ');

        return (
            <svg
                className={classes}
                viewBox={viewBox}
                fill="currentColor"
                aria-labelledby={hasTitle ? this.id : undefined}
                aria-hidden={hasTitle ? undefined : true}
                role="img"
                width="1em"
                height="1em"
                transform={`scale(${scale})`}
                {...(props as Omit<React.SVGProps<SVGElement>, 'ref'>)} // Lie.
            >
                {hasTitle && <title id={this.id}>{title}</title>}
                <path
                    d={
                        'M0 153.652H144.484V732.504H81.664V680.456H55.992V531.836H81.664V423.784H55.992V275.168H81.664V216.472H0V153.652ZM932.156 350.748V678.4C932.156 706.152 909.66 728.664 881.904 728.664H881.852V778.504H560.968V728.664H530.52V778.504H209.636V728.664H181.5V300.5H881.904C909.66 300.5 932.156 322.996 932.156 350.748ZM250.08 726.168H234.08V762.168H250.08V726.168ZM282.08 726.168H266.08V762.168H282.08V726.168ZM314.08 726.168H298.08V762.168H314.08V726.168ZM346.08 726.168H330.08V762.168H346.08V726.168ZM355.944 515.22H315.992V530.92H338.228V538.692C329.624 548.748 319.988 553.772 309.312 553.772 304.648 553.772 300.32 552.816 296.332 550.892 292.34 548.976 288.896 546.36 285.996 543.044 283.092 539.728 280.808 535.812 279.152 531.304 277.496 526.796 276.668 521.952 276.668 516.768 276.668 511.792 277.42 507.076 278.92 502.62 280.424 498.168 282.548 494.224 285.296 490.804 288.044 487.388 291.36 484.692 295.248 482.72 299.132 480.752 303.408 479.768 308.072 479.768 313.976 479.768 319.444 481.216 324.476 484.12 329.5 487.024 333.412 491.22 336.212 496.712L352.228 484.896C348.492 477.536 342.924 471.68 335.512 467.328 328.1 462.972 319.212 460.796 308.852 460.796 301.18 460.796 294.084 462.272 287.556 465.224 281.024 468.18 275.348 472.168 270.532 477.196 265.712 482.224 261.928 488.08 259.18 494.764 256.432 501.448 255.064 508.576 255.064 516.14 255.064 524.124 256.436 531.556 259.18 538.448 261.928 545.344 265.656 551.332 270.376 556.404 275.088 561.484 280.632 565.476 287.008 568.376 293.384 571.28 300.196 572.728 307.452 572.728 319.164 572.728 329.42 568.324 338.232 559.512V571.948H355.952V515.22ZM378.08 726.168H362.08V762.168H378.08V726.168ZM410.08 726.168H394.08V762.168H410.08V726.168ZM442.08 726.168H426.08V762.168H442.08V726.168ZM448.444 461.584H374.288V571.964H395.74V526.256H439.584V508.844H395.744V480.396H448.448V461.584ZM474.08 726.168H458.08V762.168H474.08V726.168ZM506.08 726.168H490.08V762.168H506.08V726.168ZM513.584 517.552 552.916 461.584H529.752L502.392 502.628 474.872 461.584H451.556L490.888 517.552 452.8 571.96H476.12L502.392 532.472 528.508 571.96H551.672L513.584 517.552ZM601.416 726.168H585.416V762.168H601.416V726.168ZM633.416 726.168H617.416V762.168H633.416V726.168ZM665.416 726.168H649.416V762.168H665.416V726.168ZM697.416 726.168H681.416V762.168H697.416V726.168ZM729.416 726.168H713.416V762.168H729.416V726.168ZM761.416 726.168H745.416V762.168H761.416V726.168ZM793.416 726.168H777.416V762.168H793.416V726.168ZM825.416 726.168H809.416V762.168H825.416V726.168ZM857.416 726.168H841.416V762.168H857.416V726.168ZM870.908 522.78C870.908 445.468 808.228 382.78 730.908 382.78 653.588 382.78 590.908 445.468 590.908 522.78 590.908 600.088 653.588 662.78 730.908 662.78 808.228 662.78 870.908 600.088 870.908 522.78ZM806.3 525.008C809.744 523.152 813.192 521.312 816.58 519.484 819.944 517.568 823.26 515.68 826.464 513.852 829.68 512.012 832.796 510.244 835.716 508.412 835.944 508.276 836.16 508.14 836.384 507.996 832.672 481.26 819.044 457.684 799.312 441.144 799.04 441.512 798.752 441.912 798.464 442.296 797.236 443.992 795.856 445.88 794.352 447.948 792.744 450.028 791.012 452.276 789.168 454.664 787.36 457.064 785.312 459.544 783.196 462.12 781.076 464.708 778.884 467.376 776.66 470.104 774.336 472.76 771.98 475.472 769.616 478.196 769.608 478.196 769.6 478.208 769.588 478.224 769.752 475.592 769.916 472.92 770.088 470.212 770.316 466.384 770.376 462.492 770.524 458.6 770.648 454.692 770.776 450.788 770.896 446.944 770.916 443.06 770.928 439.252 770.944 435.556 770.968 431.848 770.984 428.26 770.86 424.82 770.86 424.54 770.848 424.3 770.84 424.028 758.5 419.024 745.032 416.264 730.904 416.264 718.072 416.264 705.78 418.532 694.384 422.68 694.58 423.116 694.78 423.576 694.984 424.028 695.828 425.94 696.784 428.08 697.824 430.428 698.82 432.852 699.904 435.48 701.044 438.268 702.22 441.036 703.348 444.044 704.516 447.164 705.696 450.308 706.916 453.528 708.148 456.808 709.3 460.16 710.468 463.56 711.64 466.96 711.644 466.976 711.648 466.98 711.66 467.008 709.456 465.544 707.232 464.068 704.96 462.56 701.768 460.456 698.436 458.452 695.128 456.372 691.808 454.32 688.484 452.256 685.216 450.228 681.864 448.28 678.572 446.352 675.38 444.492 672.184 442.624 669.088 440.82 666.048 439.2 665.812 439.072 665.6 438.96 665.368 438.824 645.02 454.732 630.616 477.864 625.996 504.368 626.456 504.416 626.936 504.468 627.42 504.508 629.488 504.732 631.828 504.984 634.376 505.256 636.976 505.6 639.792 505.984 642.776 506.392 645.756 506.748 648.928 507.288 652.22 507.832 655.516 508.38 658.932 508.932 662.392 509.508 665.864 510.184 669.392 510.872 672.92 511.56 672.936 511.56 672.948 511.56 672.968 511.56 670.608 512.736 668.216 513.928 665.772 515.144 662.352 516.856 658.96 518.74 655.504 520.56 652.06 522.412 648.612 524.252 645.224 526.08 641.856 527.996 638.54 529.884 635.34 531.724 632.124 533.552 629.008 535.332 626.092 537.156 625.86 537.292 625.644 537.42 625.416 537.564 629.132 564.308 642.76 587.876 662.492 604.42 662.764 604.052 663.056 603.656 663.34 603.264 664.568 601.576 665.948 599.684 667.452 597.612 669.056 595.532 670.796 593.288 672.636 590.904 674.444 588.496 676.492 586.016 678.608 583.448 680.728 580.856 682.916 578.188 685.144 575.472 687.468 572.812 689.824 570.092 692.188 567.38 692.192 567.372 692.204 567.352 692.216 567.344 692.052 569.972 691.888 572.64 691.72 575.356 691.488 579.184 691.424 583.068 691.28 586.968 691.152 590.872 691.028 594.784 690.904 598.624 690.888 602.5 690.876 606.32 690.86 610.008 690.836 613.72 690.82 617.3 690.94 620.744 690.944 621.02 690.956 621.268 690.956 621.532 703.296 626.54 716.768 629.3 730.896 629.3 743.728 629.3 756.02 627.036 767.412 622.88 767.216 622.448 767.024 621.988 766.816 621.532 765.972 619.628 765.016 617.484 763.976 615.14 762.98 612.712 761.896 610.08 760.76 607.304 759.584 604.532 758.452 601.516 757.288 598.404 756.108 595.268 754.884 592.032 753.656 588.752 752.5 585.404 751.332 582 750.16 578.608 750.156 578.596 750.152 578.58 750.144 578.556 752.344 580.028 754.568 581.496 756.84 583.008 760.028 585.104 763.364 587.108 766.672 589.188 769.992 591.244 773.316 593.308 776.584 595.34 779.936 597.288 783.228 599.216 786.416 601.076 789.616 602.936 792.708 604.748 795.748 606.36 795.988 606.496 796.2 606.608 796.428 606.74 816.78 590.828 831.18 567.708 835.804 541.2 835.344 541.148 834.864 541.096 834.38 541.056 832.308 540.832 829.976 540.588 827.424 540.316 824.824 539.964 822.004 539.584 819.024 539.168 816.04 538.82 812.872 538.284 809.58 537.74 806.284 537.192 802.868 536.636 799.408 536.06 795.936 535.384 792.408 534.692 788.88 534.008 788.864 534.008 788.852 534.008 788.832 534.008 791.192 532.824 793.584 531.636 796.024 530.416 799.448 528.716 802.844 526.824 806.3 525.008Z'
                    }
                />
            </svg>
        );
    }
}
