// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.27.2
// source: internal/server/api/proto/gateway.proto

package proto

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ClusterGateway_ID_FullMethodName                     = "/gateway.ClusterGateway/ID"
	ClusterGateway_RemoveHost_FullMethodName             = "/gateway.ClusterGateway/RemoveHost"
	ClusterGateway_MigrateKernelReplica_FullMethodName   = "/gateway.ClusterGateway/MigrateKernelReplica"
	ClusterGateway_NotifyKernelRegistered_FullMethodName = "/gateway.ClusterGateway/NotifyKernelRegistered"
	ClusterGateway_SmrReady_FullMethodName               = "/gateway.ClusterGateway/SmrReady"
	ClusterGateway_SmrNodeAdded_FullMethodName           = "/gateway.ClusterGateway/SmrNodeAdded"
	ClusterGateway_Notify_FullMethodName                 = "/gateway.ClusterGateway/Notify"
	ClusterGateway_PingGateway_FullMethodName            = "/gateway.ClusterGateway/PingGateway"
)

// ClusterGatewayClient is the client API for ClusterGateway service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// gRPC service provided by the ClusterGateway and "used" by the Local Daemons
// (i.e., the Cluster Gateway is the server while the Local Daemons are the clients).
type ClusterGatewayClient interface {
	// ID returns the cluster gateway id and can be used to test connectivity.
	ID(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ProvisionerId, error)
	// RemoveHost removes a local gateway from the cluster.
	RemoveHost(ctx context.Context, in *HostId, opts ...grpc.CallOption) (*Void, error)
	// MigrateKernelReplica selects a qualified host and adds a kernel replica to the replica set.
	// Unlike StartKernelReplica, a new replica is added to the replica set and a training task may
	// need to start immediately after replica started, e.g., preempting a training task.
	//
	// The function will simply remove the replica from the kernel without stopping it.
	// The caller should stop the replica after confirmed that the new replica is ready.
	MigrateKernelReplica(ctx context.Context, in *MigrationRequest, opts ...grpc.CallOption) (*MigrateKernelResponse, error)
	// Notify the Gateway that a distributed kernel replica has started somewhere.
	NotifyKernelRegistered(ctx context.Context, in *KernelRegistrationNotification, opts ...grpc.CallOption) (*KernelRegistrationNotificationResponse, error)
	SmrReady(ctx context.Context, in *SmrReadyNotification, opts ...grpc.CallOption) (*Void, error)
	SmrNodeAdded(ctx context.Context, in *ReplicaInfo, opts ...grpc.CallOption) (*Void, error)
	// Report that an error occurred within one of the local daemons (or possibly a jupyter kernel).
	Notify(ctx context.Context, in *Notification, opts ...grpc.CallOption) (*Void, error)
	// PingGateway is a no-op for testing connectivity.
	PingGateway(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error)
}

type clusterGatewayClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterGatewayClient(cc grpc.ClientConnInterface) ClusterGatewayClient {
	return &clusterGatewayClient{cc}
}

func (c *clusterGatewayClient) ID(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ProvisionerId, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ProvisionerId)
	err := c.cc.Invoke(ctx, ClusterGateway_ID_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterGatewayClient) RemoveHost(ctx context.Context, in *HostId, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, ClusterGateway_RemoveHost_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterGatewayClient) MigrateKernelReplica(ctx context.Context, in *MigrationRequest, opts ...grpc.CallOption) (*MigrateKernelResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MigrateKernelResponse)
	err := c.cc.Invoke(ctx, ClusterGateway_MigrateKernelReplica_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterGatewayClient) NotifyKernelRegistered(ctx context.Context, in *KernelRegistrationNotification, opts ...grpc.CallOption) (*KernelRegistrationNotificationResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(KernelRegistrationNotificationResponse)
	err := c.cc.Invoke(ctx, ClusterGateway_NotifyKernelRegistered_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterGatewayClient) SmrReady(ctx context.Context, in *SmrReadyNotification, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, ClusterGateway_SmrReady_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterGatewayClient) SmrNodeAdded(ctx context.Context, in *ReplicaInfo, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, ClusterGateway_SmrNodeAdded_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterGatewayClient) Notify(ctx context.Context, in *Notification, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, ClusterGateway_Notify_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterGatewayClient) PingGateway(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, ClusterGateway_PingGateway_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterGatewayServer is the server API for ClusterGateway service.
// All implementations must embed UnimplementedClusterGatewayServer
// for forward compatibility.
//
// gRPC service provided by the ClusterGateway and "used" by the Local Daemons
// (i.e., the Cluster Gateway is the server while the Local Daemons are the clients).
type ClusterGatewayServer interface {
	// ID returns the cluster gateway id and can be used to test connectivity.
	ID(context.Context, *Void) (*ProvisionerId, error)
	// RemoveHost removes a local gateway from the cluster.
	RemoveHost(context.Context, *HostId) (*Void, error)
	// MigrateKernelReplica selects a qualified host and adds a kernel replica to the replica set.
	// Unlike StartKernelReplica, a new replica is added to the replica set and a training task may
	// need to start immediately after replica started, e.g., preempting a training task.
	//
	// The function will simply remove the replica from the kernel without stopping it.
	// The caller should stop the replica after confirmed that the new replica is ready.
	MigrateKernelReplica(context.Context, *MigrationRequest) (*MigrateKernelResponse, error)
	// Notify the Gateway that a distributed kernel replica has started somewhere.
	NotifyKernelRegistered(context.Context, *KernelRegistrationNotification) (*KernelRegistrationNotificationResponse, error)
	SmrReady(context.Context, *SmrReadyNotification) (*Void, error)
	SmrNodeAdded(context.Context, *ReplicaInfo) (*Void, error)
	// Report that an error occurred within one of the local daemons (or possibly a jupyter kernel).
	Notify(context.Context, *Notification) (*Void, error)
	// PingGateway is a no-op for testing connectivity.
	PingGateway(context.Context, *Void) (*Void, error)
	mustEmbedUnimplementedClusterGatewayServer()
}

// UnimplementedClusterGatewayServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedClusterGatewayServer struct{}

func (UnimplementedClusterGatewayServer) ID(context.Context, *Void) (*ProvisionerId, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ID not implemented")
}
func (UnimplementedClusterGatewayServer) RemoveHost(context.Context, *HostId) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveHost not implemented")
}
func (UnimplementedClusterGatewayServer) MigrateKernelReplica(context.Context, *MigrationRequest) (*MigrateKernelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MigrateKernelReplica not implemented")
}
func (UnimplementedClusterGatewayServer) NotifyKernelRegistered(context.Context, *KernelRegistrationNotification) (*KernelRegistrationNotificationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NotifyKernelRegistered not implemented")
}
func (UnimplementedClusterGatewayServer) SmrReady(context.Context, *SmrReadyNotification) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SmrReady not implemented")
}
func (UnimplementedClusterGatewayServer) SmrNodeAdded(context.Context, *ReplicaInfo) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SmrNodeAdded not implemented")
}
func (UnimplementedClusterGatewayServer) Notify(context.Context, *Notification) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Notify not implemented")
}
func (UnimplementedClusterGatewayServer) PingGateway(context.Context, *Void) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PingGateway not implemented")
}
func (UnimplementedClusterGatewayServer) mustEmbedUnimplementedClusterGatewayServer() {}
func (UnimplementedClusterGatewayServer) testEmbeddedByValue()                        {}

// UnsafeClusterGatewayServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ClusterGatewayServer will
// result in compilation errors.
type UnsafeClusterGatewayServer interface {
	mustEmbedUnimplementedClusterGatewayServer()
}

func RegisterClusterGatewayServer(s grpc.ServiceRegistrar, srv ClusterGatewayServer) {
	// If the following call pancis, it indicates UnimplementedClusterGatewayServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ClusterGateway_ServiceDesc, srv)
}

func _ClusterGateway_ID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).ID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_ID_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).ID(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterGateway_RemoveHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HostId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).RemoveHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_RemoveHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).RemoveHost(ctx, req.(*HostId))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterGateway_MigrateKernelReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).MigrateKernelReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_MigrateKernelReplica_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).MigrateKernelReplica(ctx, req.(*MigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterGateway_NotifyKernelRegistered_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelRegistrationNotification)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).NotifyKernelRegistered(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_NotifyKernelRegistered_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).NotifyKernelRegistered(ctx, req.(*KernelRegistrationNotification))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterGateway_SmrReady_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SmrReadyNotification)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).SmrReady(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_SmrReady_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).SmrReady(ctx, req.(*SmrReadyNotification))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterGateway_SmrNodeAdded_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicaInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).SmrNodeAdded(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_SmrNodeAdded_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).SmrNodeAdded(ctx, req.(*ReplicaInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterGateway_Notify_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Notification)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).Notify(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_Notify_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).Notify(ctx, req.(*Notification))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterGateway_PingGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterGatewayServer).PingGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterGateway_PingGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterGatewayServer).PingGateway(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

// ClusterGateway_ServiceDesc is the grpc.ServiceDesc for ClusterGateway service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ClusterGateway_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gateway.ClusterGateway",
	HandlerType: (*ClusterGatewayServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ID",
			Handler:    _ClusterGateway_ID_Handler,
		},
		{
			MethodName: "RemoveHost",
			Handler:    _ClusterGateway_RemoveHost_Handler,
		},
		{
			MethodName: "MigrateKernelReplica",
			Handler:    _ClusterGateway_MigrateKernelReplica_Handler,
		},
		{
			MethodName: "NotifyKernelRegistered",
			Handler:    _ClusterGateway_NotifyKernelRegistered_Handler,
		},
		{
			MethodName: "SmrReady",
			Handler:    _ClusterGateway_SmrReady_Handler,
		},
		{
			MethodName: "SmrNodeAdded",
			Handler:    _ClusterGateway_SmrNodeAdded_Handler,
		},
		{
			MethodName: "Notify",
			Handler:    _ClusterGateway_Notify_Handler,
		},
		{
			MethodName: "PingGateway",
			Handler:    _ClusterGateway_PingGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "internal/server/api/proto/gateway.proto",
}

const (
	DistributedCluster_InducePanic_FullMethodName                         = "/gateway.DistributedCluster/InducePanic"
	DistributedCluster_ClusterAge_FullMethodName                          = "/gateway.DistributedCluster/ClusterAge"
	DistributedCluster_SpoofNotifications_FullMethodName                  = "/gateway.DistributedCluster/SpoofNotifications"
	DistributedCluster_Ping_FullMethodName                                = "/gateway.DistributedCluster/Ping"
	DistributedCluster_PingKernel_FullMethodName                          = "/gateway.DistributedCluster/PingKernel"
	DistributedCluster_IsKernelActivelyTraining_FullMethodName            = "/gateway.DistributedCluster/IsKernelActivelyTraining"
	DistributedCluster_IsKernelActivelyMigrating_FullMethodName           = "/gateway.DistributedCluster/IsKernelActivelyMigrating"
	DistributedCluster_IsKernelActivelyTrainingOrMigrating_FullMethodName = "/gateway.DistributedCluster/IsKernelActivelyTrainingOrMigrating"
	DistributedCluster_ListKernels_FullMethodName                         = "/gateway.DistributedCluster/ListKernels"
	DistributedCluster_SetTotalVirtualGPUs_FullMethodName                 = "/gateway.DistributedCluster/SetTotalVirtualGPUs"
	DistributedCluster_GetClusterActualGpuInfo_FullMethodName             = "/gateway.DistributedCluster/GetClusterActualGpuInfo"
	DistributedCluster_GetJupyterMessage_FullMethodName                   = "/gateway.DistributedCluster/GetJupyterMessage"
	DistributedCluster_GetClusterVirtualGpuInfo_FullMethodName            = "/gateway.DistributedCluster/GetClusterVirtualGpuInfo"
	DistributedCluster_MigrateKernelReplica_FullMethodName                = "/gateway.DistributedCluster/MigrateKernelReplica"
	DistributedCluster_FailNextExecution_FullMethodName                   = "/gateway.DistributedCluster/FailNextExecution"
	DistributedCluster_RegisterDashboard_FullMethodName                   = "/gateway.DistributedCluster/RegisterDashboard"
	DistributedCluster_GetVirtualDockerNodes_FullMethodName               = "/gateway.DistributedCluster/GetVirtualDockerNodes"
	DistributedCluster_GetDockerSwarmNodes_FullMethodName                 = "/gateway.DistributedCluster/GetDockerSwarmNodes"
	DistributedCluster_GetNumNodes_FullMethodName                         = "/gateway.DistributedCluster/GetNumNodes"
	DistributedCluster_SetNumClusterNodes_FullMethodName                  = "/gateway.DistributedCluster/SetNumClusterNodes"
	DistributedCluster_AddClusterNodes_FullMethodName                     = "/gateway.DistributedCluster/AddClusterNodes"
	DistributedCluster_RemoveSpecificClusterNodes_FullMethodName          = "/gateway.DistributedCluster/RemoveSpecificClusterNodes"
	DistributedCluster_RemoveClusterNodes_FullMethodName                  = "/gateway.DistributedCluster/RemoveClusterNodes"
	DistributedCluster_ModifyClusterNodes_FullMethodName                  = "/gateway.DistributedCluster/ModifyClusterNodes"
	DistributedCluster_GetLocalDaemonNodeIDs_FullMethodName               = "/gateway.DistributedCluster/GetLocalDaemonNodeIDs"
	DistributedCluster_QueryMessage_FullMethodName                        = "/gateway.DistributedCluster/QueryMessage"
	DistributedCluster_ForceLocalDaemonToReconnect_FullMethodName         = "/gateway.DistributedCluster/ForceLocalDaemonToReconnect"
	DistributedCluster_ClusterStatistics_FullMethodName                   = "/gateway.DistributedCluster/ClusterStatistics"
	DistributedCluster_ClearClusterStatistics_FullMethodName              = "/gateway.DistributedCluster/ClearClusterStatistics"
)

// DistributedClusterClient is the client API for DistributedCluster service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// gRPC service provided by the Cluster Gateway and "used" by the Dashboard
// (i.e., the Cluster Gateway is the server while the Dashboard is the client).
type DistributedClusterClient interface {
	// Used for debugging/testing. Causes a Panic.
	InducePanic(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error)
	// ClusterAge returns the age of the DistributedCluster as a UnixMilliseconds timestamp.
	ClusterAge(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterAgeResponse, error)
	// Used to test notifications.
	SpoofNotifications(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error)
	// Used to test connectivity.
	Ping(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Pong, error)
	// Used to test connectivity with kernels.
	PingKernel(ctx context.Context, in *PingInstruction, opts ...grpc.CallOption) (*Pong, error)
	// IsKernelTraining is used to query whether or not a particular kernel is actively training.
	IsKernelActivelyTraining(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*IsKernelTrainingReply, error)
	// IsKernelActivelyMigrating is used to query whether or not a particular kernel is actively being migrated.
	IsKernelActivelyMigrating(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*IsKernelMigratingReply, error)
	// IsKernelActivelyMigrating is used to query whether or not a particular kernel is actively being migrated
	// or if it is actively training.
	IsKernelActivelyTrainingOrMigrating(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*IsKernelTrainingOrMigratingReply, error)
	// Return a list of all of the current kernel IDs.
	ListKernels(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ListKernelsResponse, error)
	// Set the maximum number of vGPU resources available on a particular node (identified by the local daemon).
	SetTotalVirtualGPUs(ctx context.Context, in *SetVirtualGPUsRequest, opts ...grpc.CallOption) (*VirtualGpuInfo, error)
	// Return the current GPU resource metrics on the node.
	GetClusterActualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterActualGpuInfo, error)
	// GetJupyterMessage enables frontend clients to request a Jupyter message via gRPC in situations where
	// the ZMQ message appears to have been delayed or dropped or otherwise lost in transit to the client.
	GetJupyterMessage(ctx context.Context, in *GetJupyterMessageRequest, opts ...grpc.CallOption) (*GetJupyterMessageResponse, error)
	// Return the current vGPU (or "deflated GPU") resource metrics on the node.
	GetClusterVirtualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterVirtualGpuInfo, error)
	// MigrateKernelReplica selects a qualified host and adds a kernel replica to the replica set.
	// Unlike StartKernelReplica, a new replica is added to the replica set and a training task may
	// need to start immediately after replica started, e.g., preempting a training task.
	//
	// The function will simply remove the replica from the kernel without stopping it.
	// The caller should stop the replica after confirmed that the new replica is ready.
	MigrateKernelReplica(ctx context.Context, in *MigrationRequest, opts ...grpc.CallOption) (*MigrateKernelResponse, error)
	// Ensure that the next 'execute_request' for the specified kernel fails.
	// This is to be used exclusively for testing/debugging purposes.
	FailNextExecution(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error)
	// RegisterDashboard is called by the Cluster Dashboard backend server to both verify that a connection has been
	// established and to obtain any important configuration information, such as the deployment mode (i.e., Docker or
	// Kubernetes), from the Cluster Gateway.
	RegisterDashboard(ctx context.Context, in *Void, opts ...grpc.CallOption) (*DashboardRegistrationResponse, error)
	// GetVirtualDockerNodes returns a (pointer to a) GetVirtualDockerNodesResponse struct describing the virtual,
	// simulated nodes currently provisioned within the cluster.
	//
	// When deployed in Docker Swarm mode, our cluster has both "actual" nodes, which correspond to the nodes that
	// Docker Swarm knows about, and virtual nodes that correspond to each local daemon container.
	//
	// In a "real" deployment, there would be one local daemon per Docker Swarm node. But for development and debugging,
	// we may provision many local daemons per Docker Swarm node, where each local daemon manages its own virtual node.
	//
	// If the Cluster is not running in Docker mode, then this will return an error.
	GetVirtualDockerNodes(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GetVirtualDockerNodesResponse, error)
	// GetDockerSwarmNodes returns a (pointer to a) GetDockerSwarmNodesResponse struct describing the Docker Swarm
	// nodes that exist within the Docker Swarm cluster.
	//
	// When deployed in Docker Swarm mode, our cluster has both "actual" nodes, which correspond to the nodes that
	// Docker Swarm knows about, and virtual nodes that correspond to each local daemon container.
	//
	// In a "real" deployment, there would be one local daemon per Docker Swarm node. But for development and debugging,
	// we may provision many local daemons per Docker Swarm node, where each local daemon manages its own virtual node.
	//
	// If the Cluster is not running in Docker mode, then this will return an error.
	GetDockerSwarmNodes(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GetDockerSwarmNodesResponse, error)
	// GetNumNodes returns the number of nodes in the cluster.
	GetNumNodes(ctx context.Context, in *Void, opts ...grpc.CallOption) (*NumNodesResponse, error)
	// SetNumClusterNodes is used to scale the number of nodes in the cluster to a specifically value.
	// This function accepts a SetNumClusterNodesRequest struct, which encodes the target number of nodes.
	SetNumClusterNodes(ctx context.Context, in *SetNumClusterNodesRequest, opts ...grpc.CallOption) (*SetNumClusterNodesResponse, error)
	// AddClusterNodes provisions a parameterized number of additional nodes within the cluster.
	// This function accepts a AddClusterNodesRequest struct, which encodes the number of nodes to add.
	AddClusterNodes(ctx context.Context, in *AddClusterNodesRequest, opts ...grpc.CallOption) (*AddClusterNodesResponse, error)
	// RemoveClusterNodes removes the specified nodes from the Docker cluster.
	// This function accepts a RemoveSpecificClusterNodesRequest struct, which encodes the IDs of the nodes to remove.
	RemoveSpecificClusterNodes(ctx context.Context, in *RemoveSpecificClusterNodesRequest, opts ...grpc.CallOption) (*RemoveSpecificClusterNodesResponse, error)
	// RemoveClusterNodes removes the specified number of existing nodes from the Docker cluster.
	// This function accepts a RemoveClusterNodesRequest struct, which encodes the number of nodes to remove.
	RemoveClusterNodes(ctx context.Context, in *RemoveClusterNodesRequest, opts ...grpc.CallOption) (*RemoveClusterNodesResponse, error)
	// ModifyClusterNodes enables the modification of one or more nodes within the cluster.
	// Modifications include altering the number of GPUs available on the nodes.
	ModifyClusterNodes(ctx context.Context, in *ModifyClusterNodesRequest, opts ...grpc.CallOption) (*ModifyClusterNodesResponse, error)
	// GetLocalDaemonNodeIDs returns a string slice containing the host IDs of each local daemon.
	GetLocalDaemonNodeIDs(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GetLocalDaemonNodeIDsResponse, error)
	// QueryMessage is used to query whether a given ZMQ message has been seen by any of the Cluster components
	// and what the status of that message is (i.e., sent, response received, etc.)
	QueryMessage(ctx context.Context, in *QueryMessageRequest, opts ...grpc.CallOption) (*QueryMessageResponse, error)
	// ForceLocalDaemonToReconnect is used to tell a Local Daemon to reconnect to the Cluster Gateway.
	// This is mostly used for testing/debugging the reconnection process.
	ForceLocalDaemonToReconnect(ctx context.Context, in *ForceLocalDaemonToReconnectRequest, opts ...grpc.CallOption) (*Void, error)
	// ClusterStatistics is used to request a serialized ClusterStatistics struct.
	ClusterStatistics(ctx context.Context, in *ClusterStatisticsRequest, opts ...grpc.CallOption) (*ClusterStatisticsResponse, error)
	// ClearClusterStatistics clears the current ClusterStatistics struct.
	//
	// ClearClusterStatistics returns the serialized ClusterStatistics struct before it was cleared.
	ClearClusterStatistics(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterStatisticsResponse, error)
}

type distributedClusterClient struct {
	cc grpc.ClientConnInterface
}

func NewDistributedClusterClient(cc grpc.ClientConnInterface) DistributedClusterClient {
	return &distributedClusterClient{cc}
}

func (c *distributedClusterClient) InducePanic(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, DistributedCluster_InducePanic_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) ClusterAge(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterAgeResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClusterAgeResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_ClusterAge_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) SpoofNotifications(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, DistributedCluster_SpoofNotifications_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) Ping(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Pong, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Pong)
	err := c.cc.Invoke(ctx, DistributedCluster_Ping_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) PingKernel(ctx context.Context, in *PingInstruction, opts ...grpc.CallOption) (*Pong, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Pong)
	err := c.cc.Invoke(ctx, DistributedCluster_PingKernel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) IsKernelActivelyTraining(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*IsKernelTrainingReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IsKernelTrainingReply)
	err := c.cc.Invoke(ctx, DistributedCluster_IsKernelActivelyTraining_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) IsKernelActivelyMigrating(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*IsKernelMigratingReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IsKernelMigratingReply)
	err := c.cc.Invoke(ctx, DistributedCluster_IsKernelActivelyMigrating_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) IsKernelActivelyTrainingOrMigrating(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*IsKernelTrainingOrMigratingReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IsKernelTrainingOrMigratingReply)
	err := c.cc.Invoke(ctx, DistributedCluster_IsKernelActivelyTrainingOrMigrating_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) ListKernels(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ListKernelsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListKernelsResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_ListKernels_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) SetTotalVirtualGPUs(ctx context.Context, in *SetVirtualGPUsRequest, opts ...grpc.CallOption) (*VirtualGpuInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(VirtualGpuInfo)
	err := c.cc.Invoke(ctx, DistributedCluster_SetTotalVirtualGPUs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) GetClusterActualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterActualGpuInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClusterActualGpuInfo)
	err := c.cc.Invoke(ctx, DistributedCluster_GetClusterActualGpuInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) GetJupyterMessage(ctx context.Context, in *GetJupyterMessageRequest, opts ...grpc.CallOption) (*GetJupyterMessageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetJupyterMessageResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_GetJupyterMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) GetClusterVirtualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterVirtualGpuInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClusterVirtualGpuInfo)
	err := c.cc.Invoke(ctx, DistributedCluster_GetClusterVirtualGpuInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) MigrateKernelReplica(ctx context.Context, in *MigrationRequest, opts ...grpc.CallOption) (*MigrateKernelResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MigrateKernelResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_MigrateKernelReplica_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) FailNextExecution(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, DistributedCluster_FailNextExecution_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) RegisterDashboard(ctx context.Context, in *Void, opts ...grpc.CallOption) (*DashboardRegistrationResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DashboardRegistrationResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_RegisterDashboard_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) GetVirtualDockerNodes(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GetVirtualDockerNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetVirtualDockerNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_GetVirtualDockerNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) GetDockerSwarmNodes(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GetDockerSwarmNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetDockerSwarmNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_GetDockerSwarmNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) GetNumNodes(ctx context.Context, in *Void, opts ...grpc.CallOption) (*NumNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NumNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_GetNumNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) SetNumClusterNodes(ctx context.Context, in *SetNumClusterNodesRequest, opts ...grpc.CallOption) (*SetNumClusterNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetNumClusterNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_SetNumClusterNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) AddClusterNodes(ctx context.Context, in *AddClusterNodesRequest, opts ...grpc.CallOption) (*AddClusterNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AddClusterNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_AddClusterNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) RemoveSpecificClusterNodes(ctx context.Context, in *RemoveSpecificClusterNodesRequest, opts ...grpc.CallOption) (*RemoveSpecificClusterNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RemoveSpecificClusterNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_RemoveSpecificClusterNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) RemoveClusterNodes(ctx context.Context, in *RemoveClusterNodesRequest, opts ...grpc.CallOption) (*RemoveClusterNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RemoveClusterNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_RemoveClusterNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) ModifyClusterNodes(ctx context.Context, in *ModifyClusterNodesRequest, opts ...grpc.CallOption) (*ModifyClusterNodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ModifyClusterNodesResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_ModifyClusterNodes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) GetLocalDaemonNodeIDs(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GetLocalDaemonNodeIDsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetLocalDaemonNodeIDsResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_GetLocalDaemonNodeIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) QueryMessage(ctx context.Context, in *QueryMessageRequest, opts ...grpc.CallOption) (*QueryMessageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(QueryMessageResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_QueryMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) ForceLocalDaemonToReconnect(ctx context.Context, in *ForceLocalDaemonToReconnectRequest, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, DistributedCluster_ForceLocalDaemonToReconnect_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) ClusterStatistics(ctx context.Context, in *ClusterStatisticsRequest, opts ...grpc.CallOption) (*ClusterStatisticsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClusterStatisticsResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_ClusterStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distributedClusterClient) ClearClusterStatistics(ctx context.Context, in *Void, opts ...grpc.CallOption) (*ClusterStatisticsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClusterStatisticsResponse)
	err := c.cc.Invoke(ctx, DistributedCluster_ClearClusterStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DistributedClusterServer is the server API for DistributedCluster service.
// All implementations must embed UnimplementedDistributedClusterServer
// for forward compatibility.
//
// gRPC service provided by the Cluster Gateway and "used" by the Dashboard
// (i.e., the Cluster Gateway is the server while the Dashboard is the client).
type DistributedClusterServer interface {
	// Used for debugging/testing. Causes a Panic.
	InducePanic(context.Context, *Void) (*Void, error)
	// ClusterAge returns the age of the DistributedCluster as a UnixMilliseconds timestamp.
	ClusterAge(context.Context, *Void) (*ClusterAgeResponse, error)
	// Used to test notifications.
	SpoofNotifications(context.Context, *Void) (*Void, error)
	// Used to test connectivity.
	Ping(context.Context, *Void) (*Pong, error)
	// Used to test connectivity with kernels.
	PingKernel(context.Context, *PingInstruction) (*Pong, error)
	// IsKernelTraining is used to query whether or not a particular kernel is actively training.
	IsKernelActivelyTraining(context.Context, *KernelId) (*IsKernelTrainingReply, error)
	// IsKernelActivelyMigrating is used to query whether or not a particular kernel is actively being migrated.
	IsKernelActivelyMigrating(context.Context, *KernelId) (*IsKernelMigratingReply, error)
	// IsKernelActivelyMigrating is used to query whether or not a particular kernel is actively being migrated
	// or if it is actively training.
	IsKernelActivelyTrainingOrMigrating(context.Context, *KernelId) (*IsKernelTrainingOrMigratingReply, error)
	// Return a list of all of the current kernel IDs.
	ListKernels(context.Context, *Void) (*ListKernelsResponse, error)
	// Set the maximum number of vGPU resources available on a particular node (identified by the local daemon).
	SetTotalVirtualGPUs(context.Context, *SetVirtualGPUsRequest) (*VirtualGpuInfo, error)
	// Return the current GPU resource metrics on the node.
	GetClusterActualGpuInfo(context.Context, *Void) (*ClusterActualGpuInfo, error)
	// GetJupyterMessage enables frontend clients to request a Jupyter message via gRPC in situations where
	// the ZMQ message appears to have been delayed or dropped or otherwise lost in transit to the client.
	GetJupyterMessage(context.Context, *GetJupyterMessageRequest) (*GetJupyterMessageResponse, error)
	// Return the current vGPU (or "deflated GPU") resource metrics on the node.
	GetClusterVirtualGpuInfo(context.Context, *Void) (*ClusterVirtualGpuInfo, error)
	// MigrateKernelReplica selects a qualified host and adds a kernel replica to the replica set.
	// Unlike StartKernelReplica, a new replica is added to the replica set and a training task may
	// need to start immediately after replica started, e.g., preempting a training task.
	//
	// The function will simply remove the replica from the kernel without stopping it.
	// The caller should stop the replica after confirmed that the new replica is ready.
	MigrateKernelReplica(context.Context, *MigrationRequest) (*MigrateKernelResponse, error)
	// Ensure that the next 'execute_request' for the specified kernel fails.
	// This is to be used exclusively for testing/debugging purposes.
	FailNextExecution(context.Context, *KernelId) (*Void, error)
	// RegisterDashboard is called by the Cluster Dashboard backend server to both verify that a connection has been
	// established and to obtain any important configuration information, such as the deployment mode (i.e., Docker or
	// Kubernetes), from the Cluster Gateway.
	RegisterDashboard(context.Context, *Void) (*DashboardRegistrationResponse, error)
	// GetVirtualDockerNodes returns a (pointer to a) GetVirtualDockerNodesResponse struct describing the virtual,
	// simulated nodes currently provisioned within the cluster.
	//
	// When deployed in Docker Swarm mode, our cluster has both "actual" nodes, which correspond to the nodes that
	// Docker Swarm knows about, and virtual nodes that correspond to each local daemon container.
	//
	// In a "real" deployment, there would be one local daemon per Docker Swarm node. But for development and debugging,
	// we may provision many local daemons per Docker Swarm node, where each local daemon manages its own virtual node.
	//
	// If the Cluster is not running in Docker mode, then this will return an error.
	GetVirtualDockerNodes(context.Context, *Void) (*GetVirtualDockerNodesResponse, error)
	// GetDockerSwarmNodes returns a (pointer to a) GetDockerSwarmNodesResponse struct describing the Docker Swarm
	// nodes that exist within the Docker Swarm cluster.
	//
	// When deployed in Docker Swarm mode, our cluster has both "actual" nodes, which correspond to the nodes that
	// Docker Swarm knows about, and virtual nodes that correspond to each local daemon container.
	//
	// In a "real" deployment, there would be one local daemon per Docker Swarm node. But for development and debugging,
	// we may provision many local daemons per Docker Swarm node, where each local daemon manages its own virtual node.
	//
	// If the Cluster is not running in Docker mode, then this will return an error.
	GetDockerSwarmNodes(context.Context, *Void) (*GetDockerSwarmNodesResponse, error)
	// GetNumNodes returns the number of nodes in the cluster.
	GetNumNodes(context.Context, *Void) (*NumNodesResponse, error)
	// SetNumClusterNodes is used to scale the number of nodes in the cluster to a specifically value.
	// This function accepts a SetNumClusterNodesRequest struct, which encodes the target number of nodes.
	SetNumClusterNodes(context.Context, *SetNumClusterNodesRequest) (*SetNumClusterNodesResponse, error)
	// AddClusterNodes provisions a parameterized number of additional nodes within the cluster.
	// This function accepts a AddClusterNodesRequest struct, which encodes the number of nodes to add.
	AddClusterNodes(context.Context, *AddClusterNodesRequest) (*AddClusterNodesResponse, error)
	// RemoveClusterNodes removes the specified nodes from the Docker cluster.
	// This function accepts a RemoveSpecificClusterNodesRequest struct, which encodes the IDs of the nodes to remove.
	RemoveSpecificClusterNodes(context.Context, *RemoveSpecificClusterNodesRequest) (*RemoveSpecificClusterNodesResponse, error)
	// RemoveClusterNodes removes the specified number of existing nodes from the Docker cluster.
	// This function accepts a RemoveClusterNodesRequest struct, which encodes the number of nodes to remove.
	RemoveClusterNodes(context.Context, *RemoveClusterNodesRequest) (*RemoveClusterNodesResponse, error)
	// ModifyClusterNodes enables the modification of one or more nodes within the cluster.
	// Modifications include altering the number of GPUs available on the nodes.
	ModifyClusterNodes(context.Context, *ModifyClusterNodesRequest) (*ModifyClusterNodesResponse, error)
	// GetLocalDaemonNodeIDs returns a string slice containing the host IDs of each local daemon.
	GetLocalDaemonNodeIDs(context.Context, *Void) (*GetLocalDaemonNodeIDsResponse, error)
	// QueryMessage is used to query whether a given ZMQ message has been seen by any of the Cluster components
	// and what the status of that message is (i.e., sent, response received, etc.)
	QueryMessage(context.Context, *QueryMessageRequest) (*QueryMessageResponse, error)
	// ForceLocalDaemonToReconnect is used to tell a Local Daemon to reconnect to the Cluster Gateway.
	// This is mostly used for testing/debugging the reconnection process.
	ForceLocalDaemonToReconnect(context.Context, *ForceLocalDaemonToReconnectRequest) (*Void, error)
	// ClusterStatistics is used to request a serialized ClusterStatistics struct.
	ClusterStatistics(context.Context, *ClusterStatisticsRequest) (*ClusterStatisticsResponse, error)
	// ClearClusterStatistics clears the current ClusterStatistics struct.
	//
	// ClearClusterStatistics returns the serialized ClusterStatistics struct before it was cleared.
	ClearClusterStatistics(context.Context, *Void) (*ClusterStatisticsResponse, error)
	mustEmbedUnimplementedDistributedClusterServer()
}

// UnimplementedDistributedClusterServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedDistributedClusterServer struct{}

func (UnimplementedDistributedClusterServer) InducePanic(context.Context, *Void) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InducePanic not implemented")
}
func (UnimplementedDistributedClusterServer) ClusterAge(context.Context, *Void) (*ClusterAgeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClusterAge not implemented")
}
func (UnimplementedDistributedClusterServer) SpoofNotifications(context.Context, *Void) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SpoofNotifications not implemented")
}
func (UnimplementedDistributedClusterServer) Ping(context.Context, *Void) (*Pong, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Ping not implemented")
}
func (UnimplementedDistributedClusterServer) PingKernel(context.Context, *PingInstruction) (*Pong, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PingKernel not implemented")
}
func (UnimplementedDistributedClusterServer) IsKernelActivelyTraining(context.Context, *KernelId) (*IsKernelTrainingReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsKernelActivelyTraining not implemented")
}
func (UnimplementedDistributedClusterServer) IsKernelActivelyMigrating(context.Context, *KernelId) (*IsKernelMigratingReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsKernelActivelyMigrating not implemented")
}
func (UnimplementedDistributedClusterServer) IsKernelActivelyTrainingOrMigrating(context.Context, *KernelId) (*IsKernelTrainingOrMigratingReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsKernelActivelyTrainingOrMigrating not implemented")
}
func (UnimplementedDistributedClusterServer) ListKernels(context.Context, *Void) (*ListKernelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKernels not implemented")
}
func (UnimplementedDistributedClusterServer) SetTotalVirtualGPUs(context.Context, *SetVirtualGPUsRequest) (*VirtualGpuInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTotalVirtualGPUs not implemented")
}
func (UnimplementedDistributedClusterServer) GetClusterActualGpuInfo(context.Context, *Void) (*ClusterActualGpuInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterActualGpuInfo not implemented")
}
func (UnimplementedDistributedClusterServer) GetJupyterMessage(context.Context, *GetJupyterMessageRequest) (*GetJupyterMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJupyterMessage not implemented")
}
func (UnimplementedDistributedClusterServer) GetClusterVirtualGpuInfo(context.Context, *Void) (*ClusterVirtualGpuInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterVirtualGpuInfo not implemented")
}
func (UnimplementedDistributedClusterServer) MigrateKernelReplica(context.Context, *MigrationRequest) (*MigrateKernelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MigrateKernelReplica not implemented")
}
func (UnimplementedDistributedClusterServer) FailNextExecution(context.Context, *KernelId) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FailNextExecution not implemented")
}
func (UnimplementedDistributedClusterServer) RegisterDashboard(context.Context, *Void) (*DashboardRegistrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterDashboard not implemented")
}
func (UnimplementedDistributedClusterServer) GetVirtualDockerNodes(context.Context, *Void) (*GetVirtualDockerNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVirtualDockerNodes not implemented")
}
func (UnimplementedDistributedClusterServer) GetDockerSwarmNodes(context.Context, *Void) (*GetDockerSwarmNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDockerSwarmNodes not implemented")
}
func (UnimplementedDistributedClusterServer) GetNumNodes(context.Context, *Void) (*NumNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNumNodes not implemented")
}
func (UnimplementedDistributedClusterServer) SetNumClusterNodes(context.Context, *SetNumClusterNodesRequest) (*SetNumClusterNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNumClusterNodes not implemented")
}
func (UnimplementedDistributedClusterServer) AddClusterNodes(context.Context, *AddClusterNodesRequest) (*AddClusterNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddClusterNodes not implemented")
}
func (UnimplementedDistributedClusterServer) RemoveSpecificClusterNodes(context.Context, *RemoveSpecificClusterNodesRequest) (*RemoveSpecificClusterNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveSpecificClusterNodes not implemented")
}
func (UnimplementedDistributedClusterServer) RemoveClusterNodes(context.Context, *RemoveClusterNodesRequest) (*RemoveClusterNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveClusterNodes not implemented")
}
func (UnimplementedDistributedClusterServer) ModifyClusterNodes(context.Context, *ModifyClusterNodesRequest) (*ModifyClusterNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyClusterNodes not implemented")
}
func (UnimplementedDistributedClusterServer) GetLocalDaemonNodeIDs(context.Context, *Void) (*GetLocalDaemonNodeIDsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLocalDaemonNodeIDs not implemented")
}
func (UnimplementedDistributedClusterServer) QueryMessage(context.Context, *QueryMessageRequest) (*QueryMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryMessage not implemented")
}
func (UnimplementedDistributedClusterServer) ForceLocalDaemonToReconnect(context.Context, *ForceLocalDaemonToReconnectRequest) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceLocalDaemonToReconnect not implemented")
}
func (UnimplementedDistributedClusterServer) ClusterStatistics(context.Context, *ClusterStatisticsRequest) (*ClusterStatisticsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClusterStatistics not implemented")
}
func (UnimplementedDistributedClusterServer) ClearClusterStatistics(context.Context, *Void) (*ClusterStatisticsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearClusterStatistics not implemented")
}
func (UnimplementedDistributedClusterServer) mustEmbedUnimplementedDistributedClusterServer() {}
func (UnimplementedDistributedClusterServer) testEmbeddedByValue()                            {}

// UnsafeDistributedClusterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DistributedClusterServer will
// result in compilation errors.
type UnsafeDistributedClusterServer interface {
	mustEmbedUnimplementedDistributedClusterServer()
}

func RegisterDistributedClusterServer(s grpc.ServiceRegistrar, srv DistributedClusterServer) {
	// If the following call pancis, it indicates UnimplementedDistributedClusterServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&DistributedCluster_ServiceDesc, srv)
}

func _DistributedCluster_InducePanic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).InducePanic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_InducePanic_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).InducePanic(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_ClusterAge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).ClusterAge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_ClusterAge_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).ClusterAge(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_SpoofNotifications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).SpoofNotifications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_SpoofNotifications_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).SpoofNotifications(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_Ping_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).Ping(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_PingKernel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PingInstruction)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).PingKernel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_PingKernel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).PingKernel(ctx, req.(*PingInstruction))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_IsKernelActivelyTraining_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).IsKernelActivelyTraining(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_IsKernelActivelyTraining_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).IsKernelActivelyTraining(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_IsKernelActivelyMigrating_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).IsKernelActivelyMigrating(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_IsKernelActivelyMigrating_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).IsKernelActivelyMigrating(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_IsKernelActivelyTrainingOrMigrating_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).IsKernelActivelyTrainingOrMigrating(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_IsKernelActivelyTrainingOrMigrating_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).IsKernelActivelyTrainingOrMigrating(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_ListKernels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).ListKernels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_ListKernels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).ListKernels(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_SetTotalVirtualGPUs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetVirtualGPUsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).SetTotalVirtualGPUs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_SetTotalVirtualGPUs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).SetTotalVirtualGPUs(ctx, req.(*SetVirtualGPUsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_GetClusterActualGpuInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).GetClusterActualGpuInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_GetClusterActualGpuInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).GetClusterActualGpuInfo(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_GetJupyterMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJupyterMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).GetJupyterMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_GetJupyterMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).GetJupyterMessage(ctx, req.(*GetJupyterMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_GetClusterVirtualGpuInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).GetClusterVirtualGpuInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_GetClusterVirtualGpuInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).GetClusterVirtualGpuInfo(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_MigrateKernelReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).MigrateKernelReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_MigrateKernelReplica_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).MigrateKernelReplica(ctx, req.(*MigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_FailNextExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).FailNextExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_FailNextExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).FailNextExecution(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_RegisterDashboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).RegisterDashboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_RegisterDashboard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).RegisterDashboard(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_GetVirtualDockerNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).GetVirtualDockerNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_GetVirtualDockerNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).GetVirtualDockerNodes(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_GetDockerSwarmNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).GetDockerSwarmNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_GetDockerSwarmNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).GetDockerSwarmNodes(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_GetNumNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).GetNumNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_GetNumNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).GetNumNodes(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_SetNumClusterNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNumClusterNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).SetNumClusterNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_SetNumClusterNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).SetNumClusterNodes(ctx, req.(*SetNumClusterNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_AddClusterNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).AddClusterNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_AddClusterNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).AddClusterNodes(ctx, req.(*AddClusterNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_RemoveSpecificClusterNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveSpecificClusterNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).RemoveSpecificClusterNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_RemoveSpecificClusterNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).RemoveSpecificClusterNodes(ctx, req.(*RemoveSpecificClusterNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_RemoveClusterNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveClusterNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).RemoveClusterNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_RemoveClusterNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).RemoveClusterNodes(ctx, req.(*RemoveClusterNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_ModifyClusterNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyClusterNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).ModifyClusterNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_ModifyClusterNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).ModifyClusterNodes(ctx, req.(*ModifyClusterNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_GetLocalDaemonNodeIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).GetLocalDaemonNodeIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_GetLocalDaemonNodeIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).GetLocalDaemonNodeIDs(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_QueryMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).QueryMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_QueryMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).QueryMessage(ctx, req.(*QueryMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_ForceLocalDaemonToReconnect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForceLocalDaemonToReconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).ForceLocalDaemonToReconnect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_ForceLocalDaemonToReconnect_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).ForceLocalDaemonToReconnect(ctx, req.(*ForceLocalDaemonToReconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_ClusterStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClusterStatisticsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).ClusterStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_ClusterStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).ClusterStatistics(ctx, req.(*ClusterStatisticsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistributedCluster_ClearClusterStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistributedClusterServer).ClearClusterStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DistributedCluster_ClearClusterStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistributedClusterServer).ClearClusterStatistics(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

// DistributedCluster_ServiceDesc is the grpc.ServiceDesc for DistributedCluster service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DistributedCluster_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gateway.DistributedCluster",
	HandlerType: (*DistributedClusterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InducePanic",
			Handler:    _DistributedCluster_InducePanic_Handler,
		},
		{
			MethodName: "ClusterAge",
			Handler:    _DistributedCluster_ClusterAge_Handler,
		},
		{
			MethodName: "SpoofNotifications",
			Handler:    _DistributedCluster_SpoofNotifications_Handler,
		},
		{
			MethodName: "Ping",
			Handler:    _DistributedCluster_Ping_Handler,
		},
		{
			MethodName: "PingKernel",
			Handler:    _DistributedCluster_PingKernel_Handler,
		},
		{
			MethodName: "IsKernelActivelyTraining",
			Handler:    _DistributedCluster_IsKernelActivelyTraining_Handler,
		},
		{
			MethodName: "IsKernelActivelyMigrating",
			Handler:    _DistributedCluster_IsKernelActivelyMigrating_Handler,
		},
		{
			MethodName: "IsKernelActivelyTrainingOrMigrating",
			Handler:    _DistributedCluster_IsKernelActivelyTrainingOrMigrating_Handler,
		},
		{
			MethodName: "ListKernels",
			Handler:    _DistributedCluster_ListKernels_Handler,
		},
		{
			MethodName: "SetTotalVirtualGPUs",
			Handler:    _DistributedCluster_SetTotalVirtualGPUs_Handler,
		},
		{
			MethodName: "GetClusterActualGpuInfo",
			Handler:    _DistributedCluster_GetClusterActualGpuInfo_Handler,
		},
		{
			MethodName: "GetJupyterMessage",
			Handler:    _DistributedCluster_GetJupyterMessage_Handler,
		},
		{
			MethodName: "GetClusterVirtualGpuInfo",
			Handler:    _DistributedCluster_GetClusterVirtualGpuInfo_Handler,
		},
		{
			MethodName: "MigrateKernelReplica",
			Handler:    _DistributedCluster_MigrateKernelReplica_Handler,
		},
		{
			MethodName: "FailNextExecution",
			Handler:    _DistributedCluster_FailNextExecution_Handler,
		},
		{
			MethodName: "RegisterDashboard",
			Handler:    _DistributedCluster_RegisterDashboard_Handler,
		},
		{
			MethodName: "GetVirtualDockerNodes",
			Handler:    _DistributedCluster_GetVirtualDockerNodes_Handler,
		},
		{
			MethodName: "GetDockerSwarmNodes",
			Handler:    _DistributedCluster_GetDockerSwarmNodes_Handler,
		},
		{
			MethodName: "GetNumNodes",
			Handler:    _DistributedCluster_GetNumNodes_Handler,
		},
		{
			MethodName: "SetNumClusterNodes",
			Handler:    _DistributedCluster_SetNumClusterNodes_Handler,
		},
		{
			MethodName: "AddClusterNodes",
			Handler:    _DistributedCluster_AddClusterNodes_Handler,
		},
		{
			MethodName: "RemoveSpecificClusterNodes",
			Handler:    _DistributedCluster_RemoveSpecificClusterNodes_Handler,
		},
		{
			MethodName: "RemoveClusterNodes",
			Handler:    _DistributedCluster_RemoveClusterNodes_Handler,
		},
		{
			MethodName: "ModifyClusterNodes",
			Handler:    _DistributedCluster_ModifyClusterNodes_Handler,
		},
		{
			MethodName: "GetLocalDaemonNodeIDs",
			Handler:    _DistributedCluster_GetLocalDaemonNodeIDs_Handler,
		},
		{
			MethodName: "QueryMessage",
			Handler:    _DistributedCluster_QueryMessage_Handler,
		},
		{
			MethodName: "ForceLocalDaemonToReconnect",
			Handler:    _DistributedCluster_ForceLocalDaemonToReconnect_Handler,
		},
		{
			MethodName: "ClusterStatistics",
			Handler:    _DistributedCluster_ClusterStatistics_Handler,
		},
		{
			MethodName: "ClearClusterStatistics",
			Handler:    _DistributedCluster_ClearClusterStatistics_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "internal/server/api/proto/gateway.proto",
}

const (
	ClusterDashboard_SendNotification_FullMethodName = "/gateway.ClusterDashboard/SendNotification"
)

// ClusterDashboardClient is the client API for ClusterDashboard service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// gRPC service provided by the Dashboard and "used" by the Cluster Gateway
// (i.e., the Dashboard is the server while the Cluster Gateway is the client).
type ClusterDashboardClient interface {
	SendNotification(ctx context.Context, in *Notification, opts ...grpc.CallOption) (*Void, error)
}

type clusterDashboardClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterDashboardClient(cc grpc.ClientConnInterface) ClusterDashboardClient {
	return &clusterDashboardClient{cc}
}

func (c *clusterDashboardClient) SendNotification(ctx context.Context, in *Notification, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, ClusterDashboard_SendNotification_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterDashboardServer is the server API for ClusterDashboard service.
// All implementations must embed UnimplementedClusterDashboardServer
// for forward compatibility.
//
// gRPC service provided by the Dashboard and "used" by the Cluster Gateway
// (i.e., the Dashboard is the server while the Cluster Gateway is the client).
type ClusterDashboardServer interface {
	SendNotification(context.Context, *Notification) (*Void, error)
	mustEmbedUnimplementedClusterDashboardServer()
}

// UnimplementedClusterDashboardServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedClusterDashboardServer struct{}

func (UnimplementedClusterDashboardServer) SendNotification(context.Context, *Notification) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendNotification not implemented")
}
func (UnimplementedClusterDashboardServer) mustEmbedUnimplementedClusterDashboardServer() {}
func (UnimplementedClusterDashboardServer) testEmbeddedByValue()                          {}

// UnsafeClusterDashboardServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ClusterDashboardServer will
// result in compilation errors.
type UnsafeClusterDashboardServer interface {
	mustEmbedUnimplementedClusterDashboardServer()
}

func RegisterClusterDashboardServer(s grpc.ServiceRegistrar, srv ClusterDashboardServer) {
	// If the following call pancis, it indicates UnimplementedClusterDashboardServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ClusterDashboard_ServiceDesc, srv)
}

func _ClusterDashboard_SendNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Notification)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterDashboardServer).SendNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterDashboard_SendNotification_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterDashboardServer).SendNotification(ctx, req.(*Notification))
	}
	return interceptor(ctx, in, info, handler)
}

// ClusterDashboard_ServiceDesc is the grpc.ServiceDesc for ClusterDashboard service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ClusterDashboard_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gateway.ClusterDashboard",
	HandlerType: (*ClusterDashboardServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SendNotification",
			Handler:    _ClusterDashboard_SendNotification_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "internal/server/api/proto/gateway.proto",
}

const (
	KernelErrorReporter_Notify_FullMethodName = "/gateway.KernelErrorReporter/Notify"
)

// KernelErrorReporterClient is the client API for KernelErrorReporter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// KernelErrorReporter is a gRPC service provided by Local Daemon nodes.
//
// Kernel replicas running on the same node as the Local Daemon will connect to the KernelErrorReporter service.
// If an error occurs within the kernel, then the kernel can report it to the Local Daemon using the KernelErrorReporter
// gRPC service. The Local Daemon can, in turn, report the error to the Cluster Gateway, so that a notification can
// be submitted to the Cluster Dashboard.
type KernelErrorReporterClient interface {
	// Report that an error occurred within one of the local daemons (or possibly a jupyter kernel).
	Notify(ctx context.Context, in *KernelNotification, opts ...grpc.CallOption) (*Void, error)
}

type kernelErrorReporterClient struct {
	cc grpc.ClientConnInterface
}

func NewKernelErrorReporterClient(cc grpc.ClientConnInterface) KernelErrorReporterClient {
	return &kernelErrorReporterClient{cc}
}

func (c *kernelErrorReporterClient) Notify(ctx context.Context, in *KernelNotification, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, KernelErrorReporter_Notify_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KernelErrorReporterServer is the server API for KernelErrorReporter service.
// All implementations must embed UnimplementedKernelErrorReporterServer
// for forward compatibility.
//
// KernelErrorReporter is a gRPC service provided by Local Daemon nodes.
//
// Kernel replicas running on the same node as the Local Daemon will connect to the KernelErrorReporter service.
// If an error occurs within the kernel, then the kernel can report it to the Local Daemon using the KernelErrorReporter
// gRPC service. The Local Daemon can, in turn, report the error to the Cluster Gateway, so that a notification can
// be submitted to the Cluster Dashboard.
type KernelErrorReporterServer interface {
	// Report that an error occurred within one of the local daemons (or possibly a jupyter kernel).
	Notify(context.Context, *KernelNotification) (*Void, error)
	mustEmbedUnimplementedKernelErrorReporterServer()
}

// UnimplementedKernelErrorReporterServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedKernelErrorReporterServer struct{}

func (UnimplementedKernelErrorReporterServer) Notify(context.Context, *KernelNotification) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Notify not implemented")
}
func (UnimplementedKernelErrorReporterServer) mustEmbedUnimplementedKernelErrorReporterServer() {}
func (UnimplementedKernelErrorReporterServer) testEmbeddedByValue()                             {}

// UnsafeKernelErrorReporterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to KernelErrorReporterServer will
// result in compilation errors.
type UnsafeKernelErrorReporterServer interface {
	mustEmbedUnimplementedKernelErrorReporterServer()
}

func RegisterKernelErrorReporterServer(s grpc.ServiceRegistrar, srv KernelErrorReporterServer) {
	// If the following call pancis, it indicates UnimplementedKernelErrorReporterServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&KernelErrorReporter_ServiceDesc, srv)
}

func _KernelErrorReporter_Notify_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelNotification)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KernelErrorReporterServer).Notify(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KernelErrorReporter_Notify_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KernelErrorReporterServer).Notify(ctx, req.(*KernelNotification))
	}
	return interceptor(ctx, in, info, handler)
}

// KernelErrorReporter_ServiceDesc is the grpc.ServiceDesc for KernelErrorReporter service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var KernelErrorReporter_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gateway.KernelErrorReporter",
	HandlerType: (*KernelErrorReporterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Notify",
			Handler:    _KernelErrorReporter_Notify_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "internal/server/api/proto/gateway.proto",
}

const (
	LocalGateway_SetID_FullMethodName                     = "/gateway.LocalGateway/SetID"
	LocalGateway_StartKernel_FullMethodName               = "/gateway.LocalGateway/StartKernel"
	LocalGateway_StartKernelReplica_FullMethodName        = "/gateway.LocalGateway/StartKernelReplica"
	LocalGateway_PromotePrewarmedContainer_FullMethodName = "/gateway.LocalGateway/PromotePrewarmedContainer"
	LocalGateway_GetKernelStatus_FullMethodName           = "/gateway.LocalGateway/GetKernelStatus"
	LocalGateway_KillKernel_FullMethodName                = "/gateway.LocalGateway/KillKernel"
	LocalGateway_StopKernel_FullMethodName                = "/gateway.LocalGateway/StopKernel"
	LocalGateway_PingKernel_FullMethodName                = "/gateway.LocalGateway/PingKernel"
	LocalGateway_WaitKernel_FullMethodName                = "/gateway.LocalGateway/WaitKernel"
	LocalGateway_SetClose_FullMethodName                  = "/gateway.LocalGateway/SetClose"
	LocalGateway_AddReplica_FullMethodName                = "/gateway.LocalGateway/AddReplica"
	LocalGateway_UpdateReplicaAddr_FullMethodName         = "/gateway.LocalGateway/UpdateReplicaAddr"
	LocalGateway_StartSyncLog_FullMethodName              = "/gateway.LocalGateway/StartSyncLog"
	LocalGateway_PrepareToMigrate_FullMethodName          = "/gateway.LocalGateway/PrepareToMigrate"
	LocalGateway_ResourcesSnapshot_FullMethodName         = "/gateway.LocalGateway/ResourcesSnapshot"
	LocalGateway_GetLocalDaemonInfo_FullMethodName        = "/gateway.LocalGateway/GetLocalDaemonInfo"
	LocalGateway_GetActualGpuInfo_FullMethodName          = "/gateway.LocalGateway/GetActualGpuInfo"
	LocalGateway_GetVirtualGpuInfo_FullMethodName         = "/gateway.LocalGateway/GetVirtualGpuInfo"
	LocalGateway_SetTotalVirtualGPUs_FullMethodName       = "/gateway.LocalGateway/SetTotalVirtualGPUs"
	LocalGateway_GetVirtualGpuAllocations_FullMethodName  = "/gateway.LocalGateway/GetVirtualGpuAllocations"
	LocalGateway_YieldNextExecution_FullMethodName        = "/gateway.LocalGateway/YieldNextExecution"
	LocalGateway_ReconnectToGateway_FullMethodName        = "/gateway.LocalGateway/ReconnectToGateway"
)

// LocalGatewayClient is the client API for LocalGateway service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// The Jupyter gateway service for host local kernels.
type LocalGatewayClient interface {
	// SetID sets the local gateway id and return old id for failure tolerance.
	// This also instructs the Local Daemon associated with the LocalGateway to create a PrometheusManager and begin serving metrics.
	SetID(ctx context.Context, in *HostId, opts ...grpc.CallOption) (*HostId, error)
	// StartKernel starts a kernel or kernel replica.
	StartKernel(ctx context.Context, in *KernelSpec, opts ...grpc.CallOption) (*KernelConnectionInfo, error)
	// StartKernelReplica starts a kernel replica on the local host.
	StartKernelReplica(ctx context.Context, in *KernelReplicaSpec, opts ...grpc.CallOption) (*KernelConnectionInfo, error)
	// PromotePrewarmedContainer is similar to StartKernelReplica, except that PromotePrewarmedContainer launches the new
	// kernel using an existing, pre-warmed container that is already available on this host.
	PromotePrewarmedContainer(ctx context.Context, in *PrewarmedKernelReplicaSpec, opts ...grpc.CallOption) (*KernelConnectionInfo, error)
	// GetKernelStatus returns the status of a kernel.
	GetKernelStatus(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*KernelStatus, error)
	// KillKernel kills a kernel.
	KillKernel(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error)
	// StopKernel stops a kernel gracefully and return immediately.
	StopKernel(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error)
	// Used to test connectivity with kernels.
	PingKernel(ctx context.Context, in *PingInstruction, opts ...grpc.CallOption) (*Pong, error)
	// WaitKernel waits for a kernel to stop and return status.
	WaitKernel(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*KernelStatus, error)
	// SetClose request the gateway to close all kernels and stop.
	SetClose(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error)
	// AddReplica instructs a set of kernel replicas to add a new node to their SMR cluster.
	AddReplica(ctx context.Context, in *ReplicaInfoWithAddr, opts ...grpc.CallOption) (*Void, error)
	// UpdateReplicaAddr instructs a set of kernel replicas to update the peer address of a particular node.
	// This is primarily used during migrations.
	UpdateReplicaAddr(ctx context.Context, in *ReplicaInfoWithAddr, opts ...grpc.CallOption) (*Void, error)
	// StartSyncLog instructs the LocalGateway to send a "start_synclog_request" message to the specified kernel replica.
	StartSyncLog(ctx context.Context, in *ReplicaInfo, opts ...grpc.CallOption) (*Void, error)
	// Used to instruct a specific kernel replica to prepare to be migrated to a new node.
	// This involves writing the contents of the etcd-raft data directory to remote storage so that
	// it can be read back from make build-linux-amd64 by the new replica.
	PrepareToMigrate(ctx context.Context, in *ReplicaInfo, opts ...grpc.CallOption) (*PrepareToMigrateResponse, error)
	// ResourcesSnapshot returns a NodeResourcesSnapshot struct encoding a snapshot of
	// the current resource quantities on the node.
	ResourcesSnapshot(ctx context.Context, in *Void, opts ...grpc.CallOption) (*NodeResourcesSnapshotWithContainers, error)
	// GetLocalDaemonInfo returns key information about the Local Daemon, including its current resource counts,
	// its ID, etc.
	GetLocalDaemonInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*LocalDaemonInfo, error)
	// Return the current GPU resource metrics on the node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	GetActualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GpuInfo, error)
	// Return the current vGPU (or "deflated GPU") resource metrics on the node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	GetVirtualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*VirtualGpuInfo, error)
	// Set the maximum number of vGPU resources available on the node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	SetTotalVirtualGPUs(ctx context.Context, in *SetVirtualGPUsRequest, opts ...grpc.CallOption) (*VirtualGpuInfo, error)
	// Return the current vGPU allocations on this node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	GetVirtualGpuAllocations(ctx context.Context, in *Void, opts ...grpc.CallOption) (*VirtualGpuAllocations, error)
	// Ensure that the next 'execute_request' for the specified kernel fails.
	// This is to be used exclusively for testing/debugging purposes.
	YieldNextExecution(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error)
	// ReconnectToGateway is used to force the Local Daemon to reconnect to the Cluster Gateway.
	//
	// The reconnection procedure is optionally initiated shortly after the ReconnectToGateway gRPC call returns,
	// to avoid causing the ReconnectToGateway to encounter an error.
	ReconnectToGateway(ctx context.Context, in *ReconnectToGatewayRequest, opts ...grpc.CallOption) (*Void, error)
}

type localGatewayClient struct {
	cc grpc.ClientConnInterface
}

func NewLocalGatewayClient(cc grpc.ClientConnInterface) LocalGatewayClient {
	return &localGatewayClient{cc}
}

func (c *localGatewayClient) SetID(ctx context.Context, in *HostId, opts ...grpc.CallOption) (*HostId, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HostId)
	err := c.cc.Invoke(ctx, LocalGateway_SetID_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) StartKernel(ctx context.Context, in *KernelSpec, opts ...grpc.CallOption) (*KernelConnectionInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(KernelConnectionInfo)
	err := c.cc.Invoke(ctx, LocalGateway_StartKernel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) StartKernelReplica(ctx context.Context, in *KernelReplicaSpec, opts ...grpc.CallOption) (*KernelConnectionInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(KernelConnectionInfo)
	err := c.cc.Invoke(ctx, LocalGateway_StartKernelReplica_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) PromotePrewarmedContainer(ctx context.Context, in *PrewarmedKernelReplicaSpec, opts ...grpc.CallOption) (*KernelConnectionInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(KernelConnectionInfo)
	err := c.cc.Invoke(ctx, LocalGateway_PromotePrewarmedContainer_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) GetKernelStatus(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*KernelStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(KernelStatus)
	err := c.cc.Invoke(ctx, LocalGateway_GetKernelStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) KillKernel(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_KillKernel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) StopKernel(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_StopKernel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) PingKernel(ctx context.Context, in *PingInstruction, opts ...grpc.CallOption) (*Pong, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Pong)
	err := c.cc.Invoke(ctx, LocalGateway_PingKernel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) WaitKernel(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*KernelStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(KernelStatus)
	err := c.cc.Invoke(ctx, LocalGateway_WaitKernel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) SetClose(ctx context.Context, in *Void, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_SetClose_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) AddReplica(ctx context.Context, in *ReplicaInfoWithAddr, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_AddReplica_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) UpdateReplicaAddr(ctx context.Context, in *ReplicaInfoWithAddr, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_UpdateReplicaAddr_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) StartSyncLog(ctx context.Context, in *ReplicaInfo, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_StartSyncLog_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) PrepareToMigrate(ctx context.Context, in *ReplicaInfo, opts ...grpc.CallOption) (*PrepareToMigrateResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PrepareToMigrateResponse)
	err := c.cc.Invoke(ctx, LocalGateway_PrepareToMigrate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) ResourcesSnapshot(ctx context.Context, in *Void, opts ...grpc.CallOption) (*NodeResourcesSnapshotWithContainers, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NodeResourcesSnapshotWithContainers)
	err := c.cc.Invoke(ctx, LocalGateway_ResourcesSnapshot_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) GetLocalDaemonInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*LocalDaemonInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LocalDaemonInfo)
	err := c.cc.Invoke(ctx, LocalGateway_GetLocalDaemonInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) GetActualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*GpuInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GpuInfo)
	err := c.cc.Invoke(ctx, LocalGateway_GetActualGpuInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) GetVirtualGpuInfo(ctx context.Context, in *Void, opts ...grpc.CallOption) (*VirtualGpuInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(VirtualGpuInfo)
	err := c.cc.Invoke(ctx, LocalGateway_GetVirtualGpuInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) SetTotalVirtualGPUs(ctx context.Context, in *SetVirtualGPUsRequest, opts ...grpc.CallOption) (*VirtualGpuInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(VirtualGpuInfo)
	err := c.cc.Invoke(ctx, LocalGateway_SetTotalVirtualGPUs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) GetVirtualGpuAllocations(ctx context.Context, in *Void, opts ...grpc.CallOption) (*VirtualGpuAllocations, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(VirtualGpuAllocations)
	err := c.cc.Invoke(ctx, LocalGateway_GetVirtualGpuAllocations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) YieldNextExecution(ctx context.Context, in *KernelId, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_YieldNextExecution_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localGatewayClient) ReconnectToGateway(ctx context.Context, in *ReconnectToGatewayRequest, opts ...grpc.CallOption) (*Void, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Void)
	err := c.cc.Invoke(ctx, LocalGateway_ReconnectToGateway_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LocalGatewayServer is the server API for LocalGateway service.
// All implementations must embed UnimplementedLocalGatewayServer
// for forward compatibility.
//
// The Jupyter gateway service for host local kernels.
type LocalGatewayServer interface {
	// SetID sets the local gateway id and return old id for failure tolerance.
	// This also instructs the Local Daemon associated with the LocalGateway to create a PrometheusManager and begin serving metrics.
	SetID(context.Context, *HostId) (*HostId, error)
	// StartKernel starts a kernel or kernel replica.
	StartKernel(context.Context, *KernelSpec) (*KernelConnectionInfo, error)
	// StartKernelReplica starts a kernel replica on the local host.
	StartKernelReplica(context.Context, *KernelReplicaSpec) (*KernelConnectionInfo, error)
	// PromotePrewarmedContainer is similar to StartKernelReplica, except that PromotePrewarmedContainer launches the new
	// kernel using an existing, pre-warmed container that is already available on this host.
	PromotePrewarmedContainer(context.Context, *PrewarmedKernelReplicaSpec) (*KernelConnectionInfo, error)
	// GetKernelStatus returns the status of a kernel.
	GetKernelStatus(context.Context, *KernelId) (*KernelStatus, error)
	// KillKernel kills a kernel.
	KillKernel(context.Context, *KernelId) (*Void, error)
	// StopKernel stops a kernel gracefully and return immediately.
	StopKernel(context.Context, *KernelId) (*Void, error)
	// Used to test connectivity with kernels.
	PingKernel(context.Context, *PingInstruction) (*Pong, error)
	// WaitKernel waits for a kernel to stop and return status.
	WaitKernel(context.Context, *KernelId) (*KernelStatus, error)
	// SetClose request the gateway to close all kernels and stop.
	SetClose(context.Context, *Void) (*Void, error)
	// AddReplica instructs a set of kernel replicas to add a new node to their SMR cluster.
	AddReplica(context.Context, *ReplicaInfoWithAddr) (*Void, error)
	// UpdateReplicaAddr instructs a set of kernel replicas to update the peer address of a particular node.
	// This is primarily used during migrations.
	UpdateReplicaAddr(context.Context, *ReplicaInfoWithAddr) (*Void, error)
	// StartSyncLog instructs the LocalGateway to send a "start_synclog_request" message to the specified kernel replica.
	StartSyncLog(context.Context, *ReplicaInfo) (*Void, error)
	// Used to instruct a specific kernel replica to prepare to be migrated to a new node.
	// This involves writing the contents of the etcd-raft data directory to remote storage so that
	// it can be read back from make build-linux-amd64 by the new replica.
	PrepareToMigrate(context.Context, *ReplicaInfo) (*PrepareToMigrateResponse, error)
	// ResourcesSnapshot returns a NodeResourcesSnapshot struct encoding a snapshot of
	// the current resource quantities on the node.
	ResourcesSnapshot(context.Context, *Void) (*NodeResourcesSnapshotWithContainers, error)
	// GetLocalDaemonInfo returns key information about the Local Daemon, including its current resource counts,
	// its ID, etc.
	GetLocalDaemonInfo(context.Context, *Void) (*LocalDaemonInfo, error)
	// Return the current GPU resource metrics on the node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	GetActualGpuInfo(context.Context, *Void) (*GpuInfo, error)
	// Return the current vGPU (or "deflated GPU") resource metrics on the node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	GetVirtualGpuInfo(context.Context, *Void) (*VirtualGpuInfo, error)
	// Set the maximum number of vGPU resources available on the node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	SetTotalVirtualGPUs(context.Context, *SetVirtualGPUsRequest) (*VirtualGpuInfo, error)
	// Return the current vGPU allocations on this node.
	// @Deprecated: this should eventually be merged with the updated/unified ModifyClusterNodes API.
	GetVirtualGpuAllocations(context.Context, *Void) (*VirtualGpuAllocations, error)
	// Ensure that the next 'execute_request' for the specified kernel fails.
	// This is to be used exclusively for testing/debugging purposes.
	YieldNextExecution(context.Context, *KernelId) (*Void, error)
	// ReconnectToGateway is used to force the Local Daemon to reconnect to the Cluster Gateway.
	//
	// The reconnection procedure is optionally initiated shortly after the ReconnectToGateway gRPC call returns,
	// to avoid causing the ReconnectToGateway to encounter an error.
	ReconnectToGateway(context.Context, *ReconnectToGatewayRequest) (*Void, error)
	mustEmbedUnimplementedLocalGatewayServer()
}

// UnimplementedLocalGatewayServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedLocalGatewayServer struct{}

func (UnimplementedLocalGatewayServer) SetID(context.Context, *HostId) (*HostId, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetID not implemented")
}
func (UnimplementedLocalGatewayServer) StartKernel(context.Context, *KernelSpec) (*KernelConnectionInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartKernel not implemented")
}
func (UnimplementedLocalGatewayServer) StartKernelReplica(context.Context, *KernelReplicaSpec) (*KernelConnectionInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartKernelReplica not implemented")
}
func (UnimplementedLocalGatewayServer) PromotePrewarmedContainer(context.Context, *PrewarmedKernelReplicaSpec) (*KernelConnectionInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromotePrewarmedContainer not implemented")
}
func (UnimplementedLocalGatewayServer) GetKernelStatus(context.Context, *KernelId) (*KernelStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKernelStatus not implemented")
}
func (UnimplementedLocalGatewayServer) KillKernel(context.Context, *KernelId) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method KillKernel not implemented")
}
func (UnimplementedLocalGatewayServer) StopKernel(context.Context, *KernelId) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopKernel not implemented")
}
func (UnimplementedLocalGatewayServer) PingKernel(context.Context, *PingInstruction) (*Pong, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PingKernel not implemented")
}
func (UnimplementedLocalGatewayServer) WaitKernel(context.Context, *KernelId) (*KernelStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WaitKernel not implemented")
}
func (UnimplementedLocalGatewayServer) SetClose(context.Context, *Void) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetClose not implemented")
}
func (UnimplementedLocalGatewayServer) AddReplica(context.Context, *ReplicaInfoWithAddr) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddReplica not implemented")
}
func (UnimplementedLocalGatewayServer) UpdateReplicaAddr(context.Context, *ReplicaInfoWithAddr) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReplicaAddr not implemented")
}
func (UnimplementedLocalGatewayServer) StartSyncLog(context.Context, *ReplicaInfo) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartSyncLog not implemented")
}
func (UnimplementedLocalGatewayServer) PrepareToMigrate(context.Context, *ReplicaInfo) (*PrepareToMigrateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PrepareToMigrate not implemented")
}
func (UnimplementedLocalGatewayServer) ResourcesSnapshot(context.Context, *Void) (*NodeResourcesSnapshotWithContainers, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResourcesSnapshot not implemented")
}
func (UnimplementedLocalGatewayServer) GetLocalDaemonInfo(context.Context, *Void) (*LocalDaemonInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLocalDaemonInfo not implemented")
}
func (UnimplementedLocalGatewayServer) GetActualGpuInfo(context.Context, *Void) (*GpuInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActualGpuInfo not implemented")
}
func (UnimplementedLocalGatewayServer) GetVirtualGpuInfo(context.Context, *Void) (*VirtualGpuInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVirtualGpuInfo not implemented")
}
func (UnimplementedLocalGatewayServer) SetTotalVirtualGPUs(context.Context, *SetVirtualGPUsRequest) (*VirtualGpuInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTotalVirtualGPUs not implemented")
}
func (UnimplementedLocalGatewayServer) GetVirtualGpuAllocations(context.Context, *Void) (*VirtualGpuAllocations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVirtualGpuAllocations not implemented")
}
func (UnimplementedLocalGatewayServer) YieldNextExecution(context.Context, *KernelId) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method YieldNextExecution not implemented")
}
func (UnimplementedLocalGatewayServer) ReconnectToGateway(context.Context, *ReconnectToGatewayRequest) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReconnectToGateway not implemented")
}
func (UnimplementedLocalGatewayServer) mustEmbedUnimplementedLocalGatewayServer() {}
func (UnimplementedLocalGatewayServer) testEmbeddedByValue()                      {}

// UnsafeLocalGatewayServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LocalGatewayServer will
// result in compilation errors.
type UnsafeLocalGatewayServer interface {
	mustEmbedUnimplementedLocalGatewayServer()
}

func RegisterLocalGatewayServer(s grpc.ServiceRegistrar, srv LocalGatewayServer) {
	// If the following call pancis, it indicates UnimplementedLocalGatewayServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&LocalGateway_ServiceDesc, srv)
}

func _LocalGateway_SetID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HostId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).SetID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_SetID_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).SetID(ctx, req.(*HostId))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_StartKernel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelSpec)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).StartKernel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_StartKernel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).StartKernel(ctx, req.(*KernelSpec))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_StartKernelReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelReplicaSpec)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).StartKernelReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_StartKernelReplica_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).StartKernelReplica(ctx, req.(*KernelReplicaSpec))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_PromotePrewarmedContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrewarmedKernelReplicaSpec)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).PromotePrewarmedContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_PromotePrewarmedContainer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).PromotePrewarmedContainer(ctx, req.(*PrewarmedKernelReplicaSpec))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_GetKernelStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).GetKernelStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_GetKernelStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).GetKernelStatus(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_KillKernel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).KillKernel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_KillKernel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).KillKernel(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_StopKernel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).StopKernel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_StopKernel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).StopKernel(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_PingKernel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PingInstruction)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).PingKernel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_PingKernel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).PingKernel(ctx, req.(*PingInstruction))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_WaitKernel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).WaitKernel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_WaitKernel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).WaitKernel(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_SetClose_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).SetClose(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_SetClose_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).SetClose(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_AddReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicaInfoWithAddr)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).AddReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_AddReplica_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).AddReplica(ctx, req.(*ReplicaInfoWithAddr))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_UpdateReplicaAddr_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicaInfoWithAddr)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).UpdateReplicaAddr(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_UpdateReplicaAddr_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).UpdateReplicaAddr(ctx, req.(*ReplicaInfoWithAddr))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_StartSyncLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicaInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).StartSyncLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_StartSyncLog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).StartSyncLog(ctx, req.(*ReplicaInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_PrepareToMigrate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicaInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).PrepareToMigrate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_PrepareToMigrate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).PrepareToMigrate(ctx, req.(*ReplicaInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_ResourcesSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).ResourcesSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_ResourcesSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).ResourcesSnapshot(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_GetLocalDaemonInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).GetLocalDaemonInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_GetLocalDaemonInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).GetLocalDaemonInfo(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_GetActualGpuInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).GetActualGpuInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_GetActualGpuInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).GetActualGpuInfo(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_GetVirtualGpuInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).GetVirtualGpuInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_GetVirtualGpuInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).GetVirtualGpuInfo(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_SetTotalVirtualGPUs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetVirtualGPUsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).SetTotalVirtualGPUs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_SetTotalVirtualGPUs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).SetTotalVirtualGPUs(ctx, req.(*SetVirtualGPUsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_GetVirtualGpuAllocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Void)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).GetVirtualGpuAllocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_GetVirtualGpuAllocations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).GetVirtualGpuAllocations(ctx, req.(*Void))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_YieldNextExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KernelId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).YieldNextExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_YieldNextExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).YieldNextExecution(ctx, req.(*KernelId))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalGateway_ReconnectToGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReconnectToGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalGatewayServer).ReconnectToGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LocalGateway_ReconnectToGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalGatewayServer).ReconnectToGateway(ctx, req.(*ReconnectToGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LocalGateway_ServiceDesc is the grpc.ServiceDesc for LocalGateway service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LocalGateway_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gateway.LocalGateway",
	HandlerType: (*LocalGatewayServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetID",
			Handler:    _LocalGateway_SetID_Handler,
		},
		{
			MethodName: "StartKernel",
			Handler:    _LocalGateway_StartKernel_Handler,
		},
		{
			MethodName: "StartKernelReplica",
			Handler:    _LocalGateway_StartKernelReplica_Handler,
		},
		{
			MethodName: "PromotePrewarmedContainer",
			Handler:    _LocalGateway_PromotePrewarmedContainer_Handler,
		},
		{
			MethodName: "GetKernelStatus",
			Handler:    _LocalGateway_GetKernelStatus_Handler,
		},
		{
			MethodName: "KillKernel",
			Handler:    _LocalGateway_KillKernel_Handler,
		},
		{
			MethodName: "StopKernel",
			Handler:    _LocalGateway_StopKernel_Handler,
		},
		{
			MethodName: "PingKernel",
			Handler:    _LocalGateway_PingKernel_Handler,
		},
		{
			MethodName: "WaitKernel",
			Handler:    _LocalGateway_WaitKernel_Handler,
		},
		{
			MethodName: "SetClose",
			Handler:    _LocalGateway_SetClose_Handler,
		},
		{
			MethodName: "AddReplica",
			Handler:    _LocalGateway_AddReplica_Handler,
		},
		{
			MethodName: "UpdateReplicaAddr",
			Handler:    _LocalGateway_UpdateReplicaAddr_Handler,
		},
		{
			MethodName: "StartSyncLog",
			Handler:    _LocalGateway_StartSyncLog_Handler,
		},
		{
			MethodName: "PrepareToMigrate",
			Handler:    _LocalGateway_PrepareToMigrate_Handler,
		},
		{
			MethodName: "ResourcesSnapshot",
			Handler:    _LocalGateway_ResourcesSnapshot_Handler,
		},
		{
			MethodName: "GetLocalDaemonInfo",
			Handler:    _LocalGateway_GetLocalDaemonInfo_Handler,
		},
		{
			MethodName: "GetActualGpuInfo",
			Handler:    _LocalGateway_GetActualGpuInfo_Handler,
		},
		{
			MethodName: "GetVirtualGpuInfo",
			Handler:    _LocalGateway_GetVirtualGpuInfo_Handler,
		},
		{
			MethodName: "SetTotalVirtualGPUs",
			Handler:    _LocalGateway_SetTotalVirtualGPUs_Handler,
		},
		{
			MethodName: "GetVirtualGpuAllocations",
			Handler:    _LocalGateway_GetVirtualGpuAllocations_Handler,
		},
		{
			MethodName: "YieldNextExecution",
			Handler:    _LocalGateway_YieldNextExecution_Handler,
		},
		{
			MethodName: "ReconnectToGateway",
			Handler:    _LocalGateway_ReconnectToGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "internal/server/api/proto/gateway.proto",
}
