%% X_format_02.m
    % A database for identifying and tracking renewable energy embodied in global trade
    % Copyright (c) 2025 Yan Cheng
% To calculate yearly X 
% To prepare X from [30807x1] to [189x163]
% Input: yearly Y[30807x189] and T[30807x30807]
% Output: yearly A and yearly X two formates([30807x1] & [189x163])


%% To calculate yearly X 
% Define path
baseFolder = 'D:\DataCollection\REX3\Original_REX3';
outputFolder = 'D:\DataCollection\REX3\Processed_REX3_V2'; % save A and X [30807x1]
outputFolder_Xmatrix = 'D:\nutSync\我的坚果云\SciStudy\09paperWork\REAccount\Data\DataForCode\03REX3_Xmatrix_V2';  % save X [189x163]


% basic parameter
c = 189;
s = 163;
n = c * s;

% get subfolders
subFolders = dir(fullfile(baseFolder, 'REX3_*'));
subFolders = subFolders([subFolders.isdir]);  

% get yearly data in subfolders
for k = 1:length(subFolders)

    currentFolder = fullfile(baseFolder, subFolders(k).name);
    
    % create output subfolder
    yearFolder = fullfile(outputFolder, subFolders(k).name);
    if ~exist(yearFolder, 'dir')
        mkdir(yearFolder);
    end

    T_REX3 = load(fullfile(currentFolder, 'T_REX3.mat')).T_REX3;  
    Y_REX3 = load(fullfile(currentFolder, 'Y_REX3.mat')).Y_REX3;
    
    % check to ensure the robustness of MRIO result
    T_REX3(isnan(T_REX3))=0;
    T_REX3(isinf(T_REX3))=0;
    T_REX3(T_REX3 < 0) = 0;

    Y_REX3(isnan(Y_REX3))=0;
    Y_REX3(isinf(Y_REX3))=0;
    Y_REX3(Y_REX3 < 0) = 0;

    % calculate X
    X_REX3 = sum(T_REX3, 2) + sum(Y_REX3, 2);
    
    % calculate A
    A_REX3 = T_REX3 ./ repmat(X_REX3', n, 1);
    A_REX3(isnan(A_REX3)) = 0;
    A_REX3(isinf(A_REX3)) = 0;
    
    % save A & X
    save(fullfile(yearFolder, 'X_REX3.mat'), 'X_REX3', '-v7.3');
    save(fullfile(yearFolder, 'A_REX3.mat'), 'A_REX3', '-v7.3');
    
    % change X format
    X_matrix = reshape(X_REX3, [s, c])';
    
    % save X as .csv
    outputFileName = fullfile(outputFolder_Xmatrix, [subFolders(k).name '_X_matrix.csv']);
    writematrix(X_matrix, outputFileName);
end

disp('Done！');


