%% Calculation of Leontif inverse matrix 
    % A database for identifying and tracking renewable energy embodied in global trade
    % Copyright (c) 2025 Yan Cheng
%% inv(I-A) for REX3 MRIO table
%% pinv(I-A) for EORA MRIO table

%% set
% path
input_folder = 'D:\DataCollection\REX3\Processed_REX3_V2';
output_folder = 'D:\DataCollection\REX3\01InputEmbodied';

% year
c = 189;
s = 163;
n = c * s;
I = speye(n, n);
years = 2011:2022;


%% calculate L
for year = years
    folder_name = sprintf('REX3_%d', year);
    file_path = fullfile(input_folder, folder_name, 'A_REX3.mat');
    
    if exist(file_path, 'file') == 2

        load(file_path, 'A_REX3');
        fprintf('Start: %d\n', year);
   
        L = inv(I - A_REX3);
        
        numNAN = sum(isnan(L(:)));
        numInf = sum(isinf(L(:)));
        L(isnan(L)) = 0;
        L(isinf(L)) = 0;
        
        output_year_folder = fullfile(output_folder, num2str(year));
        if ~exist(output_year_folder, 'dir')
            mkdir(output_year_folder);
        end
        
        output_file_path = fullfile(output_year_folder, 'L.mat');
        save(output_file_path, 'L', '-v7.3');
        
        fprintf('Done: %d\n', year);
    else
        fprintf('File not found': %s\n', file_path);
    end
 
   clear A_REX3 L numNAN numInf folder_name file_path output_year_folder output_file_path;
end

disp('Done for all years！');