
This experimental package contains all files and instructions needed to replicate the data collection and analysis process for gathering and analyzing grey literature articles about empathy in software engineering from DEV.to and Medium, as well as a follow-up expert survey used to assess the resulting framework.

## Folder Structure

-   📁 **`GL_Study/`** – Materials related to the grey literature analysis, including scripts, collected data, the codebook, and coded results.
-   📁 **`Experts_Survey/`** – Materials related to the expert validation of the framework via survey responses and qualitative analysis.

## Contents

### 📁`GL_Study/`

1.  **`dev_scraper.py`**
    
    -   _Description_: Python script using Selenium to scrape articles mentioning "empathy" from DEV.to. It extracts article titles and URLs.
    -   _Usage_:
        1.  Install dependencies:
            
            ```
            pip install selenium
            ```
            
        2.  Download and configure a WebDriver (e.g., [ChromeDriver](https://sites.google.com/chromium.org/driver/)).
        3.  Run the script:
            
            ```
            python dev_scraper.py
            ```
            
        4.  Output: A CSV file containing the titles and URLs of retrieved articles.

2.  **`codebook.ods` / `codebook.xls`**
    
    -   _Description_: Defines thematic codes used during analysis, with descriptions and examples.
    -   _Usage_: Reference to interpret how themes were applied across the dataset.
3.  **`coded_articles.ods` / `coded_articles.xls`**
    
    -   _Description_: Results of the coding process, including:
        -   Article URL
        -   Codes applied for each research question
    -   _Usage_: Used to explore themes and patterns in the GL dataset.
   4. **`INSTALL.md`** – Step-by-step installation guide with example output
   5. **`REQUIREMENTS.md`** – Hardware/software requirements and environment details
   6. **`requirements.txt`** – Python dependency specification 

### 📁`Experts_Survey/`

 1. **`Framework.pdf`**
    
    -   _Description_: Visual representation of the empathy framework assessed by experts.
    
  
 2. **`Complete Survey - Framework Assessment.pdf`**
    
    -   _Description_: Full survey instrument used to collect expert feedback on the proposed empathy framework. Includes all questions
    and response options.
    
 3. **`Raw data responses.xlsx`** / **`Raw data responses.ods`**
    
    -   _Description_: Raw qualitative responses submitted by expert participants.
    
 4.  **`Data analysis survey experts.xlsx`** /**`Data analysis survey experts.ods`**    
      -  _Description_: Thematic analysis and applied coding of the expert responses. 

## Prerequisites

-   **Python 3.7+** – Required to run `dev_scraper.py`
-   **Selenium WebDriver** – ChromeDriver or another driver, depending on your browser
-  **ImportJSON** - Script to enable JSON import functionality in Google Sheets
-   **Google Sheets** – For running the `IMPORTJSON.gs` script
-   **Spreadsheet software** – To open `.xls` or `.ods` files (e.g., LibreOffice, Excel)
-   **Basic understanding of qualitative coding** – To interpret the results using the codebook

## Steps to Replicate

1.  **Collect Articles from DEV.to**
    
    -   Use `dev_scraper.py` or the `IMPORTJSON.gs` script to retrieve articles about empathy.
    -   **Using `IMPORTJSON.gs`**
    
        -   _Description_: Google Sheets script for pulling articles tagged "empathy" via the DEV.to API.
        -   _Usage_:                
                1. [Download the script](https://github.com/bradjasper/ImportJSON/)                
                2. Add to Google Sheets script editor ([instructions](https://developers.google.com/apps-script/guides/sheets)).            
            3.  Use the formula:


                    
                    
                    ```
                    =ImportJSON("https://dev.to/api/articles?tag=empathy;per_page=1000")                  
                    ```                   
                
            4.  Output: A structured table with metadata for up to 1000 empathy-tagged articles.
2.  **Review and Apply the Codebook**
    
    -   Consult `codebook.ods` or `codebook.xls` for definitions and examples of each code.
3.  **Analyze the Grey Literature Data**
    
    -   Use `coded_articles.ods` or `coded_articles.xls` to explore the application of codes.
4.  **Review the Expert Survey Data** _(optional)_
    
    -   Refer to the expert feedback survey and its analysis to understand the validation of the framework.

## License

This replication package is licensed under the **Creative Commons Attribution-ShareAlike 4.0 International License (CC BY-SA 4.0)**.

You are free to share, adapt, and build upon this material for any purpose—even commercially—provided that proper credit is given and any derivatives are distributed under the same license.

For more information, see the [CC BY-SA 4.0 License](https://creativecommons.org/licenses/by-sa/4.0/).

## 📄 Citation

If you use this dataset in your research, please cite: Cerqueira, L. (2025). Experimental Package: Exploring Empathy in Software Engineering Articles (1.5) [Data set]. Zenodo. 10.5281/zenodo.15800354

## Contact

For questions or additional information, please contact:

**Lidiany Cerqueira**  
[lidiany.cerqueira@ufba.br](mailto:lidiany.cerqueira@ufba.br)  
Federal University of Bahia (UFBA)