from matplotlib import pyplot as plt
import os
import sys
import numpy as np

#choose the animal and
animal = 1
param_est = "3"
number_starts = 1
run_dir_plotting_DE =f'/analysis/experiments_differential_evolution/Est_{param_est}'



plt.rcParams.update({
    "text.usetex": True,
    "font.family": "serif",
   "font.serif": "cm",
    "axes.prop_cycle": cycler('color', ['#1f77b4', '#ff7f0e', '#2ca02c', 
            '#d62728', '#9467bd', '#8c564b', '#e377c2', '#7f7f7f', '#bcbd22', '#17becf']),
    })

#load the optimized parameters and the loss
optimized_params_DE = np.load(f'{run_dir_plotting_DE}/a{animal}/result.npy')
obj_values_DE = optimized_params_DE[:,-1] #loss is saved in the last column


#sorting
sorted_args_DE = np.argsort(obj_values_DE)
sorted_obj_DE = np.sort(obj_values_DE)


############################
###### Waterfallplot #######
############################

fig, ax = plt.subplots(dpi=350,figsize=(5,3),constrained_layout=True)
xticks=[1]+list(range(0,len(sorted_obj_DE)+1,(len(sorted_obj_DE)+1)//5)[1:])
ax.set_xticks(xticks)
#ax.set_yticks([625,15000,30000])  
ax.plot(range(1,len(sorted_obj_DE)+1),sorted_obj_DE,'.',markersize=5, c='tab:blue', label='Differential Evolution')
ax.xaxis.set_tick_params(labelsize=10)
ax.yaxis.set_tick_params(labelsize=10)
ax.set_xlabel('Sorted run index', fontsize=15)
ax.set_ylabel("$\\chi²(\hat{\\theta})$ in ($n\mathrm{A})^{2}$" , fontsize=15)
#ax.legend(loc='upper right', ncols=2, bbox_to_anchor=(1,1.2), fontsize=11)
fig.savefig(f'{run_dir_plotting_DE}/waterfall_plot_{param_est}_{animal}.png')