from matplotlib import pyplot as plt
import os
import sys
import numpy as np
from opt_settings import *
from opt_parfor_parallel import *
import matplotlib
import seaborn
import matplotlib.ticker as ticker

plt.rcParams.update({
    "text.usetex": True,
    "font.family": "serif",
   "font.serif": "cm",
    "axes.prop_cycle": cycler('color', ['#1f77b4', '#ff7f0e', '#2ca02c', 
            '#d62728', '#9467bd', '#8c564b', '#e377c2', '#7f7f7f', '#bcbd22', '#17becf']),
    })


matplotlib.rc('xtick', labelsize=25) 
matplotlib.rc('ytick', labelsize=25) 
animals = range(1,6)
#Load the best parameters of every animal optimization -- here dependent on the specific path, adapt to your needs
path_folder = 'experiments_differential_evolution/Est_3'

params = np.load(f"{path_folder}/bestparams.npy")
#load the corresponding objective function values
obj_values=np.load(f"{path_folder}/optimal_loss.npy")

#parameter names for ylabel in plot
param_names = ['$N$','$g_V$','$g_P$','$k_R$','$n_{\mathrm{ves}}$']

fig,ax = plt.subplots(ncols=6, nrows=1,figsize=(10,1.5),dpi=200,sharex=True)
perseconds = "s$^{-1}$"
fig.subplots_adjust(left  = 0.125,  # the left side of the subplots of the figure
                    right = 0.9,    # the right side of the subplots of the figure
                    bottom = 0.1,   # the bottom of the subplots of the figure
                    top = 0.9,      # the top of the subplots of the figure
                    wspace = 1.0,   # the amount of width reserved for blank space between subplots
                    hspace = 0.2  )

for i in range(6):
    if i == 0:
        #plot the loss values
        [ax[i].scatter(j,obj_values[j], label=f'animal {j+1}', s=20) for j in range(len(obj_values))]
        ax[0].set_ylabel("$\\chi(\hat{\\theta})²$ in $n\mathrm{A})²$", fontsize=15)
        ax[0].set_xticks(np.array([]))
        ax[0].set_facecolor('papayawhip')
        yticks = ticker.MaxNLocator(5)
        ax[0].yaxis.set_major_locator(yticks)
        ax[0].yaxis.set_tick_params(labelsize=10)
    elif i>0:
        #plot the parameter values
        [ax[i].scatter(j,10**params[j-1][i-1], s=20) for j in range(1,6)]
        ax[i].set_ylabel(f"{param_names[i-1]} in {perseconds}", fontsize=15)
        ax[i].set_xticks(np.array([]))
        yticks = ticker.MaxNLocator(2)
        ax[i].yaxis.set_major_locator(yticks)
        ax[i].yaxis.set_tick_params(labelsize=10)
ax[0].set_xlim(-0.5,5.5)
ax[1].set_ylim(-0.1,400)
ax[2].set_ylim(-0.1,3)
ax[3].set_ylim(-0.1,200)
ax[4].set_ylim(-0.1,40)
ax[5].set_ylim(-0.1,55)
line,labels=ax[0].get_legend_handles_labels()
seaborn.despine(left=False, bottom=False, right=True,top=True)
fig.legend(line,labels,loc='upper right', ncols=5, fontsize=15,bbox_to_anchor=(0.95,1.3))
fig.savefig(f'{path_folder}/optimal_params_dots.png',bbox_inches='tight')