import numpy as np

"""
Extract the best parameter results from an estimation after the multistart optimization
"""
folder ='analysis/experiments_differential_evolution/Est_1/Est_1_test'
animals = [1,2,3,4,5]
animal_results = np.array([ np.load(f"{folder}/a{i}/result.npy")
               for i in animals])

minloss_res_idx = [ np.argmin(animal_results[i-1,:,-1]) for i in animals]

bestparams = np.array([animal_results[i-1,minloss_res_idx[i-1],1:-1] for i in animals])
meanvalues = np.mean(bestparams,axis=0)
optimal_loss = np.array([animal_results[i-1,minloss_res_idx[i-1],-1] for i in animals])
np.save(f"{folder}/optimal_loss.npy", optimal_loss)
np.save(f"{folder}/bestparams.npy", bestparams)
np.save(f"{folder}/avgparams.npy", meanvalues)