library(readr)
library(ggplot2)
library(tidyr)
library(dplyr)

# Cargando indicadores de España
spain_data <- read_csv("Indicadores_España.csv")

# # Cargando indicadores de Finlandia
finland_data <- read_csv("Indicadores_Finlandia.csv")

# Para evitar notación científica
options(scipen = 999)

# Calculando varianza poblacional y desviación típica poblacional
population_variance <- function(x) {
  mean((x - mean(x))^2)
}

population_sd <- function(x) {
  sqrt(population_variance(x))
}

# Para España
spain_summary <- data.frame(
  Country = "Spain",
  Variable = c("Esfuerzo_en_Presupuesto", "Esfuerzo_en_Préstamos", "Esfuerzo_en_Visitas"),
  Variance = c(
    population_variance(spain_data$Esfuerzo_en_Presupuesto),
    population_variance(spain_data$Esfuerzo_en_Préstamos),
    population_variance(spain_data$Esfuerzo_en_Visitas)
  ),
  Standard_Deviation = c(
    population_sd(spain_data$Esfuerzo_en_Presupuesto),
    population_sd(spain_data$Esfuerzo_en_Préstamos),
    population_sd(spain_data$Esfuerzo_en_Visitas)
  )
)

# Para Finlandia
finland_summary <- data.frame(
  Country = "Finland",
  Variable = c("Esfuerzo_en_Presupuesto", "Esfuerzo_en_Préstamos", "Esfuerzo_en_Visitas"),
  Variance = c(
    population_variance(finland_data$Esfuerzo_en_Presupuesto),
    population_variance(finland_data$Esfuerzo_en_Préstamos),
    population_variance(finland_data$Esfuerzo_en_Visitas)
  ),
  Standard_Deviation = c(
    population_sd(finland_data$Esfuerzo_en_Presupuesto),
    population_sd(finland_data$Esfuerzo_en_Préstamos),
    population_sd(finland_data$Esfuerzo_en_Visitas)
  )
)

# Combinando/sintetizando resultados
combined_summary <- rbind(spain_summary, finland_summary)

# Combinando/sintetizando resultados II
cat("Summary for Spain:\n")
print(spain_summary)

cat("\nSummary for Finland:\n")
print(finland_summary)

# Gráficos de dispersión entre esfuerzos en un solo gráfico

# Columnas para país
spain_data$Pais <- "España"
finland_data$Pais <- "Finlandia"

# Combinando datos
datos_combinados <- bind_rows(spain_data, finland_data)

# Convirtiendo 'Pais' en factor con el orden de Finlandia primero
datos_combinados$Pais <- factor(datos_combinados$Pais, levels = c("Finlandia", "España"))

# Creando dataframe para representar las variables necesarias
datos_grafico <- datos_combinados %>%
  pivot_longer(cols = c(Esfuerzo_en_Préstamos, Esfuerzo_en_Visitas), 
               names_to = "Variable", values_to = "Valor") %>%
  mutate(Comparacion = case_when(
    Variable == "Esfuerzo_en_Préstamos" ~ "Esfuerzo en préstamos",
    Variable == "Esfuerzo_en_Visitas" ~ "Esfuerzo en visitas"
  ))

# Gráficos unificados
ggplot(datos_grafico, aes(x = Esfuerzo_en_Presupuesto, y = Valor, color = Pais)) +
  geom_point(alpha = 0.7) +
  facet_grid(Comparacion ~ Pais) +
  scale_color_manual(values = c("Finlandia" = "#D32F2F", "España" = "#4CAF50")) +
  labs(
    # title = "Comparación de esfuerzos por país",
    x = "Esfuerzo en presupuesto",
    y = "Valores",
    color = "País"
  ) +
  theme_minimal() +
  theme(
    panel.background = element_rect(fill = "#F9F9F9"),
    strip.text.x = element_text(face = "bold", size = 12),
    strip.text.y = element_text(size = 11)
  ) +
  guides(color = "none")