Require Import List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq 
  Require Import ssreflect.
         
From CC 
  Require Import lib structures clts lts channel_complete channel_compliant protocol closure_conditions run soundness completeness.

Theorem preciseness :
  forall {State : Type}
    (S : @LTS SyncAlphabet State),
    GCLTS S ->
    (exists {LocalState : Type}, 
      @implementable State LocalState S) <-> 
        @NMC State S /\ @RCC State S /\ @SCC State S. 
Proof.
  intros.
  split; intro.
  destruct H0 as [LocalState [T_witness H_implements]]. 
  eapply completeness. exact H.
  exists T_witness. exact H_implements.
  assert (H_soundness := @soundness State). 
  spec H_soundness S H.
  repeat (spec H_soundness; try easy).
Qed.

Print Assumptions preciseness. 
