Require Import List Classical Nat Logic Lia FunctionalExtensionality ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq  
  Require Import ssreflect.
Require Import Setoid Program. 
From CC     
  Require Import lib structures lts clts channel_compliant channel_complete protocol closure_conditions canonical_implementation run nmc_soundness rcc_soundness scc_soundness. 

Section Soundness.

Context {State : Type} {LocalState : Type}. 

(* Showing that every GCLTS that satisfies NMC, SCC and RCC is implemented by its ideal implementation *) 
(* First, we show that every ideal implementation's language contains the protocol's language *) 

(* Next, we show that the protocol language includes the ideal implementation's language *) 
Lemma canonical_implementation_trace_I_non_empty :
  forall (S : @LTS SyncAlphabet State) (T : CLTS) (w : FinAsyncWord),
    GCLTS S ->
    @NMC State S -> 
    @RCC State S ->
    @SCC State S ->
    canonical_implementation S T -> 
    @is_clts_trace LocalState T w ->
    I_set_non_empty S w. 
Proof.
  intros S T w H_GCLTS H_NMC H_RCC H_SCC H_canonical H_trace.
  induction w as [|a w IHw] using rev_ind.
  - (* Empty word is compliant with every run *)
    (* Need to know that every global LTS has at least a run *)
    destruct H_GCLTS as [_ [_ [_ [_ H_exists_run]]]]. 
    destruct H_exists_run as [[run_fin H_is_run] | [run_inf H_is_run]].
    left. exists run_fin. split. assumption. intros. simpl.
    apply prefix_nil.
    right. exists run_inf. split. assumption. intros. simpl.
    exists 0. easy. 
  - assert (H_trace_w : @is_clts_trace LocalState T w). 
      {
        apply clts_trace_prefix_closed with (w ++ [a]).
        assumption.
        now apply prefix_app_r.
      }
    destruct a as [a H_neq].
    destruct a as [p q m | p q m].
    * (* Send case *)
      eapply I_set_non_empty_inductive_snd; try assumption.  
      exact H_canonical. exact H_trace_w.
      now apply IHw.
      easy. assumption. 
    * (* Receive case *)
            eapply I_set_non_empty_inductive_rcv; try assumption.
      exact H_canonical. exact H_trace_w.
      now apply IHw.
      easy.
      assumption.
Qed.

Lemma canonical_implementation_terminated_trace_run_complete :
  forall (S : @LTS SyncAlphabet State) (T : CLTS) (w : FinAsyncWord),
    GCLTS S ->
    @NMC State S -> 
    @RCC State S ->
    @SCC State S ->
    canonical_implementation S T ->
    @is_finite_clts_word LocalState T w ->
      forall (rho : FinSyncWord),
        possible_run_prefix S rho w -> 
          per_role_identical (split rho) w. 
Proof.
  intros S T w H_GCLTS H_NMC H_RCC H_SCC H_canonical H_word rho H_possible.
  assert (H_possible_copy := H_possible). 
  destruct H_possible as [H_run H_compliant].
  destruct (classic (per_role_identical (split rho) w)).
  {  assumption. } 
  (* We want to show that if w is not run-complete, we find a contradiction *) 
  exfalso. 
  (* We use our handy dandy lemma which extends w to make it run-complete *)
  assert (H_word_copy := H_word). 
  destruct H_word as [c_w [H_reach_w H_max_w]]. 
  assert (H_trace_w : @is_clts_trace LocalState T w). 
  {  exists c_w. exact H_reach_w. }  
  assert (H_helper := @possible_run_prefix_channel_compliant_word_extension State).
  spec H_helper S w rho.
  spec H_helper.
  eapply clts_trace_channel_compliant.
  exact H_trace_w.
  spec H_helper H_possible_copy. 
  destruct H_helper as [u [H_cc_wu H_role_wu]].
  (* Now of course if this extension is empty, then we are done *)
  destruct u.
  rewrite app_nil_r in H_role_wu.
  apply H. now intro p.
  (* Otherwise, it prescribes some action that some role can take next *)
  (* We first show that this must be a send action *)
  (* This is how we get the next action, not just by simply negating the premise, because that is not strong enough! *)
  (* Anywhere we intuitively do the "pick the next role that can take an action" reasoning,
     we invoke this lemma *) 
  destruct a as [a H_neq_a].
  destruct a as [p q m | p q m].
  - destruct H_run as [s_rho H_reach_rho].
    eapply (send_extension_means_non_terminated_trace S T w (Snd p q m ↾ H_neq_a) H_GCLTS H_SCC H_canonical).
    easy. 2 : assumption.
    (* All that we need to show is that this is a valid CLTS trace *)
    eapply clts_trace_snd_extension_sufficient.
    assumption.
    (* Which just amounts to showing that p's part is valid *)
    spec H_canonical p.
    destruct H_canonical as [_ H_canonical].
    spec H_canonical (w ++ [Snd p q m ↾ H_neq_a]).
    destruct H_canonical as [_ H_canonical].
    spec H_canonical.
    eapply channel_compliant_I_non_empty_implies_prefix.
    { unfold GCLTS in H_GCLTS. tauto. }
    eapply prefix_preserves_channel_compliance.
    exact H_cc_wu. apply prefix_app. apply singleton_prefix_cons.
    split.
    { destruct H_possible_copy as [H_trace_rho _].
      exact H_trace_rho. }
    intros p0.
    spec H_role_wu p0.
    clean H_role_wu.
    clean.
    rewrite <- H_role_wu.
    apply prefix_app.
    now apply prefix_app_r.
    clean H_canonical.
  - (* In the case that a is a receive event, we find a contradiction to wa being channel compliant *)
    assert (H_false : channel_compliant (w ++ [Rcv p q m ↾ H_neq_a])).
    { eapply prefix_preserves_channel_compliance.
      exact H_cc_wu.
      apply prefix_app. apply singleton_prefix_cons. }
    spec H_false (w ++ [Rcv p q m ↾ H_neq_a]).
    spec H_false. reflexivity.
    spec H_false p q H_neq_a.
    destruct H_max_w as [_ H_chan].
    spec H_chan p q H_neq_a.
    assert (H_useful := (about_clts_trace_configuration_channel_contents _ _ H_reach_w p q H_neq_a)).
    clean_mproj H_false.
    rewrite H_chan in H_useful.
    rewrite <- H_useful in H_false.
    rewrite app_nil_r in H_false. 
    eapply prefix_snoc_not. exact H_false.
Qed.

Lemma canonical_implementation_finite_maximal_word_infinite_possible_run_false : 
  forall (S : @LTS SyncAlphabet State) (T : CLTS),
    GCLTS S ->
    @NMC State S -> 
    @RCC State S ->
    @SCC State S ->
    canonical_implementation S T ->
    forall (w : FinAsyncWord),
      @is_finite_clts_word LocalState T w ->
      forall (rho : InfSyncWord),
        infinite_possible_run S rho w ->
        False. 
Proof.
  intros S T H_GCLTS H_NMC H_RCC H_SCC H_canonical w H_word rho H_run.
  assert (H_df : deadlock_free S). { unfold GCLTS in *; tauto. } 
  assert (H_trace_w : @is_clts_trace LocalState T w).  
  { destruct H_word as [s H_reach].
    exists s. tauto. }
  assert (H_useful := infinite_possible_run_means_finite_possible_run_prefix S rho w H_run).
  destruct H_useful as [rho_fin [H_possible H_pref]].
  assert (H_useful := canonical_implementation_terminated_trace_run_complete S T w H_GCLTS H_NMC H_RCC H_SCC H_canonical H_word rho_fin H_possible).
  (* Whatever this possible run prefix is, all roles must have completed all actions along it *)
  (* Well now there must be an action following this in the infinite run *)
  (* Whosever action that is *)
  (* We can argue that the sender in this action can fire the send *)
  (* And again find a contradiction to sink finality using SCC *)
  destruct H_pref as [i H_pref].
  destruct H_run as [H_run H_compliant].  
  spec H_run i.  
  destruct H_run as [s_rho_fin [s_rho_fin' [H_reach_rho_fin H_transition]]].
  remember (Str_nth i rho) as a.  
  destruct a as [a H_neq_a].
  destruct a as [p q m].
  assert (H_neq_snd : sender_receiver_neq_async (Snd p q m)) by easy. 
  remember (exist _ (Snd p q m) H_neq_snd) as x_snd.
  assert (H_trace_wx : @is_clts_trace LocalState T (w ++ [x_snd])). 
  { 
    rewrite Heqx_snd.
    eapply clts_trace_snd_extension_sufficient. 
    exact H_trace_w. 
    spec H_canonical p.
    destruct H_canonical as [_ H_canonical].
    spec H_canonical (w ++ [x_snd]).
    destruct H_canonical as [_ H_canonical].
    spec H_canonical.
    eapply channel_compliant_I_non_empty_implies_prefix. 
    { unfold GCLTS in H_GCLTS. tauto. }
    eapply snd_extension_preserves_channel_compliance.
    eapply clts_trace_channel_compliant.
    exact H_trace_w.
    rewrite Heqx_snd. easy.
    assert (H_goal : possible_run_prefix S (rho_fin ++ [Event p q m ↾ H_neq_a]) (w ++ [x_snd])).
    {
      split.
      exists s_rho_fin'.
      eapply lts.Reachable_step.
      rewrite <- H_pref. exact H_reach_rho_fin.
      exact H_transition.
      intro p0.
      destruct (classic (p = p0)).
      * subst p0. 
        clean. 
        rewrite wproj_symbol_sender_eq. reflexivity.
        rewrite wproj_symbol_receiver_neq. easy.
        rewrite Heqx_snd.
        rewrite wproj_symbol_sender_eq. reflexivity.
        spec H_useful p.
        rewrite H_useful. rewrite app_nil_r.
        assert (H_rewrite : [Snd p q m ↾ H_neq_snd] = [Snd p q m ↾ H_neq_a]). 
        { f_equal. sigma_equal. }
        now rewrite H_rewrite.
      * rewrite Heqx_snd.
        clean. rewrite wproj_symbol_sender_neq. easy. 
        rewrite wproj_symbol_sender_neq. easy.
        unnil.
        destruct H_possible as [_ H_possible]. 
        spec H_possible p0.
        now apply prefix_app_r.
    }
    exact H_goal.
    clean H_canonical. rewrite Heqx_snd in H_canonical.
    clean H_canonical.
  }
  (* Now having established that wx is a CLTS trace, we are ready to concoct all the ingredients *) 
  (* But first we need to concoct all the ingredients to instantiate SCC with *)
  (* Begin: Obtaining a global transition from p's transition on x *) 
  destruct H_word as [c_w [H_reach_w H_final_w]]. 
  destruct H_trace_wx as [c_wx H_reach_wx].
  subst x_snd.
  rename H_useful into H_role_eq. 
  assert (H_helper := @canonical_implementation_local_transition_means_global_transition State LocalState). 
  spec H_helper S T (wproj w p) (Snd p q m ↾ H_neq_snd) p (get_local_state c_w p) (get_local_state c_wx p).
  spec H_helper H_df H_canonical. 
  spec H_helper. 
  (* Establishing that T_p reaches (get_local_state c_w p) on (wproj w p) *)
  { 
    apply (clts_reachable_means_implementation_reachable T w c_w H_reach_w p).
  }
  spec H_helper.
  (* Establishing that T_p reaches (get_local_state c_wx p) on (wproj wx p) *)
  {
    assert (H_useful := clts_reachable_means_implementation_reachable T (w ++ [Snd p q m ↾ H_neq_snd]) c_wx H_reach_wx p).
    clean H_useful.
  }
  (* End: Obtaining a global transition from p's transition on x *)
  destruct H_helper as [s1 [s2 [rho_p [H_reach_rho_p [H_rho_p_eq H_transition1]]]]].
  assert (H_eq : (async_to_sync
                    (Snd p q m ↾ H_neq_snd)) = (exist _ (Event p q m) H_neq_a)).
  { unfold async_to_sync.  simpl.
    sigma_equal. } 
  rewrite H_eq in H_transition1. 
  clear H_eq.
  (* s1 -> s2 is the transition we obtained *) 
  (* Now we can instantiate the first parts of SCC *)
  spec H_SCC s1 s2 (Event p q m ↾ H_neq_a) H_transition1.
  (* Begin: Obtaining a simultaneously reachable state as s1 *)
  (* This state comes from the existing possible run, specifically from alpha *)
  spec H_canonical p.
  destruct H_canonical as [H_finite_words _].
  spec H_finite_words (wproj w p). 
  destruct H_finite_words as [H_finite_words _].
  spec H_finite_words.
  { (* We need to show that wproj w p is final in T_p *)
    exists (get_local_state c_w p). split.
    eapply clts_reachable_means_implementation_reachable.
    exact H_reach_w.
    unfold Configuration_final in H_final_w.
     destruct H_final_w as [H_final_state _].
     spec H_final_state p.
     assumption. }
  (* From the fact that p is in a final state in c_w,
     we can obtain a finite protocol word in S whose projection onto p is equal to wproj w p *) 
  (* And we actually don't need to care what any of the other roles are doing in this word w_fin *)
  destruct H_finite_words as [w_fin [H_w_fin H_eq_w_fin]].
  (* From this finite protocol word we can obtain a final state *)
  (* And this final state we shall show to have outgoing transitions *)
  destruct H_w_fin as [w_fin_run [H_reach_w_fin_run [H_role H_cc]]]. 
  destruct H_reach_w_fin_run as [s_w_fin_run [H_reach_w_fin_run H_final_w_fin_run]].
  spec H_SCC s_w_fin_run. 
  spec H_SCC.
  exists (wproj w p). split; unfold reachable_for, reachable_for_on.
  exists rho_p. tauto.
  exists w_fin_run. split. 
  tauto. 
  clean.
  spec H_role p.
  rewrite <- H_eq_w_fin. assumption.
  (* Now we can finally show that this final state s_w_fin_run has outgoing transitions and contradict sink finality *)
  destruct H_SCC as [s2' H_reach_s2'].
  clean H_reach_s2'. 
  rewrite wproj_symbol_sender_eq in H_reach_s2'.
  reflexivity.
  destruct H_reach_s2' as [rho_seg [H_reach_rho_seg H_about_rho_seg]].
  destruct rho_seg. 
  { simpl in H_about_rho_seg.
    subst. 
    inversion H_about_rho_seg. }
  apply lts.Reachable_behead in H_reach_rho_seg. 
  destruct H_reach_rho_seg as [s' [H_reach_rho_seg' H_transition']].
  (* Contradicting sink finality *)
  assert (H_sink_final : sink_final S).
  { unfold GCLTS in H_GCLTS. tauto. }
  spec H_sink_final s_w_fin_run s' s.
  spec H_sink_final.
  split. exact H_final_w_fin_run. exact H_transition'.
  contradiction.
Qed. 

Lemma canonical_implementation_finite_maximal_word_exists_finite_possible_run : 
  forall (S : @LTS SyncAlphabet State) (T : CLTS) (w : FinAsyncWord),
    GCLTS S ->
    @NMC State S -> 
    @RCC State S ->
    @SCC State S ->
    canonical_implementation S T ->
    @is_finite_clts_word LocalState T w ->
      exists (rho : FinSyncWord),
        finite_possible_run S rho w /\
          per_role_identical (split rho) w. 
Proof.
  intros S T w H_GCLTS H_NMC H_RCC H_SCC H_canonical H_word. 
  assert (H_useful := canonical_implementation_trace_I_non_empty).
  spec H_useful S T w H_GCLTS H_NMC H_RCC H_SCC H_canonical.
  assert (H_finite_word_copy := H_word). 
  destruct H_word as [c_w [H_reach H_final]].
  spec H_useful.
  exists c_w.
  assumption.
  destruct H_useful as [H_fin | H_inf].
  - (* In the finite case, we need to show that no role has more actions *)
    destruct H_fin as [rho [H_run H_compliant]]. 
    exists rho. 
    split. unfold finite_possible_run.
    tauto.
    eapply (canonical_implementation_terminated_trace_run_complete S T).
    exact H_GCLTS. exact H_NMC. exact H_RCC. exact H_SCC.
    exact H_canonical.
    assumption.
    apply finite_possible_run_is_possible_run_prefix.
    split. assumption. assumption.
  - destruct H_inf as [rho [H_run H_compliant]]. 
    exfalso.
    eapply canonical_implementation_finite_maximal_word_infinite_possible_run_false. 
    exact H_GCLTS. exact H_NMC. exact H_RCC. exact H_SCC.
    exact H_canonical. exact H_finite_word_copy.
    split. exact H_run.  exact H_compliant.
Qed.

(* 
Lemma canonical_implementation_infinite_maximal_word_exists_infinite_possible_run : 
  forall (S : @LTS SyncAlphabet State) (T : CLTS) (w : InfAsyncWord),
    GCLTS S ->
    @NMC State S ->
    @RCC State S ->
    @SCC State S ->
    canonical_implementation S T ->
    @is_infinite_clts_word LocalState T w ->
    exists (rho : InfSyncWord),
      forall (pref : FinAsyncWord),
        prefix_inf pref w ->
        infinite_possible_run S rho pref. 
Proof.
  intros S T w H_GCLTS H_NMC H_RCC H_SCC H_canonical H_word.
  assert (H_useful := @specialized_konig_lemma State LocalState S w).  
  spec H_useful.
  { unfold GCLTS in H_GCLTS. tauto. }
  spec H_useful.
  intros pref H_pref.
  eapply (canonical_implementation_trace_I_non_empty S T pref H_GCLTS H_NMC H_RCC H_SCC H_canonical).
  destruct H_pref as [i H_pref]. 
  spec H_word i. 
  destruct H_word as [c H_reach].
  exists c. rewrite H_pref in H_reach. assumption.
  assumption. 
Qed.   *) 
    
Lemma protocol_prefixes_include_canonical_implementation_prefixes : 
  forall (S : @LTS SyncAlphabet State) (T : CLTS),
    GCLTS S ->
    @NMC State S -> 
    @RCC State S ->
    @SCC State S ->
    canonical_implementation S T ->
    forall (w : FinAsyncWord),
      @is_clts_trace LocalState T w -> 
      is_protocol_prefix S w. 
Proof.
  intros S T H_GCLTS H_NMC H_RCC H_SCC H_canonical w H_trace.
  assert (H_useful := (@canonical_implementation_trace_I_non_empty S T)).
  spec H_useful w H_GCLTS H_NMC H_RCC H_SCC H_canonical H_trace.
  destruct H_useful as [H_fin | H_inf].
  destruct H_fin as [rho_fin H_fin].
  apply finite_possible_run_is_possible_run_prefix in H_fin.
  eapply channel_compliant_I_non_empty_implies_prefix. 
  unfold GCLTS in H_GCLTS; tauto.
  now apply (@clts_trace_channel_compliant LocalState T).
  exact H_fin. 
  destruct H_inf as [rho_inf H_inf].
  apply infinite_possible_run_means_finite_possible_run_prefix in H_inf.
  destruct H_inf as [rho_fin [H_possible H_pref]].
  eapply channel_compliant_I_non_empty_implies_prefix. 
  unfold GCLTS in H_GCLTS; tauto.
  now apply (@clts_trace_channel_compliant LocalState T).
  exact H_possible.
Qed. 

Lemma protocol_language_includes_canonical_implementation :
  forall (S : @LTS SyncAlphabet State) (T : CLTS),
    GCLTS S ->
    @NMC State S ->
    @RCC State S ->
    @SCC State S -> 
    canonical_implementation S T ->
    @protocol_includes_clts_language State LocalState S T.
Proof.
  intros S T H_GCLTS H_NMC H_RCC H_SCC H_canonical.
  assert (H_df : deadlock_free S). { unfold GCLTS in *; tauto. } 
  split; intros w H_word.
  - (* Finite case *)
    assert (H_useful := canonical_implementation_finite_maximal_word_exists_finite_possible_run S T w H_GCLTS H_NMC H_RCC H_SCC H_canonical H_word). 
    destruct H_useful as [rho_fin [H_possible H_complete]].
    exists rho_fin.
    split.
    { unfold finite_possible_run in H_possible. tauto. }
    split.
    assumption.
    assert (H_trace_w : @is_clts_trace LocalState T w). 
    {
      destruct H_word as [c [H_reach H_final]].
      exists c. tauto.
    }
    eapply clts_trace_channel_compliant.
    exact H_trace_w.
  - (* Infinite case *)
    (* Need to prove that s is an infinite protocol word *) 
    intro i.
    assert (H_useful := protocol_prefixes_include_canonical_implementation_prefixes S T H_GCLTS H_NMC H_RCC H_SCC H_canonical).
    spec H_useful (stream_to_list w i). 
    spec H_useful. spec H_word i. assumption.
    apply protocol_prefix_exists_possible_run_prefix in H_useful.
    destruct H_useful as [rho_fin [H_possible_rho_fin H_pref_rho_fin]].
    assert (H_useful := possible_run_prefix_channel_compliant_word_extension S (stream_to_list w i) rho_fin).
    spec H_useful. 
    {
      spec H_word i.
      destruct H_word as [c H_reach].
      eapply clts_trace_channel_compliant.
      exists c. exact H_reach.
    }
    spec H_useful.
    split. assumption.
    assumption. 
    destruct H_useful as [v [H_cc_uv H_role_eq_uv]].
    exists rho_fin, v. split. eapply deadlock_free_lts_trace_prefix_iff. assumption.
    assumption. split. 
    assumption.
    assumption.
    tauto. 
Qed.

Lemma per_role_identical_nil_word_inv :
  forall (rho : FinSyncWord),
    per_role_identical [] (split rho) ->
    rho = []. 
Proof.
  intros rho H_role.
  destruct rho as [|a rho]. reflexivity.
  simpl in H_role.
  destruct a as [a H_neq].
  destruct a as [p q m].
  spec H_role p.
  simpl in H_role.
  rewrite wproj_symbol_sender_eq in H_role.
  reflexivity. inversion H_role.
Qed.

Lemma per_role_identical_nil_run_inv :
  forall (w : FinAsyncWord),
    per_role_identical w [] -> 
    w = []. 
Proof.
  intros w H_role.
  destruct w. reflexivity.
  simpl in H_role.
  destruct a as [a H_neq].
  destruct a as [p q m | p q m].
  spec H_role p.
  simpl in H_role.
  rewrite wproj_symbol_sender_eq in H_role.
  reflexivity. inversion H_role.
  spec H_role q.
  simpl in H_role.
  rewrite wproj_symbol_receiver_eq in H_role.
  reflexivity. inversion H_role.
Qed.

Lemma per_role_identical_prefix_exists_per_role_identical_suffix :
  forall (rho : FinSyncWord) (w : FinAsyncWord) (alpha beta : FinSyncWord),
    per_role_identical w (split rho) -> 
    alpha ++ beta = rho ->
    exists (w' : FinAsyncWord),
      per_role_identical w' (split alpha). 
Proof.
  intros rho w alpha beta H_role_w H_split_rho.
  generalize dependent rho.
  generalize dependent beta. 
  generalize dependent w.
  (* We instead rather want to prove this by induction on w! *)
  induction alpha as [|a alpha' IHalpha'] using rev_ind; intros.
  - exists []. easy. 
  (* apply per_role_identical_nil_word_inv in H_role_w. *)
    (* subst. *)
    (* exists [].  *)
    (* apply app_nil in H_split_rho. *)
    (* destruct H_split_rho. subst. *)
    (* easy. *)
  - spec IHalpha' w ([a] ++ beta) rho.
    spec IHalpha' H_role_w.
    spec IHalpha'.
    now rewrite <- app_assoc in H_split_rho.
    destruct IHalpha' as [w' H_role_w'].
    destruct a as [a H_neq].
    destruct a as [p q m].
    assert (H_neq_snd : sender_receiver_neq_async (Snd p q m)) by easy.
    assert (H_neq_rcv : sender_receiver_neq_async (Rcv p q m)) by easy.
    exists (w' ++ [exist _ (Snd p q m) H_neq_snd] ++ [exist _ (Rcv p q m) H_neq_rcv]).
    intros p0.
    destruct (classic (p0 = p \/ p0 = q)).
    destruct H.
    subst p0.
    clean.
    rewrite wproj_symbol_sender_eq. reflexivity.
    rewrite wproj_symbol_receiver_neq. easy.
    spec H_role_w' p.
    rewrite H_role_w'.
    apply app_inv_head_iff.
    rewrite app_nil_r.
    rewrite wproj_symbol_sender_eq. reflexivity.
    rewrite wproj_symbol_receiver_neq. easy.
    rewrite app_nil_r. f_equal. sigma_equal.
    subst p0.
    clean.
    rewrite wproj_symbol_sender_neq. easy. 
    rewrite wproj_symbol_receiver_eq. reflexivity. 
    spec H_role_w' q.
    rewrite H_role_w'.
    apply app_inv_head_iff.
    rewrite wproj_symbol_sender_neq. easy. 
    rewrite wproj_symbol_receiver_eq. reflexivity. 
    unnil. f_equal. f_equal. sigma_equal.
    clean.
    apply not_or_and in H.
    rewrite wproj_symbol_sender_neq. easy. 
    rewrite wproj_symbol_receiver_neq. easy.
    rewrite wproj_symbol_sender_neq. easy. 
    rewrite wproj_symbol_receiver_neq. easy.
    unnil. spec H_role_w' p0.
    rewrite H_role_w'.
    rewrite app_nil_r. 
    reflexivity.
Qed.

Lemma per_role_identical_means_channel_complete :
  forall (rho : FinSyncWord) (w : FinAsyncWord),
    per_role_identical w (split rho) ->
    channel_complete w.  
Proof.
  intros rho w H_role.
  (* Proving channel completeness directly *) 
  { assert (H_helper := split_word_channel_complete rho). 
    intros p q H_neq.
    spec H_helper p q H_neq.
    rewrite mproj_rcv_wproj_idempotent.
    rewrite mproj_snd_wproj_idempotent.
    assert (H_role_p := H_role p). 
    assert (H_role_q := H_role q).
    rewrite H_role_p H_role_q.
    rewrite <- mproj_rcv_wproj_idempotent.
    rewrite <- mproj_snd_wproj_idempotent.
    assumption.
  }
Qed. 

Lemma canonical_implementation_deadlock_free :
  forall (S : @LTS SyncAlphabet State) (T : @CLTS LocalState),
    GCLTS S ->
    @NMC State S ->
    @RCC State S ->
    @SCC State S -> 
    canonical_implementation S T ->
    @clts_deadlock_free LocalState T. 
Proof. 
  intros S T H_GCLTS H_NMC H_RCC H_SCC H_canonical.
  intros c_w w H_reach.
  (* Deadlock freedom asks us to show that every CLTS trace has a maximal extension to either a finite or infinite word *) 
  (* We know that w is a trace of T *)
  (* From the prefix inclusion property we know that w is a protocol prefix *) 

  (* And thus w has either a finite or infinite maximal extension *)
  (* Because all protocol words are canonical CLTS words *)
  (* We are done *)
  assert (H_useful := protocol_prefixes_include_canonical_implementation_prefixes).
  spec H_useful S T H_GCLTS H_NMC H_RCC H_SCC H_canonical w.
  spec H_useful.
  { now exists c_w. }
  assert (H_useful2 := @canonical_implementation_language_includes_protocol_language State LocalState).
  spec H_useful2 S T H_canonical.
  destruct H_useful as [H_fin | H_inf].
  destruct H_fin as [w_fin [H_word H_pref]].
  left. exists w_fin. split.
  destruct H_useful2 as [H_useful _].
  spec H_useful w_fin.
  now apply H_useful. 
  assumption.
  destruct H_inf as [w_inf [H_word H_pref]].
  right. exists w_inf.
  split.
  destruct H_useful2 as [_ H_useful].
  spec H_useful w_inf.
  now apply H_useful.
  assumption.
Qed. 

End Soundness. 

Theorem soundness_helper :
  forall {State LocalState : Type} (S : @LTS SyncAlphabet State) (T: CLTS),
    GCLTS S -> 
    @NMC State S ->
    @RCC State S ->
    @SCC State S ->
    canonical_implementation S T ->
    @implements State LocalState S T. 
Proof.
  intros.
  split.
  split.
  now apply canonical_implementation_language_includes_protocol_language. 
  now apply protocol_language_includes_canonical_implementation.
  now apply canonical_implementation_deadlock_free with S.
Qed. 

Theorem soundness :
  forall {State : Type} (S : @LTS SyncAlphabet State),
    GCLTS S -> 
    @NMC State S ->
    @RCC State S ->
    @SCC State S ->
    exists {LocalState : Type} (T : CLTS), 
      @implements State LocalState S T. 
Proof.
  intros.
  assert (H_witness := @canonical_implementation_exists State).
  spec H_witness S. 
  destruct H_witness as [T H_canonical].
  unfold GCLTS in H. easy. exists (State -> Prop), T.
  now apply soundness_helper.
Qed. 



