Require Import List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq 
  Require Import ssreflect.
         
From CC 
  Require Import lib structures clts lts channel_complete channel_compliant protocol closure_conditions run nmc_completeness.

Section SCC_Completeness.

  Context {State : Type} {LocalState : Type}.

Lemma SCC_completeness_helper :
  forall (S : LTS)
    (H_GCLTS : GCLTS S)
    (s1 s2 : State)
    (p q : participant)
    (m : message)
    (H_neq : sender_receiver_neq_sync (Event p q m))
    (H_transition1 : transition S s1 (Event p q m ↾ H_neq) s2)
    (s3 : State)
    (u_p : FinAsyncWord)
    (w1 : FinSyncWord)
    (H_reach1 : @Reachable SyncAlphabet State S (s0 S) w1 s1)
    (H_proj1 : wproj (split w1) (sender_sync (Event p q m ↾ H_neq)) = u_p)
    (w2 : FinSyncWord)
    (H_reach2 : @Reachable SyncAlphabet State S (s0 S) w2 s3)
    (H_proj2 : wproj (split w2) (sender_sync (Event p q m ↾ H_neq)) = u_p)
    (H_contra : ∀ s2' : State,
        ¬ @reachable_for_on State S (sender_sync (Event p q m ↾ H_neq)) s3 s2'
          (wproj (split_symbol (Event p q m ↾ H_neq))
             (sender_sync (Event p q m ↾ H_neq))))
    (T : CLTS)
    (H_df : clts_deadlock_free T)
    (H_impl_copy : @implements State LocalState S T)
    (rho_false : FinSyncWord)
    (H_run_rho_false : @is_trace SyncAlphabet State S rho_false)
    (H_possible_rho_false : ∀ p0 : participant,
        wproj (split w2 ++ [Snd p q m ↾ H_neq]) p0
          `prefix_of` wproj (split rho_false) p0),
    False. 
Proof.
  intros.
  assert (H_useful := split_run_finite_possible_run_prefix S rho_false w2 H_GCLTS H_run_rho_false).
  spec H_useful.
  exists s3. exact H_reach2.
  spec H_useful.
  { 
    intro p0.
    spec H_possible_rho_false p0.
    rewrite wproj_app in H_possible_rho_false. 
    apply prefix_app_l in H_possible_rho_false.
    assumption. }
  (* Now we find a contradiction to H_contra by splitting rho_false according to split w2 ++ [Snd p q m ↾ H_neq] for p, to obtain a state to instantiate s2' with *) 
  assert (H_unique_split := prefix_app_finite_unique_splitting_elaborate). 
  spec H_unique_split rho_false (wproj (split w2) p).
  assert (H_neq_snd : sender_receiver_neq_async (Snd p q m)) by easy.
  spec H_unique_split (Snd p q m ↾ H_neq_snd) p.
  spec H_unique_split.
  spec H_possible_rho_false p.
  rewrite wproj_app in H_possible_rho_false.
  assert (H_rewrite : Snd p q m ↾ H_neq_snd = Snd p q m ↾ H_neq) by sigma_equal.
  rewrite H_rewrite.
  rewrite <- (wproj_sender_eq p q p m). 
  2 : reflexivity.
  assumption.
  destruct H_unique_split as [alpha [y [beta [H_unique_split [H_max_alpha H_about_y]]]]].
  assert (H_trace_alphay : @is_trace SyncAlphabet State S (alpha ++ [y])).
  { eapply lts_trace_prefix_closed.
    destruct H_run_rho_false as [s_rho_false H_reach_s_rho_false]. 
    exists s_rho_false. exact H_reach_s_rho_false.
    rewrite H_unique_split.
    rewrite app_assoc.
    now apply prefix_app_r. }
  destruct H_trace_alphay as [s_alphay H_reach_alphay].
  (* We want to instantiate s2' with s_alphay *)
  spec H_contra s_alphay.
  apply H_contra.
  (* Because alpha is the maximal prefix for p, it may be the case that alpha <= w2 *)
  (* However it cannot be the case that w2 <= alpha *)
  (* We can thus establish that w2 <= alpha *)
  assert (H_pref_w2_alpha : prefix w2 alpha).
  {
    assert (H_or := prefix_weak_total alpha w2 rho_false).
    spec H_or. { rewrite H_unique_split. now apply prefix_app_r. }
    spec H_or H_useful. destruct H_or. 
    2 : assumption.
    (* In the case that alpha <= w2, we need to prove a contradiction *) 
    destruct H_max_alpha as [H_pref_alpha [H_role_eq H_max_alpha]].
    spec H_max_alpha w2 H_useful.
    spec H_max_alpha. 
    now rewrite wproj_idempotent. 
    assumption. }
  (* First simplifying the goal *) 
  simpl. 
  unfold sender_sync, receiver_sync, value_sync; simpl.
  unfold wproj_symbol; simpl.
  rewrite participant_eqb_refl. simpl.
  replace (participant_eqb q p) with false. simpl.
  2 : symmetry; now apply participant_eqb_no.
  unfold reachable_for_on.
  (* Now we want to find a synchronous run segment following w2 such that p's projection in the run segment is Snd p q m *) 
  apply prefix_exists_suffix in H_pref_w2_alpha.
  destruct H_pref_w2_alpha as [w2_suf H_pref_w2_alpha].
  exists (w2_suf ++ [y]). 
  (* w2_suf may be empty, in which case alpha = w2 *)
  (* But regardless we can show the required local reachability for p on Snd p q *)
  apply Reachable_unwind in H_reach_alphay.
  destruct H_reach_alphay as [s_alpha [H_reach_alpha H_goal]].
  rewrite H_pref_w2_alpha in H_reach_alpha.
  apply Reachable_app_inv in H_reach_alpha. 
  destruct H_reach_alpha as [s3' [H_reach_w2 H_reach_w2_suf]].
  assert (H_eq_s3 : s3' = s3).
  { eapply (deterministic_word S).
    unfold GCLTS in H_GCLTS. tauto.
    exact H_reach_w2.
    exact H_reach2. }
  subst.
  split. 
  apply Reachable_app with s_alpha.
  assumption.
  rewrite <- (app_nil_l [y]).
  apply Reachable_step with s_alpha. 
  apply Reachable_refl.
  assumption.
  rewrite wproj_split_app. 
  rewrite H_about_y.
  (* The remaining one is easy enough, just need to show that w2_suf has no actions by p since w2 already contained all the actions and alpha is the maximal run *)
  enough (H_empty : wproj (split w2_suf) p = []).
  rewrite H_empty.
  rewrite app_nil_l.
  f_equal. sigma_equal.
  { destruct (classic (wproj (split w2_suf) p = [])). 
    assumption.
    exfalso. 
    remember (wproj (split w2_suf) p) as l. 
    destruct l as [| hd tl].
    contradiction. clear H.
    assert (H_in_l := in_wproj_means_eq).
    spec H_in_l (split w2_suf) p hd.
    spec H_in_l. rewrite <- Heql.
    apply in_eq.
    destruct H_max_alpha as [H_pref [H_eq_p H_max_alpha]]. 
    destruct hd as [hd H_neq_hd]. 
    destruct hd as [p0 q0 m0 | p0 q0 m0].
    * simpl in H_in_l.
      unfold wproj_symbol in H_in_l; simpl in H_in_l.
      destruct (participant_eqb p0 p).
      simpl in H_in_l.
      rewrite wproj_split_app in H_eq_p.
      rewrite <- Heql in H_eq_p.
      rewrite wproj_idempotent in H_eq_p.
      rewrite <- app_nil_r in H_eq_p at 1.
      apply app_inv_head in H_eq_p.
      inversion H_eq_p. simpl in H_in_l.
      inversion H_in_l.
    * simpl in H_in_l.
      unfold wproj_symbol in H_in_l; simpl in H_in_l.
      destruct (participant_eqb q0 p).
      simpl in H_in_l.
      rewrite wproj_split_app in H_eq_p.
      rewrite <- Heql in H_eq_p.
      rewrite wproj_idempotent in H_eq_p.
      rewrite <- app_nil_r in H_eq_p at 1.
      apply app_inv_head in H_eq_p.
      inversion H_eq_p. simpl in H_in_l.
      inversion H_in_l. } 
Qed. 

Lemma SCC_completeness :
  forall (S : @LTS SyncAlphabet State),
    GCLTS S -> 
    ~ @SCC State S ->
    ~@implementable State LocalState S.  
Proof.
  intros S H_GCLTS H_SCC.
  assert (H_df_copy : deadlock_free S). { unfold GCLTS in *; tauto. } 
  apply neg_SCC_iff in H_SCC.
  destruct H_SCC as [s1 [s2 [l [H_transition1 [s3 [H_sim_reach H_contra]]]]]].
  destruct H_sim_reach as [u_p [H_reach_s1 H_reach_s3]].
  intro H_impl.
  unfold implementable in H_impl. 
  destruct H_impl as [T H_impl].
  assert (H_impl_copy := H_impl). 
  destruct H_impl as [[H_incl1 H_incl2] H_df].
  (* Now we need to construct a prefix to use the sufficient fact about completeness *) 
  assert (H_suf := completeness_sufficiency_fact S T).
  destruct H_reach_s1 as [w1 [H_reach1 H_proj1]].
  destruct H_reach_s3 as [w2 [H_reach2 H_proj2]].  
  (* Need fact about every reachable state leading to a maximal run *)
  assert (H_key : exists (w : FinAsyncWord), @is_clts_trace LocalState T w /\ ~ I_set_non_empty S w).
  { (* Constructing the witness immediately *)
    destruct l as [l H_neq].
    destruct l as [p q m].
    exists (split w2 ++ [exist _ (Snd p q m) H_neq]).
    split.
    (** First obligation is that our witness is a CLTS trace **)
    apply clts_trace_snd_extension_sufficient. 
    (* It is sufficient to show that (split w2) is a CLTS trace
       and that the send extension is a local trace for p *)
    (* Showing that (split w2) is a CLTS trace *) 
    assert (H_helper := @deadlock_free_clts_trace_prefix_iff LocalState T (split w2) H_df).
    rewrite H_helper. clear H_helper. 
    eapply protocol_fidelity_means_prefixes_eq in H_impl_copy.
    apply H_impl_copy.
    eapply split_run_protocol_prefix.
    unfold GCLTS in H_GCLTS. tauto.
    exact H_reach2.
    (* Showing that (wproj (split w2) p ++ [Snd p q m ↾ H_neq]) is a T_p trace *)
    (* Step 1 : (split w1) ++ [Snd p q m ↾ H_neq] is a protocol prefix *)
    (* Step 2 : (split w1) ++ [Snd p q m ↾ H_neq] is trace of implementation T *) 
    (* Step 3 : wproj (split w1) p ++ [Snd p q m ↾ H_neq] is a trace of T_p *)
    (* Step 4 : wproj (split w2) p ++ [Snd p q m ↾ H_neq] is a trace of T_p *) 
    assert (H_step1 : @is_protocol_prefix State S  (split w1 ++ [Snd p q m ↾ H_neq])).  
    {
      assert (H_inter1 : @is_trace SyncAlphabet State S (w1 ++ [(Event p q m ↾ H_neq)])).
      { exists s2.
        now apply Reachable_step with s1.
      } 
      destruct H_inter1 as [s_w1x1 H_reach_w1x1].
      destruct H_GCLTS as [_ [_ [_ [H_df_S _]]]].
      spec H_df_S s_w1x1 (w1 ++ [Event p q m ↾ H_neq]) H_reach_w1x1.
      (** Case analysis based on whether w1x1 comes from a finite or infinite run **)
      destruct H_df_S as [H_fin | H_inf].
      (* For each case, we need to provide a witness of either a finite or infinite run, and also show the prefix relation *) 
      - destruct H_fin as [run_fin [H_max H_pref]].
        left. exists (split run_fin). split.
        now apply split_finite_run_is_finite_word. 
        apply prefix_split_prefix_iff in H_pref.
        rewrite split_app in H_pref. 
        unfold split at 2 in H_pref.
        unfold split_symbol in H_pref.
        simpl in H_pref.
        unfold sender_sync, receiver_sync, value_sync in H_pref.
        simpl in H_pref.
        apply prefix_app_l with [Rcv p q m ↾ H_neq].
        rewrite <- app_assoc. simpl.
        assumption. 
      - destruct H_inf as [run_inf [H_max H_pref]].
        right. exists (split_inf run_inf). split.
        now apply split_infinite_run_is_infinite_word.
        destruct H_pref as [i H_pref].
        (* w1 is length (i-1), and (Event p q m) is the ith element in run_inf *)
        (* First we establish that i >= 1 *) 
        destruct i. 
        rewrite stream_to_list_zero in H_pref.
        symmetry in H_pref.
        apply app_eq_nil in H_pref.
        destruct H_pref as [_ H_pref]. inversion H_pref.
        exists (Datatypes.S (2*i)).
        assert (H_useful : stream_to_list run_inf i = w1 /\ Str_nth i run_inf = (Event p q m ↾ H_neq)).
        { assert (H_inter := stream_to_list_S_Str_nth_app SyncAlphabet i run_inf).
          rewrite H_inter in H_pref.
          apply app_inj_2 in H_pref.
          split. tauto.
          destruct H_pref as [_ H_x].
          inversion H_x. reflexivity.
          easy. }
        rewrite stream_to_list_S_Str_nth_app.
        destruct H_useful as [H_w1 H_x1].
        rewrite <- H_w1. 
        rewrite split_inf_inf_split.
        rewrite app_inv_head_iff.  
        f_equal.
        assert (H_helper := Str_nth_split_inf_inf_split run_inf i p q m H_neq H_neq H_neq H_x1).
        tauto. 
    }
    assert (H_step2 : @is_clts_trace LocalState T  (split w1 ++ [Snd p q m ↾ H_neq])).
    {
      apply (protocol_fidelity_means_prefixes_eq S T (split w1 ++ [Snd p q m ↾ H_neq])) in H_impl_copy. 
      apply H_impl_copy in H_step1.
      now apply deadlock_free_clts_trace_prefix_iff.
    }
    assert (H_step3 : @is_trace AsyncAlphabet LocalState (implementations T p) (wproj (split w1) p ++ [Snd p q m ↾ H_neq])).
    {
      rewrite <- (wproj_sender_eq p q p m). 
      2 : reflexivity.
      rewrite <- wproj_app.
      destruct H_step2 as [c H_step2].
      assert (H_useful := @clts_trace_participant_projection LocalState T). 
      spec H_useful (split w1 ++ [Snd p q m ↾ H_neq]) c H_step2 p.
      exists (get_local_state c p).
      assumption.
    }
    rewrite H_proj2. 
    rewrite H_proj1 in H_step3.
    assumption.
    (** Second obligation is that the intersection set is empty **)
    (* We show by contradiction that if a run exists, then p cannot be compliant with it *) 
    intro H_false.
    destruct H_false as [H_false_fin | H_false_inf].
    (* Case split on whether the run in the intersection set is a finite or infinite run *)
    * destruct H_false_fin as [rho_false [H_max_rho_false H_possible_rho_false]].
      assert (H_useful := SCC_completeness_helper S H_GCLTS s1 s2 p q m H_neq H_transition1 s3 u_p w1 H_reach1 H_proj1 w2 H_reach2 H_proj2 H_contra T H_df H_impl_copy rho_false). 
      spec H_useful.
      { destruct H_max_rho_false as [s_rho [H_run_rho_false _]].
        now exists s_rho. }
      spec H_useful H_possible_rho_false.
      contradiction.
    * destruct H_false_inf as [rho_inf [H_run_rho_inf H_possible_rho_inf]]. 
      assert (H_useful := infinite_possible_run_means_finite_possible_run_prefix S rho_inf (split w2 ++ [Snd p q m ↾ H_neq])).
      spec H_useful.
      { split. assumption. exact H_possible_rho_inf. }
      destruct H_useful as [rho_false [H_run_rho_false H_possible_rho_false]].
      assert (H_useful := SCC_completeness_helper S H_GCLTS s1 s2 p q m H_neq H_transition1 s3 u_p w1 H_reach1 H_proj1 w2 H_reach2 H_proj2 H_contra T H_df H_impl_copy rho_false).
      spec H_useful.
      {
        unfold possible_run_prefix in H_run_rho_false.
        tauto.
      }
      spec H_useful.
      {
        unfold possible_run_prefix in H_run_rho_false.
        tauto.
      } 
      contradiction. }
  (* Grand finale *)
  destruct H_key as [v [H_trace_v H_I_v_empty]].
  spec H_suf v H_GCLTS.
  spec H_suf.
  now apply deadlock_free_clts_trace_prefix_iff.
  spec H_suf H_I_v_empty. 
  contradiction.
Qed. 

End SCC_Completeness. 
