Require Import List Classical Nat Logic Lia FunctionalExtensionality ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq  
Require Import ssreflect. 
         
From CC      
  Require Import lib structures lts clts channel_compliant channel_complete protocol closure_conditions run canonical_implementation nmc_soundness.
      

Section NMC.

Context {State : Type} {LocalState : Type}.
  
Lemma I_set_non_empty_inductive_rcv_rcv_case_sender_neq :
  forall  (S : @LTS SyncAlphabet State)
     (T : @CLTS LocalState)
     (w : FinAsyncWord)
     (H_GCLTS : GCLTS S)
     (H_RCC : @RCC State S)
     (H_canonical : canonical_implementation S T)
     (H_trace_w : @is_clts_trace LocalState T w)
     (rho : FinSyncWord)
     (H_is_run : @is_trace SyncAlphabet _ S rho)
     (H_possible : ∀ p : participant, wproj w p `prefix_of` wproj (split rho) p)
     (p q : participant)
     (m : message)
     (H_neq : sender_receiver_neq_async (Rcv p q m))
     (H_trace_wx : @is_clts_trace LocalState T (w ++ [Rcv p q m ↾ H_neq]))
     (p' : participant)
     (m' : message)
     (H_neq_y : sender_receiver_neq_async (Snd p' q m))
     (suf : list AsyncAlphabet)
     (H_split : wproj (split rho) q = wproj w q ++ [Rcv p' q m' ↾ H_neq_y] ++ suf)
     (H_p' : p' ≠ p),
     False.
Proof.
  intros. assert (H_df : deadlock_free S). { unfold GCLTS in *; tauto. } 
  (* This case we discharge by proving a contradiction to RCC *)
  apply (neg_RCC_iff S). 
  2 : exact H_RCC.
  (* Obtaining s1 and s2, which come from the fact that wproj wx q is a trace in T_q *)
  (* From wproj wx q we obtain a run prefix from S *) 
  (* From the run prefix we obtain the two transitions *)
  (* Establishing that wproj w q is a trace in T_q *)  
  assert (H_local_prefix_w : @is_trace AsyncAlphabet LocalState (implementations T q) (wproj w q)).   
  { destruct H_trace_w as [c_w H_reach_w].
    exists (get_local_state c_w q).
    eapply clts_trace_participant_projection. 
    exact H_reach_w.
  } 
  destruct H_local_prefix_w as [s_w_q H_reach_s_w_q].
  (* Establishing that wproj w q ++ [x] is a trace in T_q *) 
  assert (H_local_prefix_wx : @is_trace AsyncAlphabet LocalState (implementations T q) (wproj w q ++ [Rcv p q m ↾ H_neq])).   
  { destruct H_trace_wx as [c_wx H_reach_wx].
    exists (get_local_state c_wx q).
    replace [Rcv p q m ↾ H_neq] with (wproj [Rcv p q m ↾ H_neq] q).
    rewrite <- wproj_app.
    eapply clts_trace_participant_projection. 
    exact H_reach_wx.
    now apply wproj_receiver_eq.  }
  destruct H_local_prefix_wx as [s_wx_q H_reach_s_wx_q].
  (* Establishing the existence of a run and transition for wproj wx q *)
  assert (H_useful := @canonical_implementation_local_transition_means_global_transition State LocalState).  
  spec H_useful S T (wproj w q) (Rcv p q m ↾ H_neq) q s_w_q s_wx_q. spec H_useful H_df H_canonical.
  spec H_useful H_reach_s_w_q H_reach_s_wx_q. 
  destruct H_useful as [s1 [s2 [rho_w [H_reach_rho_w [H_role_eq_rho_w H_transition_s1_s2]]]]].
  (* Instantiating s1, s2 *)
  exists s1, s2.
  (* Obtaining s1' and s2', which come from rho directly *)
  assert (H_split' := prefix_app_finite_unique_splitting_elaborate rho (wproj w q) (Rcv p' q m' ↾ H_neq_y) q).
  spec H_split'. 
  { rewrite H_split.
    rewrite app_assoc.
    now apply prefix_app_r. }
  destruct H_split' as [alpha [y [beta [H_split_rho [H_max_alpha H_about_y]]]]].  
  assert (H_reach_alpha : @is_trace SyncAlphabet State S alpha).
  { eapply lts_trace_prefix_closed.
    destruct H_is_run as [s_rho H_reach_s_rho]. 
    exists s_rho.
    exact H_reach_s_rho.
    unfold is_alpha in H_max_alpha. 
    tauto. }
  assert (H_reach_alpha_y : @is_trace SyncAlphabet State S (alpha ++ [async_to_sync (Rcv p' q m' ↾ H_neq_y)])).  
  { eapply lts_trace_prefix_closed.
    destruct H_is_run as [s_rho H_reach_s_rho]. 
    exists s_rho.
    exact H_reach_s_rho.
    rewrite H_split_rho.
    apply wproj_split_symbol_eq_rcv_inv in H_about_y. 
    destruct H_about_y as [H_neq_sync H_about_y].
    unfold async_to_sync. 
    simpl.
    rewrite H_about_y.
    apply prefix_app.
    apply (prefix_app_alt  [Event p' q m' ↾ H_neq_y] [Event p' q m' ↾ H_neq_sync] [] beta).
    f_equal.
    f_equal. apply proof_irrelevance.
    apply prefix_nil. } 
  destruct H_reach_alpha as [s_alpha H_reach_alpha].
  destruct H_reach_alpha_y as [s_alpha_y H_reach_alpha_y].
  eapply lts.Reachable_unwind in H_reach_alpha_y.
  destruct H_reach_alpha_y as [s_alpha' [H_reach_alpha' H_transition_s3_s4]].
  assert (H_rewrite : s_alpha' = s_alpha).
  { apply (deterministic_word S s_alpha' s_alpha alpha). 
    unfold GCLTS in H_GCLTS. tauto.
    assumption. assumption. }
  rewrite H_rewrite in H_transition_s3_s4.
  clear H_rewrite H_reach_alpha'.
  (* Instantiating s3, s4 *)
  exists s_alpha, s_alpha_y. 
  (* Instantiating the transition labels *)
  assert (H_neq_sync : sender_receiver_neq_sync (Event p q m)) by easy.
  apply wproj_split_symbol_eq_rcv_inv in H_about_y. 
  destruct H_about_y as [H_neq_sync' H_about_y].
  exists p, q, p', m, m', H_neq_sync, H_neq_sync'.
  (* Discharging all the conjuncts that are already established *) 
  split.
  unfold async_to_sync in H_transition_s1_s2; simpl in H_transition_s1_s2. 
  assert (H_sync_eq : (Event p q m ↾ H_neq) = (Event p q m ↾ H_neq_sync)).
  { f_equal. apply proof_irrelevance. }
  rewrite <- H_sync_eq. assumption.
  split.
  unfold async_to_sync in H_transition_s3_s4; simpl in H_transition_s3_s4. 
  assert (H_sync_eq' : (Event p' q m' ↾ H_neq_y) = (Event p' q m' ↾ H_neq_sync')).
  { f_equal. apply proof_irrelevance. }
  rewrite H_sync_eq' in H_transition_s3_s4. assumption.
  split.
  lia.
  split.
  (* Showing that s_1 and s_alpha are simultaneously reachable *) 
  exists (wproj w q).
  split.
  unfold reachable_for, reachable_for_on.
  exists rho_w. tauto.
  exists alpha. split. exact H_reach_alpha.
  {
    unfold is_alpha in H_max_alpha.
    destruct H_max_alpha as [_ [H_goal _]].
    rewrite wproj_idempotent in H_goal. 
    symmetry. assumption. }
  
  (* Now finally onto the important part : 
     the way we want to construct w0 is by deleting all symbols in split alpha *)
  assert (H_useful := @possible_run_prefix_exists_possible_run_suffix State).
  (* This lemma needs S to be deterministic *) 
  spec H_useful S (alpha ++ [y] ++ beta) w (alpha ++ [y]) beta s_alpha_y. 
  spec H_useful.
  { unfold GCLTS in H_GCLTS. tauto. }
  spec H_useful.
  { split. 
    rewrite H_split_rho in H_is_run.
    assumption.
    rewrite <- H_split_rho.
    intro p0. now spec H_possible p0.
  }
  spec H_useful.
  { eapply clts_trace_channel_compliant.
    exact H_trace_w. }
  spec H_useful.
  {
    now rewrite <- app_assoc.
  }
  spec H_useful.
  { 
    eapply lts.Reachable_step.
    exact H_reach_alpha.
    simpl in H_transition_s3_s4.
    rewrite H_about_y.
    assert (H_rewrite : Event p' q m' ↾ H_neq_sync' = Event p' q m' ↾ H_neq_y) by sigma_equal. 
    rewrite H_rewrite.
    assumption.
  }
  destruct H_useful as [w' [H_possible_beta_w' [H_cc_w' [H_about_w'_lazy H_about_w'_diligent]]]].
  (* Now we can use the witness given by this lemma *) 
  exists w'. repeat split.
  (* RCC obligation 1 : Showing that w' is a protocol prefix in S' *)
  {
    eapply channel_compliant_I_non_empty_implies_prefix.
    eapply reinitial_S_preserves_deadlock_freedom. 
    { unfold GCLTS in H_GCLTS. tauto. }
    { unfold GCLTS in H_GCLTS. tauto. }
    eapply lts.Reachable_step.
    exact H_reach_alpha.
    exact H_transition_s3_s4.
    exact H_cc_w'.
    exact H_possible_beta_w'. 
  }
  (* RCC obligation 2 : Showing that q has no actions in w' *)
  { 
    spec H_about_w'_lazy q.  
    spec H_about_w'_lazy.
    unfold is_alpha in H_max_alpha.
    rewrite wproj_split_app.
    rewrite wproj_idempotent in H_max_alpha.
    replace (wproj (split alpha) q) with (wproj w q) by tauto.
    now apply prefix_app_r. assumption.
  }
  (* RCC obligation 3: showing a relationship between mproj_rcv w' p q and mproj_snd w' p q *)
  {
    (* First establishing a relation between mproj_rcv w p q and mproj_snd w p q *) 
    destruct H_trace_w as [c_w H_reach_w]. 
    assert (H_chan := about_clts_trace_configuration_channel_contents _ _ H_reach_w p q H_neq).
    destruct H_trace_wx as [c_wx H_reach_wx]. 
    apply Reachable_unwind in H_reach_wx.
    destruct H_reach_wx as [c_w' [H_reach_w' H_step_w_wx]].
    assert (H_det := deterministic_clts T w c_w c_w' H_reach_w H_reach_w').
    rewrite <- H_det in H_step_w_wx.
    clear H_reach_w' H_det c_w'.
    destruct H_step_w_wx as [H_false | [_ H_step_w_wx]].
    destruct H_false as [H_false _]; inversion H_false.
    assert (H_step_w_wx_chan := H_step_w_wx).
    destruct H_step_w_wx_chan as [_ [_ H_step_w_wx_chan]].
    destruct H_step_w_wx_chan as [_[chan_w_rest H_step_w_wx_chan]].
    simpl in H_step_w_wx_chan.
    destruct H_step_w_wx_chan as [H_chan_w H_chan_wx].
    rewrite H_chan_w in H_chan.
    (* Now reasoning our way to the new relationship between mproj_rcv w' p q and mproj_snd w' p q *)
    (* First we establish that all of the receptions between q and p in w are those in alpha *) 
    assert (H_step1 : mproj_rcv w p q = mproj_rcv (split alpha) p q).  
    { 
      rewrite mproj_rcv_wproj_idempotent.
      unfold is_alpha in H_max_alpha.
      rewrite wproj_idempotent in H_max_alpha.
      replace (wproj w q) with (wproj (split alpha) q) by (symmetry; tauto). 
      rewrite <- mproj_rcv_wproj_idempotent.
      reflexivity. }
    (* Next we establish that the receptions and sends in alpha match up *) 
    assert (H_step2 : mproj_rcv (split alpha) p q = mproj_snd (split alpha) p q) by now apply split_word_channel_complete.
    rewrite H_step1 in H_chan.
    rewrite H_step2 in H_chan.
    (* Using H_about_w'_diligent_p *)
    spec H_about_w'_diligent p.
    spec H_about_w'_diligent.
    { rewrite H_about_y. 
      clean.
      rewrite wproj_symbol_sender_neq. easy.
      rewrite wproj_symbol_receiver_neq. easy.
      do 2 rewrite app_nil_r.
      (* Just need that p's alpha is longer *)
      assert (H_useful := @channel_non_empty_means_longer_compliant_prefix State LocalState T).
      spec H_useful w c_w p q m chan_w_rest H_reach_w.   
      spec H_useful. easy.
      spec H_useful H_chan_w.
      spec H_useful S rho. 
      assert (H_alpha_p := finite_unique_splitting rho w p).
      spec H_alpha_p (H_possible p).
      destruct H_alpha_p as [alpha_p H_alpha_p].
      spec H_useful alpha_p alpha H_is_run H_alpha_p.
      spec H_useful.
      { unfold is_alpha in H_max_alpha. 
        split. tauto. split.
        rewrite wproj_idempotent in H_max_alpha.
        tauto. rewrite wproj_idempotent in H_max_alpha. tauto. }
      replace (wproj w p) with (wproj (split alpha_p) p).
      2 : { unfold is_alpha in H_alpha_p.
            symmetry. tauto. }
      destruct H_useful as [H_goal H_pq_neq].
      apply prefix_split_prefix_iff in H_goal.
      apply (wproj_preserves_prefix _ _ p) in H_goal. assumption.
    } 
    assert (H_step3 : mproj_snd (wproj w p) p q =
                        mproj_snd (wproj (split (alpha ++ [y])) p ++
                        wproj w' p) p q). 
    { rewrite H_about_w'_diligent. reflexivity. }
    (* Massaging H_step3 into shape *) 
    rewrite <- mproj_snd_wproj_idempotent in H_step3.
    rewrite mproj_snd_app in H_step3.
    rewrite wproj_split_app in H_step3.
    rewrite H_about_y in H_step3.
    clean H_step3. rewrite wproj_symbol_sender_neq in H_step3.
    easy. rewrite wproj_symbol_receiver_neq in H_step3.
    easy. unnil H_step3.
    rewrite <- mproj_snd_wproj_idempotent in H_step3.
    rewrite <- H_chan in H_step3.
    apply app_inv_head_iff in H_step3.
    rewrite <- mproj_snd_wproj_idempotent in H_step3.
    rewrite <- H_step3.
    spec H_about_w'_lazy q. 
    spec H_about_w'_lazy.
    {
      unfold is_alpha in H_max_alpha.
      rewrite wproj_idempotent in H_max_alpha.
      destruct H_max_alpha as [_ [H_rewrite _]].
      rewrite H_rewrite.
      rewrite wproj_split_app.
      now apply prefix_app_r.
    }
    rewrite mproj_rcv_wproj_idempotent. rewrite H_about_w'_lazy.
    simpl. apply singleton_prefix_cons.
    } 
Qed.

Lemma I_set_non_empty_inductive_rcv_rcv_case_message_neq :
  forall  (S : @LTS SyncAlphabet State)
     (T : @CLTS LocalState)
     (w : FinAsyncWord)
     (H_GCLTS : GCLTS S)
     (H_NMC : @NMC State S)
     (H_canonical : canonical_implementation S T)
     (H_trace_w : @is_clts_trace LocalState T w)
     (rho : FinSyncWord)
     (H_is_run : @is_trace SyncAlphabet State S rho)
     (H_possible : ∀ p : participant, wproj w p `prefix_of` wproj (split rho) p)
     (p q : participant)
     (m : message)
     (H_neq : sender_receiver_neq_async (Rcv p q m))
     (H_trace_wx : @is_clts_trace LocalState T (w ++ [Rcv p q m ↾ H_neq]))
     (m' : message)
     (H_neq_y : sender_receiver_neq_async (Rcv p q m'))
     (suf : list AsyncAlphabet)
     (H_split : wproj (split rho) q = wproj w q ++ [Rcv p q m' ↾ H_neq_y] ++ suf)
     (run_q : FinSyncWord)
     (H_max_run_q : is_alpha rho run_q w q)
     (H_m' : m' ≠ m),
     False.
Proof.
  intros.
  (* In the case that x and y only disagree on message value, contradiction to the fact that rho_q < rho_p *)
  (* The argument is basically a sequence of equational rewrites *)
  (* (1) m is at the head of get_channel_contents c_w p q *) 
  destruct H_trace_w as [c_w H_reach_w].
  assert (H_chan := about_clts_trace_configuration_channel_contents _ _ H_reach_w p q H_neq).
  destruct H_trace_wx as [c_wx H_reach_wx]. 
  apply Reachable_unwind in H_reach_wx.
  destruct H_reach_wx as [c_w' [H_reach_w' H_step_w_wx]].
  assert (H_det := deterministic_clts T w c_w c_w' H_reach_w H_reach_w').
  rewrite <- H_det in H_step_w_wx.
  clear H_reach_w' H_det c_w'.
  destruct H_step_w_wx as [H_false | [_ H_step_w_wx]].
  destruct H_false as [H_false _]; inversion H_false.
  assert (H_step_w_wx_chan := H_step_w_wx).
  destruct H_step_w_wx_chan as [_ [_ H_step_w_wx_chan]].
  destruct H_step_w_wx_chan as [_[chan_w_rest H_step_w_wx_chan]].
  simpl in H_step_w_wx_chan.
  destruct H_step_w_wx_chan as [H_chan_w H_chan_wx].
  rewrite H_chan_w in H_chan. 
  (* H_chan is (1) *) 
  (* (2) rho_q < rho_p *)
  assert (H_max_run_p := finite_unique_splitting rho w p (H_possible p)).
  destruct H_max_run_p as [run_p H_max_run_p].
  Locate channel_non_empty_means_longer_compliant_prefix. 
  assert (H_helper := channel_non_empty_means_longer_compliant_prefix T w c_w p q m chan_w_rest H_reach_w H_neq H_chan_w S rho). 
  spec H_helper run_p run_q.
  spec H_helper.
  { unfold is_finite_maximal_run in H_is_run.
    destruct H_is_run as [s_run H_reach_s_run].
    exists s_run. tauto. }
  spec H_helper H_max_run_p H_max_run_q.
  destruct H_helper as [H_pref_q_p H_neq_p_q].
  destruct H_max_run_p as [H_pref_run_p [H_eq_run_p H_max_run_p]].
  assert (H_max_run_q_copy := H_max_run_q). 
  destruct H_max_run_q as [H_pref_run_q [H_eq_run_q H_max_run_q]].
  apply prefix_exists_suffix in H_pref_run_q. 
  destruct H_pref_run_q as [run_q_suf H_pref_run_q].
  destruct run_q_suf as [|run_q_next run_q_suf].
  { (* Discharging the case where run_q_suf is empty *)
    rewrite app_nil_r in H_pref_run_q.
    rewrite H_pref_run_q in H_pref_run_p.
    apply (symmetric_prefix_means_eq _ _ H_pref_run_p) in H_pref_q_p.
    contradiction. }
  (* Now we have peeled out the next event in rho after rho_q, run_q_next *)
  (* From H_chan, and the max runs rho_p and rho_q, it follows that 
     mproj_rcv (split rho_q) p q ++ [m'] ++ mproj_rcv suf p q = mproj_snd (split rho_p) p q *)
  assert (H_step1 : mproj_rcv (split run_q) p q ++ [m] ++ chan_w_rest = mproj_snd (split run_p) p q).
  {
    rewrite mproj_rcv_wproj_idempotent.
    rewrite <- H_eq_run_q.
    rewrite mproj_snd_wproj_idempotent.
    rewrite <- H_eq_run_p.
    rewrite <- mproj_snd_wproj_idempotent.
    rewrite <- H_chan.
    rewrite <- mproj_rcv_wproj_idempotent.
    reflexivity. }
  (* From the fact that run_p and run_q are maximal runs from rho, 
     it follows that run_q ++ run_q_next <= run_p *)
  assert (H_step2 : prefix (run_q ++ [run_q_next]) run_p).
  { assert (H_helper := prefix_weak_total (run_q ++ [run_q_next]) (run_p) rho).
    spec H_helper.
    rewrite H_pref_run_q.
    replace (run_q_next :: run_q_suf) with ([run_q_next] ++ run_q_suf) by easy.
    rewrite app_assoc.
    now apply prefix_app_r.
    spec H_helper.
    assumption.
    destruct H_helper. assumption.
    apply prefix_app_tail_or in H.
    destruct H.
    apply (symmetric_prefix_means_eq _ _ H_pref_q_p) in H.
     symmetry in H. contradiction.
    rewrite H. reflexivity. }
  assert (H_step3 : prefix (mproj_snd (split (run_q ++ [run_q_next])) p q) (mproj_snd (split run_p) p q)).
  { apply mproj_snd_preserves_active_wproj_prefix.
    apply wproj_preserves_prefix.
    apply prefix_split_prefix_iff.
    assumption. assumption. }
  assert (H_step4 : prefix (mproj_rcv (split (run_q ++ [run_q_next])) p q) (mproj_snd (split run_p) p q)) by now rewrite split_word_channel_complete.
  rewrite <- H_step1 in H_step4.
  rewrite split_app in H_step4.
  rewrite mproj_rcv_app in H_step4.
  apply prefix_app_inv in H_step4.
  assert (H_step5 : mproj_rcv (split [run_q_next]) p q = [m']).
  {
    assert (H_useful := finite_unique_splitting_next_active).
    spec H_useful rho (wproj w q) (Rcv p q m' ↾ H_neq_y) q run_q run_q_next run_q_suf.
    spec H_useful.
    rewrite H_split.
    rewrite app_assoc. 
    apply prefix_app_r.
    reflexivity.
    spec H_useful.
    split. rewrite H_pref_run_q.
    now apply prefix_app_r. split.
    rewrite wproj_idempotent. assumption.
    intros u H H'.
    apply H_max_run_q. assumption. 
    rewrite wproj_idempotent in H'.
    assumption.
    spec H_useful H_pref_run_q.
    rewrite H_useful. 
    rewrite mproj_rcv_split_async_to_sync_eq. 
    easy. easy. easy. easy. }
  rewrite H_step5 in H_step4.
  inversion H_step4. inversion H.
  symmetry in H1. contradiction.
Qed. 

(* Lifting out the proof for the case where the possible run prescribes a send action, 
   but the CLTS trace is extended with a receive action, 
   and we prove a contradiction to NMC *)
(** In the case that our candidate run rho is a finite run **) 
Lemma I_set_non_empty_inductive_rcv_snd_case :
  forall  (S : LTS)
  (T : CLTS)
  (w : FinAsyncWord)
  (H_GCLTS : GCLTS S)
  (H_NMC : @NMC State S)
  (H_canonical : canonical_implementation S T)
  (H_trace_w : @is_clts_trace LocalState T w)
  (rho : FinSyncWord)
  (H_is_run : @is_trace SyncAlphabet State S rho)
  (p q : participant)
  (m : message)
  (H_neq : sender_receiver_neq_async (Rcv p q m))
  (H_trace_wx : @is_clts_trace LocalState T (w ++ [Rcv p q m ↾ H_neq]))
  (p' q' : participant)
  (m' : message)
  (H_neq_y : sender_receiver_neq_async (Snd p' q' m'))
  (suf : list AsyncAlphabet)
  (H_split : wproj (split rho) q = wproj w q ++ [Snd p' q' m' ↾ H_neq_y] ++ suf),
    False.
Proof. 
  intros.
  (* Note that because no_mixed_choice is stated non-symmetrically, the order of instantiation matters *) 
  assert (H_contra := NMC_implies_no_mixed_choice S T (wproj w q) (Snd p' q' m' ↾ H_neq_y) (Rcv p q m ↾ H_neq) q H_GCLTS H_NMC H_canonical).  
  spec H_contra.
  (* The first trace is a local prefix for q from the fact that rho is a possible run prefix, and S is deadlock free *) 
  { destruct H_GCLTS as [_ [_ [_ [H_df _]]]].
    destruct H_is_run as [s_rho H_reach_rho].
    spec H_canonical q. 
    destruct H_canonical as [_ H_canonical].
    spec H_canonical (split rho). 
    destruct H_canonical as [_ H_canonical].
    spec H_canonical.
    eapply split_run_protocol_prefix.
    assumption.     
    exact H_reach_rho.
    eapply lts_trace_prefix_closed.
    exact H_canonical.
    rewrite H_split.
    rewrite app_assoc. 
    apply prefix_app_r. reflexivity.
  } 
  (* The second trace is a local prefix for q from the fact that wx is an canonical CLTS trace *)
  spec H_contra. 
  destruct H_trace_wx as [c_wx H_trace_wx].
  exists (get_local_state c_wx q).
  assert (H_replace : (wproj w q ++ [Rcv p q m ↾ H_neq]) =
                        (wproj (w ++ [Rcv p q m ↾ H_neq]) q)).
  {
    unfold wproj at 2. rewrite flat_map_app.
    simpl. rewrite app_nil_r.
    unfold wproj_symbol at 2.
    simpl.
    replace (participant_eqb q q) with true.
    2 : symmetry; now apply participant_eqb_refl.
    reflexivity. }
  rewrite H_replace. clear H_replace. 
  eapply clts_reachable_means_implementation_reachable.
  assumption.
  (* The final premise trivially says that a send event is a send event *)
  spec H_contra. easy. 
  (* Finally we can derive a contradiction *) 
  inversion H_contra. 
Qed. 


(* (* Update 1: This lemma doesn't even need that rho_fin is a maximal run *)  *)
(* Any compliant run section will do *)
(* Update 2: Actually this lemma doesn't even need that rho_fin is compliant with all roles, just that it is compliant with p and q *)
(* Update 3: Actually it just needs to be compliant with the sender p *) 
Lemma rcv_extension_means_possible_run_incomplete :
  forall  (S : @LTS SyncAlphabet State)
     (T : CLTS)
     (w : FinAsyncWord)
     (rho_fin : FinSyncWord)
     (H_trace_w : @is_clts_trace LocalState T w)
     (p q : participant)
     (m : message)
     (H_neq : sender_receiver_neq_async (Rcv p q m))
     (H_possible_p : wproj w p `prefix_of` wproj (split rho_fin) p)

     (H_trace_wx : @is_clts_trace LocalState T
                     (w ++ [Rcv p q m ↾ H_neq])),
    wproj (split rho_fin) q <> wproj w q.
Proof. 
  intros.
  (* Assume by contradiction that these two are equal *) 
  intro H_contra.
  (* Step 1: From the contradiction, their mproj_rcv's must be equal *) 
  assert (H_step1 : mproj_rcv (split rho_fin) p q = mproj_rcv w p q). 
  { rewrite mproj_rcv_wproj_idempotent.
    rewrite (mproj_rcv_wproj_idempotent w).
    rewrite H_contra.
    reflexivity. }
  (* Step 2: Split words have equal mproj_rcv and mproj_snd's *) 
  assert (H_step2 : mproj_snd (split rho_fin) p q = mproj_rcv (split rho_fin) p q).
  { assert (H_helper := split_word_channel_complete rho_fin p q).
    spec H_helper. easy.
    symmetry. assumption. }
  (* Step 3: m is at the head of the channel between (p,q) in c_w *)
  destruct H_trace_w as [c_w H_reach_w].
  assert (H_chan := about_clts_trace_configuration_channel_contents _ _ H_reach_w p q H_neq).
  destruct H_trace_wx as [c_wx H_reach_wx]. 
  apply Reachable_unwind in H_reach_wx.
  destruct H_reach_wx as [c_w' [H_reach_w' H_step_w_wx]].
  assert (H_det := deterministic_clts T w c_w c_w' H_reach_w H_reach_w').
  rewrite <- H_det in H_step_w_wx.
  clear H_reach_w' H_det c_w'.
  destruct H_step_w_wx as [H_false | [_ H_step_w_wx]].
  destruct H_false as [H_false _]; inversion H_false.
  assert (H_step_w_wx_chan := H_step_w_wx).
  destruct H_step_w_wx_chan as [_ [_ H_step_w_wx_chan]].
  destruct H_step_w_wx_chan as [_[chan_w_rest H_step_w_wx_chan]].
  simpl in H_step_w_wx_chan.
  destruct H_step_w_wx_chan as [H_chan_w H_chan_wx].
  rewrite H_chan_w in H_chan.
  rename H_chan into H_step3. 
  clear H_chan_w H_chan_wx.
  (* Step 4: Establishing an equality between p's sends *)
  assert (H_step4 : mproj_snd (split rho_fin) p q ++ m :: chan_w_rest = mproj_snd w p q).
  { rewrite H_step2.
    rewrite <- H_step3.
    rewrite H_step1.
    reflexivity. }
  (* Step 5: Establishing a prefix relation between p's sends *) 
  assert (H_step5 : prefix (mproj_snd w p q) (mproj_snd (split rho_fin) p q)).
  { apply mproj_snd_preserves_active_wproj_prefix.
    apply H_possible_p.
    easy. }
  (* Step 6: Establishing a contradictory prefix relation *)
  assert (H_step6 : prefix (mproj_snd (split rho_fin) p q ++ m :: chan_w_rest) (mproj_snd (split rho_fin) p q)).
  { rewrite <- H_step4 in H_step5.
    assumption. }
  (* Finally, we derive a contradiction from H_step6 *)
  apply prefix_app_not in H_step6.
  contradiction.
  easy.
Qed. 

(** Attention: This is the critical characterization about receive events **) 
(* Critically, we only need to reason about run prefixes that are compliant with w *) 
(* We can show that this same run prefix is compliant with wx in the receive case *)
(* Then we can trivially extend this run due to deadlock freedom to obtain either run to make the I set non-empty *)
(* But really showing I set non-emptiness is the trivial part and a trap/foolish to include in the premises directly *)
Lemma rcv_possible_run_prefix_still_possible :
  forall (S : @LTS SyncAlphabet State) (T : CLTS) (w : FinAsyncWord) (rho_fin : FinSyncWord),
    GCLTS S ->
    @NMC State S -> 
    @SCC State S -> 
    @RCC State S ->
    canonical_implementation S T -> 
    @is_clts_trace LocalState T w ->
    possible_run_prefix S rho_fin w ->
    forall (x : AsyncAlphabet),
      is_rcv x ->
      @is_clts_trace LocalState T (w ++ [x]) ->
      possible_run_prefix S rho_fin (w ++ [x]). 
Proof.
  intros S T w rho_fin H_GCLTS H_NMC H_SCC H_RCC H_canonical H_trace_w H_possible x H_rcv H_trace_wx.
  destruct H_possible as [H_is_run H_possible].
  split.
  (* Discharging the trivial proof obligation that rho_fin is a finite maximal run *) 
  assumption. 
  (* Establishing that x = q?p:m *) 
  destruct x as [x H_neq]. 
  destruct x as [p q m | p q m].
  inversion H_rcv. clear H_rcv.
  (* For all non-q roles, any run in I(w) works for I(wx) *)
  (* We only need to reason about the run's compliance for q *)
  intro r.
  destruct (classic (r = q)).
  (* Showing that rho works for all non-q roles *)
  2: {
    unfold wproj at 1. 
    rewrite flat_map_app.
    unfold wproj_symbol at 2.
    unfold sender_async, receiver_async; simpl.
    replace (participant_eqb q r) with false by now symmetry; apply participant_eqb_no. 
    repeat rewrite app_nil_r. 
    spec H_possible r. 
    assumption. }
  (* Showing that rho works for q amounts to showing that wx is still a prefix of run projected onto q *)
  (* We use LEM and prove a contradiction in the false case *) 
  destruct (classic (wproj (w ++ [Rcv p q m ↾ H_neq]) r `prefix_of` wproj (split rho_fin) r)) as [H_yes | H_no].
  * assumption. 
  * exfalso.
    (* If wx is not compliant with rho for p, then the next symbol for p in rho must not match x *)   
    assert (H_helper := about_not_prefix _ (wproj w q) (wproj (split rho_fin) q) (Rcv p q m ↾ H_neq) (H_possible q)).  
    spec H_helper.
    { intro H_false.
      apply H_no.
      unfold wproj at 1.
      rewrite flat_map_app.
      unfold wproj_symbol at 2.
      simpl.
      replace (participant_eqb q r) with true.
      rewrite app_nil_r.
      rewrite H. exact H_false.
      symmetry. symmetry in H.
      now apply participant_eqb_correct. 
    }
    spec H_helper.
    (* Corner case exposed: need to show that the next element even exists, that the trace is not maximal *)
    {
      assert (H_useful := rcv_extension_means_possible_run_incomplete S T w rho_fin H_trace_w p q m H_neq (H_possible p) H_trace_wx).
      apply strict_prefix_means_length_lt. 
      exact (H_possible q).
      intro H_false.
      symmetry in H_false. contradiction. } 
    destruct H_helper as [y [suf [H_split H_mismatch]]].
    (* Now that we have established H_split and H_mismatch, which together say that the next symbol for p in rho does not match x *)
    (* It suffices to show that actually the next symbol for p in rho matches x *)
    (* Let y be the next symbol for p in rho *) 
    enough (H_next : y = Rcv p q m ↾ H_neq). 
    { rewrite H_next in H_split.
      rewrite H in H_no.
      rewrite H_split in H_no.
      apply H_no. 
      unfold wproj at 1.
      rewrite flat_map_app.
      unfold wproj_symbol at 2.
      simpl.
      replace (participant_eqb q q) with true.
      2: symmetry; now apply participant_eqb_correct.
      easy. }
    clear H_mismatch H_no.
    (* Case analysis on y *)
    destruct y as [y H_neq_y].
      destruct y as [p' q' m' | p' q' m']. 
      ** (* In the case that y is a send action, contradiction to No Mixed Choice *)
        exfalso.
        subst.
        now apply (I_set_non_empty_inductive_rcv_snd_case S T w H_GCLTS H_NMC H_canonical H_trace_w rho_fin H_is_run p q m H_neq H_trace_wx p' q' m' H_neq_y suf H_split).
      ** (* In the case that y is a receive action, further case analysis *)
        (* Obtaining the finite unique splitting for q *)
        assert (H_max_run_q := finite_unique_splitting rho_fin w q (H_possible q)).
        destruct H_max_run_q as [run_q H_max_run_q].
        destruct (classic (q' = q)).
        (* In the case that q' is not the active role, find a contradiction to Rcv p' q' m' being in wproj (split rho) q *) 
        2 : { exfalso.
              assert (H_useful := in_wproj_means_active).
              spec H_useful (split rho_fin) q.
              rewrite Forall_forall in H_useful.
              spec H_useful (Rcv p' q' m' ↾ H_neq_y).
              spec H_useful.
              rewrite H_split.
              apply elem_of_list_In.
              apply in_or_app.
              right.
              apply in_or_app.
              left.
              now apply in_eq.
              unfold is_active in H_useful.
              destruct H_useful as [_ H_rcv].
              spec H_rcv. easy.
              simpl in H_rcv. contradiction. }
        (* It must be the case that q' = q *)
        (* Now case analysis on whether p' = p *)
        destruct (classic (p' = p)).
        (* Followed by further case analysis on whether m' = m *) 
        *** destruct (classic (m' = m)).
            **** subst. f_equal. 
                 apply proof_irrelevance.
            **** subst. exfalso.
                 apply (I_set_non_empty_inductive_rcv_rcv_case_message_neq S T w H_GCLTS H_NMC H_canonical H_trace_w rho_fin H_is_run H_possible p q m H_neq H_trace_wx m' H_neq_y suf H_split run_q H_max_run_q H2). 
        *** (* In the case that x and y disagree on sender, contradiction to RCC *)
          subst. 
          exfalso.
          apply (I_set_non_empty_inductive_rcv_rcv_case_sender_neq S T w H_GCLTS H_RCC H_canonical H_trace_w rho_fin H_is_run H_possible p q m H_neq H_trace_wx p' m' H_neq_y suf H_split H1). 
Qed.

Lemma I_set_non_empty_inductive_rcv :
  forall (S : @LTS SyncAlphabet State) (T : CLTS) (w : FinAsyncWord),
    GCLTS S ->
    @NMC State S -> 
    @SCC State S -> 
    @RCC State S ->
    canonical_implementation S T -> 
    @is_clts_trace LocalState T w ->
    I_set_non_empty S w -> 
    forall (x : AsyncAlphabet),
      is_rcv x ->
      @is_clts_trace LocalState T (w ++ [x]) ->
      I_set_non_empty S (w ++ [x]). 
Proof.         
  intros S T w H_GCLTS H_NMC H_SCC H_RCC H_canonical H_trace_w IHw x H_rcv H_trace_wx.
  (** Coq-obligatory case analysis on whether w's run is finite or infinite *)
  (** Except that now we have encapsulated the reasoning to a single run prefix, thereby delaying the acknowledgement of this difference until the last possible moment **)
  (** In each case we take the maximal run, finite or infinite from w, and extend it using the deadlock freedom of S, to get either a finite or infinite run for wx **) 
  destruct IHw as [H_fin | H_inf]. 
  - (** In the finite case **)
    destruct H_fin as [rho H_finite_possible_rho].
    apply finite_possible_run_means_possible_run_prefix in H_finite_possible_rho. 
    assert (H_helper := rcv_possible_run_prefix_still_possible S T w rho H_GCLTS H_NMC H_SCC H_RCC H_canonical H_trace_w H_finite_possible_rho x H_rcv H_trace_wx). 
    destruct H_GCLTS as [_ [_ [_ [H_df _]]]].
    destruct H_helper as [[s_pref H_reach_pref] H_compliant]. 
    apply H_df in H_reach_pref.
    destruct H_reach_pref as [H_fin | H_inf].
    * destruct H_fin as [rho_fin [H_max_rho_fin H_pref]].
      left. exists rho_fin. split. assumption.
      intro p. spec H_compliant p.
      apply PreOrder_Transitive with (wproj (split rho) p).
      assumption.
      apply wproj_preserves_prefix.
      apply prefix_split_prefix_iff.
      assumption.
    * destruct H_inf as [rho_inf [H_run_inf [i H_pref]]].
      right. exists rho_inf. split. assumption.
      intro p. spec H_compliant p.
      exists i.
      apply PreOrder_Transitive with (wproj (split rho) p).
      assumption.
      apply wproj_preserves_prefix.
      apply prefix_split_prefix_iff.
      subst. reflexivity.
  - (** In the infinite case **)
    destruct H_inf as [rho H_infinite_possible_rho].
    (* In the infinite case we simply apply this conversion lemma to extract a finite possible run prefix *) 
    (* Since we are dealing with a finite trace w, this finite conversion always works *)
    assert (H_helper := infinite_possible_run_means_finite_possible_run_prefix S rho w H_infinite_possible_rho).
    destruct H_helper as [pref [H_possible H_pref_rho]].
    assert (H_helper := rcv_possible_run_prefix_still_possible S T w pref H_GCLTS H_NMC H_SCC H_RCC H_canonical H_trace_w H_possible x H_rcv H_trace_wx). 
    destruct H_GCLTS as [_ [_ [_ [H_df _]]]].
    destruct H_helper as [[s_pref H_reach_pref] H_compliant]. 
    apply H_df in H_reach_pref.
    destruct H_reach_pref as [H_fin | H_inf].
    * destruct H_fin as [rho_fin [H_max_rho_fin H_pref]].
      left. exists rho_fin. split. assumption.
      intro p. spec H_compliant p.
      apply PreOrder_Transitive with (wproj (split pref) p).
      assumption.
      apply wproj_preserves_prefix.
      apply prefix_split_prefix_iff.
      assumption.
    * destruct H_inf as [rho_inf [H_run_inf [i H_pref]]].
      right. exists rho_inf. split. assumption.
      intro p. spec H_compliant p.
      exists i.
      apply PreOrder_Transitive with (wproj (split pref) p).
      assumption.
      apply wproj_preserves_prefix.
      apply prefix_split_prefix_iff.
      subst. reflexivity.
Qed. 

End NMC. 







