Require Import List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq 
  Require Import ssreflect.
         
From CC 
  Require Import lib structures clts lts channel_complete channel_compliant protocol closure_conditions run nmc_completeness. 

Section RCC_Completeness.

Context {State : Type} {LocalState : Type}.
  
Lemma RCC_completeness_helper :
  forall (S : LTS)
    (H_GCLTS : GCLTS S)
    (s1 s2 s3 s4 : State)
    (p q r : participant)
    (m m' : message)
    (H_pq : sender_receiver_neq_sync (Event p q m))
    (H_rq : sender_receiver_neq_sync (Event r q m'))
    (H_transition1 : transition S s1 (Event p q m ↾ H_pq) s2)
    (H_transition2 : transition S s3 (Event r q m' ↾ H_rq) s4)
    (H_pr_neq : p ≠ r)
    (u_p : FinAsyncWord)
    (w1 : FinSyncWord)
    (H_reach1 : @Reachable SyncAlphabet State S (s0 S) w1 s1)
    (H_proj1 : wproj (split w1) q = u_p)
    (w2 : FinSyncWord)
    (H_reach2 : @Reachable SyncAlphabet State S (s0 S) w2 s3)
    (H_proj2 : wproj (split w2) q = u_p)
    (w : FinAsyncWord)
    (H_pref_w : is_protocol_prefix (reinitial_S s4 S) w)
    (H_q_empty : wproj w q = [])
    (H_w_pq : prefix (mproj_rcv w p q ++ [m]) (mproj_snd w p q))
    (T : CLTS)
    (H_df : clts_deadlock_free T)
    (H_impl_copy : @implements State LocalState S T)
    (H_rq_async : sender_receiver_neq_async (Snd r q m'))
    (H_qp_async : sender_receiver_neq_async (Rcv p q m))
    (rho_false : FinSyncWord)
    (H_run_rho_false : @is_trace SyncAlphabet State S rho_false) 
    (H_possible_rho_false : ∀ p0 : participant,
        wproj
          (split w2 ++
             [Snd r q m' ↾ H_rq_async] ++
             w ++ [Rcv p q m ↾ H_qp_async]) p0
          `prefix_of` wproj (split rho_false) p0),
    False.
Proof. 
  intros.
  assert (H_useful := split_run_finite_possible_run_prefix S rho_false w2 H_GCLTS H_run_rho_false). 
  spec H_useful. { exists s3. exact H_reach2. }
  spec H_useful.
  { 
    intro p0.
    spec H_possible_rho_false p0.
    rewrite wproj_app in H_possible_rho_false. 
    apply prefix_app_l in H_possible_rho_false.
    assumption. }
  (* Because w2 < rho_false and rho_false is compliant with r, it must be the case that w2 ++ [Event r q m'] < rho_false *)
  (* We first establish that w2 ++ [Event r q m'] < rho_false *) 
  apply prefix_exists_suffix in H_useful. 
  destruct H_useful as [rho_false_suf H_rho_false_split].
  destruct rho_false_suf as [| rho_false_next rho_false_suf].
  {
    (* Discharging the case where rho_false = w2 *)
    (* Using either of r or p will do *) 
    spec H_possible_rho_false r.
    rewrite app_nil_r in H_rho_false_split. 
    subst.
    repeat rewrite wproj_app in H_possible_rho_false.
    rewrite wproj_sender_eq in H_possible_rho_false.
    reflexivity.
    eapply (prefix_app_not _ ([Snd r q m' ↾ H_rq_async] ++ wproj w r ++ wproj [Rcv p q m ↾ H_qp_async] r)). 
    easy. exact H_possible_rho_false. }
  (* Now we establish that rho_false_next must be (Event r p m' *)
  assert (H_next_eq : rho_false_next = (Event r q m' ↾ H_rq)).
  {
    unfold GCLTS in H_GCLTS.
    destruct H_GCLTS as [H_det [H_sender_driven _]].
    assert (H_run_w2' : @is_trace SyncAlphabet State S (w2 ++ [rho_false_next])). 
    { eapply lts_trace_prefix_closed with rho_false.
      assumption.
      rewrite H_rho_false_split.
      replace (rho_false_next :: rho_false_suf) with ([rho_false_next] ++ rho_false_suf) by easy. 
      rewrite app_assoc. now apply prefix_app_r. }
    destruct H_run_w2' as [s_w2' H_reach_w2'].
    apply lts.Reachable_unwind in H_reach_w2'.
    destruct H_reach_w2' as [s_w2 [H_reach_w2 H_transition]].
    assert (H_s3_eq : s_w2 = s3) by now eapply (deterministic_word S s_w2 s3 w2).
    (* Instantiating sender-driven choice *) 
    subst.
    spec H_sender_driven s3 s4 s_w2' (exist _ (Event r q m') H_rq) rho_false_next H_transition2 H_transition.
    (* Now we have established that the sender in rho_false_next must be r *)
    destruct rho_false_next as [rho_false_next H_neq_next].
    destruct rho_false_next as [p0 q0 m0].
    unfold sender_sync in H_sender_driven.
    simpl in H_sender_driven.
    (* Now we instantiate H_possible_rho_false with p0 = r to establish the rest of the equalities *)
    spec H_possible_rho_false r.
    clean H_possible_rho_false. 
    (* Omg the tactic worked! *)
    apply (prefix_app_inv (wproj (split w2) r)) in H_possible_rho_false.
    rewrite (wproj_symbol_sender_eq r q r m' H_rq_async) in H_possible_rho_false.
    reflexivity.
    subst.
    rewrite (wproj_symbol_sender_eq p0 q0 p0 m0 H_neq_next) in H_possible_rho_false.
    reflexivity.
    inversion H_possible_rho_false.
    inversion H. subst.
    sigma_equal. }
  (* Now we have established that the next event following w2 must be (Event r q m') *)
  subst.
  (* Now we can finally find a contradiction by instantiating H_possible_rho_false with q *)
  spec H_possible_rho_false q.
  clean H_possible_rho_false.
  apply (prefix_app_inv (wproj (split w2) q)) in H_possible_rho_false.
  rewrite (wproj_symbol_sender_neq r q q m' H_rq_async) in H_possible_rho_false. 
  easy. 
  rewrite app_nil_l in H_possible_rho_false. 
  rewrite (wproj_symbol_receiver_eq r q q m' H_rq) in H_possible_rho_false.
  reflexivity.
  rewrite (wproj_symbol_sender_neq r q q m' H_rq) in H_possible_rho_false. 
  easy. 
  rewrite app_nil_l in H_possible_rho_false. 
  rewrite wproj_app in H_possible_rho_false.
  rewrite H_q_empty in H_possible_rho_false.
  rewrite app_nil_l in H_possible_rho_false.
  rewrite (wproj_receiver_eq p q q m H_qp_async) in H_possible_rho_false.
  reflexivity.
  inversion H_possible_rho_false.
  inversion H.
  subst. contradiction. 
Qed.

Lemma glued_together_trace_is_protocol_prefix :
  forall (S : LTS)
    (T : CLTS) 
    (H_GCLTS : GCLTS S)
    (s3 s4 : State)
    (p q r : participant)
    (m m' : message)
    (H_rq : sender_receiver_neq_sync (Event r q m'))
    (H_transition2 : transition S s3
                       (Event r q m' ↾ H_rq) s4)
    (w2 : FinSyncWord)
    (H_reach2 : Reachable S (s0 S) w2 s3)
    (w : FinAsyncWord)
    (H_pref_w : is_protocol_prefix
                  (reinitial_S s4 S) w)
    (H_q_empty : wproj w q = [])
    (H_w_pq : mproj_rcv w p q ++ [m]
                `prefix_of` mproj_snd w p q)
    (H_impl_copy : implements S T)
    (H_rq_async : sender_receiver_neq_async
                    (Snd r q m'))
    (H_qp_async : sender_receiver_neq_async
                    (Rcv p q m))
    (H_layer1 : @is_clts_trace LocalState T
                  (split w2 ++
                     [Snd r q m' ↾ H_rq_async])),
    is_protocol_prefix S
      (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w). 
Proof. 
  intros.
  (* Trying a different approach *)
  assert (H_useful := @channel_compliant_I_non_empty_implies_prefix State).
  (* To use this lemma we first need to find a possible run prefix for w in S *) 
  assert (H_goal := @protocol_prefix_exists_possible_run_prefix State). 
  spec H_goal (reinitial_S s4 S) w.
  spec H_goal.
  { unfold GCLTS in *. eapply reinitial_S_preserves_deadlock_freedom.  
    tauto. tauto. eapply Reachable_step. exact H_reach2. exact H_transition2. }
  spec H_goal H_pref_w.
  destruct H_goal as [rho H_goal]. 
  destruct H_goal as [H_trace H_compliant].  
  assert (H_possible : possible_run_prefix S (w2 ++ [(Event r q m' ↾ H_rq)] ++ rho) (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w)). 
  { split.
    { (* Showing tracehood in S *) 
      destruct H_trace as [s_rho H_reach_rho].
      exists s_rho. 
      apply lts.Reachable_app with s3. exact H_reach2.
      apply lts.Reachable_app with s4.
      simpl. apply Reachable_singleton. assumption.
      simpl in H_compliant.
      apply Reachable_means_Reachable_reinitial_swap in H_reach_rho.
      simpl in H_reach_rho. assumption. 
    }
    { 
      (* Showing per-role compliance *)
      assert (H_rewrite : (Snd r q m' ↾ H_rq_async) = (Snd r q m' ↾ H_rq)) by sigma_equal.
      intros p0. 
      clean.
      apply prefix_app.
      rewrite H_rewrite. apply prefix_app.
      (* Only when p0 = q does the LHS get something *)
      (* But in that case the LHS is [] *)
      destruct (classic (q = p0)).
      * subst p0.
        rewrite H_q_empty.
        apply prefix_nil.
      * rewrite wproj_symbol_receiver_neq.
        easy. rewrite app_nil_l.
        now spec H_compliant p0. 
    }
  } 
  (* Finished showing a possible run prefix for this word *)
  spec H_useful S (w2 ++ [Event r q m' ↾ H_rq] ++ rho) (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w). 
  spec H_useful.
  { unfold GCLTS in H_GCLTS. tauto. }
  spec H_useful.
  eapply split_run_snd_channel_compliant_app_channel_compliant.
  eapply protocol_prefix_channel_compliant. exact H_pref_w.
  assumption.
  spec H_useful H_possible.
  assumption.
Qed. 
  
Lemma RCC_completeness :
  forall (S : @LTS SyncAlphabet State),
    GCLTS S -> 
    ~ @RCC State S ->
    ~@implementable State LocalState S.
Proof.
  intros S H_GCLTS H_RCC.
  assert (H_df_copy : deadlock_free S). { unfold GCLTS in *; tauto. } 
  apply neg_RCC_iff in H_RCC.
  destruct H_RCC as [s1 [s2 [s3 [s4 [p [q [r [m [m' [H_pq [H_rq [H_transition1 [H_transition2 [H_pr_neq [H_sim_reach H_word]]]]]]]]]]]]]]].
  destruct H_sim_reach as [u_p [H_reach_s1 H_reach_s3]].
  (* w is the witness we get from the ~RCC *) 
  destruct H_word as [w [H_pref_w [H_q_empty H_w_pq]]]. 
  intro H_impl.
  unfold implementable in H_impl. 
  destruct H_impl as [T H_impl].
  assert (H_impl_copy := H_impl). 
  destruct H_impl as [[H_incl1 H_incl2] H_df].
  (* Now we need to construct a prefix to use the sufficient fact about completeness *) 
  assert (H_suf := completeness_sufficiency_fact S T).
  destruct H_reach_s1 as [w1 [H_reach1 H_proj1]].
  destruct H_reach_s3 as [w2 [H_reach2 H_proj2]].  
  (* Need fact about every reachable state leading to a maximal run *)
  assert (H_key : exists (w : FinAsyncWord), @is_clts_trace LocalState T w /\ ~ I_set_non_empty S w).
  { (* Constructing the witness immediately *)
    assert (H_rq_async : sender_receiver_neq_async (Snd r q m')) by easy.
    assert (H_qp_async : sender_receiver_neq_async (Rcv p q m)) by easy.
    exists (split w2 ++ [exist _ (Snd r q m') H_rq_async] ++ w ++ [exist _ (Rcv p q m) H_qp_async]).
    split. 
    (** First obligation is that our witness is a CLTS trace **)
    (* We do not show that our witness is a CLTS trace via stepwise extensions *) 
    (* Instead, we group the last three extensions together, and show that
       [exist _ (Snd r q m') H_rq_async] ++ w ++ [exist _ (Rcv p q m) H_qp_async] is a protocol prefix of
       LTS S' which is S reinitialized with s3 *)
    (* Separately, we show that (split w2) is a protocol prefix of LTS S *)
    (* And then we glue these two facts together *)
    (* Showing that our witness is a CLTS trace stepwise, one extension at a time *)
    assert (H_layer1 := clts_trace_snd_extension_sufficient T (split w2) r q m' H_rq_async).
    (* assert (H_layer2 := clts_trace_rcv_extension_sufficient T (split w2 ++ [Snd r q m' ↾ H_rq_async]) p q m H_qp_async). *)
    - (* First we show that split w2 ++ [exist _ (Snd r q m') H_rq_async] is a CLTS trace *)
      (* It is sufficient to show that (split w2) is a CLTS trace
       and that the first send extension is a local trace for r *)
      spec H_layer1.
      (* Showing that (split w2) is a CLTS trace *) 
      { assert (H_helper := @deadlock_free_clts_trace_prefix_iff LocalState T (split w2) H_df).
        rewrite H_helper. clear H_helper. 
        eapply protocol_fidelity_means_prefixes_eq in H_impl_copy.
        apply H_impl_copy.
        eapply split_run_protocol_prefix.
        unfold GCLTS in H_GCLTS. tauto.
        exact H_reach2. 
      }
      spec H_layer1. 
      (* Showing that (wproj (split w2) p ++ [Snd r q m' ↾ H_rq_async]) is a T_r trace *)
      (* Step 1 : (split w2) ++ [Snd r q m' ↾ H_rq_async] is a protocol prefix *)
      (* Step 2 : (split w2) ++ [Snd r q m' ↾ H_rq_async] is trace of implementation T *) 
      (* Step 3 : wproj (split w2) r ++ [Snd r q m' ↾ H_rq_async] is a trace of T_r *)
      { 
        assert (H_step1 : @is_protocol_prefix State S  (split w2 ++ [Snd r q m' ↾ H_rq_async])). 
        {
          assert (H_inter1 : @is_trace SyncAlphabet State S (w2 ++ [(Event r q m' ↾ H_rq)])).
          { exists s4.
            now apply Reachable_step with s3.
          } 
          destruct H_inter1 as [s_w2x2 H_reach_w2x2].
          destruct H_GCLTS as [_ [_ [_ [H_df_S _]]]].
          spec H_df_S s_w2x2 (w2 ++ [Event r q m' ↾ H_rq]) H_reach_w2x2.
          destruct H_df_S as [H_fin | H_inf].
          - destruct H_fin as [run_fin [H_max H_pref]].
            left. exists (split run_fin). split.
            now apply split_finite_run_is_finite_word. 
            apply prefix_split_prefix_iff in H_pref.
            rewrite split_app in H_pref. 
            unfold split at 2 in H_pref.
            unfold split_symbol in H_pref.
            simpl in H_pref.
            unfold sender_sync, receiver_sync, value_sync in H_pref.
            simpl in H_pref.
            apply prefix_app_l with [Rcv r q m' ↾ H_rq].
            rewrite <- app_assoc. simpl.
            assert (H_rewrite : (Snd r q m' ↾ H_rq_async) = (Snd r q m' ↾ H_rq)) by sigma_equal. 
            now rewrite H_rewrite.
          - destruct H_inf as [run_inf [H_max H_pref]].
            right. exists (split_inf run_inf). split.
            now apply split_infinite_run_is_infinite_word.
            destruct H_pref as [i H_pref].
            (* w1 is length (i-1), and (Event p q m) is the ith element in run_inf *)
            (* First we establish that i >= 1 *) 
            destruct i. 
            rewrite stream_to_list_zero in H_pref.
            symmetry in H_pref.
            apply app_eq_nil in H_pref.
            destruct H_pref as [_ H_pref]. inversion H_pref.
            exists (Datatypes.S (2*i)).
            assert (H_useful : stream_to_list run_inf i = w2 /\ Str_nth i run_inf = (Event r q m' ↾ H_rq)).
            { assert (H_inter := stream_to_list_S_Str_nth_app SyncAlphabet i run_inf).
              rewrite H_inter in H_pref.
              apply app_inj_2 in H_pref.
              split. tauto.
              destruct H_pref as [_ H_x].
              inversion H_x. reflexivity.
              easy. }
            rewrite stream_to_list_S_Str_nth_app.
            destruct H_useful as [H_w2 H_x2].
            rewrite <- H_w2. 
            rewrite split_inf_inf_split.
            rewrite app_inv_head_iff.  
            f_equal.
            assert (H_helper := Str_nth_split_inf_inf_split run_inf i r q m' H_rq H_rq_async H_rq_async H_x2).
            tauto. 
        } 
        assert (H_step2 : @is_clts_trace LocalState T (split w2 ++ [Snd r q m' ↾ H_rq_async])).
        {
          apply (protocol_fidelity_means_prefixes_eq S T (split w2 ++ [Snd r q m' ↾ H_rq_async])) in H_impl_copy. 
          apply H_impl_copy in H_step1.
          now apply deadlock_free_clts_trace_prefix_iff.
        }
        assert (H_step3 : @is_trace AsyncAlphabet LocalState (implementations T r) (wproj (split w2) r ++ [Snd r q m' ↾ H_rq_async])).
        {
          rewrite <- (wproj_sender_eq r q r m'). 
          2 : reflexivity.
          rewrite <- wproj_app.
          destruct H_step2 as [c H_step2].
          assert (H_useful := @clts_trace_participant_projection LocalState T). 
          spec H_useful (split w2 ++ [Snd r q m' ↾ H_rq_async]) c H_step2 r.
          exists (get_local_state c r).
          assumption.
        }
        assumption.
      }
      (* Now we move onto the second extension with w *)
      (* Because this next extension is not a singleton asynchronous action,
         we prove it by showing that the trace is a protocol prefix,
         and appealing to the fact that T implements S
         to show that the trace is a CLTS trace *)
      assert (H_layer2 := protocol_fidelity_means_prefixes_eq S T (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w) H_impl_copy). 
      destruct H_layer2 as [H_layer2 _]. 
      spec H_layer2.  
      (* Showing that (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w) is a protocol prefix *) 
      (* To obtain a maximal word for this trace to be a prefix of, we need to first extract the run for w separately *)
      (* Pulled this out into a helper lemma *) 
      apply (glued_together_trace_is_protocol_prefix S T H_GCLTS s3 s4 p q r m m' H_rq H_transition2 w2 H_reach2 w H_pref_w H_q_empty H_w_pq H_impl_copy H_rq_async H_qp_async H_layer1).
      (* Finally we show that split w2 ++ [exist _ (Snd r q m') H_rq_async] ++ w ++ [Rcv p q m ↾ H_qp_async] is a CLTS trace *)
      (* To do so we group all of the first segments together, and invoke clts_trace_rcv_extension_sufficient *) 
      rewrite app_assoc.
      rewrite app_assoc.
      rewrite <- (app_assoc (split w2) _).
      assert (H_layer3 := clts_trace_rcv_extension_sufficient T (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w) p q m H_qp_async).
      apply deadlock_free_clts_trace_prefix_iff in H_layer2.
      destruct H_layer2 as [c_w2'w H_reach_w2'w].
      spec H_layer3 c_w2'w H_reach_w2'w.
      spec H_layer3.
      {
        (* Showing that (wproj (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w) q ++ [Rcv p q m ↾ H_qp_async]) is a T_q trace *)
        (* First we can massage the goal to remove the irrelevant segments *) 
        clean.
        rewrite wproj_symbol_sender_neq. easy.
        rewrite app_nil_l.
        rewrite H_q_empty.
        rewrite app_nil_r.
        (* Now we just need to show that (wproj (split w2) q ++ [Rcv p q m ↾ H_qp_async]) is a T_q trace *)
        (* Step 1 : (split w1) ++ split [Event p q m ↾ H_pq] is a protocol prefix *) 
        (* Step 2 : (split w1) ++ [Rcv p q m ↾ H_qp_async] is trace of implementation T *) 
        (* Step 3 : wproj (split w1) r ++ [Rcv p q m ↾ H_qp_async] is a trace of T_q *)
        (* Step 3 : wproj (split w2) r ++ [Rcv p q m ↾ H_qp_async] is a trace of T_q *)
        assert (H_step1 : @is_protocol_prefix State S (split (w1 ++ [Event p q m ↾ H_pq]))). 
        {
          assert (H_inter1 : @is_trace SyncAlphabet State S (w1 ++ [(Event p q m ↾ H_pq)])).
          {
            exists s2.
            now apply Reachable_step with s1. 
          }        
          destruct H_inter1 as [s_w1x1 H_reach_w1x1].
          destruct H_GCLTS as [_ [_ [_ [H_df_S _]]]].
          spec H_df_S s_w1x1 (w1 ++ [Event p q m ↾ H_pq]) H_reach_w1x1.
          destruct H_df_S as [H_fin | H_inf].
          - destruct H_fin as [run_fin [H_max H_pref]].
            left. exists (split run_fin). split.
            now apply split_finite_run_is_finite_word. 
            apply prefix_split_prefix_iff in H_pref.
            rewrite split_app in H_pref. 
            unfold split at 2 in H_pref.
            unfold split_symbol in H_pref.
            simpl in H_pref.
            unfold sender_sync, receiver_sync, value_sync in H_pref.
            simpl in H_pref.
            rewrite split_app. 
            unfold split at 2. clean. assumption. 
          - destruct H_inf as [run_inf [H_max H_pref]].
            right. exists (split_inf run_inf). split.
            now apply split_infinite_run_is_infinite_word.
            destruct H_pref as [i H_pref].
            (* w1 is length (i-1), and (Event p q m) is the ith element in run_inf *)
            (* First we establish that i >= 1 *) 
            destruct i. 
            rewrite stream_to_list_zero in H_pref.
            symmetry in H_pref.
            apply app_eq_nil in H_pref.
            destruct H_pref as [_ H_pref]. inversion H_pref.
            exists (Datatypes.S (Datatypes.S (2 * i))). 
            assert (H_useful : stream_to_list run_inf i = w1 /\ Str_nth i run_inf = (Event p q m ↾ H_pq)).
            { assert (H_inter := stream_to_list_S_Str_nth_app SyncAlphabet i run_inf).
              rewrite H_inter in H_pref.
              apply app_inj_2 in H_pref.
              split. tauto.
              destruct H_pref as [_ H_x].
              inversion H_x. reflexivity.
              easy. }
            do 2 rewrite stream_to_list_S_Str_nth_app.
            destruct H_useful as [H_w1 H_x1].
            rewrite <- H_w1. 
            rewrite split_inf_inf_split.
            rewrite split_app.
            rewrite <- app_assoc.
            rewrite app_inv_head_iff. 
            rewrite <- H_x1.
            now apply Str_nth_split_inf_eq_split_Str_nth. 
        } 
        assert (H_step2 : @is_clts_trace LocalState T (split (w1 ++ [Event p q m ↾ H_pq]))).
        {
          apply (protocol_fidelity_means_prefixes_eq S T (split (w1 ++ [Event p q m ↾ H_pq]))) in H_impl_copy. 
          apply H_impl_copy in H_step1.
          now apply deadlock_free_clts_trace_prefix_iff.
        }
        assert (H_step3 : @is_trace AsyncAlphabet LocalState (implementations T q) (wproj (split w1) q ++ [Rcv p q m ↾ H_qp_async])).
        {
          rewrite split_app in H_step2.
          unfold split at 2 in H_step2.
          clean H_step2.
          rewrite <- (wproj_receiver_eq p q q m). 
          2 : reflexivity.
          rewrite <- wproj_app.
          destruct H_step2 as [c H_step2].
          assert (H_useful := @clts_trace_participant_projection LocalState T).
          assert (H_pq_async : sender_receiver_neq_async (Snd p q m)) by easy. 
          spec H_useful (split w1 ++ [Snd p q m ↾ H_pq; Rcv p q m ↾ H_pq]) c H_step2 q.
          exists (get_local_state c q).
          rewrite wproj_app in H_useful.
          clean H_useful.
          rewrite wproj_symbol_sender_neq in H_useful. easy.
          rewrite wproj_symbol_receiver_eq in H_useful. reflexivity.
          assert (H_rewrite : Rcv p q m ↾ H_pq = Rcv p q m ↾ H_qp_async) by sigma_equal.
          rewrite H_rewrite in H_useful.
          rewrite wproj_app.
          rewrite wproj_receiver_eq. reflexivity.
          assumption. } 
        rewrite H_proj1 in H_step3.
        rewrite H_proj2. 
        assumption.
      }
      spec H_layer3.
      {
        (* Showing that in the channel between p,q reached on word (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w),
           m is at the head of the channel *)
        apply prefix_exists_suffix in H_w_pq.
        destruct H_w_pq as [rest H_w_pq].
        exists rest. 
        assert (H_w2'w_chan := about_clts_trace_configuration_channel_contents _ c_w2'w H_reach_w2'w p q H_pq).
        (* This follows from H_w2'w_chan and H_q_empty and H_w_pq, and the fact that split words are channel complete *)
        repeat rewrite mproj_rcv_app in H_w2'w_chan. 
        repeat rewrite mproj_snd_app in H_w2'w_chan. 
        assert (H_w2_chan := split_word_channel_complete w2). 
        spec H_w2_chan p q H_pq. 
        rewrite H_w2_chan in H_w2'w_chan. 
        clear H_w2_chan. 
        rewrite <- app_assoc in H_w2'w_chan.
        (* Peeling out w's part which is channel complete *) 
        apply app_inv_head_iff in H_w2'w_chan.
        rewrite H_w_pq in H_w2'w_chan.
        unfold mproj_rcv at 1 in H_w2'w_chan. 
        unfold mproj_rcv_symbol in H_w2'w_chan.
        clean H_w2'w_chan.
        replace (is_rcvb (Snd r q m' ↾ H_rq_async)) with false in H_w2'w_chan by easy.
        rewrite andb_false_r in H_w2'w_chan.
        unnil H_w2'w_chan.
        rewrite app_nil_l in H_w2'w_chan.
        unfold mproj_snd_symbol in H_w2'w_chan.
        clean H_w2'w_chan.
        rewrite participant_eqb_refl in H_w2'w_chan.
        replace (is_sndb (Snd r q m' ↾ H_rq_async)) with true in H_w2'w_chan by easy.
        replace (participant_eqb r p) with false in H_w2'w_chan.
        simpl in H_w2'w_chan.
        rewrite <- app_assoc in H_w2'w_chan.
        apply app_inv_head_iff in H_w2'w_chan.
        assumption. (* Ta-da! *)
        symmetry. rewrite participant_eqb_comm.
        now apply participant_eqb_no.
      } 
      exact H_layer3. 
      exact H_df.
      - (** Second obligation is that the intersection set is empty **)
        (* We show by contradiction that if a run exists, then q cannot be compliant with it *) 
        intro H_false.  
        destruct H_false as [H_false_fin | H_false_inf].
        (* Case split on whether the run in the intersection set is a finite or infinite run *)
        *  destruct H_false_fin as [rho_false [H_max_rho_false H_possible_rho_false]].  
           destruct H_max_rho_false as [s_rho [H_run_rho_false H_max_rho_false]].
           (* And now we prove the helper lemma *) 
           assert (H_useful := RCC_completeness_helper S H_GCLTS s1 s2 s3 s4 p q r m m' H_pq H_rq H_transition1 H_transition2 H_pr_neq u_p w1 H_reach1 H_proj1 w2 H_reach2 H_proj2 w H_pref_w H_q_empty H_w_pq T H_df H_impl_copy H_rq_async H_qp_async rho_false). 
           spec H_useful. { now exists s_rho. }
           spec H_useful H_possible_rho_false.
           contradiction.
        * destruct H_false_inf as [rho_inf H_possible_inf].
          assert (H_convert := infinite_possible_run_means_finite_possible_run_prefix S rho_inf (split w2 ++ [Snd r q m' ↾ H_rq_async] ++ w ++ [Rcv p q m ↾ H_qp_async]) H_possible_inf). 
          destruct H_convert as [rho_false [H_run_rho_false H_possible_rho_false]].
          assert (H_useful := RCC_completeness_helper S H_GCLTS s1 s2 s3 s4 p q r m m' H_pq H_rq H_transition1 H_transition2 H_pr_neq u_p w1 H_reach1 H_proj1 w2 H_reach2 H_proj2 w H_pref_w H_q_empty H_w_pq T H_df H_impl_copy H_rq_async H_qp_async rho_false).
          spec H_useful.
          { unfold possible_run_prefix in H_run_rho_false.
            tauto.
          }
          spec H_useful.
          { unfold possible_run_prefix in H_run_rho_false.
            tauto.
          } 
          contradiction. 
  }
  (* Grand finale *) 
  destruct H_key as [v [H_trace_v H_I_v_empty]].
  spec H_suf v H_GCLTS.
  spec H_suf.
  now apply deadlock_free_clts_trace_prefix_iff.
  spec H_suf H_I_v_empty. 
  contradiction.
Qed. 

End RCC_Completeness. 
