Require Import List Classical Nat Logic Lia FunctionalExtensionality ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq  
Require Import ssreflect. 
      
From CC     
  Require Import lib structures lts clts channel_compliant channel_complete protocol closure_conditions run canonical_implementation.

Section NMC.

Context {State : Type} {LocalState : Type}. 

Lemma NMC_implies_no_mixed_choice :
  forall (S : LTS) (T : CLTS) (w : FinAsyncWord) (x1 x2 : AsyncAlphabet) (p : participant),
    GCLTS S -> 
    @NMC State S ->
    canonical_implementation S T -> 
    @is_trace AsyncAlphabet LocalState (implementations T p) (w ++ [x1])  ->
    @is_trace AsyncAlphabet LocalState (implementations T p) (w ++ [x2]) ->
    is_snd x1 ->
    is_snd x2. 
Proof. 
  intros S T w x1 x2 p H_GCLTS H_NMC H_canonical [s_wx1 H_reach1] [s_wx2 H_reach2] H_snd1.  
  destruct (snd_or_rcv x2) as [H_snd2 | H_rcv2]. 
  - (* In the case that x2 is a send event, we are done *)
    easy. 
  - (* In the case that x2 is a receive event, find a contradiction to S being sender-driven *)
    exfalso. 
    (* We want to find witnesses one by one to instantiate NMC with *)
    (* Obtaining protocol prefixes for wx1 and wx2 *) 
    spec H_canonical p.
    destruct H_canonical as [_ H_pref1]. 
    assert (H_pref2 := H_pref1).
    spec H_pref1 (w ++ [x1]).
    destruct H_pref1 as [H_pref1 _].
    spec H_pref1.
    exists s_wx1. assumption.
    destruct H_pref1 as [w1 [H_prot_pref1 H_eq1]]. 
    spec H_pref2 (w ++ [x2]).
    destruct H_pref2 as [H_pref2 _].
    spec H_pref2.
    exists s_wx2. assumption. 
    destruct H_pref2 as [w2 [H_prot_pref2 H_eq2]].
    (** Case analysis on whether w1 and w2 come from finite or infinite runs, needed for type reasons **)
    (** The reasoning in each case is mixing and matching one of two sets, for finite and infinite runs **) 
    destruct H_prot_pref1 as [H_fin1 | H_inf1]. 
    * destruct H_prot_pref2 as [H_fin2 | H_inf2].
      ** (** Case: both w1 and w2 come from finite runs **)
        destruct H_fin1 as [v1 [H_fin1 H_pref1]]. 
        destruct H_fin1 as [rho1 [H_max_rho1 [H_role1 H_cc1]]]. 
        destruct H_fin2 as [v2 [H_fin2 H_pref2]].
        destruct H_fin2 as [rho2 [H_max_rho2 [H_role2 H_cc2]]].  
        (* Obtaining the unique splitting of w wrt rho1 and rho2 for p *)
        (* Dealing with rho1 *) 
        assert (H_useful1 := prefix_app_finite_unique_splitting_elaborate).
        spec H_useful1 rho1 w x1 p.
        spec H_useful1. 
        rewrite <- H_eq1.
        rewrite (H_role1 p).
        now apply wproj_preserves_prefix.
        destruct H_useful1 as [alpha1 [y1 [beta1 [H_split1 [H_max_alpha1 H_y1_x1]]]]].
        destruct H_max_alpha1 as [H_pref_alpha1 [H_alpha1 H_max_alpha1]]. 
        destruct H_max_rho1 as [s_rho1 [H_reach_rho1 H_max_rho1]].
        (* Dealing with rho2 *)
        assert (H_useful2 := prefix_app_finite_unique_splitting_elaborate).
        spec H_useful2 rho2 w x2 p.
        spec H_useful2. 
        rewrite <- H_eq2.
        rewrite (H_role2 p).
        now apply wproj_preserves_prefix.
        destruct H_useful2 as [alpha2 [y2 [beta2 [H_split2 [H_max_alpha2 H_y2_x2]]]]].
        destruct H_max_alpha2 as [H_pref_alpha2 [H_alpha2 H_max_alpha2]]. 
        destruct H_max_rho2 as [s_rho2 [H_reach_rho2 H_max_rho2]].
        (* Now we have established that the next action in rho1 following alpha *)
        (* And because alpha1 and alpha1 ++ y1 are both synchronous words in the LTS, we are ready to obtain our first pair of states for the SCC contradiction *)
        (* We obtain our witness for s1 and s2 from alpha1 and y1 *)  
        assert (H_reach_alpha1 : @is_trace SyncAlphabet _ S alpha1).
        { eapply lts_trace_prefix_closed.
          exists s_rho1. exact H_reach_rho1.
          rewrite H_split1.
          now apply prefix_app_r. }
        assert (H_reach_alpha1y1 : @is_trace SyncAlphabet _ S (alpha1 ++ [y1])).
        { eapply lts_trace_prefix_closed.
          exists s_rho1. exact H_reach_rho1.
          rewrite H_split1.
          replace (alpha1 ++ y1 :: beta1) with (alpha1 ++ [y1] ++ beta1) by easy. 
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha1 as [s_alpha1 H_reach_alpha1].
        destruct H_reach_alpha1y1 as [s_alpha1y1 H_reach_alpha1y1].
        (* Instantiating s1, s2 *)
        spec H_NMC s_alpha1 s_alpha1y1.

        (* We obtain our witness for s1' and s2' from alpha2 and y2 *) 
        assert (H_reach_alpha2 : @is_trace SyncAlphabet _ S alpha2).
        { eapply lts_trace_prefix_closed.
          exists s_rho2. exact H_reach_rho2.
          rewrite H_split2.
          now apply prefix_app_r. }
        assert (H_reach_alpha2y2 : @is_trace SyncAlphabet _ S (alpha2 ++ [y2])).
        { eapply lts_trace_prefix_closed.
          exists s_rho2. exact H_reach_rho2.
          rewrite H_split2.
          replace (alpha2 ++ y2 :: beta2) with (alpha2 ++ [y2] ++ beta2) by easy. 
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha2 as [s_alpha2 H_reach_alpha2].
        destruct H_reach_alpha2y2 as [s_alpha2y2 H_reach_alpha2y2]. 
        (* Instantiating s1', s2' *)
        spec H_NMC s_alpha2 s_alpha2y2.
        (* Instantiating p q r *)
        destruct x1 as [x1 H_neq_x1].
        destruct x2 as [x2 H_neq_x2].
        destruct x1 as [p' q' m' | p' q' m'].
        2 : inversion H_snd1.
        (* Establishing that the sender in x1 is p *)
        assert (H_p'_p : p' = p).
        { assert (H_helper := in_wproj_means_active (split_symbol y1) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Snd p' q' m' ↾ H_neq_x1).
          spec H_helper.
          rewrite H_y1_x1.
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [H_helper _].
          spec H_helper. easy. easy. }
        (* Establishing that the receiver in x2 is p *)
        destruct x2 as [p'' q'' m'' | p'' q'' m''].
        inversion H_rcv2.
        assert (H_q''_q : q'' = p). 
        { assert (H_helper := in_wproj_means_active (split_symbol y2) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Rcv p'' q'' m'' ↾ H_neq_x2). 
          spec H_helper.
          rewrite H_y2_x2. 
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [_ H_helper].
          spec H_helper. easy. easy. }
        subst.
        spec H_NMC p q' p'' m' m'' H_neq_x1 H_neq_x2.
        (* Now discharging the next two obligations from NMC that require showing alpha1 -y1-> alpha1y1 *) 
        spec H_NMC. 
        {
          apply lts.Reachable_unwind in H_reach_alpha1y1.
          destruct H_reach_alpha1y1 as [s_alpha1' [H_reach_alpha1' H_goal]].
          assert (s_alpha1' = s_alpha1).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha1'.
          exact H_reach_alpha1. }
        assert (H_eq_y1 : y1 = (Event p q' m' ↾ H_neq_x1)). 
        { assert (H_helper := wproj_split_symbol_eq_snd_inv).
          spec H_helper y1 p q' m' H_neq_x1 H_y1_x1.
          destruct H_helper as [H_neq' H_rewrite].
          rewrite H_rewrite.
          f_equal. apply proof_irrelevance. }
        subst.
        assumption. }
        spec H_NMC. 
        { apply lts.Reachable_unwind in H_reach_alpha2y2.
          destruct H_reach_alpha2y2 as [s_alpha2' [H_reach_alpha2' H_goal]].
          assert (s_alpha2' = s_alpha2).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha2'.
          exact H_reach_alpha2. }
        assert (H_eq_y2 : y2 = (Event p'' p m'' ↾ H_neq_x2)).
          { assert (H_helper := wproj_split_symbol_eq_rcv_inv).
            spec H_helper y2 p'' p m'' H_neq_x2 H_y2_x2.
            destruct H_helper as [H_neq' H_rewrite].
            rewrite H_rewrite.
            f_equal. apply proof_irrelevance. } 
          subst.
          assumption. }
        (* Final simultaneous reachability obligation *) 
        spec H_NMC.
        exists (wproj w p).
        split.
        unfold reachable_for, reachable_for_on.
        exists alpha1. split. assumption.
        easy.
        exists alpha2. split. assumption.
        easy.
        (* Grand finale *)
        contradiction.
      ** (** Case: w1 comes from a finite run and w2 comes from an infinite run **)
        destruct H_fin1 as [v1 [H_fin1 H_pref1]].
        destruct H_fin1 as [rho1 [H_max_rho1 [H_role1 H_cc1]]]. 
        destruct H_inf2 as [v2 [H_inf2 [i H_pref2]]].
        spec H_inf2 i. 
        destruct H_inf2 as [rho_j [v [H_trace2 [H_role2 H_cc2]]]].
        (* Obtaining the unique splitting of w wrt rho1 and rho2 for p *) 
        (* Dealing with rho1, same as the above case because rho1 is still finite *) 
        assert (H_useful1 := prefix_app_finite_unique_splitting_elaborate).
        spec H_useful1 rho1 w x1 p.
        spec H_useful1. 
        rewrite <- H_eq1.
        rewrite (H_role1 p).
        now apply wproj_preserves_prefix.
        destruct H_useful1 as [alpha1 [y1 [beta1 [H_split1 [H_max_alpha1 H_y1_x1]]]]].
        destruct H_max_alpha1 as [H_pref_alpha1 [H_alpha1 H_max_alpha1]]. 
        destruct H_max_rho1 as [s_rho1 [H_reach_rho1 H_max_rho1]].
        (* Dealing with rho2, which is now different because rho2 is infinite *) 
        assert (H_useful2 := prefix_app_finite_unique_splitting_elaborate). 
        spec H_useful2 rho_j w x2 p.
        spec H_useful2. 
        rewrite <- H_eq2.
        rewrite <- (H_role2 p).
        rewrite H_pref2.
        apply wproj_preserves_prefix.
        now apply prefix_app_r.
        destruct H_useful2 as [alpha2 [y2 [beta2 [H_split2 [H_max_alpha2 H_y2_x2]]]]].
        destruct H_max_alpha2 as [H_pref_alpha2 [H_alpha2 H_max_alpha2]].
        (* spec H_max_rho2 j. *)
        (* destruct H_max_rho2 as [s_rho2_j [s_rho2_j' [H_reach_rho2_j H_reach_rho2_j']]]. *)
        (* Now we have established that the next action in rho1 following alpha *)
        (* And because alpha1 and alpha1 ++ y1 are both synchronous words in the LTS, we are ready to obtain our first pair of states for the SCC contradiction *)
        (* We obtain our witness for s1 and s2 from alpha1 and y1 *)  
        assert (H_reach_alpha1 : @is_trace SyncAlphabet _ S alpha1).
        { eapply lts_trace_prefix_closed.
          exists s_rho1. exact H_reach_rho1.
          rewrite H_split1.
          now apply prefix_app_r. }
        assert (H_reach_alpha1y1 : @is_trace SyncAlphabet _ S (alpha1 ++ [y1])).
        { eapply lts_trace_prefix_closed.
          exists s_rho1. exact H_reach_rho1.
          rewrite H_split1.
          replace (alpha1 ++ y1 :: beta1) with (alpha1 ++ [y1] ++ beta1) by easy. 
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha1 as [s_alpha1 H_reach_alpha1].
        destruct H_reach_alpha1y1 as [s_alpha1y1 H_reach_alpha1y1].
        (* Instantiating s1, s2 *)
        spec H_NMC s_alpha1 s_alpha1y1.

        (* We obtain our witness for s1' and s2' from alpha2 and y2 *) 
        assert (H_reach_alpha2 : @is_trace SyncAlphabet _ S alpha2).
        { eapply lts_trace_prefix_closed.
          eapply deadlock_free_lts_trace_prefix_iff. unfold GCLTS in *. tauto.
          exact H_trace2. rewrite H_split2.
          now apply prefix_app_r. }
        assert (H_reach_alpha2y2 : @is_trace SyncAlphabet _ S (alpha2 ++ [y2])).
        { eapply lts_trace_prefix_closed.
          eapply deadlock_free_lts_trace_prefix_iff. unfold GCLTS in *. tauto.
          exact H_trace2. rewrite H_split2.  
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha2 as [s_alpha2 H_reach_alpha2].
        destruct H_reach_alpha2y2 as [s_alpha2y2 H_reach_alpha2y2]. 
        (* Instantiating s1', s2' *)
        spec H_NMC s_alpha2 s_alpha2y2.
        (* Instantiating p q r *)
        destruct x1 as [x1 H_neq_x1].
        destruct x2 as [x2 H_neq_x2].
        destruct x1 as [p' q' m' | p' q' m'].
        2 : inversion H_snd1.
        (* Establishing that the sender in x1 is p *)
        assert (H_p'_p : p' = p).
        { assert (H_helper := in_wproj_means_active (split_symbol y1) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Snd p' q' m' ↾ H_neq_x1).
          spec H_helper.
          rewrite H_y1_x1.
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [H_helper _].
          spec H_helper. easy. easy. }
        (* Establishing that the receiver in x2 is p *)
        destruct x2 as [p'' q'' m'' | p'' q'' m''].
        inversion H_rcv2.
        assert (H_q''_q : q'' = p). 
        { assert (H_helper := in_wproj_means_active (split_symbol y2) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Rcv p'' q'' m'' ↾ H_neq_x2). 
          spec H_helper.
          rewrite H_y2_x2. 
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [_ H_helper].
          spec H_helper. easy. easy. }
        subst.
        spec H_NMC p q' p'' m' m'' H_neq_x1 H_neq_x2.
        (* Now discharging the next two obligations from NMC that require showing alpha1 -y1-> alpha1y1 *) 
        spec H_NMC. 
        {
          apply lts.Reachable_unwind in H_reach_alpha1y1.
          destruct H_reach_alpha1y1 as [s_alpha1' [H_reach_alpha1' H_goal]].
          assert (s_alpha1' = s_alpha1).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha1'.
          exact H_reach_alpha1. }
        assert (H_eq_y1 : y1 = (Event p q' m' ↾ H_neq_x1)). 
        { assert (H_helper := wproj_split_symbol_eq_snd_inv).
          spec H_helper y1 p q' m' H_neq_x1 H_y1_x1.
          destruct H_helper as [H_neq' H_rewrite].
          rewrite H_rewrite.
          f_equal. apply proof_irrelevance. }
        subst.
        assumption. }
        spec H_NMC. 
        { apply lts.Reachable_unwind in H_reach_alpha2y2.
          destruct H_reach_alpha2y2 as [s_alpha2' [H_reach_alpha2' H_goal]].
          assert (s_alpha2' = s_alpha2).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha2'.
          exact H_reach_alpha2. }
        assert (H_eq_y2 : y2 = (Event p'' p m'' ↾ H_neq_x2)).
          { assert (H_helper := wproj_split_symbol_eq_rcv_inv).
            spec H_helper y2 p'' p m'' H_neq_x2 H_y2_x2.
            destruct H_helper as [H_neq' H_rewrite].
            rewrite H_rewrite.
            f_equal. apply proof_irrelevance. } 
          subst.
          assumption. }
        (* Final simultaneous reachability obligation *) 
        spec H_NMC.
        exists (wproj w p).
        split.
        unfold reachable_for, reachable_for_on.
        exists alpha1. split. assumption.
        easy.
        exists alpha2. split. assumption.
        easy.
        (* Grand finale *)
        contradiction.
    * destruct H_prot_pref2 as [H_fin2 | H_inf2].
      ** (** Case: w1 comes from an infinite run and w2 comes from a finite run **)
        destruct H_inf1 as [v1 [H_inf1 [i H_pref1]]].
        (* destruct H_inf1 as [rho1 [H_max_rho1 H_about_rho1]]. *)
        (* spec H_about_rho1 i.  *)
        spec H_inf1 i.
        destruct H_inf1 as [rho_j [v [H_trace_rho_j [H_role1 H_cc1]]]]. 
        destruct H_fin2 as [v2 [H_fin2 H_pref2]]. 
        destruct H_fin2 as [rho2 [H_max_rho2 [H_role2 H_cc2]]]. 
        (* Obtaining the unique splitting of w wrt rho1 and rho2 for p *)
        (* Dealing with infinite rho1 *)
        assert (H_useful1 := prefix_app_finite_unique_splitting_elaborate). 
        spec H_useful1 rho_j w x1 p.
        spec H_useful1. 
        rewrite <- H_eq1.
        rewrite <- (H_role1 p).
        rewrite H_pref1.
        apply wproj_preserves_prefix.
        now apply prefix_app_r.
        destruct H_useful1 as [alpha1 [y1 [beta1 [H_split1 [H_max_alpha1 H_y1_x1]]]]].
        destruct H_max_alpha1 as [H_pref_alpha1 [H_alpha1 H_max_alpha1]].
        eapply deadlock_free_lts_trace_prefix_iff in H_trace_rho_j.
        2 : { unfold GCLTS in *. tauto. }
        destruct H_trace_rho_j as [s_rho1_j H_reach_rho1_j]. 
        (* Dealing with finite rho2 *)
        assert (H_useful2 := prefix_app_finite_unique_splitting_elaborate).
        spec H_useful2 rho2 w x2 p.
        spec H_useful2. 
        rewrite <- H_eq2.
        rewrite (H_role2 p).
        now apply wproj_preserves_prefix.
        destruct H_useful2 as [alpha2 [y2 [beta2 [H_split2 [H_max_alpha2 H_y2_x2]]]]].
        destruct H_max_alpha2 as [H_pref_alpha2 [H_alpha2 H_max_alpha2]]. 
        destruct H_max_rho2 as [s_rho2 [H_reach_rho2 H_max_rho2]].
        (* Now we have established that the next action in rho1 following alpha *)
        (* And because alpha1 and alpha1 ++ y1 are both synchronous words in the LTS, we are ready to obtain our first pair of states for the SCC contradiction *)
        (* We obtain our witness for s1 and s2 from alpha1 and y1 *)  
        assert (H_reach_alpha1 : @is_trace SyncAlphabet _ S alpha1).
        { eapply lts_trace_prefix_closed.
          exists s_rho1_j. exact H_reach_rho1_j.
          rewrite H_split1.
          now apply prefix_app_r. }
        assert (H_reach_alpha1y1 : @is_trace SyncAlphabet _ S (alpha1 ++ [y1])).
        { eapply lts_trace_prefix_closed.
          exists s_rho1_j. exact H_reach_rho1_j.
          rewrite H_split1.
          replace (alpha1 ++ y1 :: beta1) with (alpha1 ++ [y1] ++ beta1) by easy. 
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha1 as [s_alpha1 H_reach_alpha1].
        destruct H_reach_alpha1y1 as [s_alpha1y1 H_reach_alpha1y1].
        (* Instantiating s1, s2 *)
        spec H_NMC s_alpha1 s_alpha1y1.

        (* We obtain our witness for s1' and s2' from alpha2 and y2 *) 
        assert (H_reach_alpha2 : @is_trace SyncAlphabet _ S alpha2).
        { eapply lts_trace_prefix_closed.
          exists s_rho2. exact H_reach_rho2.
          rewrite H_split2.
          now apply prefix_app_r. }
        assert (H_reach_alpha2y2 : @is_trace SyncAlphabet _ S (alpha2 ++ [y2])).
        { eapply lts_trace_prefix_closed.
          exists s_rho2. exact H_reach_rho2.
          rewrite H_split2.
          replace (alpha2 ++ y2 :: beta2) with (alpha2 ++ [y2] ++ beta2) by easy. 
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha2 as [s_alpha2 H_reach_alpha2].
        destruct H_reach_alpha2y2 as [s_alpha2y2 H_reach_alpha2y2]. 
        (* Instantiating s1', s2' *)
        spec H_NMC s_alpha2 s_alpha2y2.
        (* Instantiating p q r *)
        destruct x1 as [x1 H_neq_x1].
        destruct x2 as [x2 H_neq_x2].
        destruct x1 as [p' q' m' | p' q' m'].
        2 : inversion H_snd1.
        (* Establishing that the sender in x1 is p *)
        assert (H_p'_p : p' = p).
        { assert (H_helper := in_wproj_means_active (split_symbol y1) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Snd p' q' m' ↾ H_neq_x1).
          spec H_helper.
          rewrite H_y1_x1.
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [H_helper _].
          spec H_helper. easy. easy. }
        (* Establishing that the receiver in x2 is p *)
        destruct x2 as [p'' q'' m'' | p'' q'' m''].
        inversion H_rcv2.
        assert (H_q''_q : q'' = p). 
        { assert (H_helper := in_wproj_means_active (split_symbol y2) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Rcv p'' q'' m'' ↾ H_neq_x2). 
          spec H_helper.
          rewrite H_y2_x2. 
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [_ H_helper].
          spec H_helper. easy. easy. }
        subst.
        spec H_NMC p q' p'' m' m'' H_neq_x1 H_neq_x2.
        (* Now discharging the next two obligations from NMC that require showing alpha1 -y1-> alpha1y1 *) 
        spec H_NMC. 
        {
          apply lts.Reachable_unwind in H_reach_alpha1y1.
          destruct H_reach_alpha1y1 as [s_alpha1' [H_reach_alpha1' H_goal]].
          assert (s_alpha1' = s_alpha1).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha1'.
          exact H_reach_alpha1. }
        assert (H_eq_y1 : y1 = (Event p q' m' ↾ H_neq_x1)). 
        { assert (H_helper := wproj_split_symbol_eq_snd_inv).
          spec H_helper y1 p q' m' H_neq_x1 H_y1_x1.
          destruct H_helper as [H_neq' H_rewrite].
          rewrite H_rewrite.
          f_equal. apply proof_irrelevance. }
        subst.
        assumption. }
        spec H_NMC. 
        { apply lts.Reachable_unwind in H_reach_alpha2y2.
          destruct H_reach_alpha2y2 as [s_alpha2' [H_reach_alpha2' H_goal]].
          assert (s_alpha2' = s_alpha2).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha2'.
          exact H_reach_alpha2. }
        assert (H_eq_y2 : y2 = (Event p'' p m'' ↾ H_neq_x2)).
          { assert (H_helper := wproj_split_symbol_eq_rcv_inv).
            spec H_helper y2 p'' p m'' H_neq_x2 H_y2_x2.
            destruct H_helper as [H_neq' H_rewrite].
            rewrite H_rewrite.
            f_equal. apply proof_irrelevance. } 
          subst.
          assumption. }
        (* Final simultaneous reachability obligation *) 
        spec H_NMC.
        exists (wproj w p).
        split.
        unfold reachable_for, reachable_for_on.
        exists alpha1. split. assumption.
        easy.
        exists alpha2. split. assumption.
        easy.
        (* Grand finale *)
        contradiction.
      ** (** Case: both w1 and w2 come from infinite runs **)
        destruct H_inf1 as [v1 [H_inf1 [i1 H_pref1]]].
        (* destruct H_inf1 as [rho1 [H_max_rho1 H_about_rho1]]. *)
        spec H_inf1 i1. 
        destruct H_inf1 as [rho_j1 [v1' [H_trace_rho1 [H_role1 H_cc1]]]]. 
        destruct H_inf2 as [v2 [H_inf2 [i2 H_pref2]]].
        (* destruct H_inf2 as [rho2 [H_max_rho2 H_about_rho2]]. *)
        spec H_inf2 i2. 
        destruct H_inf2 as [rho_j2 [v2' [H_trace_rho2 [H_role2 H_cc2]]]]. 
        (* Obtaining the unique splitting of w wrt rho1 and rho2 for p *)
        (* Dealing with infinite rho1 *)
        assert (H_useful1 := prefix_app_finite_unique_splitting_elaborate). 
        spec H_useful1 rho_j1 w x1 p.
        spec H_useful1. 
        rewrite <- H_eq1.
        rewrite <- (H_role1 p).
        rewrite H_pref1.
        apply wproj_preserves_prefix.
        now apply prefix_app_r.
        destruct H_useful1 as [alpha1 [y1 [beta1 [H_split1 [H_max_alpha1 H_y1_x1]]]]].
        destruct H_max_alpha1 as [H_pref_alpha1 [H_alpha1 H_max_alpha1]].
        eapply deadlock_free_lts_trace_prefix_iff in H_trace_rho1.
        2 : { unfold GCLTS in *. tauto. }
        destruct H_trace_rho1 as [s_rho1_j H_reach_rho1_j].  
        (* Dealing with finite rho2 *)
        assert (H_useful2 := prefix_app_finite_unique_splitting_elaborate). 
        spec H_useful2 rho_j2 w x2 p.
        spec H_useful2. 
        rewrite <- H_eq2.
        rewrite <- (H_role2 p).
        rewrite H_pref2.
        apply wproj_preserves_prefix.
        now apply prefix_app_r.
        destruct H_useful2 as [alpha2 [y2 [beta2 [H_split2 [H_max_alpha2 H_y2_x2]]]]].
        destruct H_max_alpha2 as [H_pref_alpha2 [H_alpha2 H_max_alpha2]].
        eapply deadlock_free_lts_trace_prefix_iff in H_trace_rho2.
        2 : { unfold GCLTS in *. tauto. }
        destruct H_trace_rho2 as [s_rho2_j H_reach_rho2_j]. 
        (* Now we have established that the next action in rho1 following alpha *)
        (* And because alpha1 and alpha1 ++ y1 are both synchronous words in the LTS, we are ready to obtain our first pair of states for the SCC contradiction *)
        (* We obtain our witness for s1 and s2 from alpha1 and y1 *)  
        assert (H_reach_alpha1 : @is_trace SyncAlphabet _ S alpha1).
        { eapply lts_trace_prefix_closed.
          exists s_rho1_j. exact H_reach_rho1_j.
          rewrite H_split1.
          now apply prefix_app_r. }
        assert (H_reach_alpha1y1 : @is_trace SyncAlphabet _ S (alpha1 ++ [y1])).
        { eapply lts_trace_prefix_closed.
          exists s_rho1_j. exact H_reach_rho1_j.
          rewrite H_split1.
          replace (alpha1 ++ y1 :: beta1) with (alpha1 ++ [y1] ++ beta1) by easy. 
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha1 as [s_alpha1 H_reach_alpha1].
        destruct H_reach_alpha1y1 as [s_alpha1y1 H_reach_alpha1y1].
        (* Instantiating s1, s2 *)
        spec H_NMC s_alpha1 s_alpha1y1.

        (* We obtain our witness for s1' and s2' from alpha2 and y2 *) 
        assert (H_reach_alpha2 : @is_trace SyncAlphabet _ S alpha2).
        { eapply lts_trace_prefix_closed.
          exists s_rho2_j. exact H_reach_rho2_j.
          rewrite H_split2.
          now apply prefix_app_r. }
        assert (H_reach_alpha2y2 : @is_trace SyncAlphabet _ S (alpha2 ++ [y2])).
        { eapply lts_trace_prefix_closed.
          exists s_rho2_j. exact H_reach_rho2_j.
          rewrite H_split2.
          replace (alpha2 ++ y2 :: beta2) with (alpha2 ++ [y2] ++ beta2) by easy. 
          rewrite app_assoc.
          now apply prefix_app_r. }
        destruct H_reach_alpha2 as [s_alpha2 H_reach_alpha2].
        destruct H_reach_alpha2y2 as [s_alpha2y2 H_reach_alpha2y2]. 
        (* Instantiating s1', s2' *)
        spec H_NMC s_alpha2 s_alpha2y2.
        (* Instantiating p q r *)
        destruct x1 as [x1 H_neq_x1].
        destruct x2 as [x2 H_neq_x2].
        destruct x1 as [p' q' m' | p' q' m'].
        2 : inversion H_snd1.
        (* Establishing that the sender in x1 is p *)
        assert (H_p'_p : p' = p).
        { assert (H_helper := in_wproj_means_active (split_symbol y1) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Snd p' q' m' ↾ H_neq_x1).
          spec H_helper.
          rewrite H_y1_x1.
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [H_helper _].
          spec H_helper. easy. easy. }
        (* Establishing that the receiver in x2 is p *)
        destruct x2 as [p'' q'' m'' | p'' q'' m''].
        inversion H_rcv2.
        assert (H_q''_q : q'' = p). 
        { assert (H_helper := in_wproj_means_active (split_symbol y2) p).
          rewrite Forall_forall in H_helper.
          spec H_helper (Rcv p'' q'' m'' ↾ H_neq_x2). 
          spec H_helper.
          rewrite H_y2_x2. 
          apply elem_of_list_In.
          apply in_eq. unfold is_active in H_helper.
          destruct H_helper as [_ H_helper].
          spec H_helper. easy. easy. }
        subst.
        spec H_NMC p q' p'' m' m'' H_neq_x1 H_neq_x2.
        (* Now discharging the next two obligations from NMC that require showing alpha1 -y1-> alpha1y1 *) 
        spec H_NMC. 
        {
          apply lts.Reachable_unwind in H_reach_alpha1y1.
          destruct H_reach_alpha1y1 as [s_alpha1' [H_reach_alpha1' H_goal]].
          assert (s_alpha1' = s_alpha1).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha1'.
          exact H_reach_alpha1. }
        assert (H_eq_y1 : y1 = (Event p q' m' ↾ H_neq_x1)). 
        { assert (H_helper := wproj_split_symbol_eq_snd_inv).
          spec H_helper y1 p q' m' H_neq_x1 H_y1_x1.
          destruct H_helper as [H_neq' H_rewrite].
          rewrite H_rewrite.
          f_equal. apply proof_irrelevance. }
        subst.
        assumption. }
        spec H_NMC. 
        { apply lts.Reachable_unwind in H_reach_alpha2y2.
          destruct H_reach_alpha2y2 as [s_alpha2' [H_reach_alpha2' H_goal]].
          assert (s_alpha2' = s_alpha2).
        { eapply deterministic_word.
          destruct H_GCLTS as [H_det _].
          exact H_det. 
          exact H_reach_alpha2'.
          exact H_reach_alpha2. }
        assert (H_eq_y2 : y2 = (Event p'' p m'' ↾ H_neq_x2)).
          { assert (H_helper := wproj_split_symbol_eq_rcv_inv).
            spec H_helper y2 p'' p m'' H_neq_x2 H_y2_x2.
            destruct H_helper as [H_neq' H_rewrite].
            rewrite H_rewrite.
            f_equal. apply proof_irrelevance. } 
          subst.
          assumption. }
        (* Final simultaneous reachability obligation *) 
        spec H_NMC.
        exists (wproj w p).
        split.
        unfold reachable_for, reachable_for_on.
        exists alpha1. split. assumption.
        easy.
        exists alpha2. split. assumption.
        easy.
        (* Grand finale *)
        contradiction.
Qed.

End NMC. 
