Require Import List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq 
  Require Import ssreflect.
         
From CC 
  Require Import lib structures clts lts channel_complete channel_compliant protocol closure_conditions run.

Section NMC_Completeness.

Context {State : Type} {LocalState : Type}. 
(* Key insight into mailbox semantics:
   I set emptiness no longer suffices, because according to the mailbox ~ relation,
   plenty of words in the language have empty I sets *) 
Lemma completeness_sufficiency_fact :
  forall (S : @LTS SyncAlphabet State) (T : @CLTS LocalState) (w : FinAsyncWord),
    GCLTS S -> 
    @is_clts_prefix LocalState T w -> 
    ~ I_set_non_empty S w ->
    ~ implements S T. 
Proof.   
  intros S T w H_GCLTS H_trace H_empty H_false. 
  eapply (@protocol_fidelity_means_prefixes_eq State LocalState S T w) in H_false.
  apply H_false in H_trace.
  clear H_false. apply H_empty.
  clear H_empty.
  destruct H_trace as [[w_fin [H_fin H_pref]] | [w_inf [H_inf H_pref]]].
  (* Now we just need to prove that any protocol word has a possible run *) 
  - destruct H_fin as [run_fin [H_max [H_role H_cc]]].
    left. exists run_fin.
    split. assumption.
    intro p.
    spec H_role p.
    rewrite H_role. 
    now apply wproj_preserves_prefix.
  - destruct H_pref as [i H_pref].
    spec H_inf i.
    destruct H_inf as [rho [v [H_trace [H_role H_cc]]]].
    destruct H_GCLTS as [_ [_ [_ [H_df _]]]].
    eapply deadlock_free_lts_trace_prefix_iff in H_trace.
    2 : { unfold GCLTS in *. tauto. }
    destruct H_trace as [s_rho H_reach_s_rho].
    spec H_df s_rho rho H_reach_s_rho.
    destruct H_df as [H_fin | H_inf]. 
    * destruct H_fin as [fin_run [H_fin_run H_pref_fin_run]].
      left. exists fin_run.
      split. assumption.
      intro p.
      spec H_role p.
      apply prefix_split_prefix_iff in H_pref_fin_run.
      apply (wproj_preserves_prefix _ _ p) in H_pref_fin_run.
      rewrite H_pref in H_role.
      rewrite wproj_app in H_role.
      rewrite <- H_role in H_pref_fin_run.
      eapply prefix_app_l.
      exact H_pref_fin_run.
    * destruct H_inf as [run [H_inf_run H_pref_inf_run]].
      right. 
      exists run. split. 
      assumption. intro p.
      destruct H_pref_inf_run as [j H_pref_inf_run].
      exists j. rewrite H_pref_inf_run.
      spec H_role p. rewrite H_pref in H_role.
      rewrite wproj_app in H_role.
      rewrite <- H_role.
      now apply prefix_app_r.
Qed. 

Lemma NMC_completeness_helper :
  forall (S : LTS)
  (H_GCLTS : GCLTS S)
  (s1 s2 s3 s4 : State)
  (p q r : participant)
  (m m' : message)
  (H_pq : sender_receiver_neq_sync
           (Event p q m))
  (H_rp : sender_receiver_neq_sync
           (Event r p m'))
  (H_transition1 : transition S s1
                    (Event p q m ↾ H_pq) s2)
  (H_transition2 : transition S s3
                    (Event r p m' ↾ H_rp) s4)
  (u_p : FinAsyncWord)
  (w1 : FinSyncWord)
  (H_reach1 : @Reachable SyncAlphabet State S (s0 S) w1 s1)
  (H_proj1 : wproj (split w1) p = u_p)
  (w2 : FinSyncWord)
  (H_reach2 : @Reachable SyncAlphabet State S (s0 S) w2 s3)
  (H_proj2 : wproj (split w2) p = u_p)
  (T : CLTS)
  (H_df : clts_deadlock_free T)
  (H_impl_copy : @implements State LocalState S T)
  (H_pq_async : sender_receiver_neq_async
                 (Snd p q m))
  (H_rp_async : sender_receiver_neq_async
                  (Snd r p m'))
  (rho_false : FinSyncWord)
  (H_run_rho_false : @is_trace SyncAlphabet State S rho_false)
  (H_possible_rho_false : per_role_prefix (split w2 ++
                              [Snd r p m' ↾ H_rp_async] ++ [Snd p q m ↾ H_pq_async]) (split rho_false)),
     False. 
Proof.
  intros. 
  assert (H_useful := split_run_finite_possible_run_prefix S rho_false w2 H_GCLTS H_run_rho_false).
  spec H_useful.
  exists s3. exact H_reach2.
  spec H_useful.
  { 
    intro p0.
    spec H_possible_rho_false p0.
    rewrite wproj_app in H_possible_rho_false. 
    apply prefix_app_l in H_possible_rho_false.
    assumption. }
  (* Because w2 < rho_false and rho_false is compliant with r, it must be the case that w2 ++ [Event r p m'] < rho_false *)
  (* We first establish that w2 ++ [Event r p m'] < rho_false *) 
  apply prefix_exists_suffix in H_useful. 
  destruct H_useful as [rho_false_suf H_rho_false_split].
  destruct rho_false_suf as [| rho_false_next rho_false_suf].
  {
    (* Discharging the case where rho_false = w2 *)
    (* Using either of r or p will do *) 
    spec H_possible_rho_false r.
    rewrite app_nil_r in H_rho_false_split. 
    subst.
    repeat rewrite wproj_app in H_possible_rho_false.
    rewrite wproj_sender_eq in H_possible_rho_false.
    reflexivity.
    eapply (prefix_app_not _ ([Snd r p m' ↾ H_rp_async] ++ wproj [Snd p q m ↾ H_pq_async] r)).
    easy. exact H_possible_rho_false. }
  (* Now we establish that rho_false_next must be (Event r p m' *)
  assert (H_next_eq : rho_false_next = (Event r p m' ↾ H_rp)).
  {
    unfold GCLTS in H_GCLTS.
    destruct H_GCLTS as [H_det [H_sender_driven _]].
    assert (H_run_w2' : @is_trace SyncAlphabet State S (w2 ++ [rho_false_next])). 
    { eapply lts_trace_prefix_closed with rho_false.
      assumption.
      rewrite H_rho_false_split.
      replace (rho_false_next :: rho_false_suf) with ([rho_false_next] ++ rho_false_suf) by easy. 
      rewrite app_assoc. now apply prefix_app_r. }
    destruct H_run_w2' as [s_w2' H_reach_w2'].
    apply lts.Reachable_unwind in H_reach_w2'.
    destruct H_reach_w2' as [s_w2 [H_reach_w2 H_transition]].
    assert (H_s3_eq : s_w2 = s3) by now eapply (deterministic_word S s_w2 s3 w2).
    (* Instantiating sender-driven choice *) 
    subst.
    spec H_sender_driven s3 s4 s_w2' (exist _ (Event r p m') H_rp) rho_false_next H_transition2 H_transition.
    (* Now we have established that the sender in rho_false_next must be r *)
    destruct rho_false_next as [rho_false_next H_neq_next].
    destruct rho_false_next as [p0 q0 m0].
    unfold sender_sync in H_sender_driven.
    simpl in H_sender_driven.
    (* Now we instantiate H_possible_rho_false with p0 = r to establish the rest of the equalities *)
    spec H_possible_rho_false r.
    clean H_possible_rho_false. 
    (* Omg the tactic worked! *)
    apply (prefix_app_inv (wproj (split w2) r)) in H_possible_rho_false.
    rewrite (wproj_symbol_sender_eq r p r m' H_rp_async) in H_possible_rho_false.
    reflexivity.
    subst.
    rewrite (wproj_symbol_sender_eq p0 q0 p0 m0 H_neq_next) in H_possible_rho_false.
    reflexivity.
    inversion H_possible_rho_false.
    inversion H. subst.
    sigma_equal. }
  (* Now we have established that the next event following w2 must be (Event r p m') *)
  subst.
  (* Now we can finally find a contradiction by instantiating H_possible_rho_false with p *)
  spec H_possible_rho_false p.
  clean H_possible_rho_false.
  apply (prefix_app_inv (wproj (split w2) p)) in H_possible_rho_false.
  rewrite (wproj_symbol_sender_neq r p p m' H_rp_async) in H_possible_rho_false. 
  easy. 
  rewrite app_nil_l in H_possible_rho_false. 
  rewrite (wproj_symbol_sender_eq p q p m H_pq_async) in H_possible_rho_false.
  reflexivity.
  rewrite (wproj_symbol_sender_neq r p p m' H_rp) in H_possible_rho_false. 
  easy. 
  rewrite app_nil_l in H_possible_rho_false. 
  rewrite (wproj_symbol_receiver_eq r p p m' H_rp) in H_possible_rho_false.
  reflexivity.
  inversion H_possible_rho_false.
  inversion H. 
Qed. 

Lemma NMC_completeness :
  forall (S : @LTS SyncAlphabet State),
    GCLTS S -> 
    ~ @NMC State S ->
    ~@implementable State LocalState S.  
Proof.
  intros S H_GCLTS H_NMC.
  assert (H_df_copy : deadlock_free S). { unfold GCLTS in *; tauto. } 
  apply neg_NMC_iff in H_NMC.
  destruct H_NMC as [s1 [s2 [s3 [s4 [p [q [r [m [m' [H_pq [H_rp [H_transition1 [H_transition2 H_sim_reach]]]]]]]]]]]]].
  destruct H_sim_reach as [u_p [H_reach_s1 H_reach_s3]].
  intro H_impl.
  unfold implementable in H_impl. 
  destruct H_impl as [T H_impl].
  assert (H_impl_copy := H_impl). 
  destruct H_impl as [[H_incl1 H_incl2] H_df].
  (* Now we need to construct a prefix to use the sufficient fact about completeness *) 
  assert (H_suf := completeness_sufficiency_fact S T).
  destruct H_reach_s1 as [w1 [H_reach1 H_proj1]].
  destruct H_reach_s3 as [w2 [H_reach2 H_proj2]].  
  (* Need fact about every reachable state leading to a maximal run *)
  assert (H_key : exists (w : FinAsyncWord), @is_clts_trace LocalState T w /\ ~ I_set_non_empty S w). 
  { (* Constructing the witness immediately *)
    (* Brief moment of panic: the same witness as SCC does not work here *)
    (* Instead we need to have r send first, then p send *)  
    assert (H_pq_async : sender_receiver_neq_async (Snd p q m)) by easy.
    assert (H_rp_async : sender_receiver_neq_async (Snd r p m')) by easy.
    exists (split w2 ++ [exist _ (Snd r p m') H_rp_async] ++ [exist _ (Snd p q m) H_pq_async]).
    split. 
    (** First obligation is that our witness is a CLTS trace **)
    (* Because we do two send extensions, we need to invoke this lemma twice *) 
    rewrite app_assoc.   
    assert (H_layer1 := clts_trace_snd_extension_sufficient T (split w2) r p m' H_rp_async).
    assert (H_layer2 := clts_trace_snd_extension_sufficient T (split w2 ++ [Snd r p m' ↾ H_rp_async]) p q m H_pq_async).
    - (* First we show that split w2 ++ [exist _ (Snd r p m') H_rp_async] is a CLTS trace *)
      (* It is sufficient to show that (split w2) is a CLTS trace
       and that the first send extension is a local trace for p *)
      spec H_layer1.
      (* Showing that (split w2) is a CLTS trace *) 
      { assert (H_helper := @deadlock_free_clts_trace_prefix_iff LocalState T (split w2) H_df).
        rewrite H_helper. clear H_helper. 
        eapply protocol_fidelity_means_prefixes_eq in H_impl_copy.
        apply H_impl_copy.
        eapply split_run_protocol_prefix.
        unfold GCLTS in H_GCLTS. tauto.
        exact H_reach2. 
      }
      spec H_layer1. 
      (* Showing that (wproj (split w2) p ++ [Snd r p m' ↾ H_rp_async]) is a T_r trace *)
      (* Step 1 : (split w2) ++ [Snd r p m' ↾ H_rp_async] is a protocol prefix *)
      (* Step 2 : (split w2) ++ [Snd r p m' ↾ H_rp_async] is trace of implementation T *) 
      (* Step 3 : wproj (split w2) r ++ [Snd r p m' ↾ H_rp_async] is a trace of T_r *)
      (* Asserting this as a goal so we can reuse it later *) 
      { 
        assert (H_step1 : @is_protocol_prefix State S  (split w2 ++ [Snd r p m' ↾ H_rp_async])). 
        {
          assert (H_inter1 : @is_trace SyncAlphabet State S (w2 ++ [(Event r p m' ↾ H_rp)])).
          { exists s4.
            now apply Reachable_step with s3.
          } 
          destruct H_inter1 as [s_w2x1 H_reach_w2x1].
          destruct H_GCLTS as [_ [_ [_ [H_df_S _]]]].
          spec H_df_S s_w2x1 (w2 ++ [Event r p m' ↾ H_rp]) H_reach_w2x1.
          destruct H_df_S as [H_fin | H_inf].
          - destruct H_fin as [run_fin [H_max H_pref]].
            left. exists (split run_fin). split.
            now apply split_finite_run_is_finite_word. 
            apply prefix_split_prefix_iff in H_pref.
            rewrite split_app in H_pref. 
            unfold split at 2 in H_pref.
            unfold split_symbol in H_pref.
            simpl in H_pref.
            unfold sender_sync, receiver_sync, value_sync in H_pref.
            simpl in H_pref.
            apply prefix_app_l with [Rcv r p m' ↾ H_rp].
            rewrite <- app_assoc. simpl.
            assert (H_rewrite : (Snd r p m' ↾ H_rp_async) = (Snd r p m' ↾ H_rp)) by sigma_equal. 
            now rewrite H_rewrite.
          - destruct H_inf as [run_inf [H_max H_pref]].
            right. exists (split_inf run_inf). split.
            now apply split_infinite_run_is_infinite_word.
            destruct H_pref as [i H_pref].
            (* w1 is length (i-1), and (Event p q m) is the ith element in run_inf *)
            (* First we establish that i >= 1 *) 
            destruct i. 
            rewrite stream_to_list_zero in H_pref.
            symmetry in H_pref.
            apply app_eq_nil in H_pref.
            destruct H_pref as [_ H_pref]. inversion H_pref.
            exists (Datatypes.S (2*i)).
            assert (H_useful : stream_to_list run_inf i = w2 /\ Str_nth i run_inf = (Event r p m' ↾ H_rp)).
            { assert (H_inter := stream_to_list_S_Str_nth_app SyncAlphabet i run_inf).
              rewrite H_inter in H_pref.
              apply app_inj_2 in H_pref.
              split. tauto.
              destruct H_pref as [_ H_x].
              inversion H_x. reflexivity.
              easy. }
            rewrite stream_to_list_S_Str_nth_app.
            destruct H_useful as [H_w2 H_x2].
            rewrite <- H_w2. 
            rewrite split_inf_inf_split.
            rewrite app_inv_head_iff.  
            f_equal.
            assert (H_helper := Str_nth_split_inf_inf_split run_inf i r p m' H_rp H_rp_async H_rp_async H_x2).
            tauto. 
        }
        assert (H_step2 : @is_clts_trace LocalState T  (split w2 ++ [Snd r p m' ↾ H_rp_async])).
        {
          apply (protocol_fidelity_means_prefixes_eq S T (split w2 ++ [Snd r p m' ↾ H_rp_async])) in H_impl_copy. 
          apply H_impl_copy in H_step1.
          now apply deadlock_free_clts_trace_prefix_iff.
        }
        assert (H_step3 : @is_trace AsyncAlphabet LocalState (implementations T r) (wproj (split w2) r ++ [Snd r p m' ↾ H_rp_async])).
        {
          rewrite <- (wproj_sender_eq r p r m'). 
          2 : reflexivity.
          rewrite <- wproj_app.
          destruct H_step2 as [c H_step2].
          assert (H_useful := @clts_trace_participant_projection LocalState T). 
          spec H_useful (split w2 ++ [Snd r p m' ↾ H_rp_async]) c H_step2 r.
          exists (get_local_state c r).
          assumption.
        }
        assumption.
      }
      (* Now we move onto the second send extension, i.e. H_layer2 *) 
      spec H_layer2.
      (* Showing that (split w2 ++ [Snd r p m' ↾ H_rp_async]) is a CLTS trace *) 
      (* This is exactly what H_layer1 was for *) 
      exact H_layer1.
      spec H_layer2.
      (* Showing that (wproj (split w2 ++ [Snd r p m' ↾ H_rp_async]) p ++
     [Snd p q m ↾ H_pq_async]) is a local prefix for p *) 
      (* We can first simplify the goal by removing the intermediate send action by r that p is uninvolved in *)
      rewrite wproj_app. 
      unfold wproj at 2.
      unfold wproj_symbol. simpl.
      rewrite (participant_eqb_no r p).
      exact H_rp. simpl.
      rewrite app_nil_r.
      (* Step 1 : (split w1) ++ [Snd p q m ↾ H_pq_async] is a protocol prefix *)
      (* Step 2 : (split w1) ++ [Snd p q m ↾ H_pq_async] is trace of implementation T *) 
      (* Step 3 : wproj (split w1) p ++ [Snd p q m ↾ H_pq_async] is a trace of T_p *)
      (* Step 4 : wproj (split w2) r ++ [Snd p q m ↾ H_pq_async] is a trace of T_p *) 
      assert (H_step1 : @is_protocol_prefix State S (split w1 ++ [Snd p q m ↾ H_pq_async])). 
      {
        assert (H_inter1 : @is_trace SyncAlphabet State S (w1 ++ [(Event p q m ↾ H_pq)])).
        {
          exists s2.
          now apply Reachable_step with s1. 
        }        
        destruct H_inter1 as [s_w1x1 H_reach_w1x1].
        destruct H_GCLTS as [_ [_ [_ [H_df_S _]]]].
      spec H_df_S s_w1x1 (w1 ++ [Event p q m ↾ H_pq]) H_reach_w1x1.
      destruct H_df_S as [H_fin | H_inf].
      - destruct H_fin as [run_fin [H_max H_pref]].
        left. exists (split run_fin). split.
        now apply split_finite_run_is_finite_word. 
        apply prefix_split_prefix_iff in H_pref.
        rewrite split_app in H_pref. 
        unfold split at 2 in H_pref.
        unfold split_symbol in H_pref.
        simpl in H_pref.
        unfold sender_sync, receiver_sync, value_sync in H_pref.
        simpl in H_pref.
        apply prefix_app_l with [Rcv p q m ↾ H_pq].
        rewrite <- app_assoc. simpl.
        assert (H_rewrite : (Snd p q m ↾ H_pq_async) = (Snd p q m ↾ H_pq)) by sigma_equal. 
        now rewrite H_rewrite.
      - destruct H_inf as [run_inf [H_max H_pref]].
            right. exists (split_inf run_inf). split.
            now apply split_infinite_run_is_infinite_word.
            destruct H_pref as [i H_pref].
            (* w1 is length (i-1), and (Event p q m) is the ith element in run_inf *)
            (* First we establish that i >= 1 *) 
            destruct i. 
            rewrite stream_to_list_zero in H_pref.
            symmetry in H_pref.
            apply app_eq_nil in H_pref.
            destruct H_pref as [_ H_pref]. inversion H_pref.
            exists (Datatypes.S (2*i)).
            assert (H_useful : stream_to_list run_inf i = w1 /\ Str_nth i run_inf = (Event p q m ↾ H_pq)).
            { assert (H_inter := stream_to_list_S_Str_nth_app SyncAlphabet i run_inf).
              rewrite H_inter in H_pref.
              apply app_inj_2 in H_pref.
              split. tauto.
              destruct H_pref as [_ H_x].
              inversion H_x. reflexivity.
              easy. }
            rewrite stream_to_list_S_Str_nth_app.
            destruct H_useful as [H_w1 H_x1].
            rewrite <- H_w1. 
            rewrite split_inf_inf_split.
            rewrite app_inv_head_iff.  
            f_equal.
            assert (H_helper := Str_nth_split_inf_inf_split run_inf i p q m H_pq H_pq_async H_pq_async H_x1).
            tauto. 
        } 
    assert (H_step2 : @is_clts_trace LocalState T (split w1 ++ [Snd p q m ↾ H_pq_async])).
    {
      apply (protocol_fidelity_means_prefixes_eq S T (split w1 ++ [Snd p q m ↾ H_pq_async])) in H_impl_copy. 
      apply H_impl_copy in H_step1.
      now apply deadlock_free_clts_trace_prefix_iff.
    }
    assert (H_step3 : @is_trace AsyncAlphabet LocalState (implementations T p) (wproj (split w1) p ++ [Snd p q m ↾ H_pq_async])).
    {
      rewrite <- (wproj_sender_eq p q p m). 
      2 : reflexivity.
      rewrite <- wproj_app.
      destruct H_step2 as [c H_step2].
      assert (H_useful := @clts_trace_participant_projection LocalState T). 
      spec H_useful (split w1 ++ [Snd p q m ↾ H_pq_async]) c H_step2 p.
      exists (get_local_state c p).
      assumption.
    }
    rewrite H_proj1 in H_step3.
    rewrite H_proj2. 
    assumption.
    assumption. 
    (** Second obligation is that the intersection set is empty **)
    (* We show by contradiction that if a run exists, then p cannot be compliant with it *) 
    - intro H_false.  
      destruct H_false as [H_false_fin | H_false_inf].
    (* Case split on whether the run in the intersection set is a finite or infinite run *)
      *  destruct H_false_fin as [rho_false [H_max_rho_false H_possible_rho_false]].  
         destruct H_max_rho_false as [s_rho [H_run_rho_false H_max_rho_false]].
         assert (H_useful := NMC_completeness_helper S H_GCLTS s1 s2 s3 s4 p q r m m' H_pq H_rp H_transition1 H_transition2 u_p w1 H_reach1 H_proj1 w2 H_reach2 H_proj2 T H_df H_impl_copy H_pq_async H_rp_async rho_false). 
         spec H_useful. { now exists s_rho. }
         spec H_useful H_possible_rho_false.
         contradiction.
      * destruct H_false_inf as [rho_inf H_possible_inf].
        assert (H_convert := infinite_possible_run_means_finite_possible_run_prefix S rho_inf (split w2 ++ [Snd r p m' ↾ H_rp_async] ++ [Snd p q m ↾ H_pq_async]) H_possible_inf). 
        destruct H_convert as [rho_false [H_run_rho_false H_possible_rho_false]].
        assert (H_useful := NMC_completeness_helper S H_GCLTS s1 s2 s3 s4 p q r m m' H_pq H_rp H_transition1 H_transition2 u_p w1 H_reach1 H_proj1 w2 H_reach2 H_proj2 T H_df H_impl_copy H_pq_async H_rp_async rho_false).
        spec H_useful.
        { unfold possible_run_prefix in H_run_rho_false. tauto. }
        spec H_useful.
        { unfold possible_run_prefix in H_run_rho_false. tauto. }
        contradiction. }
  (* Grand finale *) 
  destruct H_key as [v [H_trace_v H_I_v_empty]].
  spec H_suf v H_GCLTS.
  spec H_suf.
  now apply deadlock_free_clts_trace_prefix_iff.
  spec H_suf H_I_v_empty. 
  contradiction.
Qed.

End NMC_Completeness.
