Require Import Arith Nat List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list.
Import ListNotations.
From Coq
Require Import ssreflect. 

Tactic Notation "spec" hyp(H) := 
  match type of H with ?a -> _ => 
  let H1 := fresh in (assert (H1: a); 
  [|generalize (H H1); clear H H1; intro H]) end.
Tactic Notation "spec" hyp(H) constr(a) := 
  (generalize (H a); clear H; intro H).
Tactic Notation "spec" hyp(H) constr(a) constr(b) := 
  (generalize (H a b); clear H; intro H).
Tactic Notation "spec" hyp(H) constr(a) constr(b) constr(c) := 
  (generalize (H a b c); clear H; intro H).
Tactic Notation "spec" hyp(H) constr(a) constr(b) constr(c) constr(d) := 
  (generalize (H a b c d); clear H; intro H).
Tactic Notation "spec" hyp(H) constr(a) constr(b) constr(c) constr(d) constr(e) := 
  (generalize (H a b c d e); clear H; intro H).
Tactic Notation "spec" hyp(H) constr(a) constr(b) constr(c) constr(d) constr(e) constr(f) := 
  (generalize (H a b c d e f); clear H; intro H).
Tactic Notation "spec" hyp(H) constr(a) constr(b) constr(c) constr(d) constr(e) constr(f) constr(g) := 
  (generalize (H a b c d e f g); clear H; intro H).
Tactic Notation "spec" hyp(H) constr(a) constr(b) constr(c) constr(d) constr(e) constr(f) constr(g) constr(h) := 
  (generalize (H a b c d e f g h); clear H; intro H).
Tactic Notation "sigma_equal" :=
  f_equal; apply proof_irrelevance. 
Tactic Notation "unnil" hyp(H) :=
  try repeat rewrite app_nil_l app_nil_r in H; 
  try repeat rewrite app_nil_l app_nil_r in H.  
Tactic Notation "unnil" :=
  try repeat rewrite app_nil_l app_nil_r;
  try repeat rewrite app_nil_l app_nil_r.  

(** Additional facts about lists **)
Lemma eq_app_false :
  forall {A : Type} (l1 l2 : list A) (a : A),
    l1 = l1 ++ a :: l2 -> False.
Proof. 
  intros A l1 l2 a H_false.
  induction l1. 
  - inversion H_false.
  - inversion H_false. now apply IHl1.
Qed.

Lemma prefix_app_not:
  ∀ {A : Type} (l1 l2 : list A),
    l2 <> [] ->
    l1 ++ l2 `prefix_of` l1 ->
    False. 
Proof. 
  intros A l1 l2.
  generalize dependent l1. 
  induction l2 as [|a2 l2 IHl2] using rev_ind; intros. 
  - contradiction.
  - destruct l2.
    rewrite app_assoc in H0.
    rewrite app_nil_r in H0.
    eapply prefix_snoc_not. exact H0.
    eapply IHl2. 
    easy.
    assert (H_helper : l1 ++ (a :: l2) `prefix_of` l1).
    { rewrite app_assoc in H0.
      eapply prefix_app_l.
      exact H0. }
    exact H_helper.
Qed.

Lemma prefix_app_tail_or {A: Type}:
  forall (w w' : list A) (x : A),
    prefix w' (w ++ [x]) ->
    prefix w' w \/ w' = w ++ [x]. 
Proof.
  intros.
  unfold prefix in H.
  destruct H as [k H].
  apply app_eq_inv in H.
  destruct H as [H_left | H_right].
  - destruct H_left as [k' [H_left H_right]].
    rewrite H_left. 
    destruct k'.
    * rewrite app_nil_r in H_left.
      left.
      rewrite app_nil_r.
      easy.
    * left.
      apply prefix_app_r. 
      easy. 
  - destruct H_right as [k' [H_left H_right]].
    rewrite H_left.
    destruct k'.
    * left. rewrite app_nil_r. easy.
    * right.
      symmetry in H_right. 
      apply app_eq_unit in H_right.
      destruct H_right.
      destruct H as [H_false _].
      simplify_list_eq.
      destruct H.
      rewrite H.
      reflexivity.
Qed.

Lemma prefix_exists_suffix :
  forall {A : Type} (u w : list A),
    prefix u w ->
    exists (v : list A),
      w = u ++ v.
Proof.
  intros A u w H_prefix.
  induction u as [|a u' IHu'] using rev_ind.
  - exists w. reflexivity.
  - assert (H_helper := prefix_app_l u' w [a] H_prefix).
    spec IHu' H_helper.
    destruct IHu' as [v IHu'].
    destruct v as [|b v'].
    * rewrite app_nil_r in IHu'.
      rewrite IHu' in H_prefix.
      apply prefix_snoc_not in H_prefix. 
      contradiction.
    * exists v'. rewrite IHu' in H_prefix.
      inversion H_prefix.
      rewrite <- app_assoc in H.
      apply app_inv_head in H.
      simpl in H. 
      inversion H.
      rewrite <- H1.
      rewrite <- H2.
      rewrite <- app_assoc.
      rewrite IHu'. easy.
Qed.

Lemma prefix_exists_index :
  forall {A : Type} (u w : list A),
    prefix u w ->
    u = take (length u) w. 
Proof.
  intros A u w H_prefix.
  apply prefix_exists_suffix in H_prefix.
  destruct H_prefix as [v H_eq].
  rewrite H_eq.
  symmetry. apply take_app_length.
Qed.

Lemma prefix_not_prefix_means_prefix :
  forall {A : Type} (w u x y : list A),
  prefix u (w ++ x) ->
  ~ (prefix u (w ++ y)) ->
  prefix w u. 
Proof.   
  intros A w u x y H_yes H_no.
  apply prefix_exists_suffix in H_yes. 
  destruct H_yes as [v H_yes].
  apply app_eq_inv in H_yes.
  destruct H_yes as [H_yes1 | H_yes2].
  - destruct H_yes1 as [a [H_eq1 H_eq2]].
    rewrite H_eq1 in H_no.
    exfalso. rewrite <- app_assoc in H_no.
    apply H_no.
    apply prefix_app_r. 
    reflexivity.
  - destruct H_yes2 as [a [H_eq1 H_eq2]].
    rewrite H_eq1.
    apply prefix_app_r.
    reflexivity.
Qed.

Lemma destruct_list_last :
  forall (A : Type) (l : list A),
    l = [] \/
      exists (a : A) (ls : list A),
        l = ls ++ [a]. 
Proof.
  intros A l.
  induction l as [|x w IHw].
  - now left.
  - destruct IHw.
    right. rewrite H.
    exists x, []. easy.
    destruct H as [a [ls H]].
    right. rewrite H.
    exists a, (x :: ls).
    easy.
Qed.

Lemma about_not_prefix :
  forall (A : Type) (w u : list A) (x : A),
    prefix w u ->
    ~ prefix (w ++ [x]) u ->
    length u > length w -> 
    exists (y : A) (suf : list A),
      u = w ++ [y] ++ suf
      /\ y <> x. 
Proof.
  intros A w u x H_yes H_no H_length.
  apply prefix_exists_suffix in H_yes. 
  destruct H_yes as [v H_eq].
  destruct v.
  - rewrite app_nil_r in H_eq.
    rewrite H_eq in H_length.
    lia. 
  - exists a, v.
    split.
    easy.
    intro H_false.
    rewrite H_false in H_eq.
    rewrite H_eq in H_no.
    apply H_no.
    replace (w ++ x :: v) with (w ++ [x] ++ v) by easy.
    apply prefix_app_l with v.
    rewrite app_assoc.
    reflexivity.
Qed.

Lemma symmetric_prefix_means_eq :
  ∀ {A : Type} (l1 l2 : list A),
    prefix l1 l2 ->
    prefix l2 l1 ->
    l1 = l2.
Proof.
  intros A l1 l2.
  remember (length l2) as n.
  generalize dependent l1.
  generalize dependent l2.
  induction n as [|n IHn]; intros.
  - symmetry in Heqn.
    apply nil_length_inv in Heqn.
    rewrite Heqn in H.
    apply prefix_nil_inv in H.
    rewrite Heqn H.
    reflexivity.
  - destruct (destruct_list_last _ l2).
    * rewrite H1 in H.
      apply prefix_nil_inv in H.
      now rewrite H1 H. 
    * destruct H1 as [b [tl2 H_eq2]].
      rewrite H_eq2 in H.
      apply prefix_app_tail_or in H.
      destruct H.
      spec IHn tl2. spec IHn.
      rewrite H_eq2 in Heqn.
      rewrite app_length in Heqn.
      simpl in Heqn. lia.
      spec IHn l1 H.
      spec IHn.
      eapply prefix_app_l.
      rewrite H_eq2 in H0.
      exact H0.
      rewrite IHn in H0.
      rewrite H_eq2 in H0.
      exfalso.
      eapply prefix_snoc_not. exact H0.
      now rewrite H H_eq2.
Qed.

Lemma in_singleton :
  forall (A : Type) (a : A),
    In a [a]. 
Proof.
  intros.
  replace [a] with (a :: []).
  apply in_eq.
  reflexivity.
Qed.

Lemma prefix_singleton_means_in :
  forall (A : Type) (a : A) (l : list A),
    prefix [a] l ->
    In a l. 
Proof.
  intros.
  apply prefix_exists_suffix in H.
  destruct H as [ls H].
  rewrite H.
  apply in_app_iff.
  left.
  apply in_singleton.
Qed.

Lemma list_app_identity_means_nil :
  forall (A : Type) (l1 l2 : list A),
    l1 ++ l2 = l1 ->
    l2 = []. 
Proof.
  intros.
  destruct l2.
  reflexivity.
  symmetry in H. apply eq_app_false in H.
  contradiction.
Qed.

Lemma singleton_prefix_cons :
  forall (A : Type) (a : A) (l : list A),
    prefix [a] (a :: l).
Proof. 
  intros. 
  assert (H_rewrite : (a :: l) = [a] ++ l).
  easy. rewrite H_rewrite.
  now apply prefix_app_r.
Qed.

Lemma app_singleton_prefix_app_cons :
  forall (A : Type) (a : A) (l1 l2 : list A),
    prefix (l1 ++ [a]) (l1 ++ a :: l2).
Proof. 
  intros. 
  assert (H_rewrite : (a :: l2) = [a] ++ l2).
  easy. rewrite H_rewrite.
  apply prefix_app. 
  now apply prefix_app_r.
Qed.

Lemma prefix_neq_means_shorter_prefix :
  forall (A : Type) (l1 l2 : list A) (a : A),
    prefix l1 (l2 ++ [a]) ->
    l1 <> l2 ++ [a] ->
    prefix l1 l2. 
Proof.
  intros.
  apply prefix_app_tail_or in H.
  destruct H; tauto.
Qed.

Lemma list_eq_list_app_singleton_false :
  forall (A : Type) (l : list A) (a : A),
    l = l ++ [a] ->
    False. 
Proof.
  intros.
  rewrite <- (app_nil_r l) in H.
  rewrite <- app_assoc in H.
  rewrite app_nil_l in H.
  apply app_inv_head_iff in H.
  inversion H. 
Qed.

Lemma case_prefix_app_cons_app :
  forall (A : Type) (l l1 l2 : list A) (a : A),
    prefix l (l1 ++ [a] ++ l2) ->
    prefix l l1 \/
      l = l1 ++ [a] \/
      prefix (l1 ++ [a]) l. 
Proof. 
  intros.
  destruct (classic (prefix l l1)).
  now left.
  assert (H_useful := prefix_weak_total l l1 (l1 ++ [a] ++ l2)).
  spec H_useful H. spec H_useful. now apply prefix_app_r.
  destruct H_useful. contradiction.
  clear H0. 
  apply prefix_exists_suffix in H1.
  destruct H1 as [l_suf H_split_l].
  destruct l_suf. rewrite app_nil_r in H_split_l.
  left. subst. easy. rewrite H_split_l in H.
  apply prefix_app_inv in H. 
  simpl in H. inversion H. inversion H0. subst.
  right. right.
  apply prefix_app.
  now apply singleton_prefix_cons.
Qed.

Lemma prefix_cons :
  forall (A : Type) (l1 l2 : list A) (a : A),
    prefix l1 l2 ->
    prefix (a :: l1) (a :: l2).
Proof. 
  intros.
  replace (a :: l1) with ([a] ++ l1) by easy.
  replace (a :: l2) with ([a] ++ l2) by easy.
  now apply prefix_app.
Qed.

Lemma strict_prefix_means_length_lt :
  forall (A : Type) (l1 l2 : list A),
    prefix l1 l2 ->
    l1 <> l2 ->
    length l1 < length l2. 
Proof.
  intros.
  induction l2 using rev_ind. 
  - apply prefix_nil_inv in H.
    contradiction. 
  - rewrite app_length; simpl.
    destruct (classic (l1 = l2)).
    subst. lia. 
    apply prefix_app_tail_or in H.
    destruct H. spec IHl2 H H1.
    lia. contradiction.
Qed.

Lemma case_strict_prefix :
  forall (A : Type) (l1 l2 : list A),
    prefix l1 l2 \/ prefix l2 l1 ->
    (l1 = l2) \/
      (prefix l1 l2 /\ l1 <> l2) \/
      (prefix l2 l1 /\ l1 <> l2). 
Proof.
  intros.
  destruct (classic (l1 = l2)); tauto.
Qed.

(** Modulating between infinite streams and finite lists **) 
Fixpoint stream_to_list {A : Type} (ls : Stream A) (i : nat) : list A :=
  match i with
  | 0 => []
  | S i => match ls with
          | Cons a ls' => a :: stream_to_list ls' i
          end
  end.

Fixpoint cons_list_stream {A : Type} (ls : list A) (s : Stream A) : Stream A :=
  match ls with
  | [] => s
  | hd :: tl => Cons hd (cons_list_stream tl s)
  end.

Definition prefix_inf {A : Type} (w : list A) (ls : Stream A) :=
  exists (i : nat),
    stream_to_list ls i = w. 

(** Additional facts about streams **)
Lemma stream_to_list_zero :
  forall (A : Type) (ls : Stream A),
    stream_to_list ls 0 = []. 
Proof.
  intros. reflexivity.
Qed.

Lemma stream_to_list_behead :
  forall (A : Type) (hd : A) (tl : Stream A) (i : nat),
    stream_to_list (Cons hd tl) (S i) =
      [hd] ++ stream_to_list tl i. 
Proof.
  intros.
  simpl. reflexivity.
Qed.

(* Note to self: Str_nth starts counting from 0 *)
Lemma Str_nth_S_cons :
  forall (A : Type) (hd : A) (tl : Stream A) (i : nat),
  Str_nth (S i) (Cons hd tl) = Str_nth i tl. 
Proof.
  intros.
  unfold Str_nth. simpl.
  reflexivity.
Qed.

Lemma stream_to_list_S_Str_nth_app :
  forall (A : Type) (i : nat) (ls : Stream A),
    stream_to_list ls (S i) =
      stream_to_list ls i ++ [Str_nth i ls]. 
Proof.
  intros A. 
  induction i as [|i IHi]; intros.
  - simpl. destruct ls. reflexivity.
  - destruct ls.
    rewrite stream_to_list_behead.
    spec IHi ls.
    rewrite IHi.
    rewrite stream_to_list_behead.
    simpl.
    rewrite Str_nth_S_cons. 
    reflexivity.
Qed. 

Lemma stream_to_list_S_i_nil_false :
  forall {A : Type} (ls : Stream A) (i : nat),
    stream_to_list ls (S i) = [] ->
    False. 
Proof.
  intros.
  destruct ls.
  inversion H.
Qed.

Lemma stream_to_list_cons :
  forall {A : Type} (ls : Stream A) (x : A) (i : nat),
    stream_to_list (Cons x ls) (S i) =
      [x] ++ stream_to_list ls i.
Proof.
  intros A ls x i.
  generalize dependent ls. 
  generalize dependent x.
  induction i as [|i IHi]; intros.
  - simpl. reflexivity.
  - destruct ls.
    spec IHi a ls.
    rewrite IHi.
    simpl.
    reflexivity.
Qed.

Lemma stream_to_list_app :
  forall {A : Type} (ls : Stream A) (l : list A) (x : A) (i : nat),
    stream_to_list ls (S i) = l ++ [x] ->
    stream_to_list ls i = l. 
Proof.
  intros A ls l x i H.
  generalize dependent x.
  generalize dependent l.
  generalize dependent ls. 
  induction i as [|i IHi]; intros.  
  - destruct ls. simpl in H.
    symmetry in H. 
    apply app_singleton in H.
    destruct H. destruct H.
    rewrite H.
    apply stream_to_list_zero.
    destruct H. inversion H0.
  - destruct ls.
    rewrite stream_to_list_cons.
    rewrite stream_to_list_cons in H.
    destruct l. 
    rewrite app_nil_l in H.
    exfalso.
    eapply stream_to_list_S_i_nil_false.
    apply app_eq_unit in H. 
    destruct H. destruct H. inversion H.
    destruct H. exact H0.
    assert (a = a0). 
    inversion H. reflexivity. 
    spec IHi ls l x.
    spec IHi.
    rewrite <- H0 in H.
    replace ((a :: l) ++ [x]) with ([a] ++ l ++ [x]) in H. 
    2 : easy.
    apply app_inv_head in H. assumption.
    rewrite <- H0.
    rewrite IHi. easy.
Qed.

Lemma stream_to_list_length :
  forall (A : Type) (l : Stream A) (i : nat),
    length (stream_to_list l i) = i. 
Proof.
  intros.
  generalize dependent l. 
  induction i; intros. 
  - simpl. easy.
  - destruct l. simpl.
    spec IHi l.
    now rewrite IHi.
Qed.

Lemma stream_to_list_prefix :
  forall (A : Type) (l : Stream A) (i j : nat),
    j >= i ->
    prefix (stream_to_list l i) (stream_to_list l j). 
Proof.
  intros.
  generalize dependent l.
  generalize dependent i. 
  induction j; intros. 
  - inversion H. subst.
    rewrite stream_to_list_zero. reflexivity. 
  - assert (H_or : j >= i \/ S j = i) by lia.
    destruct H_or.
    * spec IHj i H0.
      destruct l. 
      destruct i.
      simpl. apply prefix_nil.
      spec IHj (Cons a l).
      rewrite (stream_to_list_S_Str_nth_app _ j). 
      eapply PreOrder_Transitive. exact IHj.
      apply prefix_app_r. reflexivity.
    * subst. 
      reflexivity. 
Qed.

Lemma cons_list_stream_cons :
  forall (A : Type) (hd : A) (tl : list A) (s : Stream A),
    cons_list_stream (hd :: tl) s = Cons hd (cons_list_stream tl s).   
Proof.
  intros. reflexivity.
Qed. 
    
Lemma cons_list_stream_to_list_length :
  forall (A : Type) (l : list A) (s : Stream A),
    stream_to_list (cons_list_stream l s) (length l) = l.
Proof.
  intros A l s.
  generalize dependent s. 
  induction l as [|hd tl IHtl]; intros. 
  - easy.
  - rewrite cons_list_stream_cons.
    simpl.
    spec IHtl s.
    rewrite IHtl.
    reflexivity.
Qed. 

Lemma cons_list_stream_app :
  forall (A : Type) (w u : list A) (rho_inf : Stream A), 
    cons_list_stream (w ++ u) rho_inf =
      cons_list_stream w (cons_list_stream u rho_inf). 
Proof.
  intros. 
  induction w.
  - reflexivity.
  - simpl. rewrite IHw.
    reflexivity.
Qed. 

Lemma Str_nth_tl_cons :
  forall (A : Type) (a : A) (tl s : Stream A) (i : nat), 
    Cons a tl = Str_nth_tl i s ->
    tl = Str_nth_tl (S i) s. 
Proof.
  intros.
  simpl.
  assert (H_useful :=  tl_nth_tl).
  spec H_useful A i s.
  rewrite <- H in H_useful.
  rewrite <- H_useful.
  easy.
Qed.

Lemma cons_list_stream_index_glue :
  forall (A : Type) (rho_inf : Stream A) (i_rho : nat), 
    cons_list_stream (stream_to_list rho_inf i_rho) (Str_nth_tl i_rho rho_inf)
    = rho_inf. 
Proof.
  intros.
  induction i_rho. 
  -  reflexivity.
  - assert (stream_to_list rho_inf (S i_rho) = stream_to_list rho_inf i_rho ++ [Str_nth i_rho rho_inf]).
    { apply stream_to_list_S_Str_nth_app. }
    remember (Str_nth_tl i_rho rho_inf) as tail.
    destruct tail.
    assert (Str_nth_tl (S i_rho) rho_inf = tail).
    { symmetry. eapply Str_nth_tl_cons.
      exact Heqtail.
    }
    rewrite H.
    rewrite H0.
    rewrite cons_list_stream_app.
    rewrite <- IHi_rho at 3.
    f_equal. rewrite Heqtail.
    simpl. 
    assert (Str_nth i_rho rho_inf = a).
    {
      assert (H_useful := Str_nth_plus).
      spec H_useful A 0 i_rho rho_inf.
      rewrite <- Heqtail in H_useful.
      simpl in H_useful.
      unfold Str_nth at 1 in H_useful.
      unfold Streams.hd in H_useful. simpl in H_useful.
      symmetry. assumption.
    }
    rewrite H1.
    assumption.
Qed. 

Lemma cons_list_stream_Str_nth :
  forall (A : Type) (l : list A) (s : Stream A) (i : nat),
    Str_nth i s = Str_nth (length l + i) (cons_list_stream l s). 
Proof.
  intros. 
  induction l.
  - simpl. reflexivity.
  - rewrite IHl.
    simpl.
    rewrite <- (Str_nth_S_cons _ a). 
    reflexivity.
Qed. 


Lemma stream_to_list_cons_list_stream_length :
  forall (A : Type) (a : list A) (b : Stream A) (k : nat),
    stream_to_list (cons_list_stream a b) (length a + k)
    = a ++ stream_to_list b k. 
Proof.
  intros. 
  induction k.
  - simpl. rewrite Nat.add_0_r.
    rewrite app_nil_r.
    rewrite cons_list_stream_to_list_length. reflexivity. 
  - replace (length a + S k) with (S (length a + k)).
    rewrite stream_to_list_S_Str_nth_app.
    rewrite IHk.
    rewrite stream_to_list_S_Str_nth_app.
    rewrite app_assoc. apply app_inv_head_iff.
    f_equal. rewrite <- cons_list_stream_Str_nth.
    reflexivity. lia.
Qed.

