Require Import List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list.
Import ListNotations. 
From Coq 
  Require Import ssreflect.
         
From CC 
  Require Import lib structures clts lts channel_complete channel_compliant protocol closure_conditions run nmc_completeness rcc_completeness scc_completeness.

Section Completeness.

  Context {State : Type} {LocalState : Type}. 
Theorem completeness :
  forall (S : @LTS SyncAlphabet State),
    GCLTS S -> 
    @implementable State LocalState S -> 
    @NMC State S /\ @RCC State S /\ @SCC State S. 
Proof.
  intros S H_GCLTS H_implementable.
  destruct (classic (@NMC State S ∧ @RCC State S ∧ @SCC State S)). 
  assumption.
  exfalso. 
  apply not_and_or in H.
  destruct H.
  assert (H_NMC := @NMC_completeness State LocalState S H_GCLTS H).
  contradiction.
  apply not_and_or in H.
  destruct H. 
  assert (H_RCC := @RCC_completeness State LocalState S H_GCLTS H).
  contradiction.
  assert (H_SCC := @SCC_completeness State LocalState S H_GCLTS H).
  contradiction.
Qed.


End Completeness. 
