Require Import List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list.
Import ListNotations.
From Coq  
Require Import ssreflect. 
   
From CC  
  Require Import lib structures lts clts protocol channel_complete channel_compliant run. 

(** Formalization of the three Coherence Conditions and canonical implementations **)

Section Conditions.

Context {State : Type} {LocalState : Type}.
  
(** The Three Coherence Conditions **) 
Definition reachable_for_on {S : LTS} (p : participant) (s1 s2 : State) (w : FinAsyncWord) : Prop :=
  exists (u : FinSyncWord),
    lts.Reachable S s1 u s2 /\
      wproj (split u) p = w.

Definition reachable_for {S : LTS} (p : participant) (s : State) (w : FinAsyncWord) : Prop :=
  @reachable_for_on S p (s0 S) s w.

Definition simultaneously_reachable_for {S : LTS} (p : participant) (s1 s2 : State) (w : FinAsyncWord) :=
  @reachable_for S p s1 w /\ @reachable_for S p s2 w. 

Definition SCC {S : LTS} :=
  forall (s1 s2 : State) (l : SyncAlphabet),
    transition S s1 l s2 ->
    forall (s1' : State),
      (exists (u : FinAsyncWord), 
          @simultaneously_reachable_for S (sender_sync l) s1 s1' u) ->
      exists (s2' : State),
        @reachable_for_on S (sender_sync l) s1' s2' (wproj (split_symbol l) (sender_sync l)). 

Definition RCC {S : LTS} :=
  forall (s1 s2 s1' s2' : State) (p q r : participant)
    (m m' : message)
    (H_pq : sender_receiver_neq_sync (Event p q m))
    (H_rq : sender_receiver_neq_sync (Event r q m)),
    transition S s1 (exist _ (Event p q m) H_pq) s2 ->
    transition S s1' (exist _ (Event r q m') H_rq) s2' ->
    (p <> r) /\
      (exists (u : FinAsyncWord), @simultaneously_reachable_for S q s1 s1' u) ->
    ~ (exists (w : FinAsyncWord), @is_protocol_prefix State (reinitial_S s2' S) w /\
                               wproj w q = [] /\
                               prefix (mproj_rcv w p q ++ [m]) (mproj_snd w p q)).

Definition NMC {S : LTS} :=
  forall (s1 s2 s1' s2' : State) (p q r : participant)
    (m m' : message)
    (H_pq : sender_receiver_neq_sync (Event p q m))
    (H_rp : sender_receiver_neq_sync (Event r p m')),
    transition S s1 (exist _ (Event p q m) H_pq) s2 ->
    transition S s1' (exist _ (Event r p m') H_rp) s2' ->
    (exists (u : FinAsyncWord), @simultaneously_reachable_for S p s1 s1' u) ->
    False.

(* Lemma that explicitly negates SCC into the right shape for ease of use *) 
Lemma neg_SCC_iff :
  forall (S : LTS),
    ~ @SCC S <->
      (exists (s1 s2 : State) (l : SyncAlphabet),
        transition S s1 l s2 /\
          (exists (s1' : State),
              (exists (u : FinAsyncWord), 
                  @simultaneously_reachable_for S (sender_sync l) s1 s1' u) /\
                forall (s2' : State),
                  ~ @reachable_for_on S (sender_sync l) s1' s2' (wproj (split_symbol l) (sender_sync l)))). 
Proof.
  intros S.
  split.
  (* Left direction *)
  - intro H_SCC.
    unfold SCC in H_SCC.
    apply not_all_ex_not in H_SCC. 
    destruct H_SCC as [s1 H_SCC].
    apply not_all_ex_not in H_SCC.
    destruct H_SCC as [s2 H_SCC].
    exists s1, s2.
    apply not_all_ex_not in H_SCC.
    destruct H_SCC as [x H_SCC].
    exists x.
    apply imply_to_and in H_SCC. 
    destruct H_SCC as [H H_SCC].
    split. assumption.
    clear H.
    apply not_all_ex_not in H_SCC.
    destruct H_SCC as [s1' H_SCC].
    exists s1'.
    apply imply_to_and in H_SCC.
    destruct H_SCC as [H H_SCC].
    split. assumption.
    clear H.
    intro s2'. 
    eapply (not_ex_all_not) in H_SCC.
    exact H_SCC.
    (* Right direction *)
  - intro H_not.
    intro H_SCC.
    destruct H_not as [s1 [s2 [l [H_trans [s1' [H_reach H_unreach]]]]]].
    spec H_SCC s1 s2 l H_trans s1' H_reach.
    destruct H_SCC as [s2' H_unreach'].
    spec H_unreach s2'.
    contradiction.
Qed.

(* Lemma that explicitly negates RCC for ease of use *) 
Lemma neg_RCC_iff :
  forall (S : LTS),
    ~ @RCC S <->
      exists (s1 s2 s1' s2' : State) (p q r : participant)
        (m m' : message)
        (H_pq : sender_receiver_neq_sync (Event p q m))
        (H_rq : sender_receiver_neq_sync (Event r q m')),
        transition S s1 (exist _ (Event p q m) H_pq) s2 /\
          transition S s1' (exist _ (Event r q m') H_rq) s2' /\
          (p <> r) /\
          (exists (u : FinAsyncWord), @simultaneously_reachable_for S q s1 s1' u) /\
          (exists (w : FinAsyncWord), @is_protocol_prefix State (reinitial_S s2' S) w /\
                                   wproj w q = [] /\
                                   prefix (mproj_rcv w p q ++ [m]) (mproj_snd w p q)). 
Proof. 
  intros S. 
  split.
  - (* Left direction *)
    intro H_RCC.
    unfold RCC in H_RCC.
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [s1 H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [s2 H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [s1' H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [s2' H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [p H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [q H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [r H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [m H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [m' H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [H_pq H_RCC].
    apply not_all_ex_not in H_RCC.
    destruct H_RCC as [H_rs H_RCC].
    exists s1, s2, s1', s2', p, q, r, m, m', H_pq, H_rs. 
    apply imply_to_and in H_RCC.
    destruct H_RCC as [H H_RCC].
    split. assumption. clear H.
    apply imply_to_and in H_RCC.
    destruct H_RCC as [H H_RCC].
    split. assumption. clear H.
    apply imply_to_and in H_RCC.
    destruct H_RCC as [[H1 H2] H_RCC].
    split. assumption.
    split. assumption.
    apply NNPP in H_RCC.
    assumption.
  - (* Right direction *)
    intro H_not.
    intro H_RCC. 
    destruct H_not as [s1 [s2 [s1' [s2' [p [q [r [m [m' [H_pq [H_rq [H_trans1 [H_trans2 [H_neq [H_simreach H_exists]]]]]]]]]]]]]]].
    spec H_RCC s1 s2 s1' s2' p q r.
    spec H_RCC m m' H_pq H_rq H_trans1 H_trans2.
    spec H_RCC.
    split; assumption.
    contradiction.
Qed.

(* Lemma that explicitly negates NMC *)
Lemma neg_NMC_iff :
  forall (S : LTS),
    ~ @NMC S <->
      exists (s1 s2 s1' s2' : State) (p q r : participant)
        (m m' : message)
        (H_pq : sender_receiver_neq_sync (Event p q m))
        (H_rp : sender_receiver_neq_sync (Event r p m')),
        transition S s1 (exist _ (Event p q m) H_pq) s2 /\
          transition S s1' (exist _ (Event r p m') H_rp) s2' /\
          (exists (u : FinAsyncWord), @simultaneously_reachable_for S p s1 s1' u).
Proof.
  intros S.
  split. 
  - (* Left direction *)
    intro H_not. 
    unfold NMC in H_not. 
    apply not_all_ex_not in H_not.
    destruct H_not as [s1 H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [s2 H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [s3 H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [s4 H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [p H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [q H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [r H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [m H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [m' H_not].
    apply not_all_ex_not in H_not. 
    destruct H_not as [H_pq H_not].
    apply not_all_ex_not in H_not.
    destruct H_not as [H_rp H_not].
    apply imply_to_and in H_not.
    destruct H_not as [H_transition H_not].
    apply imply_to_and in H_not.
    destruct H_not as [H_transition' H_not].
    exists s1, s2, s3, s4, p, q, r, m, m', H_pq, H_rp.
    tauto. 
  - (* Right direction *)
    intros [s1 [s2 [s3 [s4 [p [q [r [m [m' [H_pq [H_rp [H_transition1 [H_transition2 H_sim_reach]]]]]]]]]]]]].
    unfold NMC.
    intro H_NMC. 
    spec H_NMC s1 s2 s3 s4 p q r.
    spec H_NMC m m' H_pq H_rp H_transition1 H_transition2 H_sim_reach.
    contradiction.
Qed. 

End Conditions. 

