Require Import List Classical Nat Logic Lia ExtensionalityFacts Streams stdpp.list. 
Import ListNotations. 
From Coq 
Require Import ssreflect. 
 
From CC
  Require Import lib structures lts clts protocol.

(* Showing that split synchronous words are channel complete by construction *) 
Lemma split_word_channel_complete :
  forall (w : FinSyncWord),
    channel_complete (split w). 
Proof. 
  intro w. 
  induction w as [|x w IHw] using rev_ind; intros p q H_neq.
  - easy.
  - destruct x as [[p' q' m'] H_prop].
    destruct (classic (p' = p /\ q' = q)). 
    * (* In the case that p,q = p',q' *)
      spec IHw p q H_neq.
      unfold mproj_rcv.
      unfold split. rewrite flat_map_app.
      rewrite flat_map_app.
      unfold mproj_rcv, split in IHw.
      rewrite IHw.
      unfold mproj_snd.
      rewrite flat_map_app.
      enough (H_rewrite : flat_map (mproj_rcv_symbol p q) (flat_map split_symbol [Event p' q' m' ↾ H_prop]) =
                flat_map (mproj_snd_symbol p q) (flat_map split_symbol [Event p' q' m' ↾ H_prop])). 
      rewrite H_rewrite. reflexivity.
      unfold mproj_rcv_symbol.
      simpl.
      unfold sender_sync, receiver_sync, value_sync.
      simpl.
      replace (is_rcvb (Snd p' q' m' ↾ H_prop)) with false by easy.
      rewrite andb_false_r. simpl.
      destruct H as [H_eq1 H_eq2].  
      replace (participant_eqb p' p) with true.
      replace (participant_eqb q' q) with true.
      replace (is_rcvb (Rcv p' q' m' ↾ H_prop)) with true.
      simpl.
      unfold mproj_snd_symbol.
      simpl.
      replace (is_sndb (Rcv p' q' m' ↾ H_prop)) with false by easy. 
      replace (is_sndb (Snd p' q' m' ↾ H_prop)) with true by easy.
      replace (participant_eqb p' p) with true.
      replace (participant_eqb q' q) with true.
      easy.
      symmetry; now apply participant_eqb_correct.
      symmetry; now apply participant_eqb_correct.
      easy.
      symmetry; now apply participant_eqb_correct.
      symmetry; now apply participant_eqb_correct.
    * (* In the case that p,q <> p',q' *)
      spec IHw p q H_neq.
      unfold mproj_rcv.
      unfold split. rewrite flat_map_app.
      rewrite flat_map_app.
      unfold mproj_rcv, split in IHw.
      rewrite IHw.
      unfold mproj_snd.
      rewrite flat_map_app.
      enough (H_rewrite : flat_map (mproj_rcv_symbol p q) (flat_map split_symbol [Event p' q' m' ↾ H_prop]) =
                flat_map (mproj_snd_symbol p q) (flat_map split_symbol [Event p' q' m' ↾ H_prop])). 
      rewrite H_rewrite. reflexivity.
      unfold mproj_rcv_symbol.
      unfold mproj_snd_symbol. 
      simpl.
      unfold sender_sync, receiver_sync, value_sync.
      simpl.
      replace (is_rcvb (Snd p' q' m' ↾ H_prop)) with false by easy.
      rewrite andb_false_r. simpl.
      replace (participant_eqb p' p && participant_eqb q' q) with false. 
      replace (is_rcvb (Rcv p' q' m' ↾ H_prop)) with true.
      replace (is_sndb (Snd p' q' m' ↾ H_prop)) with true.
      easy. easy. easy.
      symmetry.
      apply andb_false_iff.
      apply not_and_or in H.
      destruct H. left.
      now apply participant_eqb_no.
      right.
      now apply participant_eqb_no.
Qed.

Lemma finite_protocol_word_channel_complete :
  forall {State : Type} (S : LTS) (w : FinAsyncWord), 
    @is_finite_protocol_word State S w -> 
     channel_complete w.
Proof.
  intros State S w H_fin.
  unfold channel_complete.
  intros p q H_neq.
  destruct H_fin as [rho [H_max [H_role H_cc]]].
  assert (H_role_copy := H_role).
  spec H_role p.
  spec H_role_copy q.
  assert (H_useful := split_word_channel_complete rho). 
  spec H_useful p q H_neq.
  rewrite (mproj_snd_wproj_idempotent w p q). 
  rewrite (mproj_rcv_wproj_idempotent w p q).
  rewrite <- H_role, <- H_role_copy.
  rewrite <- (mproj_snd_wproj_idempotent (split rho) p q). 
  rewrite <- (mproj_rcv_wproj_idempotent (split rho) p q).
  assumption. 
Qed. 


