The Rocq formal proof development accompanying ITP 2025 submission: Certified Implementability of Global Multiparty Protocols

This project was compiled with The Rocq Prover, version 8.20.0, compiled with OCaml 4.14.0, and depends on coq-stdpp, version 1.11.0. 

To install and build: 

$ touch .depend

$ make dep

$ make

The development is organized as follows: 

lib.v : supplementary library for lists and streams 

lts.v : formalization of generic labeled transition systems 

structures.v : formalization of synchronous and asynchronous alphabets and projections 

clts.v : formalization of communicating labeled transition systems 

protocol.v : formalization of global multiparty protocols and its asynchronous semantics

channel_complete.v : lemmas about channel complete words 

channel_compliant.v : lemmas about channel compliant words 

closure_conditions.v : definition of three conditions required for implementability: Send Coherence, Receive Coherence and No Mixed Choice

run.v : formalization of possible runs and unique splittings 

canonical_implementation.v : definition and existence proof of canonical implementations

nmc_soundness.v : proof of sufficiency of No Mixed Choice 

rcc_soundness.v : proof of sufficiency of Receive Coherence 

scc_soundness.v : proof of sufficiency of Send Coherence

soundness.v : proof of soundness of characterization 

nmc_completeness.v : proof of necessity of No Mixed Choice 

rcc_completeness.v : proof of necessity of Receive Coherence

scc_completeness.v : proof of necessity of Send Coherence

completeness.v : proof of completeness of characterization 

theorem.v : preciseness theorem 

