# Data Repository for "Efficient Simulation of Quantum Chemistry Problems in an Enlarged Basis Set"

This repository contains the **data** used in the above paper. The **source code** (for finding isometric THC and simulating the quantum algorithm) is available on [GitHub](https://github.com/carrot6869/Isometric-THC.git).

Below is an overview of the repository structure and its contents.


## Integrals and THC Factors
The folder `data` contains the integrals and THC factors for the systems studied.

The directory structure is organized as follows:
- **Hamiltonian parameters**: Found in `SYSTEMNAME/integral.hdf5` or the subfolder `SYSTEMNAME/integral/`.
- **Isometric THC factors**: Found in `SYSTEMNAME/u/`.
- **Generic THC factors**: Found in `SYSTEMNAME/x/`.

For instructions on how to use the data, please refer to the notebook `example.ipynb`.


---

Contact: Maxine Luo ( man.luo@mpq.mpg.de )



