import {
  scene,
  camera,
  renderer,
  controls,
  initScene,
  animate,
  centerMolecule,
  getMoleculeGroup,
  setMoleculeGroup
} from "./scene.js";



import {
  downloadUSDZ,
  downloadImage,
  downloadGLTF,
  downloadZip,
} from "./download.js";

import { loadRDKit } from "./molecule-generator.js";
import { processToken } from "./smiles-parser.js";
import { generateMoleculeFromSmiles, generateMoleculesFromList } from "./molecule-generator.js";
import { setCurrentSmiles } from "./state.js";



// -------------------------------
// Event Listeners / Startup
// -------------------------------
document.getElementById("generateButton").addEventListener("click", async () => {
  const input = document.getElementById("moleculeInput").value.trim();
  if (!input) {
    alert("Please enter one or more SMILES or molecule names!");
    return;
  }
  document.getElementById("loadingIndicator").style.display = "inline";

  const tokens = input.split(",");
  await generateMoleculesFromList(tokens);
  setCurrentSmiles("");
  /*if (input.includes(",")) {

  } else {
    const validSmiles = await processToken(input);
    if (!validSmiles) {
      alert("No valid molecule found for the input.");
      document.getElementById("loadingIndicator").style.display = "none";
      return;
    }
    await generateMoleculeFromSmiles(validSmiles);
  }*/

  document.getElementById("loadingIndicator").style.display = "none";
  document.getElementById("downloadGLTF").disabled = false;
  document.getElementById("downloadUSDZ").disabled = false;
  document.getElementById("downloadImageButton").disabled = false;
  document.getElementById("downloadZipButton").disabled = false;
});

document.getElementById("moleculeInput").addEventListener("keydown", event => {
  if (event.key === "Enter" && !event.shiftKey) {
    event.preventDefault();
    document.getElementById("generateButton").click();
  }
});

document.getElementById("downloadImageButton").addEventListener("click", downloadImage);
document.getElementById("downloadZipButton").addEventListener("click", downloadZip);

window.onload = async function () {
  try {
    await loadRDKit();
  } catch (e) {
    console.error("Failed to load RDKit, proceeding with fallback.", e);
  }
  initScene();
  animate();

  document.getElementById("downloadUSDZ").addEventListener("click", downloadUSDZ);
  document.getElementById("downloadGLTF").addEventListener("click", downloadGLTF);

  const defaultSmiles = "CCO";
  document.getElementById("moleculeInput").value = defaultSmiles;
  await generateMoleculeFromSmiles(defaultSmiles);
  document.getElementById("downloadGLTF").disabled = false;
  document.getElementById("downloadUSDZ").disabled = false
  document.getElementById("downloadImageButton").disabled = false;
  document.getElementById("downloadZipButton").disabled = false;
};
