# Hepatic Vessel Skeletonization Dataset (Task08_HepaticVessel)

## Overview

This dataset is derived from the hepatic vessel task of the Medical Segmentation Decathlon (MSD) Task 8. It comprises manually revised vessel skeletons and modified vessel segmentations that are initially generated via automatic 3D thinning and subsequently refined through manual revision. Both the skeletons and the labels have been refined to provide a high-quality ground truth for skeletonization algorithm evaluation.

## Dataset Description

### Modifications from Original MSD Task 8

**Label modifications:** Using 3D Slicer, vessel segmentations were refined to remove vessels not located within the liver parenchyma, large segmentations of the inferior vena cava and aorta that were inconsistent across the dataset, and anatomical structures not relevant for hepatic vessel skeletonization analysis.

**Skeleton revision:** The manual revision process addressed broken and missing branches, incorrect or ambiguous vessel representations, and redundant skeleton points generated by the automatic thinning algorithm.

### Dataset Characteristics

The dataset covers various anatomical aspects including vessel representation up to the third level of ramification, anatomically diverse hepatic vessel structures, and consistent spatial resolution and coordinate systems.

**Level of ramification** is defined as the level of branching in a vessel tree where branches extend at least three levels deep from the main trunk following anatomical hierarchy.

## File Structure

```
Task08_HepaticVessel/
├── 0_README.md                    # This documentation file
├── labelsTr/                      # Modified vessel segmentations (NIfTI format)
│   ├── hepaticvessel_001_mod.nii.gz
│   ├── hepaticvessel_002_mod.nii.gz
│   ├── hepaticvessel_004_mod.nii.gz
│   ├── hepaticvessel_005_mod.nii.gz
│   ├── hepaticvessel_007_mod.nii.gz
│   ├── hepaticvessel_008_mod.nii.gz
│   ├── hepaticvessel_010_mod.nii.gz
│   ├── hepaticvessel_011_mod.nii.gz
│   ├── hepaticvessel_013_mod.nii.gz
│   ├── hepaticvessel_016_mod.nii.gz
│   └── hepaticvessel_018_mod.nii.gz
└── skeletons/                     # Manually revised skeletons (JSON format)
    ├── hepaticvessel_001_LNC.json
    ├── hepaticvessel_001_NVO.json
    ├── hepaticvessel_001_ROF.json
    ├── hepaticvessel_002_LNC.json
    ├── hepaticvessel_002_NVO.json
    ├── hepaticvessel_004_LNC.json
    ├── hepaticvessel_004_NVO.json
    ├── hepaticvessel_005_LNC.json
    ├── hepaticvessel_005_NVO.json
    ├── hepaticvessel_007_LNC.json
    ├── hepaticvessel_007_NVO.json
    ├── hepaticvessel_008_NVO.json
    ├── hepaticvessel_010_NVO.json
    ├── hepaticvessel_011_NVO.json
    ├── hepaticvessel_013_NVO.json
    ├── hepaticvessel_016_NVO.json
    └── hepaticvessel_018_LNC.json
```

## Naming Convention

### Vessel Segmentations (`labelsTr/`)

Pattern: `hepaticvessel_[3-digit-number]_mod.nii.gz`
Example: `hepaticvessel_008_mod.nii.gz`

### Skeletons (`skeletons/`)

Pattern: `hepaticvessel_[3-digit-number]_[ANNOTATOR_INITIALS].json`
Example: `hepaticvessel_008_LNC.json`

### Annotator Codes

**LNC**: Lois Nodar Corral
**NVO**: Noelia Velo Outumuro
**ROF**: Roque Otero Freiría

## Data Format

### Vessel Segmentations

Format: NIfTI (.nii.gz)
Binary masks (0 = background, 1 = vessel)
Coordinate system: RAS (Right-Anterior-Superior)
Spatial resolution: Variable (inherited from original MSD dataset)

### Skeletons

Format: JSON arrays containing 3D coordinates
Coordinate system: Voxel coordinates (matching corresponding segmentation)
Structure:
```json
[
  [x1, y1, z1],
  [x2, y2, z2],
  [x3, y3, z3],
  ...
]
```

Each coordinate triplet `[x, y, z]` represents a voxel position in the 3D volume where the skeleton passes through.

## Dataset Statistics

- **Total cases**: 11 vessel segmentations
- **Total skeletons**: 17 manually revised skeletons
- **Multiple annotations**: Some cases have multiple annotator versions for validation
- **Coverage**: Cases 001, 002, 004, 005, 007, 008, 010, 011, 013, 016, 018

## File Correspondence

| Case | Segmentation File | Available Skeletons |
|------|-------------------|-------------------|
| 001 | hepaticvessel_001_mod.nii.gz | LNC, NVO, ROF |
| 002 | hepaticvessel_002_mod.nii.gz | LNC, NVO |
| 004 | hepaticvessel_004_mod.nii.gz | LNC, NVO |
| 005 | hepaticvessel_005_mod.nii.gz | LNC, NVO |
| 007 | hepaticvessel_007_mod.nii.gz | LNC, NVO |
| 008 | hepaticvessel_008_mod.nii.gz | NVO |
| 010 | hepaticvessel_010_mod.nii.gz | NVO |
| 011 | hepaticvessel_011_mod.nii.gz | NVO |
| 013 | hepaticvessel_013_mod.nii.gz | NVO |
| 016 | hepaticvessel_016_mod.nii.gz | NVO |
| 018 | hepaticvessel_018_mod.nii.gz | LNC |

## Usage Guidelines

1. **Correspondence**: Each skeleton file corresponds to a vessel segmentation with the same case number
2. **Coordinate system**: Skeleton coordinates are in voxel space of the corresponding NIfTI volume
3. **Validation**: Cases with multiple annotators can be used for inter-observer variability studies
4. **Citation**: Please cite the original Medical Segmentation Decathlon when using this dataset

## Software Tools

The manual revision was performed using custom Python tools for skeleton visualization and editing. The annotation software used for skeleton revision is available in a separate GitHub repository (link to be provided upon publication). This tool provides an interactive 3D visualization environment that allows for precise skeleton editing, branch correction, and quality validation.

The Python-based annotation tool, available at [https://github.com/Removirt/skeleton-viewer](https://github.com/Removirt/skeleton-viewer) features interactive 3D visualization of vessel segmentations and skeletons, point-by-point skeleton editing capabilities, branch connection and disconnection tools, real-time validation of topological correctness, and multi-platform compatibility (Windows, macOS, Linux).

## Dataset Access

This dataset is publicly available through Zenodo. The complete dataset including all vessel segmentations, manually revised skeletons, and documentation can be downloaded from: [https://doi.org/10.5281/zenodo.15729285](https://doi.org/10.5281/zenodo.15729285)

## Citation

### This Dataset
```
Nodar-Corral, L., Fdez-Gonzalez, M., Fdez-Vidal, X. R., Otero Freiría, R., Velo Outumuro, N., & Comesaña Figueroa, E. (2025). Refined 3D Hepatic Vessel Skeleton Dataset from the Medical Segmentation Decathlon (Task08_HepaticVessel) [Data set]. Zenodo. https://doi.org/10.5281/zenodo.15729285
```

### Original Medical Segmentation Decathlon
```
Simpson, A. L., Antonelli, M., Bakas, S., et al. (2019). A large annotated medical image 
dataset for the development and evaluation of segmentation algorithms. arXiv preprint 
arXiv:1902.09063.
```

### BibTeX Format
```bibtex
@dataset{hepatic_vessel_skeletons_2025,
  author       = {Nodar-Corral, L., Fdez-Gonzalez, M., Fdez-Vidal, X. R., Otero Freiría, R., Velo Outumuro, N., & Comesaña Figueroa, E.},
  title        = {Refined 3D Hepatic Vessel Skeleton Dataset from the Medical Segmentation Decathlon (Task08_HepaticVessel)},
  year         = {2025},
  publisher    = {Zenodo},
  doi          = {10.5281/zenodo.15729285},
  url          = {https://doi.org/10.5281/zenodo.15729285}
}

@article{simpson2019large,
  title={A large annotated medical image dataset for the development and evaluation of segmentation algorithms},
  author={Simpson, Amber L and Antonelli, Michela and Bakas, Spyridon and others},
  journal={arXiv preprint arXiv:1902.09063},
  year={2019}
}
```

## Contact

For questions about this dataset or annotation methodology, please contact the first author on lois.nodar.corral@usc.es or loisnodar@gmail.com, or any of the other authors on their ORCID correspondence.
