# Microscope Slide to STL

A browser-based tool that converts microscope images (or any image) into 3D-printable STL files. Ideal for making tactile models from biological or artistic imagery.

## Features

- Upload any image (microscope, artwork, etc.)
- Convert image intensity into a 3D height map
- Adjustable **relief height** (1–7.5 mm)
- **Greyscale preview** and **false-colour height map**
- STL export for 3D printing
- Simple interface, no installation required

## Live Demo

🔗 [https://claireprice.github.io/microscope-to-stl](https://claireprice.github.io/microscope-to-stl)

## How to Use

1. Upload an image using the file input.
2. Adjust the **relief height** slider to control how tall the raised features are.
3. Preview the model in greyscale and in colour.
4. Click **Download STL** to export the 3D model.

## 3D Printing Tips

- Use a **layer height** of 0.2 mm or finer for best results.
- Filament changes (e.g. at different heights) can add colour bands.
- Light-coloured filaments are ideal for painting or inking.
- STL files are compatible with Cura, PrusaSlicer, and similar software.

## Licence

This project is licensed under the [Creative Commons Attribution-NonCommercial 4.0 International Licence](https://creativecommons.org/licenses/by-nc/4.0/).

[![License: CC BY-NC 4.0](https://img.shields.io/badge/License-CC%20BY--NC%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-nc/4.0/)

Please cite the following:


