#include <atomic>
#include <chrono>
#include <fstream>
#include <rh_impls.cuh>
#include <rh_utils.cuh>
#include <iostream>
#include <numeric>
#include <pthread.h>
#include <stdint.h>
#include <array>
#include <vector>
#include <cuda.h>
#include <filesystem>
#include <rmm/mr/device/pool_memory_resource.hpp>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <cstring>
#include <semaphore.h>

struct SharedData {
    bool request_received;  // Flag to indicate a request
    bool response_ready;    // Flag to indicate the response is ready
    bool is_alloc;
    uint64_t size;
    uint64_t pool_offset;
    cudaIpcMemHandle_t ipchandle;   // The memory address returned by the sender
    pthread_mutex_t lock;
} __attribute__((__packed__));

std::string CLI_PREFIX = "(hammer_manual): ";
std::string exploit_file_name = "exploit_control.txt", mem_file_name = "memory_control.txt", model_file_name = "model_control.txt";
const std::filesystem::path exploit_path = exploit_file_name, mem_path = mem_file_name, model_path = model_file_name;

int
main (int argc, char *argv[])
{
  const uint64_t size = std::stoull (argv[1]);
  std::fstream control_file;
  control_file.open(exploit_file_name, std::fstream::in | std::fstream::out | std::fstream::trunc);
  control_file.close();
  control_file.open(mem_file_name, std::fstream::in | std::fstream::out | std::fstream::trunc);
  control_file.close();
  control_file.open(model_file_name, std::fstream::in | std::fstream::out | std::fstream::trunc);
  control_file.close();

  rmm::mr::cuda_memory_resource cuda_mr;
  auto pool_mr = new rmm::mr::pool_memory_resource<rmm::mr::cuda_memory_resource>{&cuda_mr, size};
  rmm::mr::set_current_device_resource(pool_mr); // Updates the current device resource pointer to `pool_mr`
  rmm::mr::device_memory_resource* mr = rmm::mr::get_current_device_resource();
  void* base_addr = mr->allocate(256);
  mr->deallocate(base_addr, 256);

  // Step 1: Open shared memory (or create it)
  int shm_fd = shm_open("/exploitshm", O_CREAT | O_RDWR | O_TRUNC, 0666);
  if (shm_fd == -1) {
      std::cerr << "Error creating shared memory" << std::endl;
      return -1;
  }
  
  // Set the size of shared memory
  ftruncate(shm_fd, sizeof(SharedData));

  // Step 2: Map shared memory into the address space
  SharedData* shared_data = (SharedData*)mmap(0, sizeof(SharedData), PROT_READ | PROT_WRITE, MAP_SHARED, shm_fd, 0);
  if (shared_data == MAP_FAILED) {
      std::cerr << "Error mapping shared memory" << std::endl;
      return -1;
  }

  pthread_mutexattr_t attr;
  pthread_mutexattr_init(&attr);
  pthread_mutexattr_setpshared(&attr, PTHREAD_PROCESS_SHARED);
  pthread_mutex_init(&shared_data->lock, &attr);


  // Step 3: Wait for requests from the receiver
  auto prev_time = std::filesystem::last_write_time(mem_path);
  std::string action;
  std::string name;
  while (true) {

    if (std::filesystem::last_write_time(mem_path) != prev_time)
      return 0;

    // Wait for a request from the receiver
    pthread_mutex_lock(&shared_data->lock);
    if (shared_data->request_received) {
      if (shared_data->is_alloc)
      {
          
          shared_data->request_received = false;

          // Allocate memory and store the pointer in shared memory
          void* allocated_memory = mr->allocate(shared_data->size);  // Example of allocated memory
          cudaIpcMemHandle_t ipc_handle;
          cudaIpcGetMemHandle(&ipc_handle, allocated_memory);
          shared_data->ipchandle = ipc_handle;  // Store the pointer in shared memory
          shared_data->pool_offset = (uint8_t*)allocated_memory - (uint8_t*)base_addr;
          
          shared_data->response_ready = true;
      }
      else
      {
          shared_data->request_received = false;
          mr->deallocate((uint8_t *)base_addr + shared_data->pool_offset, shared_data->size);  // Example of allocated memory
          shared_data->response_ready = true;
      }
        
    }
    pthread_mutex_unlock(&shared_data->lock);
  }
  return 0;
}
