#!/bin/bash

echo ""
echo "-------------------------------------------"
echo ""
echo "[INFO] Starting Experiments for Figure 12"

# Variables
agg_rowid=30327
bank_id=A

row_step=4
count_iter=50

# Constant values
addr_step=256
iterations=91000
mem_size=50465865728

num_rows=64169      # Number of rows in the row_set (line number - 1)
vic_pat=55          # Victim row data pattern in hex
agg_pat=aa          # Aggressor row data pattern in hex

num_warp=8
num_thread=3
delay=56

# for ((i=0; i<16; i++)); do
for num_agg in {8..24}; do
  
  # File paths
  mkdir -p "$HAMMER_ROOT/results/fig12/raw_data"
  rowset_file="$HAMMER_ROOT/results/row_sets/ROW_SET_${bank_id}.txt"
  log_file="$HAMMER_ROOT/results/fig12/raw_data/${num_agg}agg_b${bank_id}.log"
  bitflip_file="$HAMMER_ROOT/results/fig12/raw_data/${num_agg}agg_b${bank_id}_count.txt"

  echo Start hammering $num_agg -sided patterns ...

  $HAMMER_ROOT/src/out/build/trr_sampler $rowset_file $((num_agg - 1)) $addr_step $iterations $agg_rowid $row_step $mem_size $num_warp $num_thread $delay 1 $count_iter $num_rows $vic_pat $agg_pat $bitflip_file > $log_file

  sleep 5
done

echo "[INFO] Generating Figure 12"
python3 $HAMMER_ROOT/plot_scripts/plot_fig12.py

echo "[INFO] Done. Figure 12 is stored as 'results/fig12/fig12.pdf'"
