# Bibliography

Here are a few of the resources that this project either builds on or makes heavy use of. Additionally, there are a few
alternative pieces of software that are similar to this project that may be of interest to the reader.

## Papers

### Twelve Layer Concentric Objects (TLCO) method

- Piskunowicz M, Hofmann L, Zuercher E, et al. A new technique with high reproducibility to estimate renal oxygenation using
  BOLD-MRI in chronic kidney disease. Magn Reson Imaging. 2015;33(3):253-261.
  doi:[10.1016/j.mri.2014.12.002](https://doi.org/10.1016/j.mri.2014.12.002)
- Milani B, Ansaloni A, Sousa-Guimaraes S, et al. Reduction of cortical oxygenation in chronic kidney disease: evidence
  obtained with a new analysis method of blood oxygenation level-dependent magnetic resonance imaging. Nephrol Dial Transplant.
  2017;32(12):2097-2105. doi:[10.1093/ndt/gfw362](https://doi.org/10.1093/ndt/gfw362)
- Pruijm M, Milani B, Pivin E, et al. Reduced cortical oxygenation predicts a progressive decline of renal function in
  patients with chronic kidney disease. Kidney Int. 2018;93(4):932-940.
  doi:[10.1016/j.kint.2017.10.020](https://doi.org/10.1016/j.kint.2017.10.020)
- Li LP, Milani B, Pruijm M, et al. Renal BOLD MRI in patients with chronic kidney disease: comparison of the semi-automated
  twelve layer concentric objects (TLCO) and manual ROI methods. Magn Reson Mater Phys Biol Med. 2020;33(1):113-120.
  doi:[10.1007/s10334-019-00808-5](https://doi.org/10.1007/s10334-019-00808-5)

### Automated Kidney Segmentation

- Daniel AJ, Buchanan CE, Allcock T, et al. Automated renal segmentation in healthy and chronic kidney disease subjects
  using a convolutional neural network. Magnetic Resonance in Medicine. 2021;86(2):1125-1136.
  doi:[10.1002/mrm.28768](https://doi.org/10.1002/mrm.28768)

## Software

- [Trimesh](https://trimesh.org/index.html) - A library for interacting with meshes in Python.
- [Renal Segmentor](https://github.com/alexdaniel654/Renal_Segmentor) - Automated kidneys segmentation from T2-weighted FSE
  images using a convolutional neural network.
- [UKAT](https://github.com/UKRIN-MAPS/ukat) - UK Renal Imaging Network Kidney Analysis Toolbox, a framework for generating
  quantitative maps from renal MRI data.
- [LAYNII](https://github.com/layerfMRI/LAYNII) - One of the more popular tools for layer analysis of the brain.