# Contributing to QLayers

Thank you for considering contributing to QLayers! We welcome contributions from everyone. There are many ways to contribute, from writing tutorials or examples, improvements to the documentation, bug reports and feature requests, to contributing code that can be incorporated into QLayers itself. This contributing guide should give you an idea of how you can help make QLayers better. In general, we're just happy people are interested in this software and any feedback is greatly appreciated.

## Questions
If you have a question, your first port of call should be the [documentation](https://qlayers.readthedocs.io/latest/). If you can't find an answer there then you can submit an issue on the [GitHub issue tracker](https://github.com/alexdaniel654/qlayers/issues) or if you'd rather ask a question in private you can [email me](mailto:alexander.daniel@nottingham.ac.uk?subject=3DQLayers).

## Contributions

### Tiny Changes
If you spot things like typos, please submit an issue or a pull request. We're always happy to receive these. 

### Reporting Bugs
If you find a bug in QLayers, please submit an issue to the [GitHub issue tracker](https://github.com/alexdaniel654/qlayers/issues). When submitting an issue, please include a title and clear description of the issue. If possible, include a code snippet that demonstrates the issue, as well as any error messages you receive. If you can, please include the version of QLayers you are using, as well as the version of Python and any other relevant packages.

### Suggesting Enhancements
If you have an idea for enhancement to an existing feature, please submit an issue. Chances are we'll ask you to submit a pull request with your enhancement. When you submit an enhancement, please make sure its fully tested and documented, including adding tests to the test suite.

### New Features
QLayers currently just focuses on the kidneys. There's a balance between keeping the code general enough that, with a bit of tweaking, it can be used for other organs and keeping it easy to use for the kidneys. For this reason we suggest you submit an issue before starting work on a new feature. This way we can discuss the best way to implement the feature and make sure it fits with the rest of the codebase. If we agree your new feature fits well with QLayers then we'll ask you to submit a pull request. As with enhancements, please make sure your new feature is fully tested and documented.

### Suggested Documentation Changes
If you find the documentation lacking, please submit an issue and we can try and improve it. Especially welcome are tutorials and examples that show how to use QLayers in different ways.

## Styleguide
QLayers is written according to [pep8](https://peps.python.org/pep-0008/). The easiest way to make sure your code conforms to this style is to use [Black](https://black.readthedocs.io/en/stable/). Black is a code formatter that will automatically format your code to conform to pep8. It can easily be installed via pip and many IDEs can automatically run black on your code when you save a file.

## Code of Conduct
Please note that this project is released with a [Contributor Code of Conduct](CODE_OF_CONDUCT.md). By participating in this project you agree to abide by its terms.