import numpy as np
from PIL import Image

def reflect(image, ang):
    image_rot = image.rotate(ang, expand=True)
    image_np = np.array(image_rot)
    image_ref = np.fliplr(image_np)
    image_final = Image.fromarray(image_ref)
    image_final = image_final.rotate(-ang, expand=True)
    
    return image_final