let availableKeywords = [
    'Apple Macbook',
    'Audio Technica',
    'Apple Watch Series 7'
];

const resultsBox = document.querySelector(".result-box");
const inputBox = document.getElementById("input-box");

inputBox.onkeyup = function(){
    let result = [];
    let input = inputBox.value;

    if(input.length){
        result = availableKeywords.filter((keyword)=>{
           return keyword.toLowerCase().includes(input.toLowerCase());
        });
        console.log(result)
    }
    display(result);

    if(!result.length) {
        resultsBox.innerHTML = '';
    }
}

let matchingImageToKeywords = [
    'sproduct_pe1.html',
    'sproduct_pe2.html',
    'sproduct_pe3.html',
    'sproduct_pe4.html',
    'sproduct_pe5.html',
    'sproduct_pe6.html',
    'sproduct_pe7.html'
];

function display(result) {
    const content = result.map((list)=>{
        if(list=='Apple Macbook') {
            return '<li><a href="sproduct_pe2.html"><div class="container2"><img class="product-image" id="sproduct_pe2" width="50" height="50" style="border-radius: 8px" src="img/products/electronics/pe_2.jpg" alt=""><span>' + list + '</span></div></a></li>'
        }
        if(list=='Apple Watch Series 7') {
            return '<li><a href="sproduct_pe7.html"><div class="container2"><img class="product-image" id="sproduct_pe7" width="50" height="50" style="border-radius: 8px" src="img/products/electronics/pe_7.jpg" alt=""><span>' + list + '</span></div></a></li>'
        }
    });

    resultsBox.innerHTML = "<ul>" + content.join('') + "</ul>";
}

function selectInput(list) {
    inputBox.value = list.innerHTML;
    resultsBox.innerHTML = '';
}