/*** Login Button listener ***/

function initializeRegistrationLogin() {
var loginButton = document.getElementById('login-btn');

if(document.body.contains(loginButton)) { // if(loginButton)
document.getElementById('login-btn').addEventListener('click', async (e) => {
    e.preventDefault();

    let userEmailAddress = document.getElementById("login-user-email").value.toLowerCase();
    let password = document.getElementById("login-user-pw").value;

    if(userEmailAddress != '' && password != '' && password.length >= 6) {
        /* Login User via Node JS server (Backend)*/
        let responseLoginUser;
        await loginUser('loginUserFM', userEmailAddress)
        .then(response => {
            console.log("Result from loginUser(): ", response);
            if (response.status === "success") {
                console.log("Login successful. User data: ", response.userData);
                responseLoginUser = response;
            } else {
                console.error("Login failed: ", response.message);
                responseLoginUser = response;
            }
        })
        .catch(error => {
            console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
        });
        
        if(responseLoginUser.message == "userLoginSuccessful") {

            const loginPageElement = document.getElementById('login-page');

            document.getElementById("login-user-email").style.color = '#088178';
            document.getElementById("login-user-pw").style.color = '#088178';

            setTimeout(function() {
                loginPageElement.classList.add('hidden');
            }, 1000);

            loginPageElement.addEventListener('transitionend', function() {
            loginPageElement.remove();
            });

            document.getElementById("login-icon-color").style.color = '#088178';

            /*****************************/
            /*** Set Important Cookies ***/
            /*****************************/
            // set login cookie, i.e., remove login form if user refreshes website (8 day valid)
            setCookie("userLoggedIn","LoggedIn",8);
            /*
            let emailAddressHashed = CryptoJS.SHA256(userEmailAddress).toString().slice(0, 12);
            console.log("Email address hasedh: " + emailAddressHashed)
            */
            // get and set numberOfLogins
            setCookie("numberLogins", responseLoginUser.userData.number_logins, 8);
            // set user email hashed (first 12 digits)
            setCookie("userEmailHashed", responseLoginUser.userData.email_hashed, 8);
            // user email address
            setCookie("userEmailAddress", userEmailAddress, 8);
            // set online shop scenario (coupon)
            setCookie("scenario", responseLoginUser.userData.scenario, 8);
            // set online shop scenario (coupon)
            setCookie("scenarioDomain", responseLoginUser.userData.scenario_domain, 8);
            // set registration code
            setCookie("registrationCode", responseLoginUser.userData.registration_code, 8);
            // set user verified
            setCookie("userEmailVerified", "true", 8);

            // check whether login from other device then register device
            if(getCookie('userRegistered') == "") {
                // send login notification
                let responseLoginNotification;
                loginNotification('emailLoginNotificationFM', getCookie("userEmailAddress"), getCookie("language"))
                    .then(response => {
                        console.log("Result from registerUser(): " + response);
                        responseLoginNotification = response
                
                    })
                    .catch(error => {
                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                    });
            }

            // user registered
            setCookie("userRegistered","user_registered",8);


            let sweetAlert_LoggedInSuccessfully = data.en.sweetAlert_LoggedInSuccessfully;
            if(getLanguage() == "DE") {
                sweetAlert_LoggedInSuccessfully = data.de.sweetAlert_LoggedInSuccessfully; 
            }
            Swal.fire({
                text: sweetAlert_LoggedInSuccessfully,
                timer: 3000,
                color: "#162938",
                icon: "success",
                showConfirmButton: false,
                background: "#e3e6f3",
                });

        }
        /* Email verification needed */
        else if(responseLoginUser.message=='userRegistered_EmailAddressNotVerified') {

            document.querySelector('.error-txt-login').innerHTML = "";

            let sweetAlert_VerifyEmailAddress = data.en.sweetAlert_VerifyEmailAddress;
            let sweetAlert_VerifyEmailAddressConfirmBtn = data.en.sweetAlert_VerifyEmailAddressConfirmBtn;
            if(getLanguage() == "DE") {
                sweetAlert_VerifyEmailAddress = data.de.sweetAlert_VerifyEmailAddress;
                sweetAlert_VerifyEmailAddressConfirmBtn = data.de.sweetAlert_VerifyEmailAddressConfirmBtn;
            }
            Swal.fire({
                //title: "Success!",
                html: sweetAlert_VerifyEmailAddress,
                color: "#162938",
                icon: "info",
                confirmButtonColor: "#088178",
                confirmButtonText: sweetAlert_VerifyEmailAddressConfirmBtn,
                background: "#e3e6f3"
            }).then(function() {
                document.querySelectorAll('.swal2-container').forEach(e => e.remove());
                // function when confirm button clicked
        
                document.querySelectorAll('.swal2-shown').forEach(e => e.classList.remove("swal2-shown"));
                document.querySelectorAll('.swal2-height-auto').forEach(e => e.classList.remove("swal2-height-auto"));
        
                const elementsWithAriaHidden = document.querySelectorAll('[aria-hidden="true"]');
        
                elementsWithAriaHidden.forEach(element => {
                element.removeAttribute('aria-hidden');
                });
        
                document.querySelector('.login-link').click(); 
            });

        }
        else if(responseLoginUser.message=='userNotRegistered') {
            let sweetAlert_NotRegistered = data.en.sweetAlert_NotRegistered;
            let sweetAlert_NotRegisteredConfirmBtn = data.en.sweetAlert_NotRegisteredConfirmBtn;
            if(getLanguage() == "DE") {
                sweetAlert_NotRegistered = data.de.sweetAlert_NotRegistered;
                sweetAlert_NotRegisteredConfirmBtn = data.de.sweetAlert_NotRegisteredConfirmBtn; 
            }
            Swal.fire({
                //title: "Success!",
                html: sweetAlert_NotRegistered,
                color: "#162938",
                icon: "error",
                confirmButtonColor: "#088178",
                confirmButtonText: sweetAlert_NotRegisteredConfirmBtn,
                background: "#e3e6f3"
            }).then(function() {
                document.querySelectorAll('.swal2-container').forEach(e => e.remove());
                // function when confirm button clicked
        
                document.querySelectorAll('.swal2-shown').forEach(e => e.classList.remove("swal2-shown"));
                document.querySelectorAll('.swal2-height-auto').forEach(e => e.classList.remove("swal2-height-auto"));
        
                const elementsWithAriaHidden = document.querySelectorAll('[aria-hidden="true"]');
        t
                elementsWithAriaHidden.forEach(element => {
                element.removeAttribute('aria-hidden');
                });
        
                document.querySelector('.register-link').click(); 
            });
        }
        else {
            console.log('Response from function \"loginUser\" does not exist.');
          }
    }
    else {

        if (userEmailAddress == '' && password == ''){
            let errorEmailAndPassword = data.en.languageLoginErrorEmailAndPassword;
            if (getLanguage() == "DE") {
                errorEmailAndPassword = data.de.languageLoginErrorEmailAndPassword;
            }
            document.querySelector('.error-txt-login').innerHTML = errorEmailAndPassword;
        }
        else if (userEmailAddress == ''){
            let errorEmail = data.en.languageLoginErrorEmail;
            if (getLanguage() == "DE") {
                errorEmail = data.de.languageLoginErrorEmail;
            }
            document.querySelector('.error-txt-login').innerHTML = errorEmail;
        }
        else if (!userEmailAddress.includes("@")){
            let errorEmailValid = data.en.languageLoginErrorEmailValid;
            if (getLanguage() == "DE") {
                errorEmailValid = data.de.languageLoginErrorEmailValid;
            }
            document.querySelector('.error-txt-login').innerHTML = errorEmailValid;
       }
        else if (password == '') {
            let errorPassword = data.en.languageLoginErrorPassword;
            if (getLanguage() == "DE") {
                errorPassword = data.de.languageLoginErrorPassword;
            }
            document.querySelector('.error-txt-login').innerHTML = errorPassword;
        }
        else if (password.length < 6) {
            let errorWrongPassword = data.en.languageLoginErrorWrongPassword;
            if (getLanguage() == "DE") {
                errorWrongPassword = data.de.languageLoginErrorWrongPassword;
            }
            document.querySelector('.error-txt-login').innerHTML = errorWrongPassword;
        }
    }
});

} else {
    console.log("Not in Das Element mit der ID 'login-btn' wurde nicht gefunden.");
}

/*** Registration Button listener ***/
    


  // Überprüfe, ob das Element mit der ID "registration-btn" vorhanden ist
  var registrationButton = document.getElementById('registration-btn');

  if(document.body.contains(registrationButton)) {
    var checkbox_privacyPolicy = false;
    var checkbox = document.getElementById("language-registration-checkbox-text");
    checkbox.addEventListener("change", function() {
        if (checkbox.checked) {
            checkbox_privacyPolicy = true;
        } else {
            checkbox_privacyPolicy = false;
        }
    });

    document.getElementById('registration-btn').addEventListener('click', async (e) => {
        e.preventDefault();

        const formRegistrationCode = document.getElementById("form-registration-code");
        const formEmail = document.getElementById("form-email-address");

        const formPassword = document.getElementById("form-user-pw");
        const formConfirmPassword = document.getElementById("form-confirm-user-pw");

        let docId = 'empty'; // 1U5X38 (Verification-Code)
        let registrationCode = document.getElementById("form-registration-code").value.toUpperCase();


        checkInputs();

        // workaround check whether previous wrong registration code was entered AND whether it changed since then (cookie set below)
        let previousRegistrationCode = '';
        if(getCookie('previousRegistrationCode') != "") {
            previousRegistrationCode = getCookie('previousRegistrationCode');
        }

        if(registrationCode != '' && (!formRegistrationCode.classList.contains("error") || (formRegistrationCode.value != previousRegistrationCode)) && !formEmail.classList.contains("error") && !formPassword.classList.contains("error") && !formConfirmPassword.classList.contains("error")) {
            if(!checkbox_privacyPolicy) {
                let language_PrivacyPolicy = "Bitte akzeptiere die Datenschutzerklärung, um dich zu registrieren.";
                if (getLanguage() != "DE") {
                    language_PrivacyPolicy = "Please accept the privacy policy to register.";
                }
                Swal.fire({
                    text: language_PrivacyPolicy,
                    timer: 3000,
                    color: "#162938",
                    icon: "info",
                    showConfirmButton: false,
                    background: "#e3e6f3",
                    });
            }
            else {
                var registrationTimer = "";
                try {
                    registrationTimer = ((Date.now()-1711642572222) / 1000).toString();
                    registrationTimer = registrationTimer.split(".")[0];
                } catch (error) {
                    registrationTimer = "error_timer";
                }
    
                let responseRegisteredUsers = ""
                let userData=[formEmail.value.toLowerCase(),registrationCode, getDevice(),registrationTimer];
                await registerUser('registerUserFM', userData)
                    .then(response => {
                        console.log("Result from registerUser(): " + response);
                        responseRegisteredUsers = response
                
                    })
                    .catch(error => {
                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                    });
                
    
    
                console.log("Response from server:" + responseRegisteredUsers);
    
                if(responseRegisteredUsers=='userWrongRegistrationCode') {
                    console.log('Wrong registration code');
        
                    formRegistrationCode.classList.add("error");
                    formRegistrationCode.parentElement.classList.add("error");
    
                    let language_IncorrectRegistrationCode = "Falscher Registrierungs-Code. Bitte gib den erhaltenen Registrierungs-Code ein.";
                    if(getLanguage() != "DE") {
                        language_IncorrectRegistrationCode = "Your registration code is incorrect. Please use the provided registration code to register.";
                    }
                    formRegistrationCode.parentElement.querySelector('.error-txt').innerHTML = language_IncorrectRegistrationCode
                
                    // prevent user from using the same wrong registration code and spaming firebase...
                    setCookie("wrongRegistrationCode", registrationCode, 8);
                }
                else if(responseRegisteredUsers=='userEmailAddressAlreadyExist') {
                    formEmail.classList.add("error");
                    formEmail.parentElement.classList.add("error");
            
                    let language_DoubleEmail = "Es existiert bereits ein Account mit dieser E-Mail-Adresse."
                    if(getLanguage() != "DE") {
                        language_DoubleEmail =  "There is already an account with this email address.";
                    }
                    formEmail.parentElement.querySelector('.error-txt').innerHTML = language_DoubleEmail;
                }
                else if(responseRegisteredUsers=='userEmailAddressRegistered') {
                    console.log("Email address successfully registered.");
    
                    // set registration cookie, i.e., show by default login form instead of registration form
                    setCookie("userRegistered","user_registered",8);
    
                    const languageCookie = getCookie("language");
                    if(languageCookie == "") {
                        languageCookie == "DE";
                    }
                    
                    let responseEmailRegistration=""
                    sendEmailRegistration('emailRegistrationFM',formEmail.value.toLowerCase(), languageCookie)
                        .then(response => {
                            console.log("Result from sendEmailRegistration(): " + response);
                            responseEmailRegistration = response
                        })
                        .catch(error => {
                            // Behandele den Fehler, wenn erforderlich
                            console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                        });
                        
                        setCookie("registrationCode", registrationCode, 8);
    
                        // 1 second delay
                        setTimeout(function(){
                            showSuccessfulRegistrationPopupAndTranslateToLogin();
                        }, 1250);
                }
                else {
                    console.log('Response from function \"registerUser\" does not exist.');
                }
            }

        }

        // workaround registration code changed
        setCookie('previousRegistrationCode', formRegistrationCode.value.toUpperCase(), 8);

    });
  } else {
        console.log("Not in Das Element mit der ID 'login-btn' wurde nicht gefunden.");
  }





  var resetPasswordButton = document.getElementById('resetpw-btn');

  if(document.body.contains(resetPasswordButton)) {
    resetPasswordButton.addEventListener('click', async (e) => {
        e.preventDefault();

        const resetPW = document.querySelector('.form-box.resetpw');
        const hideRegister = document.querySelector('.form-box.register');
        const hideLogin = document.querySelector('.form-box.login');
        const wrapper = document.querySelector('.wrapper');

        resetPW.style.display = 'none';

        hideRegister.style.display = 'block';
        hideLogin.style.display = 'block';

        wrapper.style.height = '440px';

        const formEmail = document.getElementById("reset-user-email-form");


        const languageCookie = getCookie("language");
        if(languageCookie == "") {
            languageCookie == "DE";
        }

        let responseResetEmailPassword = ""

        /* Send password reset email via Node JS server (Backend)*/
        
        await sendEmailPasswordReset('emailPasswordResetFM', formEmail.value.toLowerCase(), languageCookie)
        .then(response => {
            console.log("Result from sendRegistrationEmail(): " + response);
            responseResetEmailPassword = response
    
        })
        .catch(error => {
            console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
        });
        

        // Registration Email send successfully
        if(responseResetEmailPassword=="SendEmail_ResetPasswort_Successfully") {
            let sweetAlert_ResetPassword = data.en.sweetAlert_ResetPassword;
            if(getLanguage() == "DE") {
                sweetAlert_ResetPassword = data.de.sweetAlert_ResetPassword; 
            }
            Swal.fire({
                html: sweetAlert_ResetPassword,
                timer: 4000,
                color: "#162938",
                icon: "info",
                showConfirmButton: false,
                background: "#e3e6f3",
                });

                // back to login screen
                const hideReset = document.querySelector('.form-box.resetpw');
                hideReset.style.display = 'none';
                
                document.querySelector('.login-link').click();

                // reset email address to zero
                formEmail.value = '';
        }
        else if (responseResetEmailPassword=="SendEmail_ResetPasswort_Error") {
          console.log('\"sendRegistrationEmail\" -- Mailtrap Send Mail Error');
        }
        else {
            console.log('Response from function \"sendRegistrationEmail\" does not exist.');
        }
    });
}


function showSuccessfulRegistrationPopupAndTranslateToLogin() {
    let sweetAlert_VerifyEmailAddress = data.en.sweetAlert_VerifyEmailAddress;
    let sweetAlert_VerifyEmailAddressConfirmBtn = data.en.sweetAlert_VerifyEmailAddressConfirmBtn;
    if(getLanguage() == "DE") {
        sweetAlert_VerifyEmailAddress = data.de.sweetAlert_VerifyEmailAddress;
        sweetAlert_VerifyEmailAddressConfirmBtn = data.de.sweetAlert_VerifyEmailAddressConfirmBtn; 
    }
    Swal.fire({
        html: sweetAlert_VerifyEmailAddress,
        color: "#162938",
        icon: "info",
        confirmButtonColor: "#088178",
        confirmButtonText: sweetAlert_VerifyEmailAddressConfirmBtn,
        background: "#e3e6f3"
    }).then(function() {
        document.querySelectorAll('.swal2-container').forEach(e => e.remove());
        // function when confirm button clicked

        document.querySelectorAll('.swal2-shown').forEach(e => e.classList.remove("swal2-shown"));
        document.querySelectorAll('.swal2-height-auto').forEach(e => e.classList.remove("swal2-height-auto"));

        const elementsWithAriaHidden = document.querySelectorAll('[aria-hidden="true"]');

        elementsWithAriaHidden.forEach(element => {
        element.removeAttribute('aria-hidden');
        });

        document.querySelector('.login-link').click(); 
    });
  }
}