
ready();

//updateCartTotal();

cartBadgeNumber();


function ready() {

    cartBadgeNumber()

    // update order list and show "order list empty"-message (if not empty)
    const orderCookieExist = getCookie("OrderedProductsArray");
    if (orderCookieExist == "") {
        updateMessageEmptyOrderList();
    }
    else {
        updateOrderList();
    }

    let userLoggedIn = getCookie("userLoggedIn");
    if (userLoggedIn == "") {
        initializeLoginPage();
        const loginPageElements = document.querySelector('.login-page-node-notification');

        loginPageElements.style.display = 'none';

        var initializeCloseButton = document.querySelector('.icon-close')

        initializeCloseButton.addEventListener('click', function(event) {
            const loginPageElements = document.querySelector('.login-page-node-notification');

            loginPageElements.style.display = 'none';
        });
    }
}

function initializeLoginPage() {
    const loginPageElements = document.querySelectorAll('.login-page-node-notification');

    const htmlCode = `
    <section class="wrapper" id="login-page">
        <span class="icon-close">
            <ion-icon name="close"><i class='bx bx-x'></i></ion-icon>
        </span>
        
        <div class="form-box login">
            <h2>Login</h2>
            <form action="#" id="input-boxes">
                <div class="input-box">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="login-user-email" required>
                    <label>Email</label>
                </div>
                <div class="input-box">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="login-user-pw" required>
                    <label>Password</label>
                </div>
                <div class="remember-forgot">
                    <label><input type="checkbox" checked>Remember me</label>
                    <a href="#" class="resetpw-link">Forgot Password?</a>
                </div>
                <button type="submit" id="login-btn" class="btn">Login</button>
                <div class="login-register">
                    <p>Don't have an account? <a href="#" class="register-link">Register</a></p>
                </div>
                <div class="error-txt-login">
                <p></p>
            </div>
            </form>
        </div>

        <div class="form-box register sendregistermail">
            <h2>Registration</h2>
            <form action="#" id="input-boxes">
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-user'></i></span>
                    <input type="text" id="form-registration-code" class="item" autcomplete="off">
                    <label>Verification-Code</label>
                    <div class="error-txt">Verification-Code can't be blank.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="form-email-address" class="item" autcomplete="off">
                    <label>Email</label>
                    <div class="error-txt">Email Address can't be blank.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-user-pw" class="item" autcomplete="off">
                    <label>Password (min 6 characters)</label>
                    <div class="error-txt">Password can't be blank.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-confirm-user-pw" class="item" autcomplete="off">
                    <label>Password (confirm)</label>
                    <div class="error-txt">Confirm password can't be blank.</div>
                </div>
                <div class="remember-forgot">
                    <label><input type="checkbox" checked>I agree to the terms & conditions</label>
                </div>
                <button type="submit" id="registration-btn" class="btn">Register</button>
                <div class="login-register">
                    <p>Already have an account? <a href="#" class="login-link">Login</a></p>
                </div>
            </form>
        </div>

        <div class="form-box resetpw">
        <h2>Password Reset</h2>
            <form action="#" id="input-boxes">
                <div class="input-box">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="login-user-email" required>
                    <label>Email</label>
                </div>
                <button type="submit" id="resetpw-btn" class="btn">Login</button>
                <div class="login-register">
                    <p>Remember your password? <a href="#" class="back-to-login-link">Login</a></p>
                </div>
            </form>
        </div>

        <div class="form-box changepw">
        <h2>Password Reset</h2>
            <form action="#" id="input-boxes">
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-change-user-pw" class="item" autcomplete="off">
                    <label>New Password (min 6 characters)</label>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-confirm-change-user-pw" class="item" autcomplete="off">
                    <label>Confirm Password</label>
                </div>
                <button type="submit" id="changepw-btn" class="btn">Change Password</button>
                <div class="error-txt-changepw">
                <p></p>
                </div>
            </form>
        </div>
    </section>
    `;

    /*
    // Füge das neue div-Element unter jedes Element mit der Klasse 'login-page' hinzu
    loginPageElements.forEach(element => {
        element.insertAdjacentHTML('beforeend', htmlCode); // Wir verwenden cloneNode, um eine Kopie des Elements einzufügen
    });
    */
    // Füge den HTML-Code unter jedes Element ein

    let loginPageAlreadyExists = document.getElementById('login-page')
    if(!document.body.contains(loginPageAlreadyExists)) {
        loginPageElements.forEach(element => {
            element.insertAdjacentHTML('beforeend', htmlCode);
        });
    }
}


function cartBadgeNumber() {
    let quantityOfCartElements = getCookie("CartNumberOfArticles");
    if (quantityOfCartElements != "") {
        var quantityOfCartElementsToInt = quantityOfCartElements

        document.getElementsByClassName('cart-badge')[0].innerHTML = quantityOfCartElementsToInt
    } else {
        document.getElementsByClassName('cart-badge')[0].innerHTML = ''
    }
}

function updateOrderList() {
    const orderedProductsArrayCookieMonster = cookiemonster.get('OrderedProductsArray')
    if(orderedProductsArrayCookieMonster != "") {

        var tbodyRef = document.getElementById('order').getElementsByTagName('tbody')[0];

        let showOrderProducts = []

        showOrderProducts = orderedProductsArrayCookieMonster

        console.log('Ordered ProductsArray New Elements:' + showOrderProducts)
          
        for(i=0; i < showOrderProducts.length; i+=6) {
            // Insert a row at the end of table
            var addProductRow = tbodyRef.insertRow();
            addProductRow.className = 'order-item';

            console.log(i)

            var orderDate = showOrderProducts[i]
            var orderNumber = showOrderProducts[i+1]
            var productName = showOrderProducts[i+2]
            var productPrice = showOrderProducts[i+4]+" €";;

            var productQuantity = showOrderProducts[i+5]

            // Insert a cell at the end of the row

            var productOrderDate = addProductRow.insertCell();
            productOrderDate.innerHTML = orderDate

            var productOrderCell = addProductRow.insertCell();
            productOrderCell.innerHTML = orderNumber
            
            var productNameCell = addProductRow.insertCell();
            productNameCell.className = 'product-name'
            var productNameTextContent = document.createTextNode(productName);
            productNameCell.appendChild(productNameTextContent);
            
            var productQuantityCell = addProductRow.insertCell();
            productQuantityCell.innerHTML = productQuantity;
            
            var productPriceSubTotalCell = addProductRow.insertCell();
            productPriceSubTotalCell.className = 'order-quantity-subtotal-input'

            var priceParsed= parseFloat(productPrice.replace('€', '').replace(',', '.'))
            var productPriceSubTotalTextContent = document.createTextNode(priceItemSubTotal(priceParsed, productQuantity) + " €");
            productPriceSubTotalCell.appendChild(productPriceSubTotalTextContent);
        }
    }
    // Finde alle Elemente mit der Klasse "order-item"
    const orderItems = document.querySelectorAll('.order-item');

    // Initialisiere eine Map, um die Anzahl der Vorkommen jeder Bestellnummer zu speichern
    const orderNumberCountMap = new Map();

    // Initialisiere eine Variable, um das vorherige Element zu speichern
    let prevItem = null;

    // Durchlaufe alle Elemente
    orderItems.forEach(item => {
    // Finde die Zelle mit der Bestellnummer
    const orderNumberCell = item.querySelector('td:nth-child(2)');
    const orderNumber = orderNumberCell.textContent.trim();

    const orderDateCell = item.querySelector('td:nth-child(1)');
    
    // Überprüfe, ob die Bestellnummer leer ist
    const isEmptyOrderNumber = orderNumber === '';

    // Zähle die Anzahl der Vorkommen der Bestellnummer
    const count = orderNumberCountMap.get(orderNumber) || 0;
    orderNumberCountMap.set(orderNumber, count + 1);
    
    // Überprüfe, ob dies das erste Vorkommen der Bestellnummer ist und nicht leer ist
    if (count === 0 && !isEmptyOrderNumber) {
        // Wenn ja, aktualisiere die vorherige Bestellnummer
        prevItem = item;
    } else {
        // Wenn nicht, ersetze den Inhalt durch ein Leerzeichen
        orderNumberCell.textContent = ' ';
        orderDateCell.textContent = ' ';
        // Entferne die Grenzlinie des aktuellen Elements
        item.style.borderBottom = 'none';
        // Suchen Sie das vorherige Element mit der Klasse "order-item"
        if (prevItem) {
        const prevOrderItem = prevItem.previousElementSibling;
        if (prevOrderItem && prevOrderItem.classList.contains('order-item')) {
            // Wenn ein vorheriges Element gefunden wurde, behalten Sie die untere Grenzlinie bei
            prevOrderItem.style.borderBottom = '1px solid #e2e9e1';
        }
        }
    }
    });
}

function updateMessageEmptyOrderList() {

    const showMessageEmptyOrderList = document.querySelector('.show-message-empty-order-list');

    showMessageEmptyOrderList.style.display = "block";
}


function priceItemSubTotal (price, quantity) {
    let priceItemSubTotalInt = price * quantity;
    try {
        priceItemSubTotalInt = (Math.round(priceItemSubTotalInt * 100) / 100).toFixed(2);
    } catch (error) {
        priceItemSubTotalInt = Math.round(priceItemSubTotalInt * 100) / 100;
    }
    let priceItemSubTotal = priceItemSubTotalInt.toString()
    if(getLanguage() == "DE") {
        priceItemSubTotal = priceItemSubTotal.toString().replace('.', ',');
    }
    // Überprüfen, ob es Nachkommastellen gibt
    let decimalSeparator = priceItemSubTotal.includes(',') ? ',' : '.';
    let decimalPart = priceItemSubTotal.split(decimalSeparator)[1];
    if (decimalPart && decimalPart.length === 1) {
        // Fügen Sie eine weitere Null hinzu, um sicherzustellen, dass immer zwei Nachkommastellen vorhanden sind
        priceItemSubTotal += '0';
    }

    return priceItemSubTotal;
}


/*
  //delete cookies workaround
  function setCookie(key, value, expireDays, expireHours, expireMinutes, expireSeconds) {
    var expireDate = new Date();
    if (expireDays) {
        expireDate.setDate(expireDate.getDate() + expireDays);
    }
    if (expireHours) {
        expireDate.setHours(expireDate.getHours() + expireHours);
    }
    if (expireMinutes) {
        expireDate.setMinutes(expireDate.getMinutes() + expireMinutes);
    }
    if (expireSeconds) {
        expireDate.setSeconds(expireDate.getSeconds() + expireSeconds);
    }
    document.cookie = key +"="+ escape(value) +
        ";domain="+ window.location.hostname +
        ";path=/"+
        ";expires="+expireDate.toUTCString();
}

function deleteCookie(name) {
    setCookie(name, "", null , null , null, 1);
}

function setCookie(key, value, time) {
    // get the current time
    let d = new Date()
    d.setTime(d.getTime() + (time*24*60*60*1000))

    let expires = "expires=" + d.toUTCString()

    document.cookie = key + "=" + value + ";" + expires + ";"//";path=/"

}
*/
