/*** Local Node JS Server ***/
//const nodeJSConnection='http://localhost:3000';
/*** Plesk Node JS Server ***/
const nodeJSConnection='https://smartbuyonline.de';
const nodeJSConnection_smart_buy_online='https://smart-buy-online.de';
const nodeJSConnection_couponcampaign='https://coupon-info-smartbuyonline.couponcampaign.org';

const nodeJSConnectionRegisterUser='/register-user';
const nodeJSConnectionLoginUser='/login-user';
const nodeJSConnectionLoginNotification = '/login-notification';
const nodeJSConnectionUserOrderToDB='/send-order';
const nodeJSConnectionFirestoreDBVerifyEmailAddress='/update-registrationverification';
const nodeJSConnectionFirestoreDBEmailCoupon='/store-data-coupon';
const nodeJSConnectionFirestoreDBStoreOpenedWebsite='/store-data-openedwebsite';


const nodeJSConnectionSendEmailOrderConfirmation='/send-email-order-confirmation';

const nodeJSConnectionSendEmailRegistration='/send-email';
const nodeJSConnectionSendEmailPasswortReset='/send-email';
const nodeJSConnectionSendEmailCoupon='/send-coupon';







async function registerUser(functionName, params) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionRegisterUser, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, params }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }


  async function loginUser(functionName, params) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionLoginUser, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, params }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

// send login notification
  async function loginNotification(functionName, param1, param2) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionLoginNotification, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  /*
  async function loginUser(functionName, params) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionLoginUser, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, params }),
      });

      // Debugging: Logge die Antwort des Servers
      console.log(response);

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }
  */

  async function firestoreDBVerifyEmailAddress(functionName, param1, param2) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionFirestoreDBVerifyEmailAddress, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function userOrderToDB(functionName, param1, param2, param3, param4, param5, param6, param7, param8) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionUserOrderToDB, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3, param4, param5, param6, param7, param8 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function storeDataCoupon(functionName, param1, param2, param3) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionFirestoreDBEmailCoupon, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3}),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function storeDataOpenedPhishingWebsite(functionName, param1, param2) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionFirestoreDBStoreOpenedWebsite, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }


  /*** send E-Mail ***/
  async function sendEmailRegistration(functionName, param1, param2) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionSendEmailRegistration, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function sendEmailPasswordReset(functionName, param1, param2) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionSendEmailPasswortReset, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function sendEmailCoupon(functionName, param1, param2, param3) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionSendEmailCoupon, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }
  async function sendEmailCoupon_Smart_Buy_Online(functionName, param1, param2, param3) {
    try {
      const response = await fetch(nodeJSConnection_smart_buy_online+nodeJSConnectionSendEmailCoupon, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }
  async function sendEmailCoupon_CouponCampaign(functionName, param1, param2, param3) {
    try {
      const response = await fetch(nodeJSConnection_couponcampaign+nodeJSConnectionSendEmailCoupon, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function sendEmailOrderConfirmation(functionName, param1, param2, param3, param4, param5, param6) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionSendEmailOrderConfirmation, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3, param4, param5, param6 }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }
