const data = {
    "de":
    {
        "registrationHeader": "Registrieren",
        "registrationVerificationCode": "Registrierungs-Code",
        "registrationVerificationcodeError": "Gib den erhaltenen Registrierungs-Code ein.",
        "registrationEmailaddress": "E-Mail-Adresse",
        "registrationEmailaddressError": "Gib deine E-Mail-Adresse ein.",
        "registrationFirstPassword": "Passwort (mind. 6 Zeichen)",
        "registrationFirstPasswordError": "Gib dein Passwort ein.",
        "registrationSecondPassword": "Passwort erneut eingeben",
        "registrationSecondPasswordError": "Gib dein Passwort ein.",
        "registrationCheckboxText": '<div id="registrationcheckbox-workaround" style="font-size: 12px; padding-left: 8px; padding-top: 3px;">Ich stimme der&nbsp;<a href="privacy.html" style="color: #088178; text-decoration: none;">Datenschutzerklärung</a>&nbsp;zu.<div>',
        "registrationButton": "Registrieren",
        "registrationBacktologinText": 'Du hast einen Account? ',
        "registrationLoginLink": "Anmelden",

        "languageLoginHeader": "Anmelden",
        "languageLoginEmailaddress": "E-Mail-Adresse",
        "languageLoginPassword": "Passwort",
        "languageLoginrememberpwd": "Passwort merken",
        "languageLoginforgotpwd": "Passwort vergessen?",
        "languageLoginbutton": "Anmelden",
        "languageLoginRequireaccount": 'Noch keinen Account? ',
        "languageLoginregistrationlink": "Registrieren",

        "languageLoginErrorEmailAndPassword": "Gib deine E-Mail-Adresse und Passwort ein.",
        "languageLoginErrorEmail": "Gib deine E-Mail-Adresse ein.",
        "languageLoginErrorEmailValid": "Gib eine gültige E-Mail-Adresse ein.",
        "languageLoginErrorPassword": "Gib dein Passwort ein.",
        "languageLoginErrorWrongPassword": "Falsches Passwort.",

        "languageResetpwdHeader": "Passwort zurücksetzen",
        "languageResetpwdEmailaddress": "E-Mail-Adresse",
        "languageResetpwdButton": "Weiter",
        "languageResetpwdRememberpwd": 'Du kennst dein Passwort? ',
        "languageResetpwdLoginLink": "Anmelden",

        "passwordresetHeader": "Passwort zurücksetzen",
        "passwordresetFirstnewpassword": "Neues Password (mind. 6 Zeichen)",
        "passwordresetSecondnewpassword": "Passwort erneut eingeben",
        "passwordButton": "Passwort ändern",

        /* Hero Element */
        "heroFirstHeader": "Fashion Woche auf Smart Buy Online",
        "heroSecondHeader": "Finde dein perfektes Outfit",
        "heroThirdHeader": "KI unterstützte Auswahl",
        "heroFourthHeader": "Bis zu 25% Rabatt!",
        "heroButton": "Zum Shop",

        /* Feature Element*/
        "feature_1": "Unkomplizierte Bestellung",
        "feature_2": "Schnelle Lieferung<br>(1-2 Tage)",
        "feature_3": "Umweltbewusstsein",
        "feature_4": "Über 99.9% zufriedene Kunden",
        "feature_5": "Hochwertige Produkte",
        "feature_6": "24/7 Kundensupport",

        /* Product1 Section */
        "product1_Title": "Neue Produkte",
        "product1_Subtitle": "Kaufe neue Produkte und spare bis zu 15%",

        /* Product2 Section */
        "product2_Title": "Entdecke mehr",
        "product2_Subtitle": "Weitere Produkte in unserem Shop",
        "product2_Button": "Zum Shop",

        /* Sweet Alert Messages */
        "sweetAlert_LoggedInSuccessfully": "Du bist eingeloggt!",
        "sweetAlert_VerifyEmailAddress": "Bitte prüfe dein E-Mail Postfach, um deine Registrierung zu bestätigen.<br><span style='font-size: 14px;'>Bitte denk dran auch im <b>Spam</b> oder <b>Werbung</b> Ordner nachzuschauen!</span>",
        "sweetAlert_ResetPassword": "Prüf dein E-Mail Postfach, um dein Passwort zurückzusetzen.<br><br><span style='font-size: 14px;'>Bitte denk dran auch im <b>Spam</b> oder <b>Werbung</b> Ordner nachzuschauen!</span>",
        "sweetAlert_NotRegistered": "Deine E-Mail-Adresse ist nicht registriert.<br><span style='font-size: 14px;'>Bitte klick auf &bdquo;Registrieren&ldquo;.</span>",
        "sweetAlert_VerifyEmailAddressConfirmBtn": "Verstanden",
        "sweetAlert_NotRegisteredConfirmBtn": "Verstanden",
    },
    "en":
    {
        "registrationHeader": "Registration",
        "registrationVerificationCode": "Registration Code",
        "registrationVerificationcodeError": "Enter your registration code.",
        "registrationEmailaddress": "Email",
        "registrationEmailaddressError": "Enter your email address.",
        "registrationFirstPassword": "Password (min 6 characters)",
        "registrationFirstPasswordError": "Enter your password.",
        "registrationSecondPassword": "Re-enter password.",
        "registrationSecondPasswordError": "Re-enter your password.",
        "registrationCheckboxText": '<div id="registrationcheckbox-workaround" style="font-size: 12px; padding-left: 8px; padding-top: 3px;">I agree to the&nbsp;<a href="privacy.html" style="color: #088178; text-decoration: none;">privacy policy</a>.<div>',

        "registrationButton": "Register",
        "registrationBacktologinText": 'Already have an account? ',
        "registrationLoginLink": "Login",

        "languageLoginHeader": "Login",
        "languageLoginEmailaddress": "Email",
        "languageLoginPassword": "Password",
        "languageLoginrememberpwd": "Remember me",
        "languageLoginforgotpwd": "Forgot Password?",
        "languageLoginbutton": "Login",
        "languageLoginRequireaccount": 'Don\'t have an account? ',
        "languageLoginRegistrationlink": "Register",

        "languageLoginErrorEmailAndPassword": "Enter email address and password.",
        "languageLoginErrorEmail": "Enter email address.",
        "languageLoginErrorEmailValid": "Enter a valid email address.",
        "languageLoginErrorPassword": "Enter your password.",
        "languageLoginErrorWrongPassword": "Wrong password.",

        "languageResetpwdHeader": "Password Reset",
        "languageResetpwdEmailaddress": "Email",
        "languageResetpwdButton": "Continue",
        "languageResetpwdRememberpwd": 'Remember your password? ',
        "languageResetpwdLoginLink": "Login",

        "passwordresetHeader": "Reset Password",
        "passwordresetFirstnewpassword": "New Password (min 6 characters)",
        "passwordresetSecondnewpassword": "Re-enter password",
        "passwordButton": "Change Password",

        /* Hero Element */
        "heroFirstHeader": "Fashion week on Smart Buy Online",
        "heroSecondHeader": "Find your perfect Outfit",
        "heroThirdHeader": "Selection assisted by AI",
        "heroFourthHeader": "Save up to 25% off!",
        "heroButton": "Shop now",

        /* Feature Element */
        "feature_1": "Hassle-Free Order",
        "feature_2": "Fast Delivery<br>(1-2 days)",
        "feature_3": "Environmental Awareness",
        "feature_4": "Over 99.9% Satisfied Customers",
        "feature_5": "Superior Products",
        "feature_6": "24/7 Support",

        /* Product1 Section */
        "product1_Title": "New Products",
        "product1_Subtitle": "Buy new arrivals and save up to 15%",

        /* Product2 Section */
        "product2_Title": "Explore More",
        "product2_Subtitle": "More Products in our Shop",
        "product2_Button": "Shop now",

        /* Sweet Alert Messages */
        "sweetAlert_LoggedInSuccessfully": "You're logged in",
        "sweetAlert_VerifyEmailAddress": "Please check your mailbox to verify your email address.<br><span style='font-size: 14px;'>Please also check your <b>spam</b> or <b>promotions</b> folder!</span>",
        "sweetAlert_ResetPassword": "Please check your mailbox to reset your password.<br><span style='font-size: 14px;'>Please also check your <b>spam</b> or <b>promotions</b> folder!</span>",
        "sweetAlert_NotRegistered": "Your entered email address is not registered.<br><span style='font-size: 14px;'>Please &ldquo;Register&rdquo;.</span>",
        "sweetAlert_VerifyEmailAddressConfirmBtn": "Confirm",
        "sweetAlert_NotRegisteredConfirmBtn": "Confirm",
        
    }
}

const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
dropdownLanguage_German.addEventListener('click', ()=> {

    setLanguageGerman_LoginPopup()
});


const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
dropdownLanguage_English.addEventListener('click', ()=> {

    setLanguageEnglish_LoginPopup()
});


const languageCookie = getCookie("language");
if (languageCookie != "") {

    if(languageCookie=="DE") {

        setLanguageGerman_LoginPopup()
    }
    else {

        setLanguageEnglish_LoginPopup()
    }
}

function setLanguageGerman_LoginPopup() {

    const loginPopup = document.querySelector('#login-page');
    if(document.body.contains(loginPopup)) {
        /*registration popup*/
        loginPopup.querySelector("#language-registration-header").textContent= data.de.registrationHeader;
        loginPopup.querySelector("#language-registration-verificationcode").textContent= data.de.registrationVerificationCode;
        loginPopup.querySelector("#language-registration-verificationcode-error").textContent= data.de.registrationVerificationcodeError;
        loginPopup.querySelector("#language-registration-emailaddress").textContent= data.de.registrationEmailaddress;
        loginPopup.querySelector("#language-registration-emailaddress-error").textContent= data.de.registrationEmailaddressError;
        loginPopup.querySelector("#language-registration-firstpassword").textContent= data.de.registrationFirstPassword;
        loginPopup.querySelector("#language-registration-firstpassword-error").textContent= data.de.registrationFirstPasswordError;
        loginPopup.querySelector("#language-registration-secondpassword").textContent= data.de.registrationSecondPassword;
        loginPopup.querySelector("#language-registration-secondpassword-error").textContent= data.de.registrationSecondPasswordError;
        
        // Element mit der ID "registrationcheckbox-workaround" auswählen
        var workaroundElement = document.getElementById("registrationcheckbox-workaround");

        // Überprüfen, ob das Element existiert
        if (workaroundElement) {
            // Element und alle seine Kinder entfernen
            workaroundElement.parentNode.removeChild(workaroundElement);
        }

        var inputElement = document.getElementById("language-registration-checkbox-text");


        // HTML-Code als Kindelement hinzufügen
        inputElement.insertAdjacentHTML('afterend', data.de.registrationCheckboxText);
        
        //loginPopup.querySelector("#language-registration-checkbox-text").nextSibling.nodeValue= data.de.registrationCheckboxText;
        loginPopup.querySelector("#registration-btn").textContent= data.de.registrationButton;
        //loginPopup.querySelector("#language-registration-backtologin-text").innerHTML= data.de.registrationBacktologinText;
        loginPopup.querySelector("#language-registration-backtologin-text").firstChild.textContent = data.de.registrationBacktologinText;
        loginPopup.querySelector("#language-registration-loginlink").textContent= data.de.registrationLoginLink;

        /* Login Popup */
        loginPopup.querySelector("#language-login-header").textContent= data.de.languageLoginHeader;
        loginPopup.querySelector("#language-login-emailaddress").textContent= data.de.languageLoginEmailaddress;
        loginPopup.querySelector("#language-login-password").textContent= data.de.languageLoginPassword;
        loginPopup.querySelector("#language-login-rememberpwd").nextSibling.nodeValue = data.de.languageLoginrememberpwd;
        loginPopup.querySelector("#language-login-forgotpwd").textContent= data.de.languageLoginforgotpwd;
        loginPopup.querySelector("#login-btn").textContent= data.de.languageLoginbutton;
        //loginPopup.querySelector("#language-login-requireaccount").innerHTML= data.de.languageLoginRequireaccount;
        loginPopup.querySelector("#language-login-requireaccount").firstChild.textContent= data.de.languageLoginRequireaccount;
        loginPopup.querySelector("#language-login-registrationlink").textContent= data.de.languageLoginregistrationlink;

        loginPopup.querySelector("#language-resetpwd-header").textContent= data.de.languageResetpwdHeader;
        loginPopup.querySelector("#language-resetpwd-emailaddress").textContent= data.de.languageResetpwdEmailaddress;
        loginPopup.querySelector("#resetpw-btn").textContent= data.de.languageResetpwdButton;
        //loginPopup.querySelector("#language-resetpwd-rememberpwd").innerHTML= data.de.languageResetpwdRememberpwd;
        loginPopup.querySelector("#language-resetpwd-rememberpwd").firstChild.textContent= data.de.languageResetpwdRememberpwd;
        loginPopup.querySelector("#language-resetpwd-loginlink").textContent= data.de.languageResetpwdLoginLink;

        loginPopup.querySelector("#language-passwordreset-header").textContent= data.de.passwordresetHeader;
        loginPopup.querySelector("#language-passwordreset-firstnewpassword").textContent= data.de.passwordresetFirstnewpassword;
        loginPopup.querySelector("#language-passwordreset-secondnewpassword").textContent= data.de.passwordresetSecondnewpassword;
        loginPopup.querySelector("#changepw-btn").textContent= data.de.passwordButton;

        /*
        const wrapper = document.querySelector('.wrapper');
        const loginLink = document.querySelector('.login-link');
        const registerLink = document.querySelector('.register-link');
        
        const resetPW = document.querySelector('.form-box.resetpw');
        const changePW = document.querySelector('.form-box.changepw');

        resetPW.style.display = 'none';
        changePW.style.display = 'none';

        if(registerLink !== null) {
            registerLink.addEventListener('click', ()=> {
            
                wrapper.classList.add('active');
        
                wrapper.style.height = '660px';
            });
        }

        if(loginLink !== null) {
            loginLink.addEventListener('click', ()=> {
                
                wrapper.classList.remove('active');

                wrapper.style.height = '440px';
            });
        }

        
        

        const resetPWLink = document.querySelector('.resetpw-link');

        const hideRegister = document.querySelector('.form-box.register');
        const hideLogin = document.querySelector('.form-box.login');
        
        if(resetPWLink !== null) {
            resetPWLink.addEventListener('click', ()=> {
                resetPW.style.display = 'block';
                wrapper.style.height = '360px';

                hideRegister.style.display = 'none';
                hideLogin.style.display = 'none';
            });
        }

        const backToLoginLink = document.querySelector('.back-to-login-link');

        if(backToLoginLink !== null) {
            backToLoginLink.addEventListener('click', ()=> {
                resetPW.style.display = 'none';

                hideRegister.style.display = 'block';
                hideLogin.style.display = 'block';

                wrapper.style.height = '440px';
            });
        }

        /* Reset Password Workaround */


        // http://127.0.0.1:5500/onlineshop/index.html?hashed_email=e3b0c44298fc&reset_password=true
        const queryString_PasswordReset = window.location.search;
        const urlParams_PasswordReset = new URLSearchParams(queryString_PasswordReset);
        if(urlParams_PasswordReset.has('hashed_email') && urlParams_PasswordReset.has('reset_password')) {
            resetPasswordWorkaround()
        }
    
    }
}

function setLanguageEnglish_LoginPopup() {
    
    const loginPopup = document.querySelector('#login-page');

    if(document.body.contains(loginPopup)) {
        /* registration popup */
        loginPopup.querySelector("#language-registration-header").textContent= data.en.registrationHeader;
        loginPopup.querySelector("#language-registration-verificationcode").textContent= data.en.registrationVerificationCode;
        loginPopup.querySelector("#language-registration-verificationcode-error").textContent= data.en.registrationVerificationcodeError;
        loginPopup.querySelector("#language-registration-emailaddress").textContent= data.en.registrationEmailaddress;
        loginPopup.querySelector("#language-registration-emailaddress-error").textContent= data.en.registrationEmailaddressError;
        loginPopup.querySelector("#language-registration-firstpassword").textContent= data.en.registrationFirstPassword;
        loginPopup.querySelector("#language-registration-firstpassword-error").textContent= data.en.registrationFirstPasswordError;
        loginPopup.querySelector("#language-registration-secondpassword").textContent= data.en.registrationSecondPassword;
        loginPopup.querySelector("#language-registration-secondpassword-error").textContent= data.en.registrationSecondPasswordError;
        
        // Element mit der ID "registrationcheckbox-workaround" auswählen
        var workaroundElement = document.getElementById("registrationcheckbox-workaround");

        // Überprüfen, ob das Element existiert
        if (workaroundElement) {
            // Element und alle seine Kinder entfernen
            workaroundElement.parentNode.removeChild(workaroundElement);
        }

        var inputElement = document.getElementById("language-registration-checkbox-text");


        // HTML-Code als Kindelement hinzufügen
        inputElement.insertAdjacentHTML('afterend', data.en.registrationCheckboxText);
        
        //loginPopup.querySelector("#language-registration-checkbox-text").nextSibling.nodeValue= data.en.registrationCheckboxText;
        loginPopup.querySelector("#registration-btn").textContent= data.en.registrationButton;
        //loginPopup.querySelector("#language-registration-backtologin-text").innerHTML= data.en.registrationBacktologinText;
        loginPopup.querySelector("#language-registration-backtologin-text").firstChild.textContent= data.en.registrationBacktologinText;
        loginPopup.querySelector("#language-registration-loginlink").textContent= data.en.registrationLoginLink;

        loginPopup.querySelector("#language-login-header").textContent= data.en.languageLoginHeader;
        loginPopup.querySelector("#language-login-emailaddress").textContent= data.en.languageLoginEmailaddress;
        loginPopup.querySelector("#language-login-password").textContent= data.en.languageLoginPassword;
        loginPopup.querySelector("#language-login-rememberpwd").nextSibling.nodeValue= data.en.languageLoginrememberpwd;
        loginPopup.querySelector("#language-login-forgotpwd").textContent= data.en.languageLoginforgotpwd;
        loginPopup.querySelector("#login-btn").textContent= data.en.languageLoginbutton;
        //loginPopup.querySelector("#language-login-requireaccount").innerHTML= data.en.languageLoginRequireaccount;
        loginPopup.querySelector("#language-login-requireaccount").firstChild.textContent= data.en.languageLoginRequireaccount;
        loginPopup.querySelector("#language-login-registrationlink").textContent= data.en.languageLoginRegistrationlink;

        loginPopup.querySelector("#language-resetpwd-header").textContent= data.en.languageResetpwdHeader;
        loginPopup.querySelector("#language-resetpwd-emailaddress").textContent= data.en.languageResetpwdEmailaddress;
        loginPopup.querySelector("#resetpw-btn").textContent= data.en.languageResetpwdButton;
        //loginPopup.querySelector("#language-resetpwd-rememberpwd").innerHTML= data.en.languageResetpwdRememberpwd;
        loginPopup.querySelector("#language-resetpwd-rememberpwd").firstChild.textContent= data.en.languageResetpwdRememberpwd;
        loginPopup.querySelector("#language-resetpwd-loginlink").textContent= data.en.languageResetpwdLoginLink;

        loginPopup.querySelector("#language-passwordreset-header").textContent= data.en.passwordresetHeader;
        loginPopup.querySelector("#language-passwordreset-firstnewpassword").textContent= data.en.passwordresetFirstnewpassword;
        loginPopup.querySelector("#language-passwordreset-secondnewpassword").textContent= data.en.passwordresetSecondnewpassword;
        loginPopup.querySelector("#changepw-btn").textContent= data.en.passwordButton;



        /*
        const wrapper = document.querySelector('.wrapper');
        const loginLink = document.querySelector('.login-link');
        const registerLink = document.querySelector('.register-link');
        
        const resetPW = document.querySelector('.form-box.resetpw');
        const changePW = document.querySelector('.form-box.changepw');

        resetPW.style.display = 'none';
        changePW.style.display = 'none';

        if(registerLink !== null) {
            registerLink.addEventListener('click', ()=> {
            
                wrapper.classList.add('active');
        
                wrapper.style.height = '660px';
            });
        }

        if(loginLink !== null) {
            loginLink.addEventListener('click', ()=> {
                
                wrapper.classList.remove('active');

                wrapper.style.height = '440px';
            });
        }

        
        

        const resetPWLink = document.querySelector('.resetpw-link');

        const hideRegister = document.querySelector('.form-box.register');
        const hideLogin = document.querySelector('.form-box.login');
        

        if(resetPWLink !== null) {
            resetPWLink.addEventListener('click', ()=> {
                resetPW.style.display = 'block';
                wrapper.style.height = '360px';

                hideRegister.style.display = 'none';
                hideLogin.style.display = 'none';
            });
        }

        const backToLoginLink = document.querySelector('.back-to-login-link');

        if(backToLoginLink !== null) {
            backToLoginLink.addEventListener('click', ()=> {
                resetPW.style.display = 'none';

                hideRegister.style.display = 'block';
                hideLogin.style.display = 'block';

                wrapper.style.height = '440px';
            });
        }


        
        /* Reset Password Workaround */
        const queryString_PasswordReset = window.location.search;
        const urlParams_PasswordReset = new URLSearchParams(queryString_PasswordReset);
        // http://127.0.0.1:5500/onlineshop/index.html?hashed_email=e3b0c44298fc&reset_password=true
        if(urlParams_PasswordReset.has('hashed_email') && urlParams_PasswordReset.has('reset_password')) {
            resetPasswordWorkaround()
        }
    }
}








function resetPasswordWorkaround() {

    const wrapper = document.querySelector('.wrapper');
    const changePW = document.querySelector('.form-box.changepw');
    const resetPW = document.querySelector('.form-box.resetpw');
    const hideRegister = document.querySelector('.form-box.register');
    const hideLogin = document.querySelector('.form-box.login');



    wrapper.style.height = '440px';
    changePW.style.display = 'block';
    resetPW.style.display = 'none';
    hideRegister.style.display = 'none';
    hideLogin.style.display = 'none';




        /* Change Passwort actions */
        let changePWButton = document.getElementById("changepw-btn"); 
    
        //changePWButton.addEventListener("click", function() {


            if(document.body.contains(changePWButton)) { // if(registrationButton)
                changePWButton.addEventListener('click', async (e) => {
                  e.preventDefault();
    
            let changeUserPWForm = document.getElementById("form-change-user-pw").value;
            let confirmChangeUserPWForm = document.getElementById("form-confirm-change-user-pw").value;
    
            if(changeUserPWForm == "") {
                document.querySelector('.error-txt-changepw').innerHTML = "Enter your new password.";
            }
            else if(changeUserPWForm.length < 6) {
                document.querySelector('.error-txt-changepw').innerHTML = "A minimum of 6 characters is required.";
            }
            else if(changeUserPWForm != confirmChangeUserPWForm) {
                document.querySelector('.error-txt-changepw').innerHTML = "Passwords are not equal.";
            }
            else {
                Swal.fire({
                    text: "Password Reset Successful!",
                    timer: 3000,
                    color: "#162938",
                    icon: "success",
                    showConfirmButton: false,
                    background: "#e3e6f3",
                  });
    
                  changePW.style.display = 'none';
                  resetPW.style.display = 'none';
                  hideRegister.style.display = 'none';
                  hideLogin.style.display = 'block';
    
                  wrapper.style.height = '440px';

                  document.querySelector('.login-link').click();
            }
        }); 
    }

    /* Enable close of password reset popup */
    const loginPageElements = document.querySelector('.login-page-node');
    var initializeCloseButton = document.querySelector('.icon-close')
    initializeCloseButton.addEventListener('click', function(event) {
        const loginPageElements = document.querySelector('.login-page-node');

        loginPageElements.style.display = 'none';
    });
}