const data_contact = {
    "de":
    {
        /* Header Element*/
        "headerText": "#Privatsphäre",
        "headerSubText": "Unsere Datenschutzerklärung",

        "contactHeader": "Besuch unseren Flagship Store oder kontaktier uns online",
        "contactSubHeader": "Flagship Store",
        "contactAddress": "Kaiserstraße 213, 80801 München, Bayern (BY)",
        "contactEmail": "support@smartbuyonline.de",
        "contactAvailability": "Montag bis Samstag: 9:00 - 16.00 Uhr",

        "contactFormHeader": "Schreib uns eine Nachricht",
        "contactFormSubHeader": "Wir freuen uns von dir zu hören",
        "contactFormPlaceholderName": "Dein Name",
        "contactFormPlaceholderEmail": "E-Mail",
        "contactFormPlaceholderSubject": "Betreff",
        "contactFormPlaceholderMessage": "Deine Nachricht",
        "contactFormSubmitButton": "Abschicken",


    },
    "en":
    {
        /* Header Element */
        "headerText": "#Privacy",
        "headerSubText": "Our privacy policy",

        "contactHeader": "Visit our flagship store or contact us online",
        "contactSubHeader": "Flagship Store",
        "contactAddress": "Kaiserstraße 213, 80801 Munich, Bayern (BY)",
        "contactEmail": "support@smartbuyonline.de",
        "contactAvailability": "Monday to Saturday: 9.00am - 16.00pm",

        "contactFormHeader": "LEAVE A MESSAGE",
        "contactFormSubHeader": "We love to hear from you",
        "contactFormPlaceholderName": "Your Name",
        "contactFormPlaceholderEmail": "Email",
        "contactFormPlaceholderSubject": "Subject",
        "contactFormPlaceholderMessage": "Your Message",
        "contactFormSubmitButton": "Submit",
    }
}

const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
dropdownLanguage_German.addEventListener('click', ()=> {

    setLanguageGerman_Header()
    setLanguageGerman_Contact()
});


const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
dropdownLanguage_English.addEventListener('click', ()=> {

    setLanguageEnglish_Header()
    setLanguageEnglish_Contact()
});


const languageCookie = getCookie("language");
if (languageCookie != "") {

    if(languageCookie=="DE") {
        setLanguageGerman_Header()
        setLanguageGerman_Contact()
    }
    else {
        setLanguageEnglish_Header()
        setLanguageEnglish_Contact()
    }
}

/* Header Section */
function setLanguageGerman_Header() {
    const header = document.querySelector(".privacy-header");

    header.querySelector('h2').textContent = data_contact.de.headerText;
    header.querySelector('p').innerHTML = data_contact.de.headerSubText;
}
function setLanguageEnglish_Header() {
    const header = document.querySelector(".privacy-header");

    header.querySelector('h2').textContent = data_contact.en.headerText;
    header.querySelector('p').innerHTML = data_contact.en.headerSubText;
}

/* Contact Section */
function setLanguageGerman_Contact() {
    const contact = document.querySelector("#contact-details");

    contact.querySelector('h2').textContent = data_contact.de.contactHeader;
    contact.querySelector('h3').textContent = data_contact.de.contactSubHeader;
    contact.querySelector('#language-contact-address').textContent = data_contact.de.contactAddress;
    contact.querySelector('#language-contact-email').textContent = data_contact.de.contactEmail;
    contact.querySelector('#language-contact-available').textContent = data_contact.de.contactAvailability;

}
function setLanguageEnglish_Contact() {
    const contact = document.querySelector("#contact-details");

    contact.querySelector('h2').textContent = data_contact.en.contactHeader;
    contact.querySelector('h3').textContent = data_contact.en.contactSubHeader;
    contact.querySelector('#language-contact-address').textContent = data_contact.en.contactAddress;
    contact.querySelector('#language-contact-email').textContent = data_contact.en.contactEmail;
    contact.querySelector('#language-contact-available').textContent = data_contact.en.contactAvailability;

}