/* Order Section */
const data_order= {
    "de":
    {
        "orderBannerTitle": "Deine Bestellungen",
        "orderBannerSubTitle": "Alle deine Bestellungen auf einen Blick",

        "orderDate": "BESTELLDATUM",
        "orderNumbr": "BESTELLNUMMER",
        "orderProductName": "ARTIKEL",
        "orderProductQuantity": "MENGE",
        "orderPriceTotal": "SUMME",
        "orderMessageEmptyOrderCart": "Du hast bisher noch nichts bestellt.",
    },
    "en":
    {
        "orderBannerTitle": "Your recent orders",
        "orderBannerSubTitle": "See all your orders at a glance",

        "orderDate": "ORDER DATE",
        "orderNumbr": "ORDER #",
        "orderProductName": "PRODUCT",
        "orderProductQuantity": "QUANTITY",
        "orderPriceTotal": "SUBTOTAL",
        "orderMessageEmptyOrderCart": "You never placed an order.",
    }
}

ready()

function ready() {

    const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
    dropdownLanguage_German.addEventListener('click', ()=> {
        setLanguageGerman_OrderBanner()
        setLanguageGerman_OrderTable()
    });
    
    
    const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
    dropdownLanguage_English.addEventListener('click', ()=> {
        setLanguageEnglish_OrderBanner()
        setLanguageEnglish_OrderTable()
    });
    
    
    const languageCookie = getCookie("language");
    if (languageCookie != "") {
    
        if(languageCookie=="DE") {
            setLanguageGerman_OrderBanner()
            setLanguageGerman_OrderTable()
        }
        else {
            setLanguageEnglish_OrderBanner()
            setLanguageEnglish_OrderTable()
        }
    }


}


/*** Order Banner ***/
function setLanguageGerman_OrderBanner() {
    const orderBanner = document.querySelector('#page-header');

    orderBanner.querySelector("h2").textContent= data_order.de.orderBannerTitle;
    orderBanner.querySelector("p").textContent= data_order.de.orderBannerSubTitle;



}
function setLanguageEnglish_OrderBanner() {
    const orderBanner = document.querySelector('#page-header');

    orderBanner.querySelector("h2").textContent= data_order.en.orderBannerTitle;
    orderBanner.querySelector("p").textContent= data_order.en.orderBannerSubTitle;



}


/*** Order Table ***/
function setLanguageGerman_OrderTable() {
    const orderTable = document.querySelector('#order');

    orderTable.querySelector("#language-order-date").textContent= data_order.de.orderDate;
    orderTable.querySelector("#language-order-number").textContent= data_order.de.orderNumbr;
    orderTable.querySelector("#language-order-productitem").textContent= data_order.de.orderProductName;
    orderTable.querySelector("#language-order-productquantity").textContent= data_order.de.orderProductQuantity;
    orderTable.querySelector("#language-order-pricetotal").textContent= data_order.de.orderPriceTotal;

    document.querySelector('.show-message-empty-order-list').textContent= data_order.de.orderMessageEmptyOrderCart;


}
function setLanguageEnglish_OrderTable() {
    const orderTable = document.querySelector('#order');

    orderTable.querySelector("#language-order-date").textContent= data_order.en.orderDate;
    orderTable.querySelector("#language-order-number").textContent= data_order.en.orderNumbr;
    orderTable.querySelector("#language-order-productitem").textContent= data_order.en.orderProductName;
    orderTable.querySelector("#language-order-productquantity").textContent= data_order.en.orderProductQuantity;
    orderTable.querySelector("#language-order-pricetotal").textContent= data_order.en.orderPriceTotal;

    document.querySelector('.show-message-empty-order-list').textContent= data_order.en.orderMessageEmptyOrderCart;


}